/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.rails;

import com.sun.enterprise.rails.RailsApplication;
import com.sun.enterprise.rails.RailsContainer;
import com.sun.enterprise.v3.server.V3Environment;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.grizzly.jruby.RubyObjectPool;
import com.sun.grizzly.tcp.Adapter;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyException;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class RailsDeployer
implements Deployer<RailsContainer, RailsApplication> {
    @Inject
    V3Environment env;
    @Inject
    GrizzlyService grizzlyAdapter;
    private static final String contextRootStr = "--contextRoot";
    private static final String numberOfRuntimeStr = "--jruby.runtime";

    public boolean prepare(DeploymentContext context) {
        return true;
    }

    public MetaData getMetaData() {
        return new MetaData(false, null, null, null);
    }

    public RailsApplication load(RailsContainer container, DeploymentContext context) {
        String contextRoot = this.getContextRoot(context);
        RubyObjectPool pool = this.setupRubyObjectPool(container, context);
        RailsApplication adapter = this.registerAdapter(pool, contextRoot, context);
        try {
            System.out.println("Starting Rails instances");
            pool.start();
        }
        catch (RaiseException e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            RubyException re = e.getException();
            String rubyMessage = (String)JavaEmbedUtils.rubyToJava((Ruby)pool.borrowRuntime(), (IRubyObject)re.message, String.class);
            String message = "Failed to load Rails: " + rubyMessage + "\n";
            RubyArray backtrace = (RubyArray)re.backtrace();
            for (String traceLine : backtrace) {
                message = message + "\t" + traceLine + "\n";
            }
            return null;
        }
        return adapter;
    }

    public void unload(RailsApplication container, DeploymentContext context) {
    }

    public void clean(DeploymentContext context) {
    }

    private String getContextRoot(DeploymentContext context) {
        String contextRoot = context.getCommandParameters().getProperty("contextroot");
        if (contextRoot == null) {
            contextRoot = (String)this.env.getStartupContext().getArguments().get("--contextroot");
        }
        if (contextRoot == null || contextRoot.length() == 0) {
            contextRoot = "/" + context.getCommandParameters().getProperty("name");
        }
        return contextRoot;
    }

    private RailsApplication registerAdapter(RubyObjectPool pool, String contextRoot, DeploymentContext context) {
        RailsApplication adapter = new RailsApplication(pool);
        adapter.setContextRoot(contextRoot);
        pool.setAsyncEnabled(true);
        context.getLogger().info("Loading application " + context.getCommandParameters().getProperty("name") + " at " + contextRoot);
        this.grizzlyAdapter.registerEndpoint(contextRoot, null, (Adapter)adapter, (ApplicationContainer)adapter);
        return adapter;
    }

    private RubyObjectPool setupRubyObjectPool(RailsContainer container, DeploymentContext context) {
        RubyObjectPool pool = container.getPool();
        String railsRoot = context.getSource().getURI().getSchemeSpecificPart();
        pool.setRailsRoot(railsRoot);
        String jrubyRuntime = (String)this.env.getStartupContext().getArguments().get("--runtimes");
        int numberOfRuntime = 1;
        if (jrubyRuntime != null) {
            try {
                numberOfRuntime = Integer.parseInt(jrubyRuntime);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        pool.setNumberOfRuntime(numberOfRuntime);
        return pool;
    }
}

