/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.rails;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.impl.CookedModuleDefinition;
import com.sun.enterprise.v3.deployment.GenericSniffer;
import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Sniffer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Service(name="rails")
@Scoped(value=Singleton.class)
public class RailsSniffer
extends GenericSniffer
implements Sniffer {
    @Inject
    Habitat habitat;
    @Inject
    ModulesRegistry registry;
    final String[] containers = new String[]{"com.sun.enterprise.rails.RailsContainer"};

    public RailsSniffer() {
        super("jruby", "app/controllers/application.rb", null);
    }

    public Module[] setup(String containerHome, Logger logger) throws IOException {
        super.setup(containerHome, logger);
        File rootLocation = new File(containerHome);
        if (!rootLocation.exists()) {
            throw new RuntimeException("JRuby installation not found at " + rootLocation.getPath());
        }
        rootLocation = new File(rootLocation, "lib");
        CookedModuleDefinition jruby = null;
        try {
            Attributes jrubyAttr = new Attributes();
            StringBuffer classpath = new StringBuffer();
            for (File lib : rootLocation.listFiles()) {
                if (!lib.isFile() || lib.getName().equals("jruby.jar")) continue;
                classpath.append(lib.getName());
                classpath.append(" ");
            }
            jrubyAttr.putValue(Attributes.Name.CLASS_PATH.toString(), classpath.toString());
            jruby = new CookedModuleDefinition(new File(rootLocation, "jruby.jar"), jrubyAttr);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Cannot setup jruby classpath", e);
            throw e;
        }
        this.registry.add((ModuleDefinition)jruby);
        Module jrubyModule = this.registry.makeModuleFor(jruby.getName(), jruby.getVersion());
        Module grizzlyRails = this.registry.makeModuleFor("org.glassfish.external:grizzly-jruby-module", null);
        if (grizzlyRails != null) {
            grizzlyRails.addImport(jrubyModule);
        }
        Module[] modules = new Module[]{grizzlyRails, jrubyModule};
        return modules;
    }

    public String[] getContainersNames() {
        return this.containers;
    }
}

