/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

public class FromSubquery
extends FromTable {
    boolean generatedForGroupByClause;
    boolean generatedForHavingClause;
    ResultSetNode subquery;

    public void init(Object object, Object object2, Object object3, Object object4) {
        super.init(object2, object4);
        this.subquery = (ResultSetNode)object;
        this.resultColumns = (ResultColumnList)object3;
    }

    public String toString() {
        return "";
    }

    public void printSubNodes(int n) {
    }

    public ResultSetNode getSubquery() {
        return this.subquery;
    }

    public void markAsForGroupByClause() {
        this.generatedForGroupByClause = true;
    }

    public void markAsForHavingClause() {
        this.generatedForHavingClause = true;
    }

    protected FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        if (this.generatedForGroupByClause || this.generatedForHavingClause) {
            return this.subquery.getFromTableByName(string, string2, bl);
        }
        return super.getFromTableByName(string, string2, bl);
    }

    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        this.subquery = this.subquery.bindNonVTITables(dataDictionary, fromList);
        return this;
    }

    public ResultSetNode bindVTITables(FromList fromList) throws StandardException {
        this.subquery = this.subquery.bindVTITables(fromList);
        return this;
    }

    public void rejectParameters() throws StandardException {
        this.subquery.rejectParameters();
    }

    public void bindExpressions(FromList fromList) throws StandardException {
        FromList fromList2 = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        ResultColumnList resultColumnList = this.resultColumns;
        FromList fromList3 = this.generatedForGroupByClause || this.generatedForHavingClause ? fromList : fromList2;
        this.subquery.bindExpressions(fromList3);
        this.subquery.bindResultColumns(fromList3);
        ResultColumnList resultColumnList2 = this.subquery.getResultColumns();
        if (this.resultColumns != null && this.resultColumns.getCountMismatchAllowed() && this.resultColumns.size() < resultColumnList2.size()) {
            for (int i = resultColumnList2.size() - 1; i >= this.resultColumns.size(); --i) {
                resultColumnList2.removeElementAt(i);
            }
        }
        this.subquery.setResultColumns(resultColumnList2.copyListAndObjects());
        resultColumnList2.genVirtualColumnNodes(this.subquery, this.subquery.getResultColumns());
        this.resultColumns = resultColumnList2;
        if (resultColumnList != null) {
            this.resultColumns.propagateDCLInfo(resultColumnList, this.correlationName);
        }
    }

    public ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        ResultColumn resultColumn = null;
        String string = columnReference.getTableName();
        if (columnReference.getGeneratedToReplaceAggregate()) {
            resultColumn = this.resultColumns.getResultColumn(columnReference.getColumnName());
        } else if (this.generatedForGroupByClause && this.generatedForHavingClause && (string != null || columnReference.getClause() != 1)) {
            SelectNode selectNode = (SelectNode)this.subquery;
            resultColumn = selectNode.getFromList().bindColumnReference(columnReference);
            if (resultColumn != null && (resultColumn = this.subquery.getResultColumns().findParentResultColumn(resultColumn)) != null) {
                resultColumn = this.resultColumns.findParentResultColumn(resultColumn);
            }
        } else if (this.generatedForHavingClause && !this.generatedForGroupByClause && columnReference.getClause() != 1) {
            resultColumn = null;
        } else if (this.generatedForGroupByClause) {
            resultColumn = this.resultColumns.getResultColumn(string, columnReference.getColumnName());
        } else if (string == null || string.equals(this.correlationName)) {
            resultColumn = this.resultColumns.getAtMostOneResultColumn(columnReference, this.correlationName);
        }
        if (resultColumn != null) {
            columnReference.setTableNumber(this.tableNumber);
        }
        return resultColumn;
    }

    public ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        this.subquery = this.subquery.preprocess(n, groupByList, fromList);
        if ((groupByList == null || groupByList.size() == 0) && this.tableProperties == null && this.subquery.flattenableInFromSubquery(fromList)) {
            this.setReferencedTableMap(this.subquery.getReferencedTableMap());
            return this;
        }
        return this.extractSubquery(n);
    }

    public ResultSetNode extractSubquery(int n) throws StandardException {
        ResultSetNode resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(151, this.subquery, this.resultColumns, null, null, null, null, this.tableProperties, this.getContextManager());
        JBitSet jBitSet = new JBitSet(n);
        jBitSet.set(this.tableNumber);
        resultSetNode.setReferencedTableMap(jBitSet);
        ((FromTable)resultSetNode).setTableNumber(this.tableNumber);
        return resultSetNode;
    }

    public FromList flatten(ResultColumnList resultColumnList, PredicateList predicateList, SubqueryList subqueryList, GroupByList groupByList) throws StandardException {
        FromList fromList = null;
        this.resultColumns.setRedundant();
        this.subquery.getResultColumns().setRedundant();
        if (this.subquery instanceof SelectNode) {
            SelectNode selectNode = (SelectNode)this.subquery;
            fromList = selectNode.getFromList();
            if (selectNode.getWherePredicates().size() > 0) {
                predicateList.destructiveAppend(selectNode.getWherePredicates());
            }
            if (selectNode.getWhereSubquerys().size() > 0) {
                subqueryList.destructiveAppend(selectNode.getWhereSubquerys());
            }
        } else if (!(this.subquery instanceof RowResultSetNode)) {
            // empty if block
        }
        resultColumnList.remapColumnReferencesToExpressions();
        predicateList.remapColumnReferencesToExpressions();
        if (groupByList != null) {
            groupByList.remapColumnReferencesToExpressions();
        }
        return fromList;
    }

    public String getExposedName() {
        return this.correlationName;
    }

    public ResultColumnList getAllResultColumns(TableName tableName) throws StandardException {
        ResultColumnList resultColumnList = null;
        TableName tableName2 = tableName != null ? this.makeTableName(tableName.getSchemaName(), this.correlationName) : this.makeTableName(null, this.correlationName);
        if (tableName != null && !tableName.equals(tableName2)) {
            return null;
        }
        TableName tableName3 = this.makeTableName(null, this.correlationName);
        resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int n = this.resultColumns.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.resultColumns.elementAt(i);
            if (resultColumn.isGenerated()) continue;
            String string = resultColumn.getName();
            boolean bl = resultColumn.isNameGenerated();
            TableName tableName4 = this.correlationName == null && this.generatedForGroupByClause ? this.makeTableName(null, resultColumn.getTableName()) : tableName3;
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(62, string, tableName4, this.getContextManager());
            resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, string, valueNode, this.getContextManager());
            resultColumn.setNameGenerated(bl);
            resultColumnList.addResultColumn(resultColumn);
        }
        return resultColumnList;
    }

    public void disablePrivilegeCollection() {
        super.disablePrivilegeCollection();
        this.subquery.disablePrivilegeCollection();
    }

    public boolean referencesTarget(String string, boolean bl) throws StandardException {
        return this.subquery.referencesTarget(string, bl);
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.subquery.referencesSessionSchema();
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        this.subquery.bindUntypedNullsToResultColumns(resultColumnList);
    }

    void decrementLevel(int n) {
        super.decrementLevel(n);
        this.subquery.decrementLevel(n);
    }
}

