/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-jdbc-connection-pool")
@Scoped(value=PerLookup.class)
@I18n(value="create.jdbc.connection.pool")
public class CreateJdbcConnectionPool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJdbcConnectionPool.class);
    @Param(name="datasourceclassname")
    String datasourceclassname;
    @Param(name="restype", optional=true)
    String restype;
    @Param(name="steadypoolsize", optional=true)
    String steadypoolsize = "8";
    @Param(name="maxpoolsize", optional=true)
    String maxpoolsize = "32";
    @Param(name="maxwait", optional=true)
    String maxwait = "60000";
    @Param(name="poolresize", optional=true)
    String poolresize = "2";
    @Param(name="idletimeout", optional=true)
    String idletimeout = "300";
    @Param(name="isolationlevel", optional=true)
    String isolationlevel;
    @Param(name="isisolationguaranteed", optional=true)
    String isisolationguaranteed = Boolean.TRUE.toString();
    @Param(name="isconnectvalidatereq", optional=true)
    String isconnectvalidatereq = Boolean.FALSE.toString();
    @Param(name="validationmethod", optional=true)
    String validationmethod = "auto-commit";
    @Param(name="validationtable", optional=true)
    String validationtable;
    @Param(name="failconnection", optional=true)
    String failconnection = Boolean.FALSE.toString();
    @Param(name="allownoncomponentcallers", optional=true)
    String allownoncomponentcallers = Boolean.FALSE.toString();
    @Param(name="nontransactionalconnections", optional=true)
    String nontransactionalconnections = Boolean.FALSE.toString();
    @Param(name="description", optional=true)
    String description;
    @Param(name="jdbc_connection_pool_id", primary=true)
    String jdbc_connection_pool_id;
    @Inject
    Resources resources;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        for (Resource resource : this.resources.getResources()) {
            if (!(resource instanceof JdbcConnectionPool) || !((JdbcConnectionPool)resource).getName().equals(this.jdbc_connection_pool_id)) continue;
            report.setMessage(localStrings.getLocalString("create.jdbc.connection.pool.duplicate", "A JDBC connection pool named {0} already exists.", new Object[]{this.jdbc_connection_pool_id}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    JdbcConnectionPool newResource = (JdbcConnectionPool)ConfigSupport.createChildOf((Object)param, JdbcConnectionPool.class);
                    newResource.setAllowNonComponentCallers(CreateJdbcConnectionPool.this.allownoncomponentcallers);
                    newResource.setDatasourceClassname(CreateJdbcConnectionPool.this.datasourceclassname);
                    newResource.setDescription(CreateJdbcConnectionPool.this.description);
                    newResource.setFailAllConnections(CreateJdbcConnectionPool.this.failconnection);
                    newResource.setIdleTimeoutInSeconds(CreateJdbcConnectionPool.this.idletimeout);
                    newResource.setIsConnectionValidationRequired(CreateJdbcConnectionPool.this.isconnectvalidatereq);
                    newResource.setIsIsolationLevelGuaranteed(CreateJdbcConnectionPool.this.isisolationguaranteed);
                    newResource.setMaxPoolSize(CreateJdbcConnectionPool.this.maxpoolsize);
                    newResource.setMaxWaitTimeInMillis(CreateJdbcConnectionPool.this.maxwait);
                    newResource.setName(CreateJdbcConnectionPool.this.jdbc_connection_pool_id);
                    newResource.setNonTransactionalConnections(CreateJdbcConnectionPool.this.nontransactionalconnections);
                    newResource.setPoolResizeQuantity(CreateJdbcConnectionPool.this.poolresize);
                    newResource.setResType(CreateJdbcConnectionPool.this.restype);
                    newResource.setSteadyPoolSize(CreateJdbcConnectionPool.this.steadypoolsize);
                    newResource.setTransactionIsolationLevel(CreateJdbcConnectionPool.this.isolationlevel);
                    newResource.setValidateAtmostOncePeriodInSeconds(CreateJdbcConnectionPool.this.restype);
                    newResource.setValidationTableName(CreateJdbcConnectionPool.this.validationtable);
                    param.getResources().add(newResource);
                    return newResource;
                }
            }, (ConfigBeanProxy)this.resources);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.jdbc.connection.pool.fail", "{0} create failed ", new Object[]{this.jdbc_connection_pool_id}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
        report.setMessage(localStrings.getLocalString("create.jdbc.connection.pool.success", "{0} created successfully", new Object[]{this.jdbc_connection_pool_id}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

