/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-jdbc-connection-pool")
@Scoped(value=PerLookup.class)
@I18n(value="delete.jdbc.connection.pool")
public class DeleteJdbcConnectionPool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteJdbcConnectionPool.class);
    @Param(name="jdbc_connection_pool_id", primary=true)
    String jdbc_connection_pool_id;
    @Inject
    Resources resources;
    @Inject
    JdbcConnectionPool[] connPools;

    public void execute(AdminCommandContext context) {
        final ActionReport report = context.getActionReport();
        try {
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    for (JdbcConnectionPool cp : DeleteJdbcConnectionPool.this.connPools) {
                        if (!cp.getName().equals(DeleteJdbcConnectionPool.this.jdbc_connection_pool_id)) continue;
                        return param.getResources().remove(cp);
                    }
                    report.setMessage(localStrings.getLocalString("delete.jdbc.connection.pool.notfound", "{0} delete failed, resource not found", new Object[]{DeleteJdbcConnectionPool.this.jdbc_connection_pool_id}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return null;
                }
            }, (ConfigBeanProxy)this.resources) != null) {
                report.setMessage(localStrings.getLocalString("delete.jdbc.connection.pool.success", "{0} deleted successfully", new Object[]{this.jdbc_connection_pool_id}));
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            }
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.jdbc.connection.pool.fail", "{0} delete failed ", new Object[]{this.jdbc_connection_pool_id}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

