/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.CreateJdbcResource;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-jdbc-resource")
@Scoped(value=PerLookup.class)
@I18n(value="delete.jdbc.resource")
public class DeleteJdbcResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJdbcResource.class);
    @Param(name="jdbc_resource_name", primary=true)
    String jndiName;
    @Inject
    Resources resources;
    @Inject
    JdbcResource[] jdbcResources;

    public void execute(AdminCommandContext context) {
        final ActionReport report = context.getActionReport();
        try {
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    for (JdbcResource resource : DeleteJdbcResource.this.jdbcResources) {
                        if (!resource.getJndiName().equals(DeleteJdbcResource.this.jndiName)) continue;
                        return param.getResources().remove(resource);
                    }
                    report.setMessage(localStrings.getLocalString("delete.jdbc.resource.notfound", "{0} delete failed, resource not found", new Object[]{DeleteJdbcResource.this.jndiName}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return null;
                }
            }, (ConfigBeanProxy)this.resources) != null) {
                report.setMessage(localStrings.getLocalString("delete.jdbc.resource.success", "{0} deleted successfully", new Object[]{this.jndiName}));
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            }
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.jdbc.resource.fail", "{0} delete failed ", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

