/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.ResourceManager;
import com.sun.enterprise.v3.admin.ResourceStatus;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Properties;
import org.glassfish.api.I18n;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ConfiguredBy;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@I18n(value="create.jdbc.resource")
@ConfiguredBy(value=Resources.class)
public class JDBCResourceManager
implements ResourceManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JDBCResourceManager.class);
    private static final String DESCRIPTION = "description";
    String jndiName = null;
    String description = null;
    String poolName = null;
    String enabled = Boolean.TRUE.toString();

    public ResourceStatus create(Resources resources, HashMap attrList, Properties props, String tgtName) throws Exception {
        this.jndiName = (String)attrList.get("jndi-name");
        this.description = (String)attrList.get(DESCRIPTION);
        this.poolName = (String)attrList.get("pool-name");
        this.enabled = (String)attrList.get("enabled");
        if (this.jndiName == null) {
            String msg = localStrings.getLocalString("create.jdbc.resource.noJndiName", "No JNDI name defined for JDBC resource.");
            ResourceStatus status = new ResourceStatus(ResourceStatus.FAILURE, msg);
            return status;
        }
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof JdbcResource) || !((JdbcResource)resource).getJndiName().equals(this.jndiName)) continue;
            String msg = localStrings.getLocalString("create.jdbc.resource", "A JDBC resource named {0} already exists.", new Object[]{this.jndiName});
            ResourceStatus status = new ResourceStatus(ResourceStatus.FAILURE, msg);
            return status;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    JdbcResource newResource = (JdbcResource)ConfigSupport.createChildOf((Object)param, JdbcResource.class);
                    newResource.setJndiName(JDBCResourceManager.this.jndiName);
                    if (JDBCResourceManager.this.description != null) {
                        newResource.setDescription(JDBCResourceManager.this.description);
                    }
                    newResource.setPoolName(JDBCResourceManager.this.poolName);
                    newResource.setEnabled(JDBCResourceManager.this.enabled);
                    param.getResources().add(newResource);
                    return newResource;
                }
            }, (ConfigBeanProxy)resources);
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("create.jdbc.resource.fail", "JDBC resource {0} create failed ", new Object[]{this.jndiName});
            ResourceStatus status = new ResourceStatus(ResourceStatus.FAILURE, msg);
            status.setException(tfe);
            return status;
        }
        String msg = localStrings.getLocalString("create.jdbc.resource.success", "JDBC resource {0} created successfully", new Object[]{this.jndiName});
        ResourceStatus status = new ResourceStatus(ResourceStatus.SUCCESS, msg);
        return status;
    }
}

