/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.data;

import com.sun.enterprise.v3.data.ApplicationInfo;
import com.sun.enterprise.v3.data.ModuleInfo;
import java.util.HashMap;
import java.util.Map;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ApplicationRegistry {
    private Map<String, ApplicationInfo> apps = new HashMap<String, ApplicationInfo>();

    public synchronized void add(String name, ApplicationInfo info) {
        this.apps.put(name, info);
        for (ModuleInfo module : info.getModuleInfos()) {
            module.getContainerInfo().add(info);
        }
    }

    public ApplicationInfo get(String name) {
        return this.apps.get(name);
    }

    public synchronized void remove(String name) {
        ApplicationInfo oldApp = this.apps.remove(name);
        for (ModuleInfo module : oldApp.getModuleInfos()) {
            module.getContainerInfo().remove(name);
        }
    }
}

