/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.deployment;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.admin.CommandRunner;
import com.sun.enterprise.v3.deployment.DeploymentContextImpl;
import com.sun.enterprise.v3.server.ApplicationLifecycle;
import com.sun.enterprise.v3.server.V3Environment;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="deploy")
@I18n(value="deploy.command")
@Scoped(value=PerLookup.class)
public class DeployCommand
extends ApplicationLifecycle
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeployCommand.class);
    public static final String NAME = "name";
    public static final String VIRTUAL_SERVERS = "virtualservers";
    public static final String CONTEXT_ROOT = "contextroot";
    public static final String LIBRARIES = "libraries";
    public static final String DIRECTORY_DEPLOYED = "directorydeployed";
    public static final String LOCATION = "location";
    public static final String ENABLED = "enabled";
    @Inject
    V3Environment env;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    CommandRunner commandRunner;
    String path;
    @Param(name="name", optional=true)
    String name = null;
    @Param(name="contextroot", optional=true)
    String contextRoot = null;
    @Param(optional=true)
    @I18n(value="virtualservers")
    String virtualservers = null;
    @Param(name="libraries", optional=true)
    String libraries = null;
    @Param(optional=true)
    String force = Boolean.FALSE.toString();
    @Param(optional=true)
    String precompilejsp = Boolean.FALSE.toString();
    @Param(optional=true)
    String verify = Boolean.FALSE.toString();
    @Param(optional=true)
    String retrieve = null;
    @Param(optional=true)
    String dbvendorname = null;
    @Param(optional=true)
    String createtables = null;
    @Param(optional=true)
    String dropandcreatetables = null;
    @Param(optional=true)
    String uniquetablenames = null;
    @Param(optional=true)
    String deploymentplan = null;
    @Param(optional=true)
    String enabled = Boolean.TRUE.toString();
    @Param(optional=true)
    String generatermistubs = Boolean.FALSE.toString();
    @Param(optional=true)
    String availabilityenabled = Boolean.FALSE.toString();
    @Param(optional=true)
    String target = "server";
    @Inject
    Domain domain;
    @Inject
    Applications applications;

    @Param(primary=true, shortName="p")
    public void setPath(String path) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(AdminCommandContext context) {
        block51: {
            block43: {
                block50: {
                    block42: {
                        block49: {
                            block40: {
                                block48: {
                                    block39: {
                                        operationStartTime = Calendar.getInstance().getTimeInMillis();
                                        parameters = context.getCommandParameters();
                                        report = context.getActionReport();
                                        file = new File(this.path);
                                        if (!file.exists()) {
                                            report.setMessage(DeployCommand.localStrings.getLocalString("fnf", "File not found", new Object[]{file.getAbsolutePath()}));
                                            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                            return;
                                        }
                                        if (this.sniffers == null) {
                                            msg = DeployCommand.localStrings.getLocalString("nocontainer", "No container services registered, done...");
                                            this.logger.severe(msg);
                                            report.setMessage(msg);
                                            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                            return;
                                        }
                                        try {
                                            archive = this.archiveFactory.openArchive(file);
                                        }
                                        catch (IOException e) {
                                            this.logger.log(Level.SEVERE, "Error opening deployable artifact : " + file.getAbsolutePath(), e);
                                            report.setMessage(DeployCommand.localStrings.getLocalString("unknownarchiveformat", "Archive format not recognized"));
                                            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                            return;
                                        }
                                        expansionDir = null;
                                        try {
                                            try {
                                                block44: {
                                                    archiveHandler = this.getArchiveHandler(archive);
                                                    if (archiveHandler == null) {
                                                        report.setMessage(DeployCommand.localStrings.getLocalString("deploy.unknownarchivetype", "Archive type of {0} was not recognized", new Object[]{file.getName()}));
                                                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                                        var22_12 = null;
                                                        break block39;
                                                    }
                                                    if (this.name == null) {
                                                        this.name = archiveHandler.getDefaultApplicationName(archive);
                                                        parameters.put("name", this.name);
                                                    }
                                                    this.handleRedeploy(this.name, report);
                                                    FileUtils.whack((File)new File(this.env.getApplicationRepositoryPath(), this.name));
                                                    if (parameters.getProperty("enabled") == null) {
                                                        parameters.put("enabled", this.enabled);
                                                    }
                                                    source = new File(archive.getURI().getSchemeSpecificPart());
                                                    isDirectoryDeployed = true;
                                                    if (source.isDirectory()) break block44;
                                                    isDirectoryDeployed = false;
                                                    expansionDir = new File(this.domain.getApplicationRoot(), this.name);
                                                    if (!expansionDir.mkdirs()) {
                                                        report.setMessage(DeployCommand.localStrings.getLocalString("deploy.cannotcreateexpansiondir", "Error while creating directory for jar expansion: {0}", new Object[]{expansionDir}));
                                                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                                        expansionDir = null;
                                                        break block40;
                                                    }
                                                    try {
                                                        archiveHandler.expand(archive, this.archiveFactory.createArchive(expansionDir));
                                                        try {
                                                            archive.close();
                                                        }
                                                        catch (IOException e) {
                                                            report.setMessage(DeployCommand.localStrings.getLocalString("deploy.errorclosingarchive", "Error while closing deployable artifact {0}", new Object[]{file.getAbsolutePath()}));
                                                            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                                            var22_14 = null;
                                                            try {
                                                                archive.close();
                                                            }
                                                            catch (IOException e) {
                                                                this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                                                            }
                                                            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                                                this.logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                                                                return;
                                                            }
                                                            if (expansionDir == null) return;
                                                            FileUtils.whack((File)expansionDir);
                                                            return;
                                                        }
                                                    }
                                                    catch (IOException e) {
                                                        block45: {
                                                            report.setMessage(DeployCommand.localStrings.getLocalString("deploy.errorexpandingjar", "Error while expanding archive file"));
                                                            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                                            var22_15 = null;
                                                            ** try [egrp 6[TRYBLOCK] [18 : 973->983)] { 
lbl83:
                                                            // 1 sources

                                                            archive.close();
                                                            break block45;
lbl85:
                                                            // 1 sources

                                                            catch (IOException e) {
                                                                this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                                                            }
                                                        }
                                                        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                                            this.logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                                                            return;
                                                        }
                                                        if (expansionDir == null) return;
                                                        FileUtils.whack((File)expansionDir);
                                                        return;
                                                    }
                                                    {
                                                        file = expansionDir;
                                                        archive = this.archiveFactory.openArchive(expansionDir);
                                                    }
                                                }
                                                if ((appSniffers = this.getSniffers(archive, cloader = archiveHandler.getClassLoader(parentCL = this.createSnifferParentCL(null, Arrays.asList(this.sniffers)), archive))).size() == 0) {
                                                    report.setMessage(DeployCommand.localStrings.getLocalString("deploy.unknownmoduletpe", "Module type not recognized"));
                                                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                                    break block42;
                                                }
                                                docBase = archive.getURI().toURL().toString();
                                                sourceArchive = archive;
                                                deploymentContext = new DeploymentContextImpl(this.logger, sourceArchive, parameters, this.env);
                                                deploymentContext.setClassLoader(cloader);
                                                this.deleteContainerMetaInfo(deploymentContext);
                                                moduleProps = deploymentContext.getProps();
                                                moduleProps.setProperty("name", this.name);
                                                moduleProps.setProperty("location", deploymentContext.getSource().getURI().toURL().toString());
                                                moduleProps.setProperty("object-type", "user");
                                                if (this.contextRoot != null) {
                                                    moduleProps.setProperty("context-root", this.contextRoot);
                                                }
                                                moduleProps.setProperty("enabled", this.enabled);
                                                moduleProps.setProperty("directory-deployed", String.valueOf(isDirectoryDeployed));
                                                if (this.virtualservers != null) {
                                                    moduleProps.setProperty("virtual-servers", this.virtualservers);
                                                }
                                                appInfo = this.deploy(appSniffers, deploymentContext, report);
                                                if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                                    msgPart = report.getTopMessagePart();
                                                    msgPart.addProperty("name", this.name);
                                                    this.registerAppInDomainXML(appInfo, deploymentContext);
                                                    report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.success", "Application {0} deployed successfully", new Object[]{this.name}));
                                                }
                                                break block43;
                                            }
                                            catch (Exception e) {
                                                block46: {
                                                    this.logger.log(Level.SEVERE, "Error during deployment : ", e);
                                                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                                                    report.setMessage(e.getMessage());
                                                    var22_18 = null;
                                                    ** try [egrp 6[TRYBLOCK] [18 : 973->983)] { 
lbl139:
                                                    // 1 sources

                                                    archive.close();
                                                    break block46;
lbl141:
                                                    // 1 sources

                                                    catch (IOException e) {
                                                        this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                                                    }
                                                }
                                                if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                                    this.logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                                                    return;
                                                }
                                                if (expansionDir == null) return;
                                                FileUtils.whack(expansionDir);
                                                return;
                                            }
                                        }
                                        catch (Throwable var21_41) {
                                            block47: {
                                                var22_19 = null;
                                                ** try [egrp 6[TRYBLOCK] [18 : 973->983)] { 
lbl155:
                                                // 1 sources

                                                archive.close();
                                                break block47;
lbl157:
                                                // 1 sources

                                                catch (IOException e) {
                                                    this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                                                }
                                            }
                                            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                                this.logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                                                throw var21_41;
                                            }
                                            if (expansionDir == null) throw var21_41;
                                            FileUtils.whack(expansionDir);
                                            throw var21_41;
                                        }
                                    }
                                    ** try [egrp 6[TRYBLOCK] [18 : 973->983)] { 
lbl169:
                                    // 1 sources

                                    archive.close();
                                    break block48;
lbl171:
                                    // 1 sources

                                    catch (IOException e) {
                                        this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                                    }
                                }
                                if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                    this.logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                                    return;
                                }
                                if (expansionDir == null) return;
                                FileUtils.whack(expansionDir);
                                return;
                            }
                            var22_13 = null;
                            ** try [egrp 6[TRYBLOCK] [18 : 973->983)] { 
lbl184:
                            // 1 sources

                            archive.close();
                            break block49;
lbl186:
                            // 1 sources

                            catch (IOException e) {
                                this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                            }
                        }
                        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                            this.logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                            return;
                        }
                        if (expansionDir == null) return;
                        FileUtils.whack((File)expansionDir);
                        return;
                    }
                    var22_16 = null;
                    ** try [egrp 6[TRYBLOCK] [18 : 973->983)] { 
lbl199:
                    // 1 sources

                    archive.close();
                    break block50;
lbl201:
                    // 1 sources

                    catch (IOException e) {
                        this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                    }
                }
                if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                    this.logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                    return;
                }
                if (expansionDir == null) return;
                FileUtils.whack((File)expansionDir);
                return;
            }
            var22_17 = null;
            ** try [egrp 6[TRYBLOCK] [18 : 973->983)] { 
lbl214:
            // 1 sources

            archive.close();
            break block51;
lbl216:
            // 1 sources

            catch (IOException e) {
                this.logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
            }
        }
        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            this.logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
            return;
        }
        if (expansionDir == null) return;
        FileUtils.whack((File)expansionDir);
    }

    private void handleRedeploy(String name, ActionReport report) throws Exception {
        boolean isForce = Boolean.parseBoolean(this.force);
        boolean isRegistered = this.isRegistered(name);
        if (isRegistered && !isForce) {
            String msg = localStrings.getLocalString("application.alreadyreg.redeploy", "Application {0} already registered, please use deploy --force=true to redeploy", new Object[]{name});
            throw new Exception(msg);
        }
        if (isRegistered && isForce) {
            Properties undeployParam = new Properties();
            undeployParam.put(NAME, name);
            this.commandRunner.doCommand("undeploy", undeployParam, report);
        }
    }
}

