/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.deployment;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.data.ApplicationInfo;
import com.sun.enterprise.v3.data.ApplicationRegistry;
import com.sun.enterprise.v3.deployment.DeploymentContextImpl;
import com.sun.enterprise.v3.server.ApplicationLifecycle;
import com.sun.enterprise.v3.server.V3Environment;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="undeploy")
@I18n(value="undeploy.command")
public class UndeployCommand
extends ApplicationLifecycle
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UndeployCommand.class);
    @Inject
    V3Environment env;
    @Inject
    ApplicationRegistry appRegistry;
    @Inject
    GrizzlyService adapter;
    @Param(primary=true, name="name")
    String name = null;
    @Inject
    Applications applications;
    Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.deployment");

    public void execute(AdminCommandContext context) {
        Properties parameters = context.getCommandParameters();
        ActionReport report = context.getActionReport();
        this.name = new File(this.name).getName();
        parameters.setProperty("name", this.name);
        ApplicationInfo info = this.appRegistry.get(this.name);
        if (!this.isRegistered(this.name)) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.name}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        DeploymentContextImpl deploymentContext = new DeploymentContextImpl(this.logger, info.getSource(), parameters, this.env);
        this.undeploy(this.name, deploymentContext, report);
        boolean isDirectoryDeployed = false;
        for (Module module : this.applications.getModules()) {
            if (!module.getName().equals(this.name)) continue;
            isDirectoryDeployed = Boolean.valueOf(((Application)module).getDirectoryDeployed());
        }
        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            try {
                this.unregisterAppFromDomainXML(this.name);
            }
            catch (TransactionFailure e) {
                this.logger.warning("Module " + this.name + " not found in configuration");
            }
            this.deleteContainerMetaInfo(deploymentContext);
            if (!isDirectoryDeployed) {
                FileUtils.whack((File)new File(info.getSource().getURI()));
            }
            report.setMessage(localStrings.getLocalString("undeploy.command.sucess", "{0} undeployed successfully", new Object[]{this.name}));
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }
}

