/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.module.bootstrap.Populator;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.v3.server.V3Environment;
import com.sun.enterprise.v3.server.XMLStreamReaderFilter;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.config.support.GlassFishDocument;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DomainXml
implements Populator {
    @Inject
    StartupContext context;
    @Inject
    Logger logger;
    @Inject
    Habitat habitat;
    @Inject
    XMLInputFactory xif;
    File glassFishRoot;
    private static final String DEFAULT_DOMAINS_DIR_PROPNAME = "AS_DEF_DOMAINS_PATH";
    private static final String INSTANCE_ROOT_PROP_NAME = "com.sun.aas.instanceRoot";
    private File domainRoot;

    public void run(ConfigParser parser) {
        if (this.context == null) {
            System.err.println("Startup context not provided, cannot continue");
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Startup class : " + this.getClass().getName());
        }
        File bootstrapDirectory = this.context.getRootDirectory();
        this.glassFishRoot = bootstrapDirectory.getParentFile();
        if (!this.glassFishRoot.exists()) {
            throw new RuntimeException("No such path exists " + this.glassFishRoot);
        }
        this.parseAsEnv(this.glassFishRoot);
        this.setDomainRoot();
        V3Environment env = new V3Environment(this.domainRoot.getPath(), this.context);
        this.habitat.add((Inhabitant)new ExistingSingletonInhabitant(V3Environment.class, (Object)env));
        File domainXml = new File(env.getConfigDirPath(), "domain.xml");
        this.parseDomainXml(parser, domainXml);
    }

    private void parseDomainXml(ConfigParser parser, File domainXml) {
        try {
            String serverName = "server";
            DomainXmlReader xsr = new DomainXmlReader(domainXml, "server");
            parser.parse((XMLStreamReader)xsr, (DomDocument)new GlassFishDocument(this.habitat));
            xsr.close();
            if (!xsr.foundConfig) {
                throw new RuntimeException("No <config> seen for name=" + xsr.configName);
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Failed to parse " + domainXml, e);
        }
    }

    private void parseAsEnv(File installRootFile) {
        Properties asenvProps = new Properties();
        asenvProps.putAll((Map<?, ?>)System.getProperties());
        asenvProps.put("com.sun.aas.installRoot", this.glassFishRoot.getPath());
        File configDir = new File(installRootFile, "config");
        File asenv = this.getAsEnvConf(configDir);
        BufferedReader lnReader = null;
        try {
            lnReader = new LineNumberReader(new FileReader(asenv));
            String line = ((LineNumberReader)lnReader).readLine();
            Pattern p = Pattern.compile("[Ss]?[Ee]?[Tt]? *([^=]*)=\"?([^\"]*)\"?");
            while (line != null) {
                Matcher m = p.matcher(line);
                if (m.matches()) {
                    File f = new File(m.group(2));
                    if (!f.isAbsolute()) {
                        f = new File(configDir, m.group(2));
                        if (f.exists()) {
                            asenvProps.put(m.group(1), f.getAbsolutePath());
                        } else {
                            asenvProps.put(m.group(1), m.group(2));
                        }
                    } else {
                        asenvProps.put(m.group(1), m.group(2));
                    }
                }
                line = ((LineNumberReader)lnReader).readLine();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error opening asenv.conf : ", ioe);
        }
        finally {
            try {
                if (lnReader != null) {
                    lnReader.close();
                }
            }
            catch (IOException ioe) {}
        }
        System.setProperties(asenvProps);
    }

    private File getAsEnvConf(File configDir) {
        String osName = System.getProperty("os.name");
        if (osName.indexOf("Windows") == -1) {
            return new File(configDir, "asenv.conf");
        }
        return new File(configDir, "asenv.bat");
    }

    private void setDomainRoot() {
        this.domainRoot = this.getDomainRoot();
        this.verifyDomainRoot();
    }

    private File getDomainRoot() {
        Map args = this.context.getArguments();
        String domainDir = this.getParam(args, "domaindir");
        if (this.ok(domainDir)) {
            return new File(domainDir);
        }
        File defDomainsRoot = this.getDefaultDomainsDir();
        String domainName = this.getParam(args, "domain");
        if (this.ok(domainName)) {
            return new File(defDomainsRoot, domainName);
        }
        return this.getDefaultDomain(defDomainsRoot);
    }

    private void verifyDomainRoot() {
        String msg = null;
        if (this.domainRoot == null) {
            msg = "Internal Error: The domain dir is null.";
        } else if (!this.domainRoot.isDirectory()) {
            msg = "the domain directory is not a directory.";
        } else if (!this.domainRoot.canWrite()) {
            msg = "the domain directory is not writable.";
        } else if (!new File(this.domainRoot, "config").isDirectory()) {
            msg = "the domain directory is corrupt - there is no config subdirectory.";
        }
        if (msg != null) {
            throw new RuntimeException(msg);
        }
        this.domainRoot = this.absolutize(this.domainRoot);
        System.setProperty(INSTANCE_ROOT_PROP_NAME, this.domainRoot.getPath());
    }

    private File getDefaultDomainsDir() {
        String dirname = System.getProperty(DEFAULT_DOMAINS_DIR_PROPNAME);
        if (!this.ok(dirname)) {
            throw new RuntimeException("AS_DEF_DOMAINS_PATH is not set.");
        }
        File domainsDir = this.absolutize(new File(dirname));
        if (!domainsDir.isDirectory()) {
            throw new RuntimeException("AS_DEF_DOMAINS_PATH[" + dirname + "]" + " is specifying a file that is NOT a directory.");
        }
        return domainsDir;
    }

    private File getDefaultDomain(File domainsDir) {
        File[] domains = domainsDir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (domains == null || domains.length == 0) {
            throw new RuntimeException("no domain directories found under " + domainsDir);
        }
        if (domains.length > 1) {
            throw new RuntimeException("More than one domain found under " + domainsDir + " -- you must specify one domain.");
        }
        return domains[0];
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private String getParam(Map<String, String> map, String name) {
        String val = map.get("-" + name);
        if (val == null) {
            val = map.get("--" + name);
        }
        return val;
    }

    private File absolutize(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (Exception e) {
            return f.getAbsoluteFile();
        }
    }

    private class DomainXmlReader
    extends XMLStreamReaderFilter {
        private String configName;
        private final File domainXml;
        private final String serverName;
        private boolean foundConfig;
        private FileInputStream stream;

        public DomainXmlReader(File domainXml2, String serverName) throws XMLStreamException {
            try {
                this.stream = new FileInputStream(domainXml2);
            }
            catch (FileNotFoundException e) {
                throw new XMLStreamException(e);
            }
            this.setParent(DomainXml.this.xif.createXMLStreamReader(domainXml2.toURI().toString(), this.stream));
            this.domainXml = domainXml2;
            this.serverName = serverName;
        }

        public void close() throws XMLStreamException {
            super.close();
            try {
                this.stream.close();
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }

        boolean filterOut() throws XMLStreamException {
            this.checkConfigRef(this.getParent());
            if (this.getLocalName().equals("config")) {
                if (this.configName == null) {
                    this.parse2ndTime();
                    assert (this.configName != null);
                }
                if (this.configName.equals(this.getAttributeValue(null, "name"))) {
                    this.foundConfig = true;
                    return false;
                }
                return true;
            }
            return false;
        }

        private void parse2ndTime() throws XMLStreamException {
            DomainXml.this.logger.info("Forced to parse " + this.domainXml + " twice because we didn't see <server> before <config>");
            try {
                FileInputStream stream = new FileInputStream(this.domainXml);
                XMLStreamReader xsr = DomainXml.this.xif.createXMLStreamReader(this.domainXml.toURI().toString(), stream);
                while (this.configName == null) {
                    switch (xsr.next()) {
                        case 1: {
                            this.checkConfigRef(xsr);
                            break;
                        }
                    }
                }
                xsr.close();
                ((InputStream)stream).close();
                if (this.configName == null) {
                    throw new RuntimeException(this.domainXml + " contains no <server> element that matches " + this.serverName);
                }
            }
            catch (IOException e) {
                throw new XMLStreamException("Failed to parse " + this.domainXml, e);
            }
        }

        private void checkConfigRef(XMLStreamReader xsr) {
            String ln = xsr.getLocalName();
            if (this.configName == null && ln.equals("server") && this.serverName.equals(xsr.getAttributeValue(null, "name"))) {
                this.configName = xsr.getAttributeValue(null, "config-ref");
                if (this.configName == null) {
                    throw new RuntimeException("<server> element is missing @config-ref at " + this.formatLocation(xsr));
                }
            }
        }

        private String formatLocation(XMLStreamReader xsr) {
            return "line " + xsr.getLocation().getLineNumber() + " at " + xsr.getLocation().getSystemId();
        }
    }
}

