/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.v3.server.V3Environment;
import java.io.File;
import java.util.Map;
import javax.naming.InitialContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ServerContextImpl
implements ServerContext,
PostConstruct {
    @Inject
    V3Environment env;
    @Inject
    StartupContext startupContext;
    @Inject
    Habitat habitat;
    String instanceRoot;
    final String instanceName = "server";
    String[] args;

    public void postConstruct() {
        this.instanceRoot = this.env.getDomainRoot();
        this.args = new String[this.startupContext.getArguments().size() * 2];
        int i = 0;
        for (Map.Entry entry : this.startupContext.getArguments().entrySet()) {
            this.args[i++] = (String)entry.getKey();
            this.args[i++] = (String)entry.getValue();
        }
    }

    public String getInstanceRoot() {
        return this.instanceRoot;
    }

    public String[] getCmdLineArgs() {
        return this.args;
    }

    public String getInstallRoot() {
        return new File(this.instanceRoot).getParentFile().getParent();
    }

    public String getInstanceName() {
        return "server";
    }

    public String getServerConfigURL() {
        File domainXML = new File(this.instanceRoot, "config");
        domainXML = new File(domainXML, "domain.xml");
        return domainXML.toURI().toString();
    }

    public Server getConfigBean() {
        return (Server)this.habitat.getComponent(Server.class);
    }

    public InitialContext getInitialContext() {
        return null;
    }

    public ClassLoader getCommonClassLoader() {
        return null;
    }

    public ClassLoader getSharedClassLoader() {
        return null;
    }

    public ClassLoader getLifecycleParentClassLoader() {
        return null;
    }

    public String getDefaultDomainName() {
        return "com.sun.appserv";
    }

    public Habitat getDefaultHabitat() {
        return this.habitat;
    }
}

