/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.HttpFileCache;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpProtocol;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.KeepAlive;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.RequestProcessing;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.v3.services.impl.GrizzlyServiceListener;
import com.sun.grizzly.Controller;
import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.comet.CometAsyncFilter;
import com.sun.grizzly.http.AsyncFilter;
import com.sun.grizzly.http.AsyncHandler;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GrizzlyHttpEmbed {
    protected static final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    protected static final ResourceBundle _rb = logger.getResourceBundle();

    public static GrizzlyServiceListener createListener(HttpService httpService, HttpListener httpListener, int port, Controller controller) {
        System.setProperty("product.name", "GlassFish/v3");
        GrizzlyServiceListener grizzlyListener = new GrizzlyServiceListener();
        grizzlyListener.setPort(port);
        GrizzlyServiceListener.setWebAppRootPath((String)(System.getProperty("com.sun.aas.instanceRoot") + "/docroot"));
        boolean isSecure = Boolean.parseBoolean(httpListener.getSecurityEnabled());
        GrizzlyHttpEmbed.configureGrizzlyListener(grizzlyListener, httpListener, isSecure, httpService);
        return grizzlyListener;
    }

    private static void configureGrizzlyListener(GrizzlyServiceListener grizzlyListener, HttpListener httpListener, boolean isSecure, HttpService httpService) {
        String acceptorThreads;
        grizzlyListener.setName("grizzly-v3-" + httpListener.getPort());
        GrizzlyServiceListener.setLogger((Logger)logger);
        GrizzlyHttpEmbed.configureKeepAlive(grizzlyListener, httpService.getKeepAlive());
        GrizzlyHttpEmbed.configureHttpProtocol(grizzlyListener, httpService.getHttpProtocol());
        GrizzlyHttpEmbed.configureRequestProcessing(httpService.getRequestProcessing(), grizzlyListener);
        GrizzlyHttpEmbed.configureFileCache(grizzlyListener, httpService.getHttpFileCache());
        if (isSecure) {
            GrizzlyHttpEmbed.configureSSL(grizzlyListener, httpService, httpListener);
        }
        if ((acceptorThreads = httpListener.getAcceptorThreads()) != null) {
            try {
                int readController = Integer.parseInt(acceptorThreads) - 1;
                if (readController > 0) {
                    grizzlyListener.setSelectorReadThreadsCount(readController);
                }
            }
            catch (NumberFormatException nfe) {
                logger.log(Level.WARNING, "pewebcontainer.invalid_acceptor_threads", new Object[]{acceptorThreads, httpListener.getId(), Integer.toString(grizzlyListener.getMaxProcessorWorkerThreads())});
            }
        }
        GrizzlyHttpEmbed.configureHttpServiceProperties(httpService, grizzlyListener);
        GrizzlyHttpEmbed.configureHttpListenerProperties(httpListener, grizzlyListener);
        if (Boolean.valueOf(System.getProperty("v3.grizzly.cometSupport", "false")).booleanValue() && !httpListener.getId().equalsIgnoreCase("admin-listener")) {
            GrizzlyHttpEmbed.configureComet(grizzlyListener);
        }
    }

    private static void configureSSL(GrizzlyServiceListener grizzlyListener, HttpService httpService, HttpListener httpListener) {
        Ssl sslConfig = httpListener.getSsl();
        if (sslConfig == null) {
            return;
        }
        if (Boolean.getBoolean(sslConfig.getClientAuthEnabled())) {
            grizzlyListener.setNeedClientAuth(true);
        }
        LinkedList<String> tmpSSLArtifactsList = new LinkedList<String>();
        if (Boolean.getBoolean(sslConfig.getSsl2Enabled())) {
            tmpSSLArtifactsList.add("SSLv2");
        }
        if (Boolean.getBoolean(sslConfig.getSsl3Enabled())) {
            tmpSSLArtifactsList.add("SSLv3");
        }
        if (Boolean.getBoolean(sslConfig.getTlsEnabled())) {
            tmpSSLArtifactsList.add("TLSv1");
        }
        if (Boolean.getBoolean(sslConfig.getSsl3Enabled()) || Boolean.getBoolean(sslConfig.getTlsEnabled())) {
            tmpSSLArtifactsList.add("SSLv2Hello");
        }
        if (tmpSSLArtifactsList.isEmpty()) {
            logger.log(Level.WARNING, "pewebcontainer.all_ssl_protocols_disabled", httpListener.getId());
        } else {
            String[] enabledProtocols = new String[tmpSSLArtifactsList.size()];
            tmpSSLArtifactsList.toArray(enabledProtocols);
            grizzlyListener.setEnabledProtocols(enabledProtocols);
        }
        String certNickname = sslConfig.getCertNickname();
        if (certNickname != null && certNickname.length() > 0) {
            String keyAlias = sslConfig.getCertNickname();
        }
    }

    private static void configureKeepAlive(GrizzlyServiceListener grizzlyListener, KeepAlive keepAlive) {
        int timeoutInSeconds = 60;
        int maxConnections = 256;
        int threadCount = 1;
        if (keepAlive != null) {
            String msg;
            try {
                timeoutInSeconds = Integer.parseInt(keepAlive.getTimeoutInSeconds());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveTimeout");
                msg = MessageFormat.format(msg, keepAlive.getTimeoutInSeconds(), Integer.toString(timeoutInSeconds));
                logger.log(Level.WARNING, msg, ex);
            }
            try {
                maxConnections = Integer.parseInt(keepAlive.getMaxConnections());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveMaxConnections");
                msg = MessageFormat.format(msg, keepAlive.getMaxConnections(), Integer.toString(maxConnections));
                logger.log(Level.WARNING, msg, ex);
            }
            try {
                threadCount = Integer.parseInt(keepAlive.getThreadCount());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveThreadCount");
                msg = MessageFormat.format(msg, keepAlive.getThreadCount(), Integer.toString(threadCount));
                logger.log(Level.WARNING, msg, ex);
            }
        }
        grizzlyListener.setKeepAliveTimeoutInSeconds(timeoutInSeconds);
        grizzlyListener.setMaxKeepAliveRequests(maxConnections);
        grizzlyListener.setKeepAliveThreadCount(threadCount);
    }

    private static void configureHttpProtocol(GrizzlyServiceListener grizzlyListener, HttpProtocol httpProtocol) {
        if (httpProtocol == null) {
            return;
        }
        grizzlyListener.setForcedRequestType(httpProtocol.getForcedType());
        grizzlyListener.setDefaultResponseType(httpProtocol.getDefaultType());
    }

    private static void configureFileCache(GrizzlyServiceListener grizzlyListener, HttpFileCache httpFileCache) {
        if (httpFileCache == null) {
            return;
        }
        grizzlyListener.setFileCacheIsEnabled(true);
        grizzlyListener.setLargeFileCacheEnabled(true);
        if (httpFileCache.getMaxAgeInSeconds() != null) {
            grizzlyListener.setSecondsMaxAge(Integer.parseInt(httpFileCache.getMaxAgeInSeconds()));
        }
        if (httpFileCache.getMaxFilesCount() != null) {
            grizzlyListener.setMaxCacheEntries(Integer.parseInt(httpFileCache.getMaxFilesCount()));
        }
        if (httpFileCache.getSmallFileSizeLimitInBytes() != null) {
            grizzlyListener.setMinEntrySize(Integer.parseInt(httpFileCache.getSmallFileSizeLimitInBytes()));
        }
        if (httpFileCache.getMediumFileSizeLimitInBytes() != null) {
            grizzlyListener.setMaxEntrySize(Integer.parseInt(httpFileCache.getMediumFileSizeLimitInBytes()));
        }
        if (httpFileCache.getMediumFileSpaceInBytes() != null) {
            grizzlyListener.setMaxLargeCacheSize(Integer.parseInt(httpFileCache.getMediumFileSpaceInBytes()));
        }
        if (httpFileCache.getSmallFileSpaceInBytes() != null) {
            grizzlyListener.setMaxSmallCacheSize(Integer.parseInt(httpFileCache.getSmallFileSpaceInBytes()));
        }
    }

    protected static void configureRequestProcessing(RequestProcessing rp, GrizzlyServiceListener grizzlyListener) {
        if (rp == null) {
            return;
        }
        try {
            grizzlyListener.setMaxProcessorWorkerThreads(Integer.parseInt(rp.getThreadCount()));
            grizzlyListener.setMinWorkerThreads(Integer.parseInt(rp.getInitialThreadCount()));
            grizzlyListener.setThreadsTimeout(Integer.parseInt(rp.getRequestTimeoutInSeconds()));
            grizzlyListener.setThreadsIncrement(Integer.parseInt(rp.getThreadIncrement()));
            grizzlyListener.setMaxHttpHeaderSize(Integer.parseInt(rp.getHeaderBufferLengthInBytes()));
        }
        catch (NumberFormatException ex) {
            logger.log(Level.WARNING, " Invalid request-processing attribute", ex);
        }
    }

    private static void configureHttpListenerProperties(HttpListener httpListener, GrizzlyServiceListener grizzlyListener) {
        for (Property httpListenerProp : httpListener.getProperty()) {
            String propValue;
            String propName = httpListenerProp.getName();
            if (GrizzlyHttpEmbed.configureHttpListenerProperty(propName, propValue = httpListenerProp.getValue(), grizzlyListener)) continue;
            logger.log(Level.WARNING, "pewebcontainer.invalid_http_listener_property", propName);
        }
    }

    private static boolean configureHttpListenerProperty(String propName, String propValue, GrizzlyServiceListener grizzlyListener) throws NumberFormatException {
        if ("bufferSize".equals(propName)) {
            grizzlyListener.setBufferSize(Integer.parseInt(propValue));
            return true;
        }
        if ("recycle-objects".equals(propName)) {
            grizzlyListener.setRecycleTasks(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("use-nio-direct-bytebuffer".equals(propName)) {
            grizzlyListener.setUseByteBufferView(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("maxKeepAliveRequests".equals(propName)) {
            grizzlyListener.setMaxKeepAliveRequests(Integer.parseInt(propValue));
            return true;
        }
        if ("authPassthroughEnabled".equals(propName)) {
            grizzlyListener.setProperty(propName, ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("maxPostSize".equals(propName)) {
            grizzlyListener.setMaxPostSize(Integer.parseInt(propValue));
            return true;
        }
        if ("compression".equals(propName)) {
            grizzlyListener.setCompression(propValue);
            return true;
        }
        if ("compressableMimeType".equals(propName)) {
            grizzlyListener.setCompressableMimeTypes(propValue);
            return true;
        }
        if ("noCompressionUserAgents".equals(propName)) {
            grizzlyListener.setNoCompressionUserAgents(propValue);
            return true;
        }
        if ("compressionMinSize".equals(propName)) {
            grizzlyListener.setCompressionMinSize(Integer.parseInt(propValue));
            return true;
        }
        if ("restrictedUserAgents".equals(propName)) {
            grizzlyListener.setRestrictedUserAgents(propValue);
            return true;
        }
        if ("rcmSupport".equals(propName)) {
            grizzlyListener.setProperty(propName, ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("cometSupport".equals(propName)) {
            GrizzlyHttpEmbed.configureComet(grizzlyListener);
            return true;
        }
        if ("connectionUploadTimeout".equals(propName)) {
            grizzlyListener.setUploadTimeout(Integer.parseInt(propValue));
            return true;
        }
        if ("disableUploadTimeout".equals(propName)) {
            grizzlyListener.setDisableUploadTimeout(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("proxiedProtocols".equals(propName)) {
            grizzlyListener.setProperty(propName, propValue);
            return true;
        }
        if ("chunkingDisabled".equals(propName) || "chunking-disabled".equals(propName)) {
            grizzlyListener.setProperty(propName, ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("crlFile".equals(propName)) {
            grizzlyListener.setProperty(propName, propValue);
            return true;
        }
        if ("trustAlgorithm".equals(propName)) {
            grizzlyListener.setProperty(propName, propValue);
            return true;
        }
        if ("trustMaxCertLength".equals(propName)) {
            grizzlyListener.setProperty(propName, propValue);
            return true;
        }
        return false;
    }

    private static void configureHttpServiceProperties(HttpService httpService, GrizzlyServiceListener grizzlyListener) {
        List httpServiceProps = httpService.getProperty();
        if (httpServiceProps != null) {
            for (Property httpServiceProp : httpServiceProps) {
                String propValue;
                String propName = httpServiceProp.getName();
                if (GrizzlyHttpEmbed.configureHttpListenerProperty(propName, propValue = httpServiceProp.getValue(), grizzlyListener)) continue;
                if ("connectionTimeout".equals(propName)) {
                    grizzlyListener.setSoTimeout(Integer.parseInt(propValue));
                    continue;
                }
                if ("tcpNoDelay".equals(propName)) {
                    grizzlyListener.setTcpNoDelay(ConfigBeansUtilities.toBoolean((String)propValue));
                    continue;
                }
                if ("traceEnabled".equals(propName)) {
                    grizzlyListener.setProperty(propName, ConfigBeansUtilities.toBoolean((String)propValue));
                    continue;
                }
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "pewebcontainer.invalid_http_service_property", httpServiceProp.getName());
            }
        }
    }

    private static final void configureComet(GrizzlyServiceListener grizzlyListener) {
        grizzlyListener.setEnableAsyncExecution(true);
        DefaultAsyncHandler asyncHandler = new DefaultAsyncHandler();
        asyncHandler.addAsyncFilter((AsyncFilter)new CometAsyncFilter());
        grizzlyListener.setAsyncHandler((AsyncHandler)asyncHandler);
    }
}

