/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.v3.services.impl.EndpointMapper;
import com.sun.enterprise.v3.services.impl.GrizzlyHttpEmbed;
import com.sun.enterprise.v3.services.impl.GrizzlyServiceListener;
import com.sun.enterprise.v3.services.impl.NetworkProxy;
import com.sun.enterprise.v3.services.impl.VirtualHostMapper;
import com.sun.enterprise.v3.services.impl.WebProtocolHandler;
import com.sun.grizzly.Controller;
import com.sun.grizzly.http.portunif.HttpProtocolFinder;
import com.sun.grizzly.portunif.ProtocolHandler;
import com.sun.grizzly.portunif.TLSPUPreProcessor;
import com.sun.grizzly.tcp.Adapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.glassfish.api.deployment.ApplicationContainer;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyProxy
implements NetworkProxy {
    protected GrizzlyServiceListener grizzlyListener;
    final Logger logger;
    final HttpListener httpListener;
    final HttpService httpService;
    private EndpointMapper<Adapter> endPointMapper;
    private VirtualHostMapper vsMapper;
    private static final boolean isWebProfile = Boolean.parseBoolean(System.getProperty("v3.grizzly.webProfile", "true"));
    private static List<String> nvVsMapper = new ArrayList<String>();

    public GrizzlyProxy(Logger logger, Habitat habitat, HttpListener httpListener, Controller controller, HttpService httpService) {
        this.logger = logger;
        this.httpListener = httpListener;
        this.httpService = httpService;
        String port = httpListener.getPort();
        int portNumber = 8080;
        if (port == null) {
            logger.severe("Cannot find port information from domain.xml");
            throw new RuntimeException("Cannot find port information from domain configuration");
        }
        try {
            portNumber = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            logger.severe("Cannot parse port value : " + port + ", using port 8080");
        }
        this.configureGrizzly(portNumber, controller);
    }

    private void configureGrizzly(int port, Controller controller) {
        this.grizzlyListener = GrizzlyHttpEmbed.createListener(this.httpService, this.httpListener, port, controller);
        if (!isWebProfile) {
            SSLContext sslContext = this.grizzlyListener.getSSLContext();
            ArrayList<TLSPUPreProcessor> puPreProcessors = new ArrayList<TLSPUPreProcessor>();
            if (sslContext != null) {
                TLSPUPreProcessor preProcessor = new TLSPUPreProcessor(sslContext);
                puPreProcessors.add(preProcessor);
            }
            ArrayList<HttpProtocolFinder> protocolFinders = new ArrayList<HttpProtocolFinder>();
            protocolFinders.add(new HttpProtocolFinder());
            ArrayList<ProtocolHandler> protocolHandlers = new ArrayList<ProtocolHandler>();
            this.endPointMapper = new WebProtocolHandler(this.grizzlyListener);
            protocolHandlers.add((ProtocolHandler)this.endPointMapper);
            this.grizzlyListener.configurePortUnification(protocolFinders, protocolHandlers, puPreProcessors);
        } else {
            this.endPointMapper = this.grizzlyListener.createHttpProtocolFilter();
        }
    }

    @Override
    public void stop() {
        this.grizzlyListener.stopEndpoint();
    }

    public String toString() {
        return "Grizzly on port " + this.httpListener.getPort();
    }

    @Override
    public void registerEndpoint(String contextRoot, Collection<String> vsServers, Adapter endpointAdapter, ApplicationContainer container) {
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        if (!nvVsMapper.contains(endpointAdapter.getClass().getName())) {
            this.vsMapper.registerEndpoint(contextRoot, vsServers, endpointAdapter, container);
            endpointAdapter = this.vsMapper;
        }
        this.endPointMapper.registerEndpoint(contextRoot, vsServers, endpointAdapter, container);
    }

    @Override
    public void unregisterEndpoint(String contextRoot, ApplicationContainer app) {
        this.endPointMapper.unregisterEndpoint(contextRoot, app);
        this.vsMapper.unregisterEndpoint(contextRoot, app);
    }

    public String getContextRoot() {
        return "/";
    }

    @Override
    public void start() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    GrizzlyProxy.this.grizzlyListener.initEndpoint();
                    GrizzlyProxy.this.grizzlyListener.startEndpoint();
                }
                catch (InstantiationException e) {
                    GrizzlyProxy.this.logger.log(Level.SEVERE, "Cannot start grizzly listener", e);
                }
                catch (IOException e) {
                    GrizzlyProxy.this.logger.log(Level.SEVERE, "Cannot start grizzly listener", e);
                }
                catch (RuntimeException e) {
                    GrizzlyProxy.this.logger.log(Level.INFO, "Exception in grizzly thread", e);
                }
            }
        };
        thread.start();
        this.logger.info("Listening on port " + this.grizzlyListener.getPort());
    }

    @Override
    public void setVsMapper(VirtualHostMapper vsMapper) {
        this.vsMapper = vsMapper;
    }

    @Override
    public VirtualHostMapper getVsMapper() {
        return this.vsMapper;
    }

    static {
        nvVsMapper.add("org.apache.coyote.tomcat5.CoyoteAdapter");
        nvVsMapper.add("com.sun.enterprise.v3.admin.AdminAdapter");
    }
}

