/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.services.impl.GrizzlyAdapter;
import com.sun.enterprise.v3.services.impl.GrizzlyProxy;
import com.sun.enterprise.v3.services.impl.NetworkProxy;
import com.sun.enterprise.v3.services.impl.VirtualHostMapper;
import com.sun.grizzly.Controller;
import com.sun.grizzly.tcp.Adapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.api.deployment.ApplicationContainer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class GrizzlyService
implements Startup,
PostConstruct,
PreDestroy {
    @Inject(name="server-config")
    Config config;
    @Inject
    Logger logger;
    @Inject
    Habitat habitat;
    List<NetworkProxy> proxies = new ArrayList<NetworkProxy>();
    private final Controller controller = new Controller();
    private static final boolean enablePU = Boolean.parseBoolean(System.getProperty("v3.grizzly.enablePU", "true"));

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void postConstruct() {
        HttpService httpService = this.config.getHttpService();
        try {
            for (HttpListener listener : httpService.getHttpListener()) {
                NetworkProxy proxy = null;
                proxy = enablePU ? new GrizzlyProxy(this.logger, this.habitat, listener, this.controller, httpService) : new GrizzlyAdapter(this.logger, this.habitat, listener, this.controller);
                proxy.setVsMapper(new VirtualHostMapper(this.logger, listener));
                for (VirtualServer vs : httpService.getVirtualServer()) {
                    List vsListeners = StringUtils.parseStringList((String)vs.getHttpListeners(), (String)" ,");
                    if (!vsListeners.contains(listener.getId())) continue;
                    proxy.getVsMapper().addVirtualServer(vs);
                }
                proxy.start();
                this.proxies.add(proxy);
                for (org.glassfish.api.container.Adapter subAdapter : this.habitat.getAllByContract(org.glassfish.api.container.Adapter.class)) {
                    this.logger.fine("Registering proxy " + subAdapter.getContextRoot());
                    this.registerEndpoint(subAdapter.getContextRoot(), null, (Adapter)subAdapter, null);
                }
            }
        }
        catch (RuntimeException e) {
            this.logger.warning("Closing initialized network proxies");
            for (NetworkProxy proxy : this.proxies) {
                try {
                    proxy.stop();
                }
                catch (Exception proxyStopException) {
                    this.logger.log(Level.SEVERE, "Stop network proxy error ", proxyStopException);
                }
            }
            throw e;
        }
    }

    public void preDestroy() {
        for (NetworkProxy proxy : this.proxies) {
            proxy.stop();
        }
    }

    public void registerEndpoint(String contextRoot, Adapter endpointAdapter, ApplicationContainer container) {
        this.registerEndpoint(contextRoot, null, endpointAdapter, container);
    }

    public void registerEndpoint(String contextRoot, Collection<String> vsServers, Adapter endpointAdapter, ApplicationContainer container) {
        for (NetworkProxy proxy : this.proxies) {
            proxy.registerEndpoint(contextRoot, vsServers, endpointAdapter, container);
        }
    }

    public void unregisterEndpoint(String contextRoot) {
        this.unregisterEndpoint(contextRoot, null);
    }

    public void unregisterEndpoint(String contextRoot, ApplicationContainer app) {
        for (NetworkProxy proxy : this.proxies) {
            proxy.unregisterEndpoint(contextRoot, app);
        }
    }
}

