/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.GlassfishProtocolChain;
import com.sun.enterprise.v3.services.impl.HttpProtocolFilter;
import com.sun.grizzly.Controller;
import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.UDPSelectorHandler;
import com.sun.grizzly.arp.AsyncProtocolFilter;
import com.sun.grizzly.filter.ReadFilter;
import com.sun.grizzly.http.DefaultProcessorTask;
import com.sun.grizzly.http.DefaultProtocolFilter;
import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.SecureSelector;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.util.net.SSLImplementation;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.SSLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyServiceListener
extends SelectorThread
implements SecureSelector<SSLImplementation> {
    private SSLImplementation sslImplementation;
    protected SSLContext sslContext;
    private String[] enabledCipherSuites = null;
    private String[] enabledProtocols = null;
    private boolean clientMode = false;
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;
    private ProtocolFilter httpProtcolFilter;
    private boolean algorithInitialized = false;

    public GrizzlyServiceListener() {
    }

    public GrizzlyServiceListener(Controller controller) {
        this.controller = controller;
    }

    protected void initAlgorithm() {
        if (this.algorithInitialized) {
            return;
        }
        this.algorithInitialized = true;
        super.initAlgorithm();
    }

    protected void initController() {
        super.initController();
        if (this.portUnificationFilter != null) {
            DefaultProtocolChainInstanceHandler instanceHandler = new DefaultProtocolChainInstanceHandler(){
                private final ConcurrentLinkedQueue<ProtocolChain> chains = new ConcurrentLinkedQueue();

                public ProtocolChain poll() {
                    Object protocolChain = this.chains.poll();
                    if (protocolChain == null) {
                        protocolChain = new GlassfishProtocolChain();
                        GrizzlyServiceListener.this.configureFilters((ProtocolChain)protocolChain);
                    }
                    return protocolChain;
                }

                public boolean offer(ProtocolChain instance) {
                    return this.chains.offer(instance);
                }
            };
            this.controller.setProtocolChainInstanceHandler((ProtocolChainInstanceHandler)instanceHandler);
        }
        this.controller.setReadThreadsCount(this.readThreadsCount);
        this.controller.addSelectorHandler((SelectorHandler)this.createUDPSelectorHandler());
    }

    protected void configureFilters(ProtocolChain protocolChain) {
        if (this.portUnificationFilter != null) {
            protocolChain.addFilter((ProtocolFilter)this.portUnificationFilter);
            return;
        }
        ReadFilter readFilter = new ReadFilter();
        readFilter.setContinuousExecution(true);
        protocolChain.addFilter((ProtocolFilter)readFilter);
        if (this.rcmSupport) {
            protocolChain.addFilter(this.createRaFilter());
        }
        if (this.httpProtcolFilter == null) {
            this.httpProtcolFilter = this.createHttpParserFilter();
        }
        protocolChain.addFilter(this.httpProtcolFilter);
    }

    public ProcessorTask getProcessorTask() {
        if (this.asyncExecution) {
            HttpWorkerThread httpWorkerThread = (HttpWorkerThread)Thread.currentThread();
            DefaultProcessorTask contextPt = (DefaultProcessorTask)httpWorkerThread.getProcessorTask();
            if (contextPt == null) {
                return super.getProcessorTask();
            }
            DefaultProcessorTask pt = (DefaultProcessorTask)super.getProcessorTask();
            if (contextPt != null) {
                pt.setAdapter(contextPt.getAdapter());
            }
            return pt;
        }
        return super.getProcessorTask();
    }

    public HttpProtocolFilter createHttpProtocolFilter() {
        this.initAlgorithm();
        Object wrappedFilter = this.asyncExecution ? new AsyncProtocolFilter(this.algorithmClass, this.port) : new DefaultProtocolFilter(this.algorithmClass, this.port);
        this.httpProtcolFilter = new HttpProtocolFilter((ProtocolFilter)wrappedFilter, this);
        return (HttpProtocolFilter)this.httpProtcolFilter;
    }

    public HttpProtocolFilter getHttpProtocolFilter() {
        return (HttpProtocolFilter)this.httpProtcolFilter;
    }

    protected UDPSelectorHandler createUDPSelectorHandler() {
        UDPSelectorHandler udpSelectorHandler = new UDPSelectorHandler();
        udpSelectorHandler.setPort(this.port);
        udpSelectorHandler.setPipeline((Pipeline)this.processorPipeline);
        return udpSelectorHandler;
    }

    protected void configureSelectorHandler(UDPSelectorHandler selectorHandler) {
        selectorHandler.setPort(this.port);
        selectorHandler.setReuseAddress(this.getReuseAddress());
        selectorHandler.setPipeline((Pipeline)this.processorPipeline);
    }

    public void setSSLConfig(SSLConfig sslConfig) {
        this.sslContext = sslConfig.createSSLContext();
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public void setSSLImplementation(SSLImplementation sslImplementation) {
        this.sslImplementation = sslImplementation;
    }

    public SSLImplementation getSSLImplementation() {
        return this.sslImplementation;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }
}

