/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.EndpointMapper;
import com.sun.enterprise.v3.services.impl.GrizzlyServiceListener;
import com.sun.enterprise.v3.services.impl.Mapper;
import com.sun.enterprise.v3.services.impl.Pair;
import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.http.HtmlHelper;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.api.deployment.ApplicationContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpProtocolFilter
implements ProtocolFilter,
EndpointMapper<Adapter> {
    private static final String ROOT = "/";
    private Map<String, Pair<Adapter, ApplicationContainer>> adapters = new HashMap<String, Pair<Adapter, ApplicationContainer>>();
    private Mapper mapper;
    private GrizzlyServiceListener grizzlyListener;
    private final ProtocolFilter wrappedFilter;

    public HttpProtocolFilter(ProtocolFilter wrappedFilter, GrizzlyServiceListener grizzlyListener) {
        this.grizzlyListener = grizzlyListener;
        this.mapper = new Mapper(grizzlyListener);
        this.wrappedFilter = wrappedFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context ctx) throws IOException {
        block7: {
            ByteBuffer byteBuffer = ((WorkerThread)Thread.currentThread()).getByteBuffer();
            try {
                String contextRoot = this.mapper.mapContextRoot(byteBuffer);
                if (this.mapper.mapAdapter(contextRoot) != null) break block7;
                try {
                    ByteBuffer bb = HtmlHelper.getErrorPage((String)"Not Found", (String)"HTTP/1.1 404 Not Found\n");
                    OutputWriter.flushChannel((SelectableChannel)ctx.getSelectionKey().channel(), (ByteBuffer)bb);
                }
                catch (IOException ex) {
                    GrizzlyServiceListener.logger().log(Level.FINE, "Send Error failed", ex);
                }
                finally {
                    ((WorkerThread)Thread.currentThread()).getByteBuffer().clear();
                }
                return false;
            }
            catch (IOException ex) {
                GrizzlyServiceListener.logger().severe(ex.getMessage());
            }
        }
        return this.wrappedFilter.execute(ctx);
    }

    public boolean postExecute(Context ctx) throws IOException {
        return this.wrappedFilter.postExecute(ctx);
    }

    @Override
    public void registerEndpoint(String contextRoot, Collection<String> vs, Adapter adapter, ApplicationContainer container) {
        if (!contextRoot.startsWith(ROOT)) {
            contextRoot = ROOT + contextRoot;
        }
        Pair<Adapter, ApplicationContainer> pair = new Pair<Adapter, ApplicationContainer>(adapter, container);
        this.adapters.put(contextRoot, pair);
        this.mapper.register(this.adapters, null);
    }

    @Override
    public void unregisterEndpoint(String contextRoot, ApplicationContainer app) {
        this.adapters.remove(contextRoot);
        this.mapper.register(this.adapters, null);
    }
}

