/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.GlassfishProtocolChain;
import com.sun.enterprise.v3.services.impl.GrizzlyServiceListener;
import com.sun.enterprise.v3.services.impl.HttpUtils;
import com.sun.enterprise.v3.services.impl.Pair;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.http.DefaultProcessorTask;
import com.sun.grizzly.http.DefaultProtocolFilter;
import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.standalone.StaticStreamAlgorithm;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.ApplicationContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mapper {
    private static final String ROOT = "/";
    private GrizzlyServiceListener grizzlyListener;
    private Map<String, Pair<Adapter, ApplicationContainer>> adapters = null;
    private Map<String, List<ProtocolFilter>> contextProtocolFilters = null;
    private ArrayList<ProtocolFilter> defaultProtocolFilters;
    private ProtocolFilter fallbackProtocolFilter;

    public Mapper(GrizzlyServiceListener grizzlyListener) {
        this.grizzlyListener = grizzlyListener;
    }

    void register(Map<String, Pair<Adapter, ApplicationContainer>> adapters, Map<String, List<ProtocolFilter>> contextProtocolFilters) {
        this.adapters = adapters;
        this.contextProtocolFilters = contextProtocolFilters;
    }

    boolean map(GlassfishProtocolChain protocolChain, ByteBuffer byteBuffer) throws IOException {
        String contextRoot;
        Pair<Adapter, ApplicationContainer> pair;
        List<ProtocolFilter> protocolFilters = protocolChain.protocolFilters();
        Logger logger = GrizzlyServiceListener.logger();
        if (this.defaultProtocolFilters == null) {
            this.defaultProtocolFilters = new ArrayList();
            this.defaultProtocolFilters.addAll(protocolFilters);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Mapper.dump(byteBuffer));
        }
        if ((pair = this.mapAdapter(contextRoot = this.mapContextRoot(byteBuffer))) == null) {
            return false;
        }
        List<ProtocolFilter> filtersToInject = null;
        ApplicationContainer container = pair.getSecondElement();
        if (container == null) {
            if (this.fallbackProtocolFilter == null) {
                this.fallbackProtocolFilter = new DefaultProtocolFilter(StaticStreamAlgorithm.class, this.grizzlyListener.getPort());
            }
        } else {
            filtersToInject = this.contextProtocolFilters.get(contextRoot);
        }
        if (protocolFilters.size() != this.defaultProtocolFilters.size()) {
            protocolFilters.clear();
            protocolFilters.addAll(this.defaultProtocolFilters);
        }
        if (filtersToInject != null) {
            protocolFilters.addAll(filtersToInject);
        } else {
            protocolFilters.add(this.fallbackProtocolFilter);
        }
        return true;
    }

    String mapContextRoot(ByteBuffer byteBuffer) throws IOException {
        return ROOT + HttpUtils.findContextRoot(byteBuffer);
    }

    Pair<Adapter, ApplicationContainer> mapAdapter(String contextRoot) {
        Pair<Adapter, ApplicationContainer> pair = this.lookupAdapter(contextRoot);
        if (pair == null) {
            StaticResourcesAdapter adapter = new StaticResourcesAdapter();
            adapter.setRootFolder(GrizzlyServiceListener.getWebAppRootPath());
            pair = new Pair<StaticResourcesAdapter, Object>(adapter, null);
            this.adapters.put(contextRoot, pair);
        }
        if (pair != null) {
            this.bindProcessorTask(pair.getFirstElement());
        } else {
            GrizzlyServiceListener.logger().log(Level.WARNING, "Adapter was null for: " + contextRoot);
        }
        return pair;
    }

    private static final String dump(ByteBuffer byteBuffer) {
        ByteBuffer dd = byteBuffer.duplicate();
        dd.flip();
        int length = dd.limit();
        byte[] dump = new byte[length];
        dd.get(dump, 0, length);
        return new String(dump);
    }

    private void bindProcessorTask(Adapter adapter) {
        HttpWorkerThread workerThread = (HttpWorkerThread)Thread.currentThread();
        DefaultProcessorTask processorTask = (DefaultProcessorTask)workerThread.getProcessorTask();
        if (processorTask == null) {
            try {
                processorTask = (DefaultProcessorTask)this.grizzlyListener.getProcessorTask();
            }
            catch (ClassCastException ex) {
                GrizzlyServiceListener.logger().log(Level.SEVERE, "Invalid ProcessorTask instance", ex);
            }
            workerThread.setProcessorTask((ProcessorTask)processorTask);
        }
        processorTask.setAdapter(adapter);
    }

    private Pair<Adapter, ApplicationContainer> lookupAdapter(String contextRoot) {
        Pair<Adapter, ApplicationContainer> pair = null;
        while (true) {
            int lastIndexOfRoot;
            if ((pair = this.adapters.get(contextRoot)) != null) {
                Adapter adapter = pair.getFirstElement();
                ApplicationContainer container = pair.getSecondElement();
                ClassLoader cl = null;
                if (container != null) {
                    cl = container.getClassLoader();
                }
                try {
                    if (cl == null) {
                        cl = adapter.getClass().getClassLoader();
                    }
                    Thread.currentThread().setContextClassLoader(cl);
                }
                catch (Exception e) {}
                break;
            }
            if (contextRoot.equals(ROOT) || (lastIndexOfRoot = contextRoot.lastIndexOf(ROOT)) == -1) break;
            if ((contextRoot = contextRoot.substring(0, lastIndexOfRoot)).length() != 0) continue;
            contextRoot = ROOT;
        }
        return pair;
    }
}

