/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.EndpointMapper;
import com.sun.enterprise.v3.services.impl.GlassfishProtocolChain;
import com.sun.enterprise.v3.services.impl.GrizzlyServiceListener;
import com.sun.enterprise.v3.services.impl.HttpProtocolFilter;
import com.sun.enterprise.v3.services.impl.Mapper;
import com.sun.enterprise.v3.services.impl.Pair;
import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.http.HtmlHelper;
import com.sun.grizzly.portunif.PUProtocolRequest;
import com.sun.grizzly.portunif.ProtocolHandler;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.ApplicationContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebProtocolHandler
implements ProtocolHandler,
EndpointMapper<Adapter> {
    private static final String ROOT = "/";
    protected String[][] protocols = new String[][]{{"http"}, {"https"}, {"https", "http"}, {"sip"}, {"sip", "sip_tls"}};
    private Mode mode;
    private GrizzlyServiceListener grizzlyListener;
    private Map<String, Pair<Adapter, ApplicationContainer>> adapters = new HashMap<String, Pair<Adapter, ApplicationContainer>>();
    private HashMap<String, List<ProtocolFilter>> contextProtocolFilters = new HashMap();
    private ArrayList<ProtocolFilter> defaultProtocolFilters;
    private ProtocolFilter fallbackProtocolFilter;
    private Mapper mapper;
    private Logger logger;

    public WebProtocolHandler(GrizzlyServiceListener grizzlyListener) {
        this(Mode.HTTP, grizzlyListener);
    }

    public WebProtocolHandler(Mode mode, GrizzlyServiceListener grizzlyListener) {
        this.mode = mode;
        this.grizzlyListener = grizzlyListener;
        this.mapper = new Mapper(grizzlyListener);
        this.logger = GrizzlyServiceListener.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(Context context, PUProtocolRequest protocolRequest) throws IOException {
        boolean wasMap = this.mapper.map((GlassfishProtocolChain)context.getProtocolChain(), protocolRequest.getByteBuffer());
        if (!wasMap) {
            try {
                ByteBuffer bb = HtmlHelper.getErrorPage((String)"Not Found", (String)"HTTP/1.1 404 Not Found\n");
                OutputWriter.flushChannel((SelectableChannel)protocolRequest.getChannel(), (ByteBuffer)bb);
            }
            catch (IOException ex) {
                GrizzlyServiceListener.logger().log(Level.FINE, "Send Error failed", ex);
            }
            finally {
                ((WorkerThread)Thread.currentThread()).getByteBuffer().clear();
            }
            return false;
        }
        protocolRequest.setExecuteFilterChain(true);
        return wasMap;
    }

    @Override
    public void registerEndpoint(String contextRoot, Collection<String> vs, Adapter adapter, ApplicationContainer container) {
        if (!contextRoot.startsWith(ROOT)) {
            contextRoot = ROOT + contextRoot;
        }
        Pair<Adapter, ApplicationContainer> pair = new Pair<Adapter, ApplicationContainer>(adapter, container);
        this.adapters.put(contextRoot, pair);
        ArrayList<HttpProtocolFilter> filter = new ArrayList<HttpProtocolFilter>(1);
        filter.add(this.grizzlyListener.getHttpProtocolFilter());
        this.contextProtocolFilters.put(contextRoot, filter);
        this.mapper.register(this.adapters, this.contextProtocolFilters);
    }

    @Override
    public void unregisterEndpoint(String contextRoot, ApplicationContainer app) {
        if (this.adapters.remove(contextRoot) != null) {
            this.contextProtocolFilters.remove(contextRoot);
        }
        this.mapper.register(this.adapters, this.contextProtocolFilters);
    }

    public String[] getProtocols() {
        return this.protocols[this.mode.ordinal()];
    }

    public boolean expireKey(SelectionKey key) {
        return true;
    }

    public ArrayList<ProtocolFilter> getDefaultProtocolFilters() {
        return this.defaultProtocolFilters;
    }

    public void setDefaultProtocolFilters(ArrayList<ProtocolFilter> defaultProtocolFilters) {
        this.defaultProtocolFilters = defaultProtocolFilters;
    }

    public ProtocolFilter getFallbackProtocolFilter() {
        return this.fallbackProtocolFilter;
    }

    public void setFallbackProtocolFilter(ProtocolFilter fallbackProtocolFilter) {
        this.fallbackProtocolFilter = fallbackProtocolFilter;
    }

    public ByteBuffer getByteBuffer() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        HTTP,
        HTTPS,
        HTTP_HTTPS,
        SIP,
        SIP_TLS;

    }
}

