/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import com.sun.hk2.component.Holder;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigInjector;
import org.jvnet.hk2.config.ConfigurationException;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.tiger_types.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigModel {
    public final Inhabitant<? extends ConfigInjector> injector;
    final Map<String, Leaf> attributes = new HashMap<String, Leaf>();
    final Map<String, Property> elements = new HashMap<String, Property>();
    final List<String> contracts;
    final Set<String> symbolSpaces;
    final String tagName;
    public final Holder<ClassLoader> classLoaderHolder = new Holder<ClassLoader>(){

        public ClassLoader get() {
            return ((ConfigInjector)ConfigModel.this.injector.get()).getClass().getClassLoader();
        }
    };
    public final String targetTypeName;
    public final String keyedAs;
    public final String key;
    private static final String ELEMENT_NAME_PREFIX = ConfigInjector.class.getName() + ':';

    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    void inject(Dom dom, Object target) {
        try {
            ((ConfigInjector)this.injector.get()).inject(dom, target);
        }
        catch (ConfigurationException e) {
            e.setLocation(dom.getLocation());
            throw e;
        }
    }

    public ConfigModel(DomDocument document, Inhabitant<? extends ConfigInjector> injector, MultiMap<String, String> description) {
        if (description == null) {
            throw new ComponentException("%s doesn't have any metadata", new Object[]{injector.type()});
        }
        document.models.put(injector, this);
        this.injector = injector;
        String targetTypeName = null;
        String indexTypeName = null;
        String key = null;
        for (Map.Entry e : description.entrySet()) {
            String value;
            String name = (String)e.getKey();
            String string = value = ((List)e.getValue()).size() > 0 ? (String)((List)e.getValue()).get(0) : null;
            if (name.startsWith("@")) {
                String attributeName = name.substring(1);
                this.attributes.put(attributeName, new AttributeLeaf(attributeName));
                continue;
            }
            if (name.startsWith("<")) {
                String elementName = name.substring(1, name.length() - 1);
                this.elements.put(elementName, this.parseValue(elementName, document, value));
                continue;
            }
            if (name.equals("target")) {
                targetTypeName = value;
                continue;
            }
            if (name.equals("keyed-as")) {
                indexTypeName = value;
                continue;
            }
            if (!name.equals("key")) continue;
            key = value;
        }
        if (targetTypeName == null) {
            throw new ComponentException("%s doesn't have the mandatory '%s' metadata", new Object[]{injector.type(), "target"});
        }
        if (key == null ^ indexTypeName == null) {
            throw new ComponentException("%s has inconsistent '%s=%s' and '%s=%s' metadata", new Object[]{"key", key, "target", indexTypeName});
        }
        this.targetTypeName = targetTypeName;
        this.keyedAs = indexTypeName;
        this.key = key;
        this.contracts = description.get((Object)"target-contracts");
        this.symbolSpaces = new HashSet<String>(description.get((Object)"symbolSpaces"));
        String tagName = null;
        for (String v : description.get((Object)"index")) {
            if (!v.startsWith(ELEMENT_NAME_PREFIX)) continue;
            tagName = v.substring(ELEMENT_NAME_PREFIX.length());
        }
        this.tagName = tagName;
    }

    public Property findIgnoreCase(String xmlName) {
        Property a = this.attributes.get(xmlName);
        if (a != null) {
            return a;
        }
        a = this.elements.get(xmlName);
        if (a != null) {
            return a;
        }
        a = this._findIgnoreCase(xmlName, this.attributes);
        if (a != null) {
            return a;
        }
        return this._findIgnoreCase(xmlName, this.elements);
    }

    private Property _findIgnoreCase(String name, Map<String, ? extends Property> map) {
        for (Map.Entry<String, ? extends Property> i : map.entrySet()) {
            if (!i.getKey().equalsIgnoreCase(name)) continue;
            return i.getValue();
        }
        return null;
    }

    private Property parseValue(String elementName, DomDocument document, String value) {
        boolean collection = false;
        if (value.startsWith("collection:")) {
            collection = true;
            value = value.substring(11);
        }
        if (value.equals("leaf")) {
            if (collection) {
                return new CollectionLeaf(elementName);
            }
            return new SingleLeaf(elementName);
        }
        ConfigModel model = document.buildModel(value);
        if (collection) {
            return new CollectionNode(model, elementName);
        }
        return new SingleNode(model, elementName);
    }

    static final class SingleLeaf
    extends Leaf {
        SingleLeaf(String xmlName) {
            super(xmlName);
        }

        public boolean isCollection() {
            return false;
        }

        public Object get(Dom dom, Type returnType) {
            String v = dom.leafElement(this.xmlName);
            return SingleLeaf.convertLeafValue(Types.erasure((Type)returnType), v);
        }

        public void set(Dom dom, Object arg) {
            if (arg == null) {
                Logger.getAnonymousLogger().severe("TODO : KK : implement remove");
                return;
            }
            dom.setLeafElements(this.xmlName, arg.toString());
        }
    }

    static final class AttributeLeaf
    extends Leaf {
        AttributeLeaf(String xmlName) {
            super(xmlName);
        }

        public boolean isCollection() {
            return false;
        }

        public Object get(Dom dom, Type returnType) {
            String v = dom.attribute(this.xmlName);
            return AttributeLeaf.convertLeafValue(Types.erasure((Type)returnType), v);
        }

        public void set(Dom dom, Object arg) {
            if (arg == null) {
                Logger.getAnonymousLogger().severe("TODO : KK : implement remove");
                return;
            }
            dom.attribute(this.xmlName, arg.toString());
        }
    }

    static final class CollectionLeaf
    extends Leaf {
        CollectionLeaf(String xmlName) {
            super(xmlName);
        }

        public boolean isCollection() {
            return true;
        }

        public Object get(Dom dom, Type returnType) {
            final List<String> v = dom.leafElements(this.xmlName);
            if (!(returnType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("List needs to be parameterized");
            }
            final Class itemType = Types.erasure((Type)Types.getTypeArgument((Type)returnType, (int)0));
            return new AbstractList<Object>(){

                @Override
                public Object get(int index) {
                    return Leaf.convertLeafValue(itemType, (String)v.get(index));
                }

                @Override
                public int size() {
                    return v.size();
                }
            };
        }

        public void set(Dom dom, Object arg) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Leaf
    extends Property {
        private static final Set<String> BOOLEAN_TRUE = new HashSet<String>(Arrays.asList("true", "yes", "on", "1"));

        public Leaf(String xmlName) {
            super(xmlName);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        protected static Object convertLeafValue(Class<?> returnType, String v) {
            if (v == null) {
                return null;
            }
            if (returnType == String.class) {
                return v;
            }
            if (returnType == Integer.class || returnType == Integer.TYPE) {
                return Integer.valueOf(v);
            }
            if (returnType == Boolean.class || returnType == Boolean.TYPE) {
                return BOOLEAN_TRUE.contains(v);
            }
            throw new IllegalArgumentException("Don't know how to handle " + returnType);
        }
    }

    static final class SingleNode
    extends Node {
        SingleNode(ConfigModel model, String xmlName) {
            super(model, xmlName);
        }

        public boolean isCollection() {
            return false;
        }

        public Object get(Dom dom, Type returnType) {
            Dom v = dom.nodeElement(this.xmlName);
            if (v == null) {
                return null;
            }
            if (returnType == Dom.class) {
                return v;
            }
            Class rt = Types.erasure((Type)returnType);
            if (ConfigBeanProxy.class.isAssignableFrom(rt)) {
                return v.createProxy();
            }
            throw new IllegalArgumentException("Invalid type " + returnType + " for " + this.xmlName);
        }

        public void set(Dom dom, Object arg) {
            Dom child = this.toDom(arg);
            if (child == null) {
                dom.setNodeElements(this.xmlName, new Dom[0]);
            } else {
                dom.setNodeElements(this.xmlName, child);
            }
        }
    }

    static final class CollectionNode
    extends Node {
        CollectionNode(ConfigModel model, String xmlName) {
            super(model, xmlName);
        }

        public boolean isCollection() {
            return true;
        }

        public Object get(final Dom dom, Type returnType) {
            List<Dom> v;
            if (!(returnType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("List needs to be parameterized");
            }
            Class itemType = Types.erasure((Type)Types.getTypeArgument((Type)returnType, (int)0));
            List<Dom> list = v = "*".equals(this.xmlName) ? dom.domNodeByTypeElements(itemType) : dom.nodeElements(this.xmlName);
            if (itemType == Dom.class) {
                return v;
            }
            if (ConfigBeanProxy.class.isAssignableFrom(itemType)) {
                return new AbstractList<Object>(){

                    @Override
                    public Object get(int index) {
                        return ((Dom)v.get(index)).createProxy();
                    }

                    @Override
                    public void add(int index, Object element) {
                        Dom child = Dom.unwrap((ConfigBeanProxy)element);
                        dom.insertAfter(index == 0 ? null : (Dom)v.get(index - 1), CollectionNode.this.xmlName, child);
                        v.add(index, child);
                    }

                    @Override
                    public Object remove(int index) {
                        Dom child = (Dom)v.get(index);
                        dom.removeChild(child);
                        v.remove(index);
                        return child.createProxy();
                    }

                    @Override
                    public Object set(int index, Object element) {
                        Dom child = Dom.unwrap((ConfigBeanProxy)element);
                        dom.replaceChild((Dom)v.get(index), CollectionNode.this.xmlName, child);
                        return v.set(index, child).createProxy();
                    }

                    @Override
                    public int size() {
                        return v.size();
                    }
                };
            }
            return new AbstractList(){

                public Object get(int index) {
                    return ((Dom)v.get(index)).get();
                }

                public int size() {
                    return v.size();
                }
            };
        }

        public void set(Dom dom, Object _arg) {
            if (!(_arg instanceof List)) {
                throw new IllegalArgumentException("Expecting a list but found " + _arg);
            }
            List arg = (List)_arg;
            Dom[] values = new Dom[arg.size()];
            int i = 0;
            for (Object o : arg) {
                values[i++] = this.toDom(o);
            }
            dom.setNodeElements(this.xmlName, values);
        }
    }

    static abstract class Node
    extends Property {
        final ConfigModel model;

        public Node(ConfigModel model, String xmlName) {
            super(xmlName);
            this.model = model;
        }

        public boolean isLeaf() {
            return false;
        }

        protected final Dom toDom(Object arg) {
            if (arg == null) {
                return null;
            }
            if (arg instanceof Dom) {
                return (Dom)arg;
            }
            if (arg instanceof ConfigBeanProxy) {
                return Dom.unwrap((ConfigBeanProxy)arg);
            }
            throw new IllegalArgumentException("Unexpected type " + arg.getClass() + " for " + this.xmlName);
        }
    }

    public static abstract class Property {
        public final String xmlName;

        protected Property(String xmlName) {
            this.xmlName = xmlName;
        }

        public final String xmlName() {
            return this.xmlName;
        }

        public abstract boolean isLeaf();

        public abstract boolean isCollection();

        public abstract Object get(Dom var1, Type var2);

        public abstract void set(Dom var1, Object var2);
    }
}

