/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigView;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.Transformer;
import org.jvnet.hk2.config.WriteableView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ConfigSupport {
    public static <T extends ConfigBeanProxy> Object apply(final SingleConfigCode<T> code, T param) throws TransactionFailure {
        ConfigBeanProxy[] objects = new ConfigBeanProxy[]{param};
        return ConfigSupport.apply(new ConfigCode(){

            public Object run(ConfigBeanProxy ... objects) throws PropertyVetoException, TransactionFailure {
                return code.run(objects[0]);
            }
        }, objects);
    }

    public static <T extends ConfigBeanProxy> T createChildOf(Object parent, Class<T> type) throws TransactionFailure {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        try {
            WriteableView bean = (WriteableView)WriteableView.class.cast(Proxy.getInvocationHandler(Proxy.class.cast(parent)));
            return bean.allocateProxy(type);
        }
        catch (ClassCastException e) {
            throw new TransactionFailure("Must use a locked parent config object for instantiating new config object", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object apply(ConfigCode code, ConfigBeanProxy ... objects) throws TransactionFailure {
        WriteableView[] views = new WriteableView[objects.length];
        ConfigBeanProxy[] proxies = new ConfigBeanProxy[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            proxies[i] = ConfigSupport.getWriteableView(objects[i]);
            views[i] = (WriteableView)Proxy.getInvocationHandler(proxies[i]);
        }
        Transaction t = new Transaction();
        for (WriteableView view : views) {
            if (view.join(t)) continue;
            t.rollback();
            return null;
        }
        try {
            Object toReturn = code.run(proxies);
            try {
                t.commit();
                if (toReturn instanceof WriteableView) {
                    return ((WriteableView)toReturn).getMasterView();
                }
                return toReturn;
            }
            catch (RetryableException e) {
                System.out.println("Retryable...");
                t.rollback();
                return null;
            }
            catch (TransactionFailure e) {
                System.out.println("failure, not retryable...");
                t.rollback();
                throw e;
            }
        }
        catch (PropertyVetoException e) {
            t.rollback();
            throw new TransactionFailure(e.getMessage(), e);
        }
        catch (TransactionFailure e) {
            t.rollback();
            throw e;
        }
    }

    static <T extends ConfigBeanProxy> WriteableView getWriteableView(T s, ConfigBean sourceBean) {
        WriteableView f = new WriteableView(s);
        if (sourceBean.getLock().tryLock()) {
            return f;
        }
        return null;
    }

    public static <T extends ConfigBeanProxy> T getWriteableView(final T source) {
        Transformer writeableTransformer = new Transformer(){

            @Override
            public <T extends ConfigBeanProxy> T transform(T s) {
                ConfigView sourceBean = (ConfigView)Proxy.getInvocationHandler(s);
                WriteableView writeableView = new WriteableView(source);
                return writeableView.getProxy(sourceBean.getProxyType());
            }
        };
        return ConfigSupport.getView(writeableTransformer, source);
    }

    public static <T extends ConfigBeanProxy> T getView(Transformer t, T source) {
        return t.transform(source);
    }

    public static ConfigView getImpl(ConfigBeanProxy source) {
        InvocationHandler bean = Proxy.getInvocationHandler(source);
        if (bean instanceof ConfigView) {
            return ((ConfigView)bean).getMasterView();
        }
        return (ConfigBean)bean;
    }

    public static <T extends ConfigBeanProxy> Class<T> proxyType(T element) {
        ConfigView bean = ConfigSupport.getImpl(element);
        return bean.getProxyType();
    }

    public static void sortAndDispatch(PropertyChangeEvent[] events, Changed target, Logger logger) {
        ArrayList unprocessed = new ArrayList();
        ArrayList<Dom> added = new ArrayList<Dom>();
        ArrayList<Dom> changed = new ArrayList<Dom>();
        for (PropertyChangeEvent event : events) {
            if (event.getOldValue() != null || !(event.getNewValue() instanceof ConfigBeanProxy)) continue;
            try {
                ConfigBeanProxy proxy = (ConfigBeanProxy)ConfigBeanProxy.class.cast(event.getNewValue());
                added.add(Dom.unwrap(proxy));
                target.changed(Changed.TYPE.ADD, ConfigSupport.proxyType(proxy), proxy);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception while processing config bean changes : ", e);
            }
        }
        for (PropertyChangeEvent event : events) {
            try {
                ConfigBeanProxy proxy;
                Dom eventSource = Dom.unwrap((ConfigBeanProxy)event.getSource());
                if (added.contains(eventSource)) continue;
                if (event.getNewValue() == null) {
                    proxy = (ConfigBeanProxy)ConfigBeanProxy.class.cast(event.getOldValue());
                    target.changed(Changed.TYPE.REMOVE, ConfigSupport.proxyType(proxy), proxy);
                    continue;
                }
                if (changed.contains(eventSource)) continue;
                proxy = (ConfigBeanProxy)ConfigBeanProxy.class.cast(event.getSource());
                changed.add(eventSource);
                target.changed(Changed.TYPE.CHANGE, ConfigSupport.proxyType(proxy), proxy);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception while processing config bean changes : ", e);
            }
        }
    }
}

