/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ConfigView;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.Transactor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteableView
implements InvocationHandler,
Transactor,
ConfigView {
    private final ConfigBean bean;
    private final ConfigBeanProxy readView;
    private final Map<String, PropertyChangeEvent> changedAttributes;
    private final Map<String, ProtectedList> changedCollections;
    Transaction currentTx;

    public WriteableView(ConfigBeanProxy readView) {
        this.readView = readView;
        this.bean = (ConfigBean)((ConfigView)Proxy.getInvocationHandler(readView)).getMasterView();
        this.changedAttributes = new HashMap<String, PropertyChangeEvent>();
        this.changedCollections = new HashMap<String, ProtectedList>();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ConfigModel.Property property = this.bean.toProperty(method);
        if (property == null) {
            throw new IllegalArgumentException("No corresponding property found for method: " + method);
        }
        if (args == null || args.length == 0) {
            if (this.changedAttributes.containsKey(property.xmlName())) {
                return this.changedAttributes.get(property.xmlName()).getNewValue();
            }
            Object value = this.bean.invoke(proxy, method, args);
            if (value instanceof List) {
                if (!this.changedCollections.containsKey(property.xmlName())) {
                    try {
                        if (!(method.getGenericReturnType() instanceof ParameterizedType)) {
                            throw new IllegalArgumentException("List needs to be parameterized");
                        }
                        this.changedCollections.put(property.xmlName(), new ProtectedList((List)value, this.readView, property.xmlName()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw e;
                    }
                }
                return this.changedCollections.get(property.xmlName());
            }
            return value;
        }
        if (this.currentTx == null) {
            throw new IllegalStateException("Not part of a transation");
        }
        Object oldValue = this.bean.getter(property, method.getGenericParameterTypes()[0]);
        Object newValue = args[0];
        if (args[0] instanceof ConfigBeanProxy) {
            ConfigView bean = (ConfigView)Proxy.getInvocationHandler((ConfigBeanProxy)args[0]);
            newValue = bean.getMasterView();
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this.readView, property.xmlName(), oldValue, newValue);
        this.changedAttributes.put(property.xmlName(), evt);
        return null;
    }

    @Override
    public synchronized boolean join(Transaction t) {
        if (this.currentTx == null) {
            this.currentTx = t;
            t.addParticipant(this);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean canCommit(Transaction t) {
        return this.currentTx == t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<PropertyChangeEvent> commit(Transaction t) throws TransactionFailure {
        if (this.currentTx == t) {
            this.currentTx = null;
        }
        try {
            ArrayList<PropertyChangeEvent> appliedChanges = new ArrayList<PropertyChangeEvent>();
            for (PropertyChangeEvent event : this.changedAttributes.values()) {
                ConfigModel.Property property = this.bean.model.findIgnoreCase(event.getPropertyName());
                property.set(this.bean, event.getNewValue());
                appliedChanges.add(event);
            }
            for (ProtectedList entry : this.changedCollections.values()) {
                List originalList = entry.readOnly;
                for (PropertyChangeEvent event : entry.changeEvents) {
                    if (event.getOldValue() == null) {
                        originalList.add(event.getNewValue());
                    } else {
                        Dom toBeRemoved = Dom.unwrap((ConfigBeanProxy)event.getOldValue());
                        for (int index = 0; index < originalList.size(); ++index) {
                            Object element = originalList.get(index);
                            Dom dom = Dom.unwrap((ConfigBeanProxy)element);
                            if (dom != toBeRemoved) continue;
                            originalList.remove(index);
                        }
                    }
                    appliedChanges.add(event);
                }
            }
            this.changedAttributes.clear();
            ArrayList<PropertyChangeEvent> arrayList = appliedChanges;
            return arrayList;
        }
        finally {
            this.bean.getLock().unlock();
        }
    }

    @Override
    public synchronized void abort(Transaction t) {
        this.currentTx = null;
        this.bean.getLock().unlock();
        this.changedAttributes.clear();
    }

    public <T extends ConfigBeanProxy> T allocateProxy(Class<T> type) throws TransactionFailure {
        if (this.currentTx == null) {
            throw new TransactionFailure("Not part of a transaction", null);
        }
        ConfigBean newBean = this.bean.allocate(type);
        WriteableView writeableView = ConfigSupport.getWriteableView(newBean.getProxy(type), newBean);
        writeableView.join(this.currentTx);
        return writeableView.getProxy(type);
    }

    @Override
    public ConfigBean getMasterView() {
        return this.bean;
    }

    @Override
    public void setMasterView(ConfigView view) {
    }

    @Override
    public <T extends ConfigBeanProxy> Class<T> getProxyType() {
        return this.bean.getProxyType();
    }

    @Override
    public <T extends ConfigBeanProxy> T getProxy(Class<T> type) {
        ConfigBean sourceBean = this.getMasterView();
        if (!type.getName().equals(sourceBean.model.targetTypeName)) {
            throw new IllegalArgumentException("This config bean interface is " + sourceBean.model.targetTypeName + " not " + type.getName());
        }
        Class[] interfacesClasses = new Class[]{type};
        return (T)((ConfigBeanProxy)Proxy.newProxyInstance(type.getClassLoader(), interfacesClasses, (InvocationHandler)this));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProtectedList<T extends ConfigBeanProxy>
    extends ArrayList<T> {
        final ConfigBeanProxy readView;
        final List readOnly;
        final String id;
        final List<PropertyChangeEvent> changeEvents;

        ProtectedList(List readOnly, ConfigBeanProxy parent, String id) {
            super(readOnly);
            this.changeEvents = new ArrayList<PropertyChangeEvent>();
            this.readView = parent;
            this.readOnly = readOnly;
            this.id = id;
        }

        @Override
        public boolean add(T object) {
            Object param = object;
            InvocationHandler handler = Proxy.getInvocationHandler(object);
            if (handler instanceof WriteableView) {
                param = ((WriteableView)handler).readView;
            }
            this.changeEvents.add(new PropertyChangeEvent(this.readView, this.id, null, param));
            return super.add(object);
        }

        @Override
        public boolean remove(Object object) {
            this.changeEvents.add(new PropertyChangeEvent(this.readView, this.id, object, null));
            return super.remove(object);
        }
    }
}

