/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.SecuritySupportImpl;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.server.V3Environment;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class SecurityServicesUtil
implements Startup {
    @Inject(name="PE")
    private SecuritySupport peSecSupport;
    @Inject
    private V3Environment v3env;
    @Inject
    private static Habitat habitat;
    private static final LocalStringManagerImpl _localStrings;
    private static final Logger _logger;
    public static final SecureRandom secureRandom;

    public SecuritySupport getSecuritySupport() {
        if (this.peSecSupport == null) {
            this.peSecSupport = new SecuritySupportImpl();
        }
        return this.peSecSupport;
    }

    public void initSecureSeed() {
        String seedFile = this.v3env.getConfigDirPath() + File.separator + "secure.seed";
        File secureSeedFile = new File(seedFile);
        long seed = this.readSecureSeed(secureSeedFile);
        secureRandom.setSeed(seed);
        seed = secureRandom.nextLong();
        this.writeSecureSeed(secureSeedFile, seed);
        secureSeedFile = null;
    }

    private long readSecureSeed(File fname) {
        try {
            BufferedReader fis = new BufferedReader(new FileReader(fname));
            try {
                String line = fis.readLine();
                fis.close();
                Long lseed = new Long(line);
                return lseed;
            }
            catch (IOException e) {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        secureRandom.setSeed(System.currentTimeMillis());
        long newSeed = secureRandom.nextLong();
        return newSeed;
    }

    private void writeSecureSeed(File fname, long seed) {
        try {
            FileOutputStream fos = new FileOutputStream(fname);
            String sseed = Long.toString(seed);
            fos.write(sseed.getBytes());
            fos.close();
        }
        catch (IOException e) {
            String errmsg = _localStrings.getLocalString("j2ee.startupslow", "Cannot write the seed file for fast startup. The next startup will be slow.");
            _logger.log(Level.WARNING, errmsg);
        }
    }

    public Habitat getHabitat() {
        return habitat;
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.START;
    }

    public static SecurityServicesUtil getInstance() {
        return (SecurityServicesUtil)habitat.getComponent(SecurityServicesUtil.class);
    }

    static {
        _localStrings = new LocalStringManagerImpl(SecurityServicesUtil.class);
        _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.security");
        secureRandom = new SecureRandom();
        secureRandom.setSeed(System.currentTimeMillis());
    }
}

