/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jmac.config;

import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.security.AppservAccessController;
import com.sun.enterprise.security.jmac.AuthMessagePolicy;
import com.sun.enterprise.security.jmac.config.ConfigParser;
import com.sun.logging.LogDomains;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.config.AuthConfig;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.ClientAuthConfig;
import javax.security.auth.message.config.ClientAuthContext;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.auth.message.module.ClientAuthModule;
import javax.security.auth.message.module.ServerAuthModule;

public class GFServerConfigProvider
implements AuthConfigProvider {
    public static final String SOAP = "SOAP";
    public static final String HTTPSERVLET = "HttpServlet";
    protected static final String CLIENT = "client";
    protected static final String SERVER = "server";
    protected static final String MANAGES_SESSIONS_OPTION = "managessessions";
    private static Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.core.security");
    private static final String DEFAULT_HANDLER_CLASS = "com.sun.enterprise.security.jmac.callback.ContainerCallbackHandler";
    private static final String DEFAULT_PARSER_CLASS = "com.sun.enterprise.security.jmac.config.ConfigXMLParser";
    private static final ThreadLocal<Subject> subjectLocal = new ThreadLocal();
    protected static final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected static final Map<String, String> layerDefaultRegisIDMap = new HashMap<String, String>();
    protected static int epoch;
    protected static String parserClassName;
    protected static ConfigParser parser;
    protected static boolean parserInitialized;
    protected static AuthConfigFactory slaveFactory;
    protected static AuthConfigProvider slaveProvider;
    protected AuthConfigFactory factory = null;

    private GFServerConfigProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GFServerConfigProvider(Map properties, AuthConfigFactory factory) {
        this.factory = factory;
        this.initializeParser();
        if (factory != null) {
            boolean hasSlaveFactory = false;
            try {
                rwLock.readLock().lock();
                hasSlaveFactory = slaveFactory != null;
            }
            finally {
                rwLock.readLock().unlock();
            }
            if (!hasSlaveFactory) {
                try {
                    rwLock.writeLock().lock();
                    if (slaveFactory == null) {
                        slaveFactory = factory;
                    }
                }
                finally {
                    rwLock.writeLock().unlock();
                }
            }
        }
        boolean hasSlaveProvider = false;
        try {
            rwLock.readLock().lock();
            hasSlaveProvider = slaveProvider != null;
        }
        finally {
            rwLock.readLock().unlock();
        }
        if (!hasSlaveProvider) {
            try {
                rwLock.writeLock().lock();
                if (slaveProvider == null) {
                    slaveProvider = this;
                }
            }
            finally {
                rwLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeParser() {
        try {
            rwLock.readLock().lock();
            if (parserInitialized) {
                return;
            }
        }
        finally {
            rwLock.readLock().unlock();
        }
        try {
            rwLock.writeLock().lock();
            if (!parserInitialized) {
                parserClassName = System.getProperty("config.parser", DEFAULT_PARSER_CLASS);
                parserInitialized = true;
            }
        }
        finally {
            rwLock.writeLock().unlock();
        }
    }

    protected static ModuleInfo createModuleInfo(Entry entry, CallbackHandler handler, String type, Map properties) throws AuthException {
        try {
            Object newModule = entry.newInstance();
            HashMap map = properties;
            Map entryOptions = entry.getOptions();
            if (entryOptions != null) {
                map = map == null ? new HashMap() : new HashMap(map);
                map.putAll(entryOptions);
            }
            if (SERVER.equals(type)) {
                if (newModule instanceof ServerAuthModule) {
                    ServerAuthModule sam = (ServerAuthModule)newModule;
                    sam.initialize(entry.getRequestPolicy(), entry.getResponsePolicy(), handler, map);
                }
            } else if (newModule instanceof ClientAuthModule) {
                ClientAuthModule cam = (ClientAuthModule)newModule;
                cam.initialize(entry.getRequestPolicy(), entry.getResponsePolicy(), handler, map);
            }
            return new ModuleInfo(newModule, map);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                throw (AuthException)e;
            }
            AuthException ae = new AuthException();
            ae.initCause(e);
            throw ae;
        }
    }

    private static Object createObject(String className) {
        try {
            final String finalClassName = className;
            return AppservAccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> c = Class.forName(finalClassName, true, loader);
                    return c.newInstance();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException(pae.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entry getEntry(String intercept, String id, MessagePolicy requestPolicy, MessagePolicy responsePolicy, String type) {
        MessagePolicy respP;
        Map configMap;
        try {
            rwLock.readLock().lock();
            configMap = parser.getConfigMap();
        }
        finally {
            rwLock.readLock().unlock();
        }
        if (configMap == null) {
            return null;
        }
        InterceptEntry intEntry = (InterceptEntry)configMap.get(intercept);
        if (intEntry == null || intEntry.idMap == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("module config has no IDs configured for [" + intercept + "]");
            }
            return null;
        }
        IDEntry idEntry = null;
        if (id == null || (idEntry = (IDEntry)intEntry.idMap.get(id)) == null) {
            String defaultID;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("DD did not specify ID, or DD-specified ID for [" + intercept + "] not found in config -- " + "attempting to look for default ID");
            }
            if ((idEntry = (IDEntry)intEntry.idMap.get(defaultID = CLIENT.equals(type) ? intEntry.defaultClientID : intEntry.defaultServerID)) == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("no default config ID for [" + intercept + "]");
                }
                return null;
            }
        }
        if (idEntry.type.indexOf(type) < 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("request type [" + type + "] does not match config type [" + idEntry.type + "]");
            }
            return null;
        }
        MessagePolicy reqP = requestPolicy != null || responsePolicy != null ? requestPolicy : idEntry.requestPolicy;
        MessagePolicy messagePolicy = respP = requestPolicy != null || responsePolicy != null ? responsePolicy : idEntry.responsePolicy;
        if (reqP == null && respP == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("no policy applies");
            }
            return null;
        }
        Entry entry = new Entry(idEntry.moduleClassName, reqP, respP, idEntry.options);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getEntry for: " + intercept + " -- " + id + "\n    module class: " + entry.moduleClassName + "\n    options: " + entry.options + "\n    request policy: " + entry.requestPolicy + "\n    response policy: " + entry.responsePolicy);
        }
        return entry;
    }

    public ClientAuthConfig getClientAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException {
        return new GFClientAuthConfig(this, layer, appContext, handler);
    }

    public ServerAuthConfig getServerAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException {
        return new GFServerAuthConfig(this, layer, appContext, handler);
    }

    public void refresh() {
    }

    protected static ClassLoader getClassLoader() {
        ClassLoader rvalue = (ClassLoader)AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return rvalue;
    }

    public static void setValidateRequestSubject(Subject subject) {
        subjectLocal.set(subject);
    }

    static {
        parserClassName = null;
        parserInitialized = false;
        slaveFactory = null;
        slaveProvider = null;
    }

    protected static class GFClientAuthContext
    implements ClientAuthContext {
        private GFClientAuthConfig config;
        private ClientAuthModule module;
        private Map map;

        protected GFClientAuthContext(GFClientAuthConfig config, ClientAuthModule module, Map map) {
            this.config = config;
            this.module = module;
            this.map = map;
        }

        public AuthStatus secureRequest(MessageInfo messageInfo, Subject clientSubject) throws AuthException {
            if (this.module != null) {
                return this.module.secureRequest(messageInfo, clientSubject);
            }
            throw new AuthException();
        }

        public AuthStatus validateResponse(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
            if (this.module != null) {
                return this.module.validateResponse(messageInfo, clientSubject, serviceSubject);
            }
            throw new AuthException();
        }

        public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
            if (this.module == null) {
                throw new AuthException();
            }
            this.module.cleanSubject(messageInfo, subject);
        }
    }

    protected static class GFServerAuthContext
    implements ServerAuthContext {
        private GFServerAuthConfig config;
        private ServerAuthModule module;
        private Map map;
        boolean managesSession = false;

        protected GFServerAuthContext(GFServerAuthConfig config, ServerAuthModule module, Map map) {
            this.config = config;
            this.module = module;
            this.map = map;
        }

        private static void setCallerPrincipals(final Subject s, final CallbackHandler handler, final Subject pvcSubject) throws AuthException {
            if (handler != null) {
                try {
                    AppservAccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            Set<Principal> ps = s.getPrincipals();
                            Iterator<Principal> it = ps.iterator();
                            if (ps == null || ps.isEmpty()) {
                                return null;
                            }
                            Callback[] callbacks = new Callback[]{new CallerPrincipalCallback(s, it.next().getName())};
                            if (pvcSubject != null) {
                                s.getPrincipals().addAll(pvcSubject.getPrincipals());
                            }
                            handler.handle(callbacks);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    Throwable cause = pae.getCause();
                    AuthException aex = new AuthException();
                    aex.initCause(cause);
                    throw aex;
                }
            }
        }

        public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
            if (this.module != null) {
                return this.module.validateRequest(messageInfo, clientSubject, serviceSubject);
            }
            throw new AuthException();
        }

        public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
            if (this.module != null) {
                return this.module.secureResponse(messageInfo, serviceSubject);
            }
            throw new AuthException();
        }

        public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
            if (this.module == null) {
                throw new AuthException();
            }
            this.module.cleanSubject(messageInfo, subject);
        }
    }

    class GFClientAuthConfig
    extends GFAuthConfig
    implements ClientAuthConfig {
        protected GFClientAuthConfig(AuthConfigProvider provider, String layer, String appContext, CallbackHandler handler) {
            super(provider, layer, appContext, handler, GFServerConfigProvider.CLIENT);
        }

        public ClientAuthContext getAuthContext(String authContextID, Subject clientSubject, Map properties) throws AuthException {
            GFClientAuthContext clientAuthContext = null;
            ModuleInfo moduleInfo = this.getModuleInfo(authContextID, properties);
            if (moduleInfo != null && moduleInfo.getModule() != null) {
                Object moduleObj = moduleInfo.getModule();
                Map map = moduleInfo.getMap();
                if (moduleObj instanceof ClientAuthModule) {
                    clientAuthContext = new GFClientAuthContext(this, (ClientAuthModule)moduleObj, map);
                }
            }
            return clientAuthContext;
        }
    }

    class GFServerAuthConfig
    extends GFAuthConfig
    implements ServerAuthConfig {
        protected GFServerAuthConfig(AuthConfigProvider provider, String layer, String appContext, CallbackHandler handler) {
            super(provider, layer, appContext, handler, GFServerConfigProvider.SERVER);
        }

        public ServerAuthContext getAuthContext(String authContextID, Subject serviceSubject, Map properties) throws AuthException {
            GFServerAuthContext serverAuthContext = null;
            ModuleInfo moduleInfo = this.getModuleInfo(authContextID, properties);
            if (moduleInfo != null && moduleInfo.getModule() != null) {
                Object moduleObj = moduleInfo.getModule();
                Map map = moduleInfo.getMap();
                if (moduleObj instanceof ServerAuthModule) {
                    serverAuthContext = new GFServerAuthContext(this, (ServerAuthModule)moduleObj, map);
                }
            }
            return serverAuthContext;
        }
    }

    class GFAuthConfig
    implements AuthConfig {
        protected AuthConfigProvider provider = null;
        protected String layer = null;
        protected String appContext = null;
        protected CallbackHandler handler = null;
        protected String type = null;
        protected String providerID = null;
        protected boolean init = false;
        protected boolean onePolicy = false;
        protected boolean newHandler = false;
        protected MessageSecurityBindingDescriptor binding = null;
        protected SunWebApp sunWebApp = null;

        protected GFAuthConfig(AuthConfigProvider provider, String layer, String appContext, CallbackHandler handler, String type) {
            this.provider = provider;
            this.layer = layer;
            this.appContext = appContext;
            this.type = type;
            if (handler == null) {
                handler = AuthMessagePolicy.getDefaultCallbackHandler();
                this.newHandler = true;
            }
            this.handler = handler;
        }

        public String getMessageLayer() {
            return this.layer;
        }

        public String getAppContext() {
            return this.appContext;
        }

        public String getAuthContextID(MessageInfo messageInfo) {
            if (GFServerConfigProvider.HTTPSERVLET.equals(this.layer)) {
                String isMandatoryStr = (String)messageInfo.getMap().get("javax.security.auth.message.MessagePolicy.isMandatory");
                return Boolean.valueOf(isMandatoryStr).toString();
            }
            return null;
        }

        public void refresh() {
        }

        public boolean isProtected() {
            return true;
        }

        CallbackHandler getCallbackHandler() {
            return this.handler;
        }

        protected ModuleInfo getModuleInfo(String authContextID, Map properties) throws AuthException {
            if (!this.init) {
                this.initialize(properties);
            }
            MessagePolicy[] policies = null;
            policies = GFServerConfigProvider.SOAP.equals(this.layer) ? AuthMessagePolicy.getSOAPPolicies(this.binding, authContextID, this.onePolicy) : AuthMessagePolicy.getHttpServletPolicies(authContextID);
            MessagePolicy requestPolicy = policies[0];
            MessagePolicy responsePolicy = policies[1];
            Entry entry = GFServerConfigProvider.this.getEntry(this.layer, this.providerID, requestPolicy, responsePolicy, this.type);
            return entry != null ? GFServerConfigProvider.createModuleInfo(entry, this.handler, this.type, properties) : null;
        }

        private void initialize(Map properties) {
            if (!this.init) {
                if (GFServerConfigProvider.SOAP.equals(this.layer)) {
                    this.binding = AuthMessagePolicy.getMessageSecurityBinding(this.layer, properties);
                    this.providerID = AuthMessagePolicy.getProviderID(this.binding);
                    this.onePolicy = AuthMessagePolicy.oneSOAPPolicy(this.binding);
                } else {
                    this.sunWebApp = AuthMessagePolicy.getSunWebApp(properties);
                    this.providerID = AuthMessagePolicy.getProviderID(this.sunWebApp);
                    this.onePolicy = true;
                }
                this.init = true;
            }
        }
    }

    protected static class ModuleInfo {
        private Object module;
        private Map map;

        ModuleInfo(Object module, Map map) {
            this.module = module;
            this.map = map;
        }

        Object getModule() {
            return this.module;
        }

        Map getMap() {
            return this.map;
        }
    }

    static class IDEntry {
        private String type;
        private String moduleClassName;
        private MessagePolicy requestPolicy;
        private MessagePolicy responsePolicy;
        private Map options;

        IDEntry(String type, String moduleClassName, MessagePolicy requestPolicy, MessagePolicy responsePolicy, Map options) {
            this.type = type;
            this.moduleClassName = moduleClassName;
            this.requestPolicy = requestPolicy;
            this.responsePolicy = responsePolicy;
            this.options = options;
        }
    }

    static class InterceptEntry {
        String defaultClientID;
        String defaultServerID;
        HashMap idMap;

        InterceptEntry(String defaultClientID, String defaultServerID, HashMap idMap) {
            this.defaultClientID = defaultClientID;
            this.defaultServerID = defaultServerID;
            this.idMap = idMap;
        }
    }

    static class Entry {
        private static final Class[] PARAMS = new Class[0];
        private static final Object[] ARGS = new Object[0];
        private String moduleClassName;
        private MessagePolicy requestPolicy;
        private MessagePolicy responsePolicy;
        private Map options;
        Object module;

        Entry(String moduleClassName, MessagePolicy requestPolicy, MessagePolicy responsePolicy, Map options) {
            this.moduleClassName = moduleClassName;
            this.requestPolicy = requestPolicy;
            this.responsePolicy = responsePolicy;
            this.options = options;
        }

        MessagePolicy getRequestPolicy() {
            return this.requestPolicy;
        }

        MessagePolicy getResponsePolicy() {
            return this.responsePolicy;
        }

        String getModuleClassName() {
            return this.moduleClassName;
        }

        Map getOptions() {
            return this.options;
        }

        Object newInstance() throws AuthException {
            try {
                ClassLoader finalLoader = GFServerConfigProvider.getClassLoader();
                Class<?> c = Class.forName(this.moduleClassName, true, finalLoader);
                Constructor<?> constructor = c.getConstructor(PARAMS);
                return constructor.newInstance(ARGS);
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "jmac.provider_unable_to_load_authmodule", new String[]{this.moduleClassName, e.toString()});
                }
                AuthException ae = new AuthException();
                ae.initCause(e);
                throw ae;
            }
        }
    }
}

