/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl;

import com.sun.enterprise.security.ClientSecurityContext;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.login.X509CertificateCredential;
import com.sun.enterprise.security.ssl.UnifiedX509KeyManager;
import com.sun.logging.LogDomains;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.Subject;

public final class J2EEKeyManager
implements X509KeyManager {
    private static Logger _logger = null;
    private X509KeyManager mgr = null;
    private String alias = null;
    private Map tokenName2MgrMap = null;
    private boolean supportTokenAlias = false;

    public J2EEKeyManager(X509KeyManager mgr, String alias) {
        this.mgr = mgr;
        this.alias = alias;
        if (mgr instanceof UnifiedX509KeyManager) {
            UnifiedX509KeyManager umgr = (UnifiedX509KeyManager)mgr;
            X509KeyManager[] mgrs = umgr.getX509KeyManagers();
            String[] tokenNames = umgr.getTokenNames();
            this.tokenName2MgrMap = new HashMap();
            for (int i = 0; i < mgrs.length; ++i) {
                if (tokenNames[i] == null) continue;
                this.tokenName2MgrMap.put(tokenNames[i], mgrs[i]);
            }
            this.supportTokenAlias = this.tokenName2MgrMap.size() > 0;
        }
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        String alias = null;
        if (this.alias == null) {
            if (!this.isAppClientContainer()) {
                alias = this.mgr.chooseClientAlias(keyType, issuers, socket);
            } else {
                ClientSecurityContext ctx = ClientSecurityContext.getCurrent();
                Subject s = ctx.getSubject();
                if (s == null) {
                    LoginContextDriver.doClientLogin(2, SecurityUtil.getAppContainerCallbackHandler());
                    s = ctx.getSubject();
                }
                for (Object o : s.getPrivateCredentials()) {
                    if (!(o instanceof X509CertificateCredential)) continue;
                    X509CertificateCredential crt = (X509CertificateCredential)o;
                    alias = crt.getAlias();
                    break;
                }
            }
        } else {
            alias = this.alias;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Choose client Alias :" + alias);
        }
        return alias;
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        String alias = null;
        alias = this.alias != null ? this.alias : this.mgr.chooseServerAlias(keyType, issuers, socket);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Choosing server alias :" + alias);
        }
        return alias;
    }

    public X509Certificate[] getCertificateChain(String alias) {
        X509KeyManager keyMgr;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Getting certificate chain");
        }
        if ((keyMgr = this.getManagerFromToken(alias)) != null) {
            String aliasName = alias.substring(alias.indexOf(58) + 1);
            return keyMgr.getCertificateChain(aliasName);
        }
        return this.mgr.getCertificateChain(alias);
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Getting client aliases");
        }
        return this.mgr.getClientAliases(keyType, issuers);
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Getting server aliases");
        }
        return this.mgr.getServerAliases(keyType, issuers);
    }

    public PrivateKey getPrivateKey(String alias) {
        X509KeyManager keyMgr;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Getting private key for alias:" + alias);
        }
        if ((keyMgr = this.getManagerFromToken(alias)) != null) {
            String aliasName = alias.substring(alias.indexOf(58) + 1);
            return keyMgr.getPrivateKey(aliasName);
        }
        return this.mgr.getPrivateKey(alias);
    }

    private X509KeyManager getManagerFromToken(String tokenAlias) {
        X509KeyManager keyMgr = null;
        int ind = -1;
        if (this.supportTokenAlias && tokenAlias != null && (ind = tokenAlias.indexOf(58)) != -1) {
            String tokenName = this.alias.substring(0, ind);
            keyMgr = (X509KeyManager)this.tokenName2MgrMap.get(tokenName);
        }
        return keyMgr;
    }

    private boolean isAppClientContainer() {
        return true;
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.security");
    }
}

