/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.core.deployment;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.ApplicationFactory;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.DescriptorArchivist;
import com.sun.enterprise.deployment.backend.ClientJarMakerThread;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipItem;
import com.sun.enterprise.v3.server.V3Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.DeploymentException;
import org.jvnet.hk2.annotations.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaEEDeployer<T extends Container, U extends ApplicationContainer>
implements Deployer<T, U> {
    @Inject
    protected V3Environment env;
    @Inject
    protected ArchiveFactory archiveFactory;
    @Inject
    protected ArchivistFactory archivistFactory;
    @Inject
    protected ApplicationFactory applicationFactory;
    @Inject
    protected DescriptorArchivist descriptorArchivist;
    @Inject
    protected ApplicationArchivist applicationArchivist;
    @Inject
    protected ModulesRegistry modulesRegistry;
    private static String CLIENT_JAR_MAKER_CHOICE = System.getProperty("client.jar.maker.choice");
    private static final String APPLICATION_TYPE = "Application-Type";
    private static String WRITEOUT_XML = System.getProperty("writeout.xml");

    public MetaData getMetaData() {
        ArrayList<ModuleDefinition> apis = new ArrayList<ModuleDefinition>();
        Module module = this.modulesRegistry.makeModuleFor("javax.javaee:javaee", "5.0");
        if (module != null) {
            apis.add(module.getModuleDefinition());
        }
        return new MetaData(false, apis.toArray(new ModuleDefinition[apis.size()]), null, null);
    }

    public boolean prepare(DeploymentContext dc) {
        try {
            this.prepareScratchDirs(dc);
            if (this.parseModuleMetaData(dc) == null) {
                dc.getLogger().severe("Failed to load deployment descriptor, aborting");
                return false;
            }
            String objectType = this.getObjectType(dc);
            if (objectType != null) {
                dc.getProps().setProperty("object-type", objectType);
            }
            this.generateArtifacts(dc);
            if (Boolean.valueOf(WRITEOUT_XML).booleanValue()) {
                this.saveAppDescriptor(dc);
            }
            this.createClientJar(dc);
            return true;
        }
        catch (Exception ex) {
            RuntimeException re = new RuntimeException(ex.getMessage());
            re.initCause(ex);
            throw re;
        }
    }

    protected Application parseModuleMetaData(DeploymentContext dc) throws Exception {
        ReadableArchive sourceArchive = dc.getSource();
        ClassLoader cl = dc.getClassLoader();
        Properties props = dc.getCommandParameters();
        String name = props.getProperty("name");
        Archivist archivist = this.archivistFactory.getArchivist(sourceArchive, cl);
        archivist.setAnnotationProcessingRequested(true);
        archivist.setXMLValidation(false);
        archivist.setRuntimeXMLValidation(false);
        archivist.setDefaultBundleDescriptor(this.getDefaultBundleDescriptor());
        Application application = this.applicationFactory.openArchive(name, archivist, sourceArchive, true);
        if (application != null) {
            archivist.validate(cl);
            dc.addModuleMetaData((Object)application);
        }
        return application;
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    protected void createClientJar(DeploymentContext dc) throws DeploymentException {
    }

    protected final void createClientJar(DeploymentContext dc, ZipItem[] clientStubs) throws DeploymentException {
        Properties props = dc.getCommandParameters();
        String name = props.getProperty("name");
        String clientJarRequested = props.getProperty("clientJarRequested");
        File appDirectory = dc.getScratchDir("xml");
        if (!FileUtils.safeIsDirectory((File)dc.getScratchDir("xml"))) {
            appDirectory = dc.getSourceDir();
        }
        File clientJar = new File(appDirectory, name + "Client.jar");
        if (clientJarRequested != null && Boolean.valueOf(clientJarRequested).booleanValue()) {
            ClientJarMakerThread.createClientJar(dc, clientJar, clientStubs, CLIENT_JAR_MAKER_CHOICE);
        } else {
            ClientJarMakerThread clientJarThread = new ClientJarMakerThread(dc, clientJar, clientStubs, CLIENT_JAR_MAKER_CHOICE);
            clientJarThread.start();
        }
    }

    public void clean(DeploymentContext context) {
    }

    protected void saveAppDescriptor(DeploymentContext context) throws IOException {
        Application application = (Application)context.getModuleMetaData(Application.class);
        ReadableArchive archive = this.archiveFactory.openArchive(context.getSourceDir());
        WritableArchive archive2 = this.archiveFactory.createArchive(context.getScratchDir("xml"));
        this.descriptorArchivist.write(application, archive, archive2);
        this.applicationArchivist.copyExtraElements(archive, archive2);
    }

    protected void prepareScratchDirs(DeploymentContext context) throws IOException {
        context.getScratchDir("ejb").mkdirs();
        context.getScratchDir("xml").mkdirs();
        context.getScratchDir("jsp").mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getObjectType(DeploymentContext context) {
        File appDir = context.getSourceDir();
        FileInputStream fis = null;
        try {
            File manifestFile = new File(appDir, "META-INF/MANIFEST.MF");
            fis = new FileInputStream(manifestFile);
            Manifest manifest = new Manifest(fis);
            Attributes attrs = manifest.getMainAttributes();
            String string = attrs.getValue(APPLICATION_TYPE);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    protected abstract RootDeploymentDescriptor getDefaultBundleDescriptor();

    protected abstract String getModuleType();
}

