/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.services;

import com.sun.appserv.connectors.spi.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resources;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.glassfish.api.Async;
import org.glassfish.api.Startup;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.javaee.services.ResourceAdapterProxy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Async
public class ResourceAdaptersBinder
implements Startup,
PostConstruct,
PreDestroy,
ConfigListener {
    @Inject
    JdbcResource[] jdbcResources;
    @Inject
    JdbcConnectionPool[] pools;
    @Inject
    Resources resources;
    @Inject
    GlassfishNamingManager manager;
    @Inject
    Logger logger;
    @Inject
    Habitat raProxyHabitat;
    @Inject
    Habitat connectorRuntimeHabitat;

    public void postConstruct() {
        this.deployAllJdbcResourcesAndPools();
    }

    private void deployAllJdbcResourcesAndPools() {
        for (JdbcResource resource : this.jdbcResources) {
            try {
                JdbcConnectionPool pool = this.getAssociatedPool(resource.getPoolName());
                if (pool == null) {
                    this.logger.log(Level.SEVERE, "Could not get the pool [ " + resource.getPoolName() + " ] of resource [ " + resource.getJndiName() + " ]");
                    continue;
                }
                this.bindResource(resource, pool, resource.getJndiName(), "jdbc");
            }
            catch (NamingException e) {
                this.logger.log(Level.SEVERE, "Cannot bind " + resource.getPoolName() + " to naming manager", e);
            }
        }
    }

    public void bindResource(Object resource, Object pool, String resourceName, String resourceType) throws NamingException {
        ResourceAdapterProxy raProxy = this.constructResourceProxy(resource, pool, resourceType, resourceName);
        this.manager.publishObject(resourceName, (Object)raProxy, true);
    }

    private ResourceAdapterProxy constructResourceProxy(Object resource, Object pool, String resourceType, String resourceName) {
        ResourceAdapterProxy raProxy = (ResourceAdapterProxy)this.raProxyHabitat.getComponent(ResourceAdapterProxy.class);
        raProxy.setResource(resource);
        raProxy.setConnectionPool(pool);
        raProxy.setResourceType(resourceType);
        raProxy.setResourceName(resourceName);
        return raProxy;
    }

    private JdbcConnectionPool getAssociatedPool(String poolName) {
        JdbcConnectionPool result = null;
        for (JdbcConnectionPool pool : this.pools) {
            if (!pool.getName().equalsIgnoreCase(poolName)) continue;
            result = pool;
            break;
        }
        return result;
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void preDestroy() {
        this.raProxyHabitat.getInhabitant(ConnectorRuntime.class, null).release();
    }

    private List<String> getAllPoolNames(JdbcConnectionPool[] pools) {
        ArrayList<String> poolNames = new ArrayList<String>();
        for (JdbcConnectionPool pool : pools) {
            poolNames.add(pool.getName());
        }
        return poolNames;
    }

    private List<String> getAllResourceNames(JdbcResource[] resources) {
        ArrayList<String> resourceNames = new ArrayList<String>();
        for (JdbcResource resource : resources) {
            resourceNames.add(resource.getJndiName());
        }
        return resourceNames;
    }

    public void changed(PropertyChangeEvent[] events) {
        ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new Changed(){

            public <T extends ConfigBeanProxy> void changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
                switch (type) {
                    case ADD: {
                        ResourceAdaptersBinder.this.logger.info("A new " + changedType.getName() + " was added : " + changedInstance);
                        break;
                    }
                    case CHANGE: {
                        ResourceAdaptersBinder.this.logger.info("A " + changedType.getName() + " was changed : " + changedInstance);
                        break;
                    }
                    case REMOVE: {
                        ResourceAdaptersBinder.this.logger.info("A " + changedType.getName() + " was removed : " + changedInstance);
                    }
                }
            }
        }, (Logger)this.logger);
    }
}

