/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.appserv.connectors.spi.ConnectorConstants;
import com.sun.appserv.connectors.spi.ConnectorRuntimeException;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.connectors.ConnectionManagerFactory;
import com.sun.enterprise.connectors.ConnectionManagerImpl;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.authentication.AuthenticationService;
import com.sun.enterprise.connectors.naming.ConnectorNamingEventNotifier;
import com.sun.enterprise.connectors.service.ConnectorAdminServicesFactory;
import com.sun.enterprise.connectors.service.ConnectorConnectionPoolAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorResourceAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorSecurityAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorService;
import com.sun.enterprise.connectors.service.ResourceAdapterAdminServiceImpl;
import com.sun.enterprise.connectors.util.ConnectorsUtil;
import com.sun.enterprise.connectors.util.RAWriterAdapter;
import com.sun.enterprise.container.common.spi.JavaEETransactionManager;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.util.ConnectorClassLoader;
import com.sun.logging.LogDomains;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ConfigurationException;
import javax.naming.NamingException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ConnectorRuntime
implements ConnectorConstants,
com.sun.appserv.connectors.spi.ConnectorRuntime,
PostConstruct,
PreDestroy {
    private volatile int environment = 1;
    private static ConnectorRuntime _runtime;
    protected static final Logger _logger;
    private ConnectorConnectionPoolAdminServiceImpl ccPoolAdmService;
    private ConnectorResourceAdminServiceImpl connectorResourceAdmService;
    private ConnectorService connectorService;
    private ResourceAdapterAdminServiceImpl resourceAdapterAdmService;
    private ConnectorSecurityAdminServiceImpl connectorSecurityAdmService;
    private long startTime;
    @Inject
    private GlassfishNamingManager namingManager;
    @Inject
    private PoolManager poolManager;
    @Inject
    private InvocationManager invocationManager;
    @Inject
    private ComponentEnvManager componentEnvManager;
    @Inject
    private JavaEETransactionManager transactionManager;
    private final Object getTimerLock = new Object();
    private Timer timer;

    public static ConnectorRuntime getRuntime() {
        if (_runtime == null) {
            throw new RuntimeException("Connector Runtime not initialized");
        }
        return _runtime;
    }

    public ConnectorRuntime() {
        this.startTime = System.currentTimeMillis();
        _runtime = this;
    }

    public void initialize(int environment) {
        this.environment = environment;
        ConnectorService.initialize(this.getEnviron());
    }

    public int getEnviron() {
        return this.environment;
    }

    public String getDefaultPoolName(String moduleName, String connectionDefName) {
        return this.connectorService.getDefaultPoolName(moduleName, connectionDefName);
    }

    public void deleteConnectorConnectionPool(String poolName) throws ConnectorRuntimeException {
        this.ccPoolAdmService.deleteConnectorConnectionPool(poolName);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool connectorPoolObj) throws ConnectorRuntimeException {
        this.ccPoolAdmService.createConnectorConnectionPool(connectorPoolObj);
    }

    public void createConnectorResource(String jndiName, String poolName, String resourceType) throws ConnectorRuntimeException {
        this.connectorResourceAdmService.createConnectorResource(jndiName, poolName, resourceType);
    }

    public String getDefaultResourceName(String moduleName, String connectionDefName) {
        return this.connectorService.getDefaultResourceName(moduleName, connectionDefName);
    }

    public PrintWriter getResourceAdapterLogWriter() {
        Logger logger = LogDomains.getLogger((String)"javax.enterprise.resource.resourceadapter");
        RAWriterAdapter writerAdapter = new RAWriterAdapter(logger);
        return new PrintWriter(writerAdapter);
    }

    public void deleteConnectorResource(String jndiName) throws ConnectorRuntimeException {
        this.connectorResourceAdmService.deleteConnectorResource(jndiName);
    }

    public ConnectorDescriptor getConnectorDescriptor(String rarName) throws ConnectorRuntimeException {
        return this.connectorService.getConnectorDescriptor(rarName);
    }

    public void createActiveResourceAdapter(String moduleDir, String moduleName) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.createActiveResourceAdapter(moduleDir, moduleName);
    }

    public void destroyActiveResourceAdapter(String moduleName, boolean cascade) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.stopActiveResourceAdapter(moduleName, cascade);
    }

    public ManagedConnectionFactory obtainManagedConnectionFactory(String poolName) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.obtainManagedConnectionFactory(poolName);
    }

    public ConnectionManager obtainConnectionManager(String poolName, boolean forceNoLazyAssoc) throws ConnectorRuntimeException {
        ConnectionManager mgr = ConnectionManagerFactory.getAvailableConnectionManager(poolName, forceNoLazyAssoc);
        return mgr;
    }

    public Object lookupPMResource(String jndiName, boolean force) throws NamingException {
        if (force) {
            _logger.log(Level.INFO, "lookup PM Resource [ " + jndiName + " ] with force=true is not supported");
        }
        return this.connectorResourceAdmService.lookup(jndiName + "__pm");
    }

    public Object lookupNonTxResource(String jndiName, boolean force) throws NamingException {
        if (force) {
            _logger.log(Level.INFO, "lookup NonTx Resource [ " + jndiName + " ] with force=true is not supported");
        }
        return this.connectorResourceAdmService.lookup(jndiName + "__nontx");
    }

    public void switchOnMatching(String rarName, String poolName) {
        this.connectorService.switchOnMatching(rarName, poolName);
    }

    public void switchOnMatchingInJndi(String poolName) throws ConnectorRuntimeException {
        this.ccPoolAdmService.switchOnMatching(poolName);
    }

    public Object createConnectionFactory(String jndiName, String moduleName, String poolName, Hashtable env) throws RuntimeException {
        Object cf = null;
        try {
            ManagedConnectionFactory mcf = ConnectorRuntime.getRuntime().obtainManagedConnectionFactory(poolName);
            if (mcf == null) {
                _logger.log(Level.FINE, "Failed to create MCF ", poolName);
                throw new ConnectorRuntimeException("Failed to create MCF");
            }
            boolean forceNoLazyAssoc = false;
            if (jndiName.endsWith("__pm")) {
                forceNoLazyAssoc = true;
            }
            String derivedJndiName = ConnectorsUtil.deriveJndiName(jndiName, env);
            ConnectionManagerImpl mgr = (ConnectionManagerImpl)ConnectorRuntime.getRuntime().obtainConnectionManager(poolName, forceNoLazyAssoc);
            mgr.setJndiName(derivedJndiName);
            mgr.setRarName(moduleName);
            mgr.initialize();
            cf = mcf.createConnectionFactory((ConnectionManager)mgr);
            if (cf == null) {
                String msg = "No resource adapter found";
                throw new RuntimeException(new ConfigurationException(msg));
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Connection Factory:" + cf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cf;
    }

    public GlassfishNamingManager getNamingManager() {
        return this.namingManager;
    }

    public void postConstruct() {
        this.ccPoolAdmService = (ConnectorConnectionPoolAdminServiceImpl)ConnectorAdminServicesFactory.getService("ConnectorConnectionPool");
        this.connectorResourceAdmService = (ConnectorResourceAdminServiceImpl)ConnectorAdminServicesFactory.getService("ConnectorResource");
        this.connectorService = new ConnectorService();
        this.resourceAdapterAdmService = (ResourceAdapterAdminServiceImpl)ConnectorAdminServicesFactory.getService("ResourceAdapter");
        this.connectorSecurityAdmService = (ConnectorSecurityAdminServiceImpl)ConnectorAdminServicesFactory.getService("Security");
        ConnectorClassLoader.getInstance(Thread.currentThread().getContextClassLoader());
        System.out.println("Time taken to initialize connector runtime : " + (System.currentTimeMillis() - this.startTime));
    }

    public boolean isConnectorConnectionPoolDeployed(String poolName) {
        return this.ccPoolAdmService.isConnectorConnectionPoolDeployed(poolName);
    }

    public boolean reconfigureConnectorConnectionPool(ConnectorConnectionPool ccp, Set excludedProps) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.reconfigureConnectorConnectionPool(ccp, excludedProps);
    }

    public void recreateConnectorConnectionPool(ConnectorConnectionPool ccp) throws ConnectorRuntimeException {
        this.ccPoolAdmService.recreateConnectorConnectionPool(ccp);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool ccp, String connectionDefinitionName, String rarName, List<Property> props, List<SecurityMap> securityMaps) throws ConnectorRuntimeException {
        this.ccPoolAdmService.createConnectorConnectionPool(ccp, connectionDefinitionName, rarName, props, securityMaps);
    }

    public boolean checkAndLoadResource(Object resource, Object pool, String resourceType, String resourceName, String raName) throws ConnectorRuntimeException {
        return this.connectorService.checkAndLoadResource(resource, pool, resourceType, resourceName, raName);
    }

    public void stopAllActiveResourceAdapters() {
        this.resourceAdapterAdmService.stopAllActiveResourceAdapters();
    }

    public void shutdownAllActiveResourceAdapters(List<String> poolNames, List<String> resourceNames) {
        this.destroyResourcesAndPools(resourceNames, poolNames);
        this.stopAllActiveResourceAdapters();
    }

    public void destroyResourcesAndPools(List<String> resourceNames, List<String> poolNames) {
        this.destroyConnectorResources(resourceNames);
        this.destroyConnectionPools(poolNames);
    }

    private void destroyConnectionPools(List<String> poolNames) {
        for (String poolName : poolNames) {
            try {
                this.ccPoolAdmService.deleteConnectorConnectionPool(poolName);
            }
            catch (ConnectorRuntimeException cre) {
                cre.printStackTrace();
            }
        }
    }

    private void destroyConnectorResources(List<String> resourceNames) {
        for (String resourceName : resourceNames) {
            try {
                this.connectorResourceAdmService.deleteConnectorResource(resourceName);
            }
            catch (ConnectorRuntimeException cre) {
                cre.printStackTrace();
            }
        }
    }

    public PoolManager getPoolManager() {
        return this.poolManager;
    }

    public InvocationManager getInvocationManager() {
        return this.invocationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer getTimer() {
        Object object = this.getTimerLock;
        synchronized (object) {
            if (this.timer == null) {
                this.timer = new Timer("connector-runtime", true);
            }
        }
        return this.timer;
    }

    public Set getResourceReferenceDescriptor() {
        return this.componentEnvManager.getCurrentJndiNameEnvironment().getResourceReferenceDescriptors();
    }

    public void preDestroy() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public AuthenticationService getAuthenticationService(String rarName, String poolName) {
        return this.connectorSecurityAdmService.getAuthenticationService(rarName, poolName);
    }

    public static boolean isServer() {
        ConnectorRuntime connectorRuntime = ConnectorRuntime.getRuntime();
        return connectorRuntime.connectorService.isServer();
    }

    public Transaction getTransaction() throws SystemException {
        return this.transactionManager.getTransaction();
    }

    public JavaEETransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    private ConnectorNamingEventNotifier getResourceRebindEventNotifier() {
        return this.connectorResourceAdmService.getResourceRebindEventNotifier();
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.resource.resourceadapter");
    }
}

