/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.authentication;

import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.authentication.AuthenticationService;
import com.sun.enterprise.connectors.authentication.RuntimeSecurityMap;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.logging.LogDomains;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.api.invocation.ComponentInvocation;

public class BasicPasswordAuthenticationService
implements AuthenticationService {
    private String rarName_;
    private String poolName_;
    ConnectorRegistry connectorRegistry_ = ConnectorRegistry.getInstance();
    static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.resource.resourceadapter");
    private Object containerContext = null;

    public BasicPasswordAuthenticationService(String rarName, String poolName) {
        this.rarName_ = rarName;
        this.poolName_ = poolName;
        _logger.log(Level.FINE, "Contructor:BasicPasswordAuthenticationService");
    }

    public Principal mapPrincipal(Principal callerPrincipal, Set principalSet) {
        RuntimeSecurityMap runtimeSecurityMap = this.connectorRegistry_.getRuntimeSecurityMap(this.poolName_);
        if (runtimeSecurityMap == null) {
            return null;
        }
        String principalName = callerPrincipal.getName();
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Principal p : principalSet) {
            if (((Object)p).equals(callerPrincipal)) continue;
            String groupName = p.getName();
            groupNames.add(groupName);
        }
        if (this.isContainerContextAWebModuleObject()) {
            String roleName = this.getRoleName(callerPrincipal);
            return this.doMap(principalName, groupNames, roleName, runtimeSecurityMap);
        }
        return this.doMap(principalName, groupNames, null, runtimeSecurityMap);
    }

    private Principal doMap(String principalName, List groupNames, String roleName, RuntimeSecurityMap runtimeSecurityMap) {
        HashMap userNameSecurityMap = runtimeSecurityMap.getUserMap();
        HashMap groupNameSecurityMap = runtimeSecurityMap.getGroupMap();
        if (userNameSecurityMap.containsKey(principalName)) {
            return (Principal)userNameSecurityMap.get(principalName);
        }
        if (this.isContainerContextAWebModuleObject() && roleName != null && groupNameSecurityMap.containsKey(roleName)) {
            return (Principal)groupNameSecurityMap.get(roleName);
        }
        for (int j = 0; j < groupNames.size(); ++j) {
            String groupName = (String)groupNames.get(j);
            if (!groupNameSecurityMap.containsKey(groupName)) continue;
            return (Principal)groupNameSecurityMap.get(groupName);
        }
        if (userNameSecurityMap.containsKey("*")) {
            return (Principal)userNameSecurityMap.get("*");
        }
        if (groupNameSecurityMap.containsKey("*")) {
            return (Principal)groupNameSecurityMap.get("*");
        }
        return null;
    }

    private String getRoleName(Principal callerPrincipal) {
        String roleName2 = null;
        String componentId = this.getCurrentComponentId();
        SecurityRoleMapperFactory securityRoleMapperFactory = SecurityRoleMapperFactoryMgr.getFactory();
        SecurityRoleMapper securityRoleMapper = securityRoleMapperFactory.getRoleMapper(componentId);
        Map map = securityRoleMapper.getRoleToSubjectMapping();
        Set roleSet = map.keySet();
        for (String roleName2 : roleSet) {
            Subject subject = (Subject)map.get(roleName2);
            Set<Principal> principalSet = subject.getPrincipals();
            if (!principalSet.contains(callerPrincipal)) continue;
            return roleName2;
        }
        return "";
    }

    private ComponentInvocation getCurrentComponentInvocation() {
        return ConnectorRuntime.getRuntime().getInvocationManager().getCurrentInvocation();
    }

    private String getCurrentComponentId() {
        return this.getCurrentComponentInvocation().getComponentId();
    }

    private ComponentInvocation.ComponentInvocationType getCurrentComponentType() {
        return this.getCurrentComponentInvocation().getInvocationType();
    }

    private boolean isContainerContextAWebModuleObject() {
        return ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION.equals((Object)this.getCurrentComponentType());
    }

    private boolean isContainerContextAEJBContainerObject() {
        return ComponentInvocation.ComponentInvocationType.EJB_INVOCATION.equals((Object)this.getCurrentComponentType());
    }
}

