/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.module;

import com.sun.appserv.connectors.spi.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.javaee.services.ResourceAdaptersBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorApplication
implements ApplicationContainer {
    private static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.resource.resourceadapter");
    private String moduleName = "";
    private Map<ConnectorResource, ConnectorConnectionPool> raResourcePoolMap;
    ResourceAdaptersBinder resourceBinder;
    ConnectorRuntime runtime;

    public ConnectorApplication(String moduleName, Map<ConnectorResource, ConnectorConnectionPool> raResourcePoolMap, ResourceAdaptersBinder resourceBinder, ConnectorRuntime runtime) {
        this.moduleName = moduleName;
        this.resourceBinder = resourceBinder;
        this.raResourcePoolMap = raResourcePoolMap;
        this.runtime = runtime;
    }

    public Object getDescriptor() {
        return null;
    }

    public boolean start() {
        boolean started = false;
        this.deployResources(this.resourceBinder, this.raResourcePoolMap);
        started = true;
        this.logFine("Resource Adapter [ " + this.moduleName + " ] started");
        return started;
    }

    private void deployResources(ResourceAdaptersBinder binder, Map<ConnectorResource, ConnectorConnectionPool> raResourcePoolMap) {
        for (Map.Entry<ConnectorResource, ConnectorConnectionPool> entry : raResourcePoolMap.entrySet()) {
            ConnectorResource resource = entry.getKey();
            ConnectorConnectionPool pool = entry.getValue();
            try {
                binder.bindResource((Object)resource, (Object)pool, resource.getJndiName(), "cr");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean stop() {
        boolean stopped = false;
        this.undeployResources(this.raResourcePoolMap, this.moduleName);
        stopped = true;
        this.logFine("Resource Adapter [ " + this.moduleName + " ] stopped");
        return stopped;
    }

    private void undeployResources(Map<ConnectorResource, ConnectorConnectionPool> raResourcePoolMap, String moduleName) {
        ArrayList<String> resources = new ArrayList<String>();
        ArrayList<String> pools = new ArrayList<String>();
        for (Map.Entry<ConnectorResource, ConnectorConnectionPool> entry : raResourcePoolMap.entrySet()) {
            ConnectorResource resource = entry.getKey();
            ConnectorConnectionPool pool = entry.getValue();
            resources.add(resource.getJndiName());
            pools.add(pool.getName());
            this.runtime.destroyResourcesAndPools(pools, resources);
        }
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public void logFine(String message) {
        _logger.log(Level.FINE, message);
    }
}

