/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.service;

import com.sun.appserv.connectors.spi.ConnectorRuntimeException;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.naming.ConnectorNamingEvent;
import com.sun.enterprise.connectors.naming.ConnectorNamingEventNotifier;
import com.sun.enterprise.connectors.naming.ConnectorResourceNamingEventNotifier;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.service.ConnectorService;
import com.sun.enterprise.connectors.util.ConnectorsUtil;
import com.sun.enterprise.resource.ConnectorObjectFactory;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class ConnectorResourceAdminServiceImpl
extends ConnectorService {
    public void createConnectorResource(String jndiName, String poolName, String resourceType) throws ConnectorRuntimeException {
        String errMsg = "rardeployment.jndi_lookup_failed";
        String name = poolName;
        try {
            ConnectorConnectionPool connectorConnectionPool = null;
            String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
            Context ic = this._runtime.getNamingManager().getInitialContext();
            try {
                connectorConnectionPool = (ConnectorConnectionPool)ic.lookup(jndiNameForPool);
            }
            catch (NamingException ne) {
                ne.printStackTrace();
            }
            connectorConnectionPool = (ConnectorConnectionPool)ic.lookup(jndiNameForPool);
            ConnectorDescriptorInfo cdi = connectorConnectionPool.getConnectorDescriptorInfo();
            ConnectorObjectFactory cof = new ConnectorObjectFactory(jndiName, connectorConnectionPool.getConnectorDescriptorInfo().getConnectionFactoryClass(), cdi.getRarName(), poolName);
            this._runtime.getNamingManager().publishObject(jndiName, (Object)cof, true);
            ConnectorResourceNamingEventNotifier.getInstance().notifyListeners(new ConnectorNamingEvent(jndiName, 0));
        }
        catch (NamingException ne) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(errMsg);
            cre.initCause((Throwable)ne);
            _logger.log(Level.SEVERE, errMsg, name);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
    }

    public void deleteConnectorResource(String jndiName) throws ConnectorRuntimeException {
        try {
            this._runtime.getNamingManager().unpublishObject(jndiName);
        }
        catch (NamingException ne) {
            if (ne instanceof NameNotFoundException) {
                _logger.log(Level.FINE, "rardeployment.connectorresource_removal_from_jndi_error", jndiName);
                _logger.log(Level.FINE, "", ne);
                return;
            }
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to delete connector resource from jndi");
            cre.initCause((Throwable)ne);
            _logger.log(Level.SEVERE, "rardeployment.connectorresource_removal_from_jndi_error", jndiName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
    }

    public ConnectorNamingEventNotifier getResourceRebindEventNotifier() {
        return ConnectorResourceNamingEventNotifier.getInstance();
    }

    public Object lookup(String name) throws NamingException {
        Hashtable<String, String> ht = null;
        String suffix = ConnectorsUtil.getValidSuffix(name);
        if (suffix != null) {
            ht = new Hashtable<String, String>();
            ht.put("com.sun.enterprise.connectors.jndisuffix", suffix);
            name = name.substring(0, name.lastIndexOf(suffix));
        }
        Context ic = this._runtime.getNamingManager().getInitialContext();
        return ic.lookup(name);
    }
}

