/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.appserv.connectors.spi.PoolingException;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ConnectorXAResource;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.ResourceState;
import com.sun.enterprise.resource.XAResourceWrapper;
import com.sun.enterprise.resource.allocator.LocalTxConnectorAllocator;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ConnectionEventListener;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class ResourceHandle
implements com.sun.appserv.connectors.spi.ResourceHandle {
    private static long idSequence;
    private long id;
    private ClientSecurityInfo info;
    private Object resource;
    private ResourceSpec spec;
    private XAResource xares;
    private Object usercon;
    private ResourceAllocator alloc;
    private Object instance;
    private int shareCount;
    private boolean supportsXAResource = false;
    private Subject subject = null;
    private ResourceState state = null;
    private ConnectionEventListener listener = null;
    private static Logger logger;
    public final Object lock = new Object();
    private long lastValidated;
    private int usageCount;
    private int partition;
    private boolean connectionErrorOccurred = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNextId() {
        Class<ResourceHandle> clazz = ResourceHandle.class;
        synchronized (ResourceHandle.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ++idSequence;
        }
    }

    public ResourceHandle(Object resource, ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info) {
        this.id = ResourceHandle.getNextId();
        this.spec = spec;
        this.info = info;
        this.resource = resource;
        this.alloc = alloc;
        this.supportsXAResource = !(alloc instanceof LocalTxConnectorAllocator);
    }

    public ResourceHandle(Object resource, ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info, boolean supportsXA) {
        this.id = ResourceHandle.getNextId();
        this.spec = spec;
        this.info = info;
        this.resource = resource;
        this.alloc = alloc;
        this.supportsXAResource = supportsXA;
    }

    public boolean isTransactional() {
        return this.alloc.isTransactional();
    }

    public boolean isEnlistmentSuspended() {
        return false;
    }

    public boolean supportsXA() {
        return this.supportsXAResource;
    }

    public ResourceAllocator getResourceAllocator() {
        return this.alloc;
    }

    public Object getResource() {
        return this.resource;
    }

    public ClientSecurityInfo getClientSecurityInfo() {
        return this.info;
    }

    public void setResourceSpec(ResourceSpec spec) {
        this.spec = spec;
    }

    public ResourceSpec getResourceSpec() {
        return this.spec;
    }

    public XAResource getXAResource() {
        return this.xares;
    }

    public Object getUserConnection() {
        return this.usercon;
    }

    public void setComponentInstance(Object instance) {
        this.instance = instance;
    }

    public void closeUserConnection() throws PoolingException {
        this.getResourceAllocator().closeUserConnection(this);
    }

    public Object getComponentInstance() {
        return this.instance;
    }

    public void fillInResourceObjects(Object userConnection, XAResource xaRes) {
        if (userConnection != null) {
            this.usercon = userConnection;
        }
        if (xaRes != null) {
            this.xares = logger.isLoggable(Level.FINEST) ? (xaRes instanceof XAResourceWrapper || xaRes instanceof ConnectorXAResource ? xaRes : new XAResourceWrapper(xaRes)) : xaRes;
        }
    }

    public void incrementCount() {
        ++this.shareCount;
    }

    public void decrementCount() {
        if (this.shareCount == 0) {
            throw new IllegalStateException("shareCount cannot be negative");
        }
        --this.shareCount;
    }

    public int getShareCount() {
        return this.shareCount;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof ResourceHandle) {
            return this.id == ((ResourceHandle)other).id;
        }
        return false;
    }

    public int hashCode() {
        return Long.valueOf(this.id).hashCode();
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public void setConnectionErrorOccurred() {
        this.connectionErrorOccurred = true;
    }

    public boolean hasConnectionErrorOccurred() {
        return this.connectionErrorOccurred;
    }

    public void setResourceState(ResourceState state) {
        this.state = state;
    }

    public ResourceState getResourceState() {
        return this.state;
    }

    public void setListener(ConnectionEventListener l) {
        this.listener = l;
    }

    public ConnectionEventListener getListener() {
        return this.listener;
    }

    public boolean isShareable() {
        return this.alloc.shareableWithinComponent();
    }

    public void destroyResource() {
        throw new UnsupportedOperationException("Transaction is not supported yet");
    }

    public boolean isEnlisted() {
        return this.state != null && this.state.isEnlisted();
    }

    public long getLastValidated() {
        return this.lastValidated;
    }

    public void setLastValidated(long lastValidated) {
        this.lastValidated = lastValidated;
    }

    public int getUsageCount() {
        return this.usageCount;
    }

    public void incrementUsageCount() {
        ++this.usageCount;
    }

    public int getPartition() {
        return this.partition;
    }

    public void setPartition(int partition) {
        this.partition = partition;
    }

    static {
        logger = LogDomains.getLogger((String)"javax.enterprise.resource.resourceadapter");
    }
}

