/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.spi.ConnectorRuntimeException;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdbcConnectionPoolDeployer
implements ResourceDeployer {
    private static StringManager sm = StringManager.getManager(JdbcConnectionPoolDeployer.class);
    private static String msg = sm.getString("resource.restart_needed");
    private static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.resource.resourceadapter");

    public synchronized void deployResource(Object resource) throws Exception {
        _logger.fine(" JdbcConnectionPoolDeployer - deployResource : " + resource + " calling actualDeploy");
        this.actualDeployResource(resource);
    }

    public synchronized void actualDeployResource(Object resource) {
        _logger.fine(" JdbcConnectionPoolDeployer - actualDeployResource : " + resource);
        JdbcConnectionPool adminPool = (JdbcConnectionPool)resource;
        try {
            ConnectorConnectionPool connConnPool = this.createConnectorConnectionPool(adminPool);
            ConnectorRuntime.getRuntime().createConnectorConnectionPool(connConnPool);
        }
        catch (ConnectorRuntimeException cre) {
            cre.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        _logger.fine(" JdbcConnectionPoolDeployer - unDeployResource : calling actualUndeploy of " + resource);
        this.actualUndeployResource(resource);
    }

    public synchronized void actualUndeployResource(Object resource) throws Exception {
        _logger.fine(" JdbcConnectionPoolDeployer - unDeployResource : " + resource);
        JdbcConnectionPool jdbcConnPool = (JdbcConnectionPool)resource;
        String poolName = jdbcConnPool.getName();
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        runtime.deleteConnectorConnectionPool(poolName);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Pool Undeployed");
        }
    }

    private EnvironmentProperty[] getMCFConfigProperties(JdbcConnectionPool adminPool, ConnectorConnectionPool conConnPool, ConnectorDescriptor connDesc) {
        ArrayList<EnvironmentProperty> propList = new ArrayList<EnvironmentProperty>();
        propList.add(new EnvironmentProperty("ClassName", adminPool.getDatasourceClassname() == null ? "" : adminPool.getDatasourceClassname(), "The datasource class name", "java.lang.String"));
        propList.add(new EnvironmentProperty("ConnectionValidationRequired", adminPool.getIsConnectionValidationRequired() + "", "Is connection validation required", "java.lang.String"));
        propList.add(new EnvironmentProperty("ValidationMethod", adminPool.getConnectionValidationMethod() == null ? "" : adminPool.getConnectionValidationMethod(), "How the connection is validated", "java.lang.String"));
        propList.add(new EnvironmentProperty("ValidationTableName", adminPool.getValidationTableName() == null ? "" : adminPool.getValidationTableName(), "Validation Table name", "java.lang.String"));
        propList.add(new EnvironmentProperty("TransactionIsolation", adminPool.getTransactionIsolationLevel() == null ? "" : adminPool.getTransactionIsolationLevel(), "Transaction Isolatin Level", "java.lang.String"));
        propList.add(new EnvironmentProperty("GuaranteeIsolationLevel", adminPool.getIsIsolationLevelGuaranteed() + "", "Transaction Isolation Guarantee", "java.lang.String"));
        propList.add(new EnvironmentProperty("StatementWrapping", adminPool.getWrapJdbcObjects() + "", "Statement Wrapping", "java.lang.String"));
        propList.add(new EnvironmentProperty("StatementTimeout", adminPool.getStatementTimeoutInSeconds() + "", "Statement Timeout", "java.lang.String"));
        Set connDefDescSet = connDesc.getOutboundResourceAdapter().getConnectionDefs();
        if (connDefDescSet.size() != 1) {
            throw new MissingResourceException("Only one connDefDesc present", null, null);
        }
        Iterator iter = connDefDescSet.iterator();
        Set mcfConfigProps = null;
        while (iter.hasNext()) {
            mcfConfigProps = ((ConnectionDefDescriptor)iter.next()).getConfigProperties();
        }
        if (mcfConfigProps != null) {
            HashMap<String, String> mcfConPropKeys = new HashMap<String, String>();
            Iterator mcfConfigPropsIter = mcfConfigProps.iterator();
            while (mcfConfigPropsIter.hasNext()) {
                String key = ((EnvironmentProperty)mcfConfigPropsIter.next()).getName();
                mcfConPropKeys.put(key.toUpperCase(), key);
            }
            String driverProperties = "";
            for (Property rp : adminPool.getProperty()) {
                if (rp == null) continue;
                String name = rp.getName();
                if ("MATCHCONNECTIONS".equals(name.toUpperCase())) {
                    conConnPool.setMatchConnections(this.toBoolean(rp.getValue(), false));
                    this.logFine("MATCHCONNECTIONS");
                    continue;
                }
                if ("POOLDATASTRUCTURE".equals(name.toUpperCase())) {
                    conConnPool.setPoolDataStructureType(rp.getValue());
                    this.logFine("POOLDATASTRUCTURE");
                    continue;
                }
                if ("POOLWAITQUEUE".equals(name.toUpperCase())) {
                    conConnPool.setPoolWaitQueue(rp.getValue());
                    this.logFine("POOLWAITQUEUE");
                    continue;
                }
                if ("DATASTRUCTUREPARAMETERS".equals(name.toUpperCase())) {
                    conConnPool.setDataStructureParameters(rp.getValue());
                    this.logFine("DATASTRUCTUREPARAMETERS");
                    continue;
                }
                if ("USERNAME".equals(name.toUpperCase()) || "USER".equals(name.toUpperCase())) {
                    propList.add(new EnvironmentProperty("User", rp.getValue(), "user name", "java.lang.String"));
                    continue;
                }
                if ("PASSWORD".equals(name.toUpperCase())) {
                    propList.add(new EnvironmentProperty("Password", rp.getValue(), "Password", "java.lang.String"));
                    continue;
                }
                if ("JDBC30DATASOURCE".equals(name.toUpperCase())) {
                    propList.add(new EnvironmentProperty("JDBC30DataSource", rp.getValue(), "JDBC30DataSource", "java.lang.String"));
                    continue;
                }
                if (mcfConPropKeys.containsKey(name.toUpperCase())) {
                    propList.add(new EnvironmentProperty((String)mcfConPropKeys.get(name.toUpperCase()), rp.getValue() == null ? "" : rp.getValue(), "Some property", "java.lang.String"));
                    continue;
                }
                driverProperties = driverProperties + "set" + this.escape(name) + "#" + this.escape(rp.getValue()) + "##";
            }
            if (!driverProperties.equals("")) {
                propList.add(new EnvironmentProperty("DriverProperties", driverProperties, "some proprietarty properties", "java.lang.String"));
            }
        }
        propList.add(new EnvironmentProperty("Delimiter", "#", "delim", "java.lang.String"));
        propList.add(new EnvironmentProperty("EscapeCharacter", "\\", "escapeCharacter", "java.lang.String"));
        EnvironmentProperty[] eProps = new EnvironmentProperty[propList.size()];
        ListIterator propListIter = propList.listIterator();
        int i = 0;
        while (propListIter.hasNext()) {
            eProps[i] = (EnvironmentProperty)propListIter.next();
            ++i;
        }
        return eProps;
    }

    private String escape(String value) {
        String seq = "\\";
        String replacement = "\\\\";
        value = value.replace(seq, replacement);
        seq = "#";
        replacement = "\\#";
        value = value.replace(seq, replacement);
        return value;
    }

    private boolean toBoolean(Object prop, boolean defaultVal) {
        if (prop == null) {
            return defaultVal;
        }
        return Boolean.valueOf(((String)prop).toLowerCase());
    }

    private void logFine(String msg) {
        if (_logger.isLoggable(Level.FINE) && msg != null) {
            _logger.fine(msg);
        }
    }

    public ConnectorConnectionPool createConnectorConnectionPool(JdbcConnectionPool adminPool) throws ConnectorRuntimeException {
        String moduleName = ResourcesUtil.createInstance().getRANameofJdbcConnectionPool(adminPool);
        int txSupport = this.getTxSupport(moduleName);
        ConnectorDescriptor connDesc = ConnectorRuntime.getRuntime().getConnectorDescriptor(moduleName);
        ConnectorConnectionPool conConnPool = new ConnectorConnectionPool(adminPool.getName());
        conConnPool.setTransactionSupport(txSupport);
        this.setConnectorConnectionPoolAttributes(conConnPool, adminPool);
        ConnectorDescriptorInfo connDescInfo = this.createConnectorDescriptorInfo(connDesc, moduleName);
        connDescInfo.setMCFConfigProperties(this.getMCFConfigProperties(adminPool, conConnPool, connDesc));
        connDescInfo.setResourceAdapterConfigProperties((Set)null);
        conConnPool.setConnectorDescriptorInfo(connDescInfo);
        return conConnPool;
    }

    private int getTxSupport(String moduleName) {
        if ("__xa_jdbc_ra".equals(moduleName)) {
            throw new UnsupportedOperationException("XA is not supported yet");
        }
        return ConnectionPoolObjectsUtils.parseTransactionSupportString("LocalTransaction");
    }

    private ConnectorDescriptorInfo createConnectorDescriptorInfo(ConnectorDescriptor connDesc, String moduleName) {
        ConnectorDescriptorInfo connDescInfo = new ConnectorDescriptorInfo();
        connDescInfo.setManagedConnectionFactoryClass(connDesc.getOutboundResourceAdapter().getManagedConnectionFactoryImpl());
        connDescInfo.setRarName(moduleName);
        connDescInfo.setResourceAdapterClassName(connDesc.getResourceAdapterClass());
        connDescInfo.setConnectionDefinitionName(connDesc.getOutboundResourceAdapter().getConnectionFactoryIntf());
        connDescInfo.setConnectionFactoryClass(connDesc.getOutboundResourceAdapter().getConnectionFactoryImpl());
        connDescInfo.setConnectionFactoryInterface(connDesc.getOutboundResourceAdapter().getConnectionFactoryIntf());
        connDescInfo.setConnectionClass(connDesc.getOutboundResourceAdapter().getConnectionImpl());
        connDescInfo.setConnectionInterface(connDesc.getOutboundResourceAdapter().getConnectionIntf());
        return connDescInfo;
    }

    private void setConnectorConnectionPoolAttributes(ConnectorConnectionPool ccp, JdbcConnectionPool adminPool) {
        ccp.setMaxPoolSize(adminPool.getMaxPoolSize());
        ccp.setSteadyPoolSize(adminPool.getSteadyPoolSize());
        ccp.setMaxWaitTimeInMillis(adminPool.getMaxWaitTimeInMillis());
        ccp.setPoolResizeQuantity(adminPool.getPoolResizeQuantity());
        ccp.setIdleTimeoutInSeconds(adminPool.getIdleTimeoutInSeconds());
        ccp.setFailAllConnections(Boolean.valueOf(adminPool.getFailAllConnections()));
        ccp.setConnectionValidationRequired(Boolean.valueOf(adminPool.getIsConnectionValidationRequired()));
        ccp.setNonTransactional(Boolean.valueOf(adminPool.getNonTransactionalConnections()));
        ccp.setMatchConnections(Boolean.valueOf(adminPool.getMatchConnections()));
        ccp.setConnectionLeakTracingTimeout(adminPool.getConnectionLeakTimeoutInSeconds());
        ccp.setConnectionReclaim(Boolean.valueOf(adminPool.getConnectionLeakReclaim()));
        ccp.setMaxConnectionUsage(adminPool.getMaxConnectionUsageCount());
        ccp.setConCreationRetryAttempts(adminPool.getConnectionCreationRetryAttempts());
        ccp.setConCreationRetryInterval(adminPool.getConnectionCreationRetryIntervalInSeconds());
        ccp.setValidateAtmostOncePeriod(adminPool.getValidateAtmostOncePeriodInSeconds());
    }
}

