/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.MessageDriven;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.AnnotationUtils;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHandler
implements AnnotationHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AbstractHandler.class);
    protected Logger logger = AnnotationUtils.getLogger();

    public Class<? extends Annotation>[] getTypeDependencies() {
        return null;
    }

    protected HandlerProcessingResult getDefaultProcessedResult() {
        return HandlerProcessingResultImpl.getDefaultResult((Class)this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
    }

    protected HandlerProcessingResult getDefaultFailedResult() {
        return HandlerProcessingResultImpl.getDefaultResult((Class)this.getAnnotationType(), (ResultType)ResultType.FAILED);
    }

    protected HandlerProcessingResult getInvalidAnnotatedElementHandlerResult(AnnotatedElementHandler aeHandler, AnnotationInfo ainfo) throws AnnotationProcessorException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidaehandler", "Invalid annotation symbol found for this type of class."));
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Invalid AnnotatedElementHandler: " + aeHandler);
        }
        return this.getDefaultProcessedResult();
    }

    protected void log(Level level, AnnotationInfo ainfo, String localizedMessage) throws AnnotationProcessorException {
        if (Level.SEVERE.equals(level)) {
            ainfo.getProcessingContext().getErrorHandler().error(new AnnotationProcessorException(localizedMessage, ainfo));
        } else if (Level.WARNING.equals(level)) {
            ainfo.getProcessingContext().getErrorHandler().warning(new AnnotationProcessorException(localizedMessage, ainfo));
        } else if (Level.FINE.equals(level)) {
            ainfo.getProcessingContext().getErrorHandler().fine(new AnnotationProcessorException(localizedMessage, ainfo));
        } else if (ainfo != null) {
            ainfo.getProcessingContext().getProcessor().log(level, ainfo, localizedMessage);
        } else {
            this.logger.log(level, localizedMessage);
        }
    }

    protected String getInjectionMethodPropertyName(Method method, AnnotationInfo ainfo) throws AnnotationProcessorException {
        String methodName;
        String propertyName = methodName = method.getName();
        if (methodName.length() <= 3 || !methodName.startsWith("set")) {
            throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidinjectionmethodname", "Injection method name must start with \"set\""), ainfo);
        }
        propertyName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        return propertyName;
    }

    protected void validateInjectionMethod(Method method, AnnotationInfo ainfo) throws AnnotationProcessorException {
        if (method.getParameterTypes().length != 1) {
            throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidinjectionmethod", "Injection on a method requires a JavaBeans setter method type with one parameter "), ainfo);
        }
        if (!Void.TYPE.equals(method.getReturnType())) {
            throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.injectionmethodmustreturnvoid", "Injection on a method requires a void return type"), ainfo);
        }
    }

    protected HandlerProcessingResult getOverallProcessingResult(List<HandlerProcessingResult> resultList) {
        HandlerProcessingResult overallProcessingResult = null;
        for (HandlerProcessingResult result : resultList) {
            if (overallProcessingResult != null && result.getOverallResult().compareTo((Enum)overallProcessingResult.getOverallResult()) <= 0) continue;
            overallProcessingResult = result;
        }
        return overallProcessingResult;
    }

    protected Class<? extends Annotation>[] getEjbAnnotationTypes() {
        return new Class[]{MessageDriven.class, Stateful.class, Stateless.class};
    }
}

