/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.impl;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.annotation.impl.ModuleScanner;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.deployment.web.ServletFilter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import org.glassfish.apf.impl.AnnotationUtils;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="war")
public class WarScanner
extends ModuleScanner<WebBundleDescriptor> {
    public void process(File archiveFile, WebBundleDescriptor webBundleDesc, ClassLoader classLoader) throws IOException {
        File[] jarFiles;
        File lib;
        if (AnnotationUtils.getLogger().isLoggable(Level.FINE)) {
            AnnotationUtils.getLogger().fine("archiveFile is " + archiveFile);
            AnnotationUtils.getLogger().fine("webBundle is " + webBundleDesc);
            AnnotationUtils.getLogger().fine("classLoader is " + classLoader);
        }
        this.archiveFile = archiveFile;
        this.classLoader = classLoader;
        if (!archiveFile.isDirectory()) {
            return;
        }
        File webinf = new File(archiveFile, "WEB-INF");
        File classes = new File(webinf, "classes");
        if (classes.exists()) {
            this.addScanDirectory(classes);
        }
        if ((lib = new File(webinf, "lib")).exists() && (jarFiles = lib.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getAbsolutePath().endsWith(".jar");
            }
        })) != null && jarFiles.length > 0) {
            for (File jarFile : jarFiles) {
                this.addScanJar(jarFile);
            }
        }
        for (WebComponentDescriptor webCompDesc : webBundleDesc.getWebComponentDescriptors()) {
            if (!webCompDesc.isServlet()) continue;
            this.addScanClassName(webCompDesc.getWebComponentImplementation());
        }
        Vector<ServletFilter> servletFilters = webBundleDesc.getServletFilters();
        for (int i = 0; i < servletFilters.size(); ++i) {
            ServletFilter filter = servletFilters.elementAt(i);
            this.addScanClassName(filter.getClassName());
        }
        Vector<AppListenerDescriptor> listeners = webBundleDesc.getAppListenerDescriptors();
        for (int j = 0; j < listeners.size(); ++j) {
            AppListenerDescriptor listenerDesc = listeners.elementAt(j);
            this.addScanClassName(listenerDesc.getListener());
        }
    }
}

