/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.web;

import com.sun.enterprise.deployment.AppListenerDescriptorImpl;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ErrorPageDescriptor;
import com.sun.enterprise.deployment.JspConfigDescriptor;
import com.sun.enterprise.deployment.LocaleEncodingMappingListDescriptor;
import com.sun.enterprise.deployment.LoginConfigurationImpl;
import com.sun.enterprise.deployment.MimeMappingDescriptor;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.ServletFilterDescriptor;
import com.sun.enterprise.deployment.ServletFilterMappingDescriptor;
import com.sun.enterprise.deployment.TagLibConfigurationDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.node.BundleNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.EjbLocalReferenceNode;
import com.sun.enterprise.deployment.node.EjbReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerFactoryReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerReferenceNode;
import com.sun.enterprise.deployment.node.EnvEntryNode;
import com.sun.enterprise.deployment.node.LifecycleCallbackNode;
import com.sun.enterprise.deployment.node.MessageDestinationNode;
import com.sun.enterprise.deployment.node.MessageDestinationRefNode;
import com.sun.enterprise.deployment.node.ResourceEnvRefNode;
import com.sun.enterprise.deployment.node.ResourceRefNode;
import com.sun.enterprise.deployment.node.SecurityRoleNode;
import com.sun.enterprise.deployment.node.ServiceReferenceNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.web.ErrorPageNode;
import com.sun.enterprise.deployment.node.web.FilterMappingNode;
import com.sun.enterprise.deployment.node.web.FilterNode;
import com.sun.enterprise.deployment.node.web.InitParamNode;
import com.sun.enterprise.deployment.node.web.JspConfigNode;
import com.sun.enterprise.deployment.node.web.ListenerNode;
import com.sun.enterprise.deployment.node.web.LocaleEncodingMappingListNode;
import com.sun.enterprise.deployment.node.web.LoginConfigNode;
import com.sun.enterprise.deployment.node.web.MimeMappingNode;
import com.sun.enterprise.deployment.node.web.SecurityConstraintNode;
import com.sun.enterprise.deployment.node.web.ServletMappingNode;
import com.sun.enterprise.deployment.node.web.ServletNode;
import com.sun.enterprise.deployment.node.web.TagLibNode;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.deployment.web.MimeMapping;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.ServletFilter;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBundleNode
extends BundleNode<WebBundleDescriptor> {
    public static final XMLElement tag = new XMLElement("web-app");
    public static final String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    public static final String PUBLIC_DTD_ID_12 = "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
    public static final String SYSTEM_ID = "http://java.sun.com/dtd/web-app_2_3.dtd";
    public static final String SYSTEM_ID_12 = "http://java.sun.com/dtd/web-app_2_2.dtd";
    public static final String SCHEMA_ID_24 = "web-app_2_4.xsd";
    public static final String SCHEMA_ID = "web-app_2_5.xsd";
    public static final String SPEC_VERSION = "2.5";
    private static final List<String> systemIDs = WebBundleNode.initSystemIDs();
    private WebBundleDescriptor descriptor;
    private Map servletMappings;
    private boolean isFirstWelcomeFile = true;
    private static WebBundleDescriptor defaultWbd;

    private static List<String> initSystemIDs() {
        ArrayList<String> systemIDs = new ArrayList<String>();
        systemIDs.add(SCHEMA_ID);
        systemIDs.add(SCHEMA_ID_24);
        return Collections.unmodifiableList(systemIDs);
    }

    public static String registerBundle(Map publicIDToDTD) {
        publicIDToDTD.put(PUBLIC_DTD_ID, SYSTEM_ID);
        publicIDToDTD.put(PUBLIC_DTD_ID_12, SYSTEM_ID_12);
        return tag.getQName();
    }

    public WebBundleNode() {
        this.registerElementHandler(new XMLElement("env-entry"), EnvEntryNode.class);
        this.registerElementHandler(new XMLElement("ejb-ref"), EjbReferenceNode.class);
        this.registerElementHandler(new XMLElement("ejb-local-ref"), EjbLocalReferenceNode.class);
        this.registerElementHandler(new XMLElement("service-ref"), ServiceReferenceNode.class, "addServiceReferenceDescriptor");
        this.registerElementHandler(new XMLElement("resource-ref"), ResourceRefNode.class, "addResourceReferenceDescriptor");
        this.registerElementHandler(new XMLElement("resource-env-ref"), ResourceEnvRefNode.class, "addJmsDestinationReferenceDescriptor");
        this.registerElementHandler(new XMLElement("message-destination-ref"), MessageDestinationRefNode.class, "addMessageDestinationReferenceDescriptor");
        this.registerElementHandler(new XMLElement("persistence-context-ref"), EntityManagerReferenceNode.class, "addEntityManagerReferenceDescriptor");
        this.registerElementHandler(new XMLElement("persistence-unit-ref"), EntityManagerFactoryReferenceNode.class, "addEntityManagerFactoryReferenceDescriptor");
        this.registerElementHandler(new XMLElement("security-role"), SecurityRoleNode.class, "addRole");
        this.registerElementHandler(new XMLElement("servlet"), ServletNode.class);
        this.registerElementHandler(new XMLElement("servlet-mapping"), ServletMappingNode.class);
        this.registerElementHandler(new XMLElement("mime-mapping"), MimeMappingNode.class, "addMimeMapping");
        this.registerElementHandler(new XMLElement("context-param"), InitParamNode.class, "addContextParameter");
        this.registerElementHandler(new XMLElement("security-constraint"), SecurityConstraintNode.class, "addSecurityConstraint");
        this.registerElementHandler(new XMLElement("filter"), FilterNode.class, "addServletFilter");
        this.registerElementHandler(new XMLElement("filter-mapping"), FilterMappingNode.class, "addServletFilterMapping");
        this.registerElementHandler(new XMLElement("listener"), ListenerNode.class, "addAppListenerDescriptor");
        this.registerElementHandler(new XMLElement("error-page"), ErrorPageNode.class, "addErrorPageDescriptor");
        this.registerElementHandler(new XMLElement("login-config"), LoginConfigNode.class);
        this.registerElementHandler(new XMLElement("taglib"), TagLibNode.class);
        this.registerElementHandler(new XMLElement("jsp-config"), JspConfigNode.class);
        this.registerElementHandler(new XMLElement("locale-encoding-mapping-list"), LocaleEncodingMappingListNode.class, "addLocaleEncodingMappingListDescriptor");
        this.registerElementHandler(new XMLElement("message-destination"), MessageDestinationNode.class, "addMessageDestination");
        this.registerElementHandler(new XMLElement("post-construct"), LifecycleCallbackNode.class, "addPostConstructDescriptor");
        this.registerElementHandler(new XMLElement("pre-destroy"), LifecycleCallbackNode.class, "addPreDestroyDescriptor");
    }

    @Override
    public WebBundleDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = WebBundleNode.getDefaultBundleDescriptor();
        }
        if (this.descriptor == null) {
            this.descriptor = (WebBundleDescriptor)DescriptorFactory.getDescriptor(this.getXMLPath());
        }
        return this.descriptor;
    }

    public static void setDefaultBundleDescriptor(WebBundleDescriptor wbd) {
        defaultWbd = wbd;
    }

    public static WebBundleDescriptor getDefaultBundleDescriptor() {
        return defaultWbd;
    }

    @Override
    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof EjbReference) {
            this.descriptor.addEjbReferenceDescriptor((EjbReference)newDescriptor);
        } else if (newDescriptor instanceof EnvironmentProperty) {
            DOLUtils.getDefaultLogger().fine("Adding env entry" + newDescriptor);
            this.descriptor.addEnvironmentProperty((EnvironmentProperty)newDescriptor);
        } else if (newDescriptor instanceof WebComponentDescriptor) {
            DOLUtils.getDefaultLogger().fine("Adding web component" + newDescriptor);
            this.descriptor.addWebComponentDescriptor((WebComponentDescriptor)newDescriptor);
        } else if (newDescriptor instanceof TagLibConfigurationDescriptor) {
            DOLUtils.getDefaultLogger().fine("Adding taglib component " + newDescriptor);
            if (this.descriptor.getJspConfigDescriptor() == null) {
                this.descriptor.setJspConfigDescriptor(new JspConfigDescriptor());
            }
            this.descriptor.getJspConfigDescriptor().addTagLib((TagLibConfigurationDescriptor)newDescriptor);
        } else if (newDescriptor instanceof JspConfigDescriptor) {
            DOLUtils.getDefaultLogger().fine("Adding JSP Config Descriptor" + newDescriptor);
            if (this.descriptor.getJspConfigDescriptor() != null) {
                throw new RuntimeException("Has more than one jsp-config element!");
            }
            this.descriptor.setJspConfigDescriptor((JspConfigDescriptor)newDescriptor);
        } else if (newDescriptor instanceof LoginConfiguration) {
            DOLUtils.getDefaultLogger().fine("Adding Login Config Descriptor" + newDescriptor);
            if (this.descriptor.getLoginConfiguration() != null) {
                throw new RuntimeException("Has more than one login-config element!");
            }
            this.descriptor.setLoginConfiguration((LoginConfiguration)newDescriptor);
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("session-timeout".equals(element.getQName())) {
            if (this.descriptor.getSessionTimeout() != 30) {
                throw new RuntimeException("Has more than one session-config element!");
            }
            this.descriptor.setSessionTimeout(Integer.valueOf(value.trim()));
        } else if ("welcome-file".equals(element.getQName())) {
            if (this.isFirstWelcomeFile) {
                this.descriptor.getWelcomeFilesSet().clear();
                this.isFirstWelcomeFile = false;
            }
            this.descriptor.addWelcomeFile(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    protected XMLElement getXMLRootTag() {
        return tag;
    }

    @Override
    public String getDocType() {
        return null;
    }

    @Override
    public String getSystemID() {
        return SCHEMA_ID;
    }

    @Override
    public List<String> getSystemIDs() {
        return systemIDs;
    }

    void addServletMapping(String servletName, String urlPattern) {
        if (this.servletMappings == null) {
            this.servletMappings = new HashMap();
        }
        if (this.servletMappings.containsKey(servletName)) {
            ((Vector)this.servletMappings.get(servletName)).add(urlPattern);
        } else {
            Vector<String> mappings = new Vector<String>();
            mappings.add(urlPattern);
            this.servletMappings.put(servletName, mappings);
        }
    }

    @Override
    public boolean endElement(XMLElement element) {
        if ("distributable".equals(element.getQName())) {
            this.descriptor.setDistributable(true);
            return false;
        }
        boolean allDone = super.endElement(element);
        if (allDone && this.servletMappings != null) {
            for (String servletName : this.servletMappings.keySet()) {
                Vector mappings = (Vector)this.servletMappings.get(servletName);
                WebComponentDescriptor servlet = this.descriptor.getWebComponentByCanonicalName(servletName);
                if (servlet != null) {
                    Iterator mapping = mappings.iterator();
                    while (mapping.hasNext()) {
                        servlet.addUrlPattern((String)mapping.next());
                    }
                    continue;
                }
                throw new RuntimeException("There is no web component by the name of " + servletName + " here.");
            }
        }
        return allDone;
    }

    @Override
    public Node writeDescriptor(Node parent, WebBundleDescriptor webBundleDesc) {
        Enumeration<SecurityRoleDescriptor> roles;
        LoginConfigurationImpl lci;
        Enumeration<SecurityConstraint> securityConstraints;
        JspConfigDescriptor jspConf;
        Enumeration<ErrorPageDescriptor> errorPages;
        Set<WebComponentDescriptor> servlets;
        Node jarNode = super.writeDescriptor(parent, webBundleDesc);
        if (webBundleDesc.isDistributable()) {
            WebBundleNode.appendChild(jarNode, "distributable");
        }
        WebBundleNode.addInitParam(jarNode, "context-param", webBundleDesc.getContextParametersSet());
        FilterNode filterNode = new FilterNode();
        Enumeration<ServletFilter> filters = webBundleDesc.getServletFilters().elements();
        while (filters.hasMoreElements()) {
            filterNode.writeDescriptor(jarNode, "filter", (ServletFilterDescriptor)filters.nextElement());
        }
        FilterMappingNode filterMappingNode = new FilterMappingNode();
        Enumeration<ServletFilterMapping> mappings = webBundleDesc.getServletFilterMappings().elements();
        while (mappings.hasMoreElements()) {
            filterMappingNode.writeDescriptor(jarNode, "filter-mapping", (ServletFilterMappingDescriptor)mappings.nextElement());
        }
        Vector<AppListenerDescriptor> appListeners = webBundleDesc.getAppListenerDescriptors();
        if (appListeners != null && !appListeners.isEmpty()) {
            Enumeration<AppListenerDescriptor> e = appListeners.elements();
            while (e.hasMoreElements()) {
                AppListenerDescriptorImpl listener = (AppListenerDescriptorImpl)e.nextElement();
                Element listenerNode = WebBundleNode.appendChild(jarNode, "listener");
                WebBundleNode.appendTextChild((Node)listenerNode, "listener-class", listener.getListener());
            }
        }
        if ((servlets = webBundleDesc.getWebComponentDescriptors()) != null && !servlets.isEmpty()) {
            ServletNode servletNode = new ServletNode();
            for (WebComponentDescriptor aServlet : servlets) {
                servletNode.writeDescriptor(jarNode, aServlet);
            }
        }
        if (servlets != null && !servlets.isEmpty()) {
            for (WebComponentDescriptor aServlet : servlets) {
                for (String pattern : aServlet.getUrlPatternsSet()) {
                    Element mappingNode = WebBundleNode.appendChild(jarNode, "servlet-mapping");
                    WebBundleNode.appendTextChild((Node)mappingNode, "servlet-name", aServlet.getCanonicalName());
                    if (webBundleDesc.getSpecVersion().equals("2.2") && !pattern.startsWith("/") && !pattern.startsWith("*.")) {
                        pattern = "/" + pattern;
                    }
                    WebBundleNode.appendTextChild((Node)mappingNode, "url-pattern", pattern);
                }
            }
        }
        if (webBundleDesc.getSessionTimeout() != 30) {
            Element config = WebBundleNode.appendChild(jarNode, "session-config");
            WebBundleNode.appendTextChild((Node)config, "session-timeout", String.valueOf(webBundleDesc.getSessionTimeout()));
        }
        MimeMappingNode mimeNode = new MimeMappingNode();
        Enumeration<MimeMapping> e = webBundleDesc.getMimeMappings();
        while (e.hasMoreElements()) {
            MimeMappingDescriptor mimeMapping = (MimeMappingDescriptor)e.nextElement();
            mimeNode.writeDescriptor(jarNode, "mime-mapping", mimeMapping);
        }
        Enumeration<String> welcomeFiles = webBundleDesc.getWelcomeFiles();
        if (welcomeFiles.hasMoreElements()) {
            Element welcomeList = WebBundleNode.appendChild(jarNode, "welcome-file-list");
            while (welcomeFiles.hasMoreElements()) {
                WebBundleNode.appendTextChild((Node)welcomeList, "welcome-file", welcomeFiles.nextElement());
            }
        }
        if ((errorPages = webBundleDesc.getErrorPageDescriptors()).hasMoreElements()) {
            ErrorPageNode errorPageNode = new ErrorPageNode();
            while (errorPages.hasMoreElements()) {
                errorPageNode.writeDescriptor(jarNode, "error-page", errorPages.nextElement());
            }
        }
        if ((jspConf = webBundleDesc.getJspConfigDescriptor()) != null) {
            JspConfigNode ln = new JspConfigNode();
            ln.writeDescriptor(jarNode, "jsp-config", jspConf);
        }
        if ((securityConstraints = webBundleDesc.getSecurityConstraints()).hasMoreElements()) {
            SecurityConstraintNode scNode = new SecurityConstraintNode();
            while (securityConstraints.hasMoreElements()) {
                SecurityConstraintImpl sc = (SecurityConstraintImpl)securityConstraints.nextElement();
                scNode.writeDescriptor(jarNode, "security-constraint", sc);
            }
        }
        if ((lci = (LoginConfigurationImpl)webBundleDesc.getLoginConfiguration()) != null) {
            LoginConfigNode lcn = new LoginConfigNode();
            lcn.writeDescriptor(jarNode, "login-config", lci);
        }
        if ((roles = webBundleDesc.getSecurityRoles()).hasMoreElements()) {
            SecurityRoleNode srNode = new SecurityRoleNode();
            while (roles.hasMoreElements()) {
                SecurityRoleDescriptor role = roles.nextElement();
                srNode.writeDescriptor(jarNode, "security-role", role);
            }
        }
        this.writeEnvEntryDescriptors(jarNode, webBundleDesc.getEnvironmentProperties().iterator());
        this.writeEjbReferenceDescriptors(jarNode, webBundleDesc.getEjbReferenceDescriptors().iterator());
        this.writeServiceReferenceDescriptors(jarNode, webBundleDesc.getServiceReferenceDescriptors().iterator());
        this.writeResourceRefDescriptors(jarNode, webBundleDesc.getResourceReferenceDescriptors().iterator());
        this.writeResourceEnvRefDescriptors(jarNode, webBundleDesc.getJmsDestinationReferenceDescriptors().iterator());
        this.writeMessageDestinationRefDescriptors(jarNode, webBundleDesc.getMessageDestinationReferenceDescriptors().iterator());
        this.writeEntityManagerReferenceDescriptors(jarNode, webBundleDesc.getEntityManagerReferenceDescriptors().iterator());
        this.writeEntityManagerFactoryReferenceDescriptors(jarNode, webBundleDesc.getEntityManagerFactoryReferenceDescriptors().iterator());
        this.writePostConstructDescriptors(jarNode, webBundleDesc.getPostConstructDescriptors().iterator());
        this.writePreDestroyDescriptors(jarNode, webBundleDesc.getPreDestroyDescriptors().iterator());
        this.writeMessageDestinations(jarNode, webBundleDesc.getMessageDestinations().iterator());
        LocaleEncodingMappingListDescriptor lemDesc = webBundleDesc.getLocaleEncodingMappingListDescriptor();
        if (lemDesc != null) {
            LocaleEncodingMappingListNode ln = new LocaleEncodingMappingListNode();
            ln.writeDescriptor(jarNode, "locale-encoding-mapping-list", lemDesc);
        }
        return jarNode;
    }

    static void addInitParam(Node parentNode, String nodeName, Set initParams) {
        if (!initParams.isEmpty()) {
            InitParamNode initParamNode = new InitParamNode();
            for (EnvironmentProperty ep : initParams) {
                initParamNode.writeDescriptor(parentNode, nodeName, ep);
            }
        }
    }

    static void addInitParam(Node parentNode, String nodeName, Enumeration initParams) {
        InitParamNode initParamNode = new InitParamNode();
        while (initParams.hasMoreElements()) {
            EnvironmentProperty ep = (EnvironmentProperty)initParams.nextElement();
            initParamNode.writeDescriptor(parentNode, nodeName, ep);
        }
    }

    @Override
    public String getSpecVersion() {
        return SPEC_VERSION;
    }
}

