/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.ProxyHandler;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.HTTPListenerStats;
import com.sun.enterprise.admin.monitor.stats.PWCConnectionQueueStats;
import com.sun.enterprise.admin.monitor.stats.PWCFileCacheStats;
import com.sun.enterprise.admin.monitor.stats.PWCKeepAliveStats;
import com.sun.enterprise.admin.monitor.stats.PWCRequestStats;
import com.sun.enterprise.admin.monitor.stats.PWCThreadPoolStats;
import com.sun.enterprise.admin.monitor.stats.PWCVirtualServerStats;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.ConnectionPool;
import com.sun.enterprise.config.serverbeans.HttpFileCache;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpProtocol;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.KeepAlive;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.RequestProcessing;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.security.CipherInfo;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.PEAccessLogValve;
import com.sun.enterprise.web.ProxyHandlerImpl;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.connector.coyote.PECoyoteConnector;
import com.sun.enterprise.web.pluggable.WebContainerFeatureFactory;
import com.sun.enterprise.web.stats.HTTPListenerStatsImpl;
import com.sun.enterprise.web.stats.PWCConnectionQueueStatsImpl;
import com.sun.enterprise.web.stats.PWCFileCacheStatsImpl;
import com.sun.enterprise.web.stats.PWCKeepAliveStatsImpl;
import com.sun.enterprise.web.stats.PWCRequestStatsImpl;
import com.sun.enterprise.web.stats.PWCThreadPoolStatsImpl;
import com.sun.enterprise.web.stats.PWCVirtualServerStatsImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.startup.Embedded;
import org.apache.tomcat.util.IntrospectionUtils;

public class PEWebContainer
extends WebContainer {
    private PECoyoteConnector jkConnector;
    private HashMap<String, PECoyoteConnector> connectorMap;
    protected int defaultRedirectPort = -1;
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static final String DEFAULT_TRUSTSTORE_TYPE = "JKS";

    protected PEWebContainer(String id, ServerContext context) {
    }

    protected void init(ServerContext context) {
        this.connectorMap = new HashMap();
        Config config = (Config)context.getDefaultHabitat().getComponent(Config.class);
        Server serverBean = (Server)context.getDefaultHabitat().getComponent(Server.class);
        this.createEngine();
        HttpService httpService = config.getHttpService();
        this.configureNotSupported(httpService);
        this.createConnectors(httpService);
        this.createJKConnector(httpService);
        this.createHosts(httpService, config.getSecurityService(), this.globalAccessLoggingEnabled, serverBean);
        this.checkDefaultVirtualServerPort(httpService);
    }

    private void createJKConnector(HttpService httpService) {
        String portString = System.getProperty("com.sun.enterprise.web.connector.enableJK");
        if (portString == null) {
            return;
        }
        int port = 8009;
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException ex) {
            port = 8009;
        }
        this.jkConnector = (PECoyoteConnector)((Embedded)this._embedded).createConnector("0.0.0.0", port, "ajp");
        this.configureJKProperties(this.jkConnector);
        String defaultHost = "server";
        this.jkConnector.setDefaultHost(defaultHost);
        this.jkConnector.setDomain(this._serverContext.getDefaultDomainName());
        this.jkConnector.setLogger(_logger);
        this.jkConnector.setName("httpd-listener");
        this.configureHttpProtocol(this.jkConnector, httpService.getHttpProtocol());
        _logger.log(Level.INFO, "Apache mod_jk/jk2 attached to virtual-server " + defaultHost + " listening on port: " + portString);
        this._embedded.addConnector(this.jkConnector);
    }

    public void createConnectors(HttpService httpService) {
        for (HttpListener httpListener : httpService.getHttpListener()) {
            if (!Boolean.getBoolean(httpListener.getEnabled())) continue;
            this.createConnector(httpListener, httpService);
        }
        this.setDefaultRedirectPort(this.defaultRedirectPort);
    }

    public PECoyoteConnector createConnector(HttpListener httpListener, HttpService httpService) {
        String address;
        if (!Boolean.getBoolean(httpListener.getEnabled())) {
            return null;
        }
        int port = 8080;
        this.checkHostnameUniqueness(httpListener.getId(), httpService);
        try {
            port = Integer.parseInt(httpListener.getPort());
        }
        catch (NumberFormatException nfe) {
            String msg = _rb.getString("pewebcontainer.http_listener.invalid_port");
            msg = MessageFormat.format(msg, httpListener.getPort(), httpListener.getId());
            throw new IllegalArgumentException(msg);
        }
        boolean isSecure = Boolean.getBoolean(httpListener.getSecurityEnabled());
        if (isSecure && this.defaultRedirectPort == -1) {
            this.defaultRedirectPort = port;
        }
        if ("any".equals(address = httpListener.getAddress()) || "ANY".equals(address) || "INADDR_ANY".equals(address)) {
            address = null;
        }
        PECoyoteConnector connector = (PECoyoteConnector)this._embedded.createConnector(address, port, isSecure);
        connector.setName(httpListener.getId());
        this.configureConnector(connector, httpListener, isSecure, httpService);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "create.listenerport", new Object[]{port, connector});
        }
        this._embedded.addConnector(connector);
        this.connectorMap.put(httpListener.getId(), connector);
        if (this.defaultRedirectPort != -1) {
            connector.setRedirectPort(this.defaultRedirectPort);
        }
        return connector;
    }

    private void setDefaultRedirectPort(int defaultRedirectPort) {
        if (defaultRedirectPort != -1) {
            Connector[] connectors = this._embedded.getConnectors();
            for (int i = 0; i < connectors.length; ++i) {
                if (connectors[i].getRedirectPort() != -1) continue;
                connectors[i].setRedirectPort(defaultRedirectPort);
            }
        }
    }

    private void checkDefaultVirtualServerPort(HttpService httpService) {
        List httpListeners = httpService.getHttpListener();
        if (httpListeners == null) {
            return;
        }
        for (HttpListener httpListener : httpListeners) {
            if (!Boolean.getBoolean(httpListener.getEnabled())) continue;
            int port = Integer.parseInt(httpListener.getPort());
            String defaultVsName = httpListener.getDefaultVirtualServer();
            VirtualServer defaultVs = (VirtualServer)this._embedded.getEngines()[0].findChild(defaultVsName);
            if (defaultVs == null) {
                _logger.log(Level.SEVERE, "pewebcontainer.defaultVsMissing", new Object[]{defaultVsName, httpListener.getId()});
            }
            boolean found = false;
            int[] ports = defaultVs.getPorts();
            for (int i = 0; i < ports.length; ++i) {
                if (ports[i] != port) continue;
                found = true;
                break;
            }
            if (found) continue;
            _logger.log(Level.SEVERE, "pewebcontainer.defaultVsHttpListenerDisconnect", new Object[]{defaultVsName, httpListener.getId()});
        }
    }

    protected void createEngine() {
        String engineName = "com.sun.appserv";
        Engine engine = this._embedded.createEngine();
        this._embedded.addEngine(engine);
        ((StandardEngine)engine).setName(engineName);
        if (this.isTomcatUsingDefaultDomain()) {
            ((StandardEngine)engine).setDomain(this._serverContext.getDefaultDomainName());
        } else {
            ((StandardEngine)engine).setDomain(engineName);
        }
        _logger.log(Level.FINE, "Creating Engine " + engineName);
    }

    public void createHost(com.sun.enterprise.config.serverbeans.VirtualServer vse, boolean enableMonitoring) {
        Config config = (Config)this._serverContext.getDefaultHabitat().getComponent(Config.class);
        Server serverBean = (Server)this._serverContext.getDefaultHabitat().getComponent(Server.class);
        if (serverBean == null) {
            _logger.log(Level.SEVERE, "webcontainer.configError");
        }
        VirtualServer vs = this.createHost(config.getHttpService(), config.getSecurityService(), vse, this.globalAccessLoggingEnabled, serverBean);
        if (enableMonitoring) {
            this.enableVirtualServerMonitoring(vs);
        }
    }

    protected void createHosts(HttpService httpService, SecurityService securityService, boolean globalAccessLoggingEnabled, Server serverBean) {
        for (com.sun.enterprise.config.serverbeans.VirtualServer vse : httpService.getVirtualServer()) {
            this.createHost(httpService, securityService, vse, globalAccessLoggingEnabled, serverBean);
        }
    }

    protected VirtualServer createHost(HttpService httpService, SecurityService securityService, com.sun.enterprise.config.serverbeans.VirtualServer vse, boolean globalAccessLoggingEnabled, Server serverBean) {
        PEAccessLogValve accessLogValve;
        boolean startAccessLog;
        Engine[] engines = this._embedded.getEngines();
        String docroot = null;
        MimeMap mm = null;
        String vs_id = vse.getId();
        Property element = ConfigBeansUtilities.getPropertyByName((Object)vse, (String)"docroot");
        docroot = element != null ? element.getValue() : vse.getDocroot();
        this.validateDocroot(docroot, vs_id, vse.getDefaultWebModule());
        VirtualServer vs = this.createVS(vs_id, vse, docroot, vse.getLogFile(), mm, httpService.getHttpProtocol());
        Property cacheProp = ConfigBeansUtilities.getPropertyByName((Object)vse, (String)"setCacheControl");
        if (cacheProp != null) {
            vs.configureCacheControl(cacheProp.getValue());
        }
        if ((startAccessLog = (accessLogValve = vs.getAccessLogValve()).configure(vs_id, vse, httpService, this.domain, this._serverContext.getDefaultHabitat(), (WebContainerFeatureFactory)this._serverContext.getDefaultHabitat().getComponent(WebContainerFeatureFactory.class), this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval)) && vs.isAccessLoggingEnabled(globalAccessLoggingEnabled)) {
            vs.addValve(accessLogValve);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Created virtual server " + vs_id);
        }
        this.configureHost(vs, httpService, securityService);
        engines[0].addChild(vs);
        return vs;
    }

    protected boolean validateDocroot(String docroot, String vs_id, String defaultWebModule) {
        if (docroot != null) {
            boolean isValid = new File(docroot).exists();
            if (!isValid && defaultWebModule == null) {
                String msg = _rb.getString("pewebcontainer.virtual_server.invalid_docroot");
                msg = MessageFormat.format(msg, vs_id, docroot);
                throw new IllegalArgumentException(msg);
            }
            if (!isValid) {
                _logger.log(Level.WARNING, "virtual-server " + vs_id + " has an invalid docroot: " + docroot);
            }
        } else if (defaultWebModule == null) {
            String msg = _rb.getString("pewebcontainer.virtual_server.missing_docroot");
            msg = MessageFormat.format(msg, vs_id);
            throw new IllegalArgumentException(msg);
        }
        return true;
    }

    protected void configureHost(VirtualServer vs, HttpService httpService, SecurityService securityService) {
        com.sun.enterprise.config.serverbeans.VirtualServer vsBean = vs.getBean();
        vs.configureAliases();
        List listeners = StringUtils.parseStringList((String)vsBean.getHttpListeners(), (String)",");
        if (listeners == null) {
            return;
        }
        HttpListener[] httpListeners = new HttpListener[listeners.size()];
        for (int i = 0; i < listeners.size(); ++i) {
            for (HttpListener httpListener : httpService.getHttpListener()) {
                if (!httpListener.getId().equals(listeners.get(i))) continue;
                httpListeners[i] = httpListener;
            }
        }
        this.configureHostPortNumbers(vs, httpListeners);
        vs.configureCatalinaProperties();
        vs.configureAuthRealm(securityService);
    }

    protected void configureHostPortNumbers(VirtualServer vs, HttpListener[] httpListeners) {
        boolean addJkListenerPort = this.jkConnector != null && !vs.getName().equalsIgnoreCase("__asadmin");
        ArrayList<Integer> portsList = new ArrayList<Integer>();
        for (int i = 0; i < httpListeners.length; ++i) {
            if (Boolean.getBoolean(httpListeners[i].getEnabled())) {
                PECoyoteConnector conn = this.connectorMap.get(httpListeners[i].getId());
                if (conn == null) continue;
                portsList.add(conn.getPort());
                continue;
            }
            if (!vs.getName().equalsIgnoreCase("__asadmin")) continue;
            String msg = _rb.getString("pewebcontainer.httpListener.mustNotDisable");
            msg = MessageFormat.format(msg, httpListeners[i].getId(), vs.getName());
            throw new IllegalArgumentException(msg);
        }
        int numPorts = portsList.size();
        if (addJkListenerPort) {
            ++numPorts;
        }
        if (numPorts > 0) {
            int[] ports = new int[numPorts];
            int i = 0;
            for (i = 0; i < portsList.size(); ++i) {
                ports[i] = (Integer)portsList.get(i);
            }
            if (addJkListenerPort) {
                ports[i] = this.jkConnector.getPort();
            }
            vs.setPorts(ports);
        }
    }

    private final void configureNotSupported(HttpService httpService) {
        if (!_logger.isLoggable(Level.FINE)) {
            return;
        }
        if (httpService.getHttpFileCache() != null && httpService.getHttpFileCache().getHashInitSize() != null) {
            _logger.log(Level.FINE, "pewebcontainer.unsupportedAttribute.hash-init-size");
        }
        for (HttpListener httpListener : httpService.getHttpListener()) {
            if (httpListener.getFamily() != null) {
                _logger.log(Level.FINE, "pewebcontainer.unsupportedAttribute.family");
            }
            if (httpListener.getExternalPort() == null) continue;
            _logger.log(Level.FINE, "pewebcontainer.unsupportedAttribute.external-port");
        }
        if (httpService.getHttpProtocol() != null) {
            if (httpService.getHttpProtocol().getVersion() != null) {
                _logger.log(Level.FINE, "pewebcontainer.unsupportedAttribute.version");
            }
            if (ConfigBeansUtilities.getPropertyByName((Object)httpService.getHttpProtocol(), (String)"ssl-enabled") != null) {
                _logger.log(Level.FINE, "pewebcontainer.unsupportedAttribute.ssl-enabled");
            }
        }
    }

    public static WebContainer createInstance(ServerContext context) {
        webContainer = new PEWebContainer(new String("0"), context);
        _logger.log(Level.FINE, "Creating new instance of PEWebContainer.");
        ((PEWebContainer)webContainer).init(context);
        _logger.log(Level.FINE, "Initialization of PEWebContainer.");
        return webContainer;
    }

    public void startInstance() throws ServerLifecycleException {
        _logger.log(Level.INFO, "pewebcontainer.start");
        this.enableVirtualServerMonitoring();
        this.enableHttpMonitoring();
    }

    public void stopInstance() throws ServerLifecycleException {
        _logger.log(Level.INFO, "pewebcontainer.stop");
        try {
            super.stop();
        }
        catch (LifecycleException le) {
            Throwable ex = le.getThrowable();
            if (ex == null) {
                ex = le;
            }
            String msg = _rb.getString("webcontainer.stopError");
            throw new ServerLifecycleException(msg, ex);
        }
    }

    public static PEWebContainer getPEWebContainer() {
        return (PEWebContainer)webContainer;
    }

    private void configureConnector(PECoyoteConnector connector, HttpListener httpListener, boolean isSecure, HttpService httpService) {
        String redirectPort;
        boolean blockingEnabled;
        this.configureConnectionPool(connector, httpService.getConnectionPool());
        WebContainerFeatureFactory wcFeatureFactory = (WebContainerFeatureFactory)this._serverContext.getDefaultHabitat().getComponent(WebContainerFeatureFactory.class);
        String sslImplementationName = this.webFeatureFactory.getSSLImplementationName();
        if (sslImplementationName != null) {
            connector.setProperty("sSLImplementation", sslImplementationName);
        }
        connector.setDomain(this._serverContext.getDefaultDomainName());
        connector.setLogger(_logger);
        this.configureSSL(connector, httpListener);
        this.configureKeepAlive(connector, httpService.getKeepAlive());
        this.configureHttpProtocol(connector, httpService.getHttpProtocol());
        this.configureRequestProcessing(httpService.getRequestProcessing(), connector);
        this.configureFileCache(connector, httpService.getHttpFileCache());
        connector.setDefaultHost(httpListener.getDefaultVirtualServer());
        connector.setXpoweredBy(Boolean.getBoolean(httpListener.getXpoweredBy()));
        connector.setWebAppRootPath(this.getModulesRoot());
        String serverName = httpListener.getServerName();
        if (serverName != null && serverName.length() > 0) {
            if (serverName.startsWith("http://")) {
                serverName = serverName.substring("http://".length());
            } else if (serverName.startsWith("https://")) {
                serverName = serverName.substring("https://".length());
            }
            int index = serverName.indexOf(58);
            if (index != -1) {
                connector.setProxyName(serverName.substring(0, index).trim());
                String serverPort = serverName.substring(index + 1).trim();
                if (serverPort.length() > 0) {
                    try {
                        connector.setProxyPort(Integer.parseInt(serverPort));
                    }
                    catch (NumberFormatException nfe) {
                        _logger.log(Level.SEVERE, "pewebcontainer.invalid_proxy_port", new Object[]{serverPort, httpListener.getId()});
                    }
                }
            } else {
                connector.setProxyName(serverName);
            }
        }
        if (blockingEnabled = Boolean.valueOf(httpListener.getBlockingEnabled()).booleanValue()) {
            connector.setBlocking(blockingEnabled);
        }
        if ((redirectPort = httpListener.getRedirectPort()) != null && !redirectPort.equals("")) {
            try {
                connector.setRedirectPort(Integer.parseInt(redirectPort));
            }
            catch (NumberFormatException nfe) {
                _logger.log(Level.WARNING, "pewebcontainer.invalid_redirect_port", new Object[]{redirectPort, httpListener.getId(), Integer.toString(connector.getRedirectPort())});
            }
        } else {
            connector.setRedirectPort(-1);
        }
        String acceptorThreads = httpListener.getAcceptorThreads();
        if (acceptorThreads != null) {
            try {
                connector.setSelectorReadThreadsCount(Integer.parseInt(acceptorThreads));
            }
            catch (NumberFormatException nfe) {
                _logger.log(Level.WARNING, "pewebcontainer.invalid_acceptor_threads", new Object[]{acceptorThreads, httpListener.getId(), Integer.toString(connector.getMaxProcessors())});
            }
        }
        if (isSecure) {
            this.configureConnectorKeysAndCerts(connector);
        }
        this.configureHttpServiceProperties(httpService, connector);
        this.configureHttpListenerProperties(httpListener, connector);
    }

    public void configureHttpListenerProperties(HttpListener httpListener, PECoyoteConnector connector) {
        for (Property httpListenerProp : httpListener.getProperty()) {
            String propValue;
            String propName = httpListenerProp.getName();
            if (this.configureHttpListenerProperty(propName, propValue = httpListenerProp.getValue(), connector)) continue;
            _logger.log(Level.WARNING, "pewebcontainer.invalid_http_listener_property", propName);
        }
    }

    protected boolean configureHttpListenerProperty(String propName, String propValue, PECoyoteConnector connector) throws NumberFormatException {
        if ("bufferSize".equals(propName)) {
            connector.setBufferSize(Integer.parseInt(propValue));
            return true;
        }
        if ("recycle-objects".equals(propName)) {
            connector.setRecycleObjects(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("reader-threads".equals(propName)) {
            connector.setMaxReadWorkerThreads(Integer.parseInt(propValue));
            return true;
        }
        if ("acceptor-queue-length".equals(propName)) {
            connector.setMinAcceptQueueLength(Integer.parseInt(propValue));
            return true;
        }
        if ("reader-queue-length".equals(propName)) {
            connector.setMinReadQueueLength(Integer.parseInt(propValue));
            return true;
        }
        if ("use-nio-direct-bytebuffer".equals(propName)) {
            connector.setUseDirectByteBuffer(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("maxKeepAliveRequests".equals(propName)) {
            connector.setMaxKeepAliveRequests(Integer.parseInt(propValue));
            return true;
        }
        if ("reader-selectors".equals(propName)) {
            connector.setSelectorReadThreadsCount(Integer.parseInt(propValue));
            return true;
        }
        if ("authPassthroughEnabled".equals(propName)) {
            connector.setAuthPassthroughEnabled(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("maxPostSize".equals(propName)) {
            connector.setMaxPostSize(Integer.parseInt(propValue));
            return true;
        }
        if ("compression".equals(propName)) {
            connector.setProperty("compression", propValue);
            return true;
        }
        if ("compressableMimeType".equals(propName)) {
            connector.setProperty("compressableMimeType", propValue);
            return true;
        }
        if ("noCompressionUserAgents".equals(propName)) {
            connector.setProperty("noCompressionUserAgents", propValue);
            return true;
        }
        if ("compressionMinSize".equals(propName)) {
            connector.setProperty("compressionMinSize", propValue);
            return true;
        }
        if ("restrictedUserAgents".equals(propName)) {
            connector.setProperty("restrictedUserAgents", propValue);
            return true;
        }
        if ("blocking".equals(propName)) {
            connector.setBlocking(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("selectorThreadImpl".equals(propName)) {
            connector.setSelectorThreadImpl(propValue);
            return true;
        }
        if ("cometSupport".equals(propName)) {
            connector.setProperty(propName, ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("rcmSupport".equals(propName)) {
            connector.setProperty(propName, ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("connectionUploadTimeout".equals(propName)) {
            connector.setConnectionUploadTimeout(Integer.parseInt(propValue));
            return true;
        }
        if ("disableUploadTimeout".equals(propName)) {
            connector.setDisableUploadTimeout(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("proxiedProtocols".equals(propName)) {
            connector.setProperty(propName, propValue);
            return true;
        }
        if ("proxyHandler".equals(propName)) {
            this.setProxyHandler(connector, propValue);
            return true;
        }
        if ("uriEncoding".equals(propName)) {
            connector.setURIEncoding(propValue);
            return true;
        }
        if ("chunkingDisabled".equals(propName) || "chunking-disabled".equals(propName)) {
            connector.setChunkingDisabled(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("crlFile".equals(propName)) {
            connector.setCrlFile(propValue);
            return true;
        }
        if ("trustAlgorithm".equals(propName)) {
            connector.setTrustAlgorithm(propValue);
            return true;
        }
        if ("trustMaxCertLength".equals(propName)) {
            connector.setTrustMaxCertLength(propValue);
            return true;
        }
        return false;
    }

    public void configureHttpServiceProperties(HttpService httpService, PECoyoteConnector connector) {
        List httpServiceProps = httpService.getProperty();
        connector.setProxyHandler(new ProxyHandlerImpl());
        if (httpServiceProps != null) {
            for (Property httpServiceProp : httpServiceProps) {
                String propValue;
                String propName = httpServiceProp.getName();
                if (this.configureHttpListenerProperty(propName, propValue = httpServiceProp.getValue(), connector)) continue;
                if ("connectionTimeout".equals(propName)) {
                    connector.setConnectionTimeout(Integer.parseInt(propValue));
                    continue;
                }
                if ("tcpNoDelay".equals(propName)) {
                    connector.setTcpNoDelay(ConfigBeansUtilities.toBoolean((String)propValue));
                    continue;
                }
                if ("traceEnabled".equals(propName)) {
                    connector.setAllowTrace(ConfigBeansUtilities.toBoolean((String)propValue));
                    continue;
                }
                if ("accessLoggingEnabled".equals(propName)) {
                    this.globalAccessLoggingEnabled = ConfigBeansUtilities.toBoolean((String)propValue);
                    continue;
                }
                if ("accessLogWriteInterval".equals(propName)) {
                    this.globalAccessLogWriteInterval = propValue;
                    continue;
                }
                if ("accessLogBufferSize".equals(propName)) {
                    this.globalAccessLogBufferSize = propValue;
                    continue;
                }
                if ("authPassthroughEnabled".equals(propName)) {
                    connector.setAuthPassthroughEnabled(ConfigBeansUtilities.toBoolean((String)propValue));
                    continue;
                }
                if ("ssl-session-timeout".equals(propName)) {
                    connector.setSSLSessionTimeout(propValue);
                    continue;
                }
                if ("ssl3-session-timeout".equals(propName)) {
                    connector.setSSL3SessionTimeout(propValue);
                    continue;
                }
                if ("ssl-cache-entries".equals(propName)) {
                    connector.setSSLSessionCacheSize(propValue);
                    continue;
                }
                if ("proxyHandler".equals(propName)) {
                    this.setProxyHandler(connector, propValue);
                    continue;
                }
                if ("sso-enabled".equals(propName)) {
                    this.globalSSOEnabled = ConfigBeansUtilities.toBoolean((String)propValue);
                    continue;
                }
                _logger.log(Level.WARNING, "pewebcontainer.invalid_http_service_property", httpServiceProp.getName());
            }
        }
    }

    private String getJSSECiphers(String ciphers) {
        String cipher = null;
        StringBuffer enabledCiphers = null;
        boolean first = true;
        int index = ciphers.indexOf(44);
        if (index != -1) {
            int fromIndex = 0;
            while (index != -1) {
                cipher = ciphers.substring(fromIndex, index).trim();
                if (cipher.length() > 0 && !cipher.startsWith("-")) {
                    String jsseCipher;
                    if (cipher.startsWith("+")) {
                        cipher = cipher.substring(1);
                    }
                    if ((jsseCipher = this.getJSSECipher(cipher)) == null) {
                        _logger.log(Level.WARNING, "pewebcontainer.unrecognized_cipher", cipher);
                    } else {
                        if (enabledCiphers == null) {
                            enabledCiphers = new StringBuffer();
                        }
                        if (!first) {
                            enabledCiphers.append(", ");
                        } else {
                            first = false;
                        }
                        enabledCiphers.append(jsseCipher);
                    }
                }
                fromIndex = index + 1;
                index = ciphers.indexOf(44, fromIndex);
            }
            cipher = ciphers.substring(fromIndex);
        } else {
            cipher = ciphers;
        }
        if (cipher != null && (cipher = cipher.trim()).length() > 0 && !cipher.startsWith("-")) {
            String jsseCipher;
            if (cipher.startsWith("+")) {
                cipher = cipher.substring(1);
            }
            if ((jsseCipher = this.getJSSECipher(cipher)) == null) {
                _logger.log(Level.WARNING, "pewebcontainer.unrecognized_cipher", cipher);
            } else {
                if (enabledCiphers == null) {
                    enabledCiphers = new StringBuffer();
                }
                if (!first) {
                    enabledCiphers.append(", ");
                } else {
                    first = false;
                }
                enabledCiphers.append(jsseCipher);
            }
        }
        return enabledCiphers == null ? null : enabledCiphers.toString();
    }

    private String getJSSECipher(String cipher) {
        String jsseCipher = null;
        CipherInfo ci = CipherInfo.getCipherInfo(cipher);
        if (ci != null) {
            jsseCipher = ci.getCipherName();
        }
        return jsseCipher;
    }

    private void enableHttpMonitoring() {
        String msg;
        ServerContext sc = this.getServerContext();
        Config config = (Config)this._serverContext.getDefaultHabitat().getComponent(Config.class);
        MonitoringRegistry mReg = (MonitoringRegistry)this._serverContext.getDefaultHabitat().getComponent(MonitoringRegistry.class);
        HttpService httpService = config.getHttpService();
        if (httpService == null) {
            _logger.log(Level.WARNING, "Unable to find HttpServiceBean in config");
            return;
        }
        try {
            mReg.registerPWCKeepAliveStats((PWCKeepAliveStats)new PWCKeepAliveStatsImpl(sc.getDefaultDomainName()), null);
        }
        catch (MonitoringRegistrationException mre) {
            msg = _logger.getResourceBundle().getString("web.monitoringRegistrationError");
            msg = MessageFormat.format(msg, "PWCKeepAliveStats");
            _logger.log(Level.WARNING, msg, mre);
        }
        try {
            mReg.registerPWCFileCacheStats((PWCFileCacheStats)new PWCFileCacheStatsImpl(sc.getDefaultDomainName()), null);
        }
        catch (MonitoringRegistrationException mre) {
            msg = _logger.getResourceBundle().getString("web.monitoringRegistrationError");
            msg = MessageFormat.format(msg, "PWCFileCacheStats");
            _logger.log(Level.WARNING, msg, mre);
        }
        try {
            mReg.registerPWCThreadPoolStats((PWCThreadPoolStats)new PWCThreadPoolStatsImpl(sc.getDefaultDomainName()), null);
        }
        catch (MonitoringRegistrationException mre) {
            msg = _logger.getResourceBundle().getString("web.monitoringRegistrationError");
            msg = MessageFormat.format(msg, "PWCThreadPoolStats");
            _logger.log(Level.WARNING, msg, mre);
        }
        try {
            mReg.registerPWCConnectionQueueStats((PWCConnectionQueueStats)new PWCConnectionQueueStatsImpl(sc.getDefaultDomainName()), null);
        }
        catch (MonitoringRegistrationException mre) {
            msg = _logger.getResourceBundle().getString("web.monitoringRegistrationError");
            msg = MessageFormat.format(msg, "PWCConnectionQueueStats");
            _logger.log(Level.WARNING, msg, mre);
        }
        for (com.sun.enterprise.config.serverbeans.VirtualServer vs : httpService.getVirtualServer()) {
            String vsId = vs.getId();
            if (vsId.equalsIgnoreCase("__asadmin")) continue;
            VirtualServer virtualServer = (VirtualServer)this.getEngines()[0].findChild(vsId);
            if (virtualServer == null) {
                _logger.log(Level.WARNING, "Invalid virtual-server: " + vsId);
                continue;
            }
            List listeners = StringUtils.parseStringList((String)vs.getHttpListeners(), (String)",");
            if (listeners == null) continue;
            ListIterator iter = listeners.listIterator();
            while (iter.hasNext()) {
                HttpListener currentListener = null;
                for (HttpListener httpListener : httpService.getHttpListener()) {
                    if (!httpListener.getId().equals(iter.next().toString())) continue;
                    currentListener = httpListener;
                }
                if (currentListener == null) continue;
                this.enableHttpListenerMonitoring(virtualServer, Integer.parseInt(currentListener.getPort()), currentListener.getId());
            }
        }
    }

    protected void enableHttpListenerMonitoring(VirtualServer virtualServer, int port, String httpListenerId) {
        PWCRequestStatsImpl pwcRequestStatsImpl = virtualServer.getPWCRequestStatsImpl();
        if (pwcRequestStatsImpl == null) {
            pwcRequestStatsImpl = new PWCRequestStatsImpl(this.getServerContext().getDefaultDomainName());
            virtualServer.setPWCRequestStatsImpl(pwcRequestStatsImpl);
        }
        MonitoringRegistry mReg = (MonitoringRegistry)this.getServerContext().getDefaultHabitat().getComponent(MonitoringRegistry.class);
        String vsId = virtualServer.getID();
        HTTPListenerStatsImpl httpStats = this.isTomcatUsingDefaultDomain() ? new HTTPListenerStatsImpl(this.getServerContext().getDefaultDomainName(), port) : new HTTPListenerStatsImpl(vsId, port);
        try {
            mReg.registerHttpListenerStats((HTTPListenerStats)httpStats, httpListenerId, vsId, null);
            pwcRequestStatsImpl.addHttpListenerStats(httpStats);
        }
        catch (MonitoringRegistrationException mre) {
            String msg = _logger.getResourceBundle().getString("web.monitoringRegistrationError");
            msg = MessageFormat.format(msg, "HTTPListenerStats");
            _logger.log(Level.WARNING, msg, mre);
        }
    }

    private void checkHostnameUniqueness(String listenerId, HttpService httpService) {
        int j;
        ArrayList<com.sun.enterprise.config.serverbeans.VirtualServer> listenerVses = null;
        block0: for (com.sun.enterprise.config.serverbeans.VirtualServer vse : httpService.getVirtualServer()) {
            List vsListeners = StringUtils.parseStringList((String)vse.getHttpListeners(), (String)",");
            for (j = 0; vsListeners != null && j < vsListeners.size(); ++j) {
                if (!listenerId.equals((String)vsListeners.get(j))) continue;
                if (listenerVses == null) {
                    listenerVses = new ArrayList<com.sun.enterprise.config.serverbeans.VirtualServer>();
                }
                listenerVses.add(vse);
                continue block0;
            }
        }
        if (listenerVses == null) {
            return;
        }
        for (int i = 0; i < listenerVses.size(); ++i) {
            com.sun.enterprise.config.serverbeans.VirtualServer vs = (com.sun.enterprise.config.serverbeans.VirtualServer)listenerVses.get(i);
            List hosts = StringUtils.parseStringList((String)vs.getHosts(), (String)",");
            for (j = 0; hosts != null && j < hosts.size(); ++j) {
                String host = (String)hosts.get(j);
                for (int k = 0; k < listenerVses.size(); ++k) {
                    if (k <= i) continue;
                    com.sun.enterprise.config.serverbeans.VirtualServer otherVs = (com.sun.enterprise.config.serverbeans.VirtualServer)listenerVses.get(k);
                    List otherHosts = StringUtils.parseStringList((String)otherVs.getHosts(), (String)",");
                    for (int l = 0; otherHosts != null && l < otherHosts.size(); ++l) {
                        if (!host.equals((String)otherHosts.get(l))) continue;
                        _logger.log(Level.SEVERE, "pewebcontainer.duplicate_host_name", new Object[]{host, vs.getId(), otherVs.getId(), listenerId});
                    }
                }
            }
        }
    }

    protected boolean isTomcatUsingDefaultDomain() {
        return true;
    }

    protected void loadAllJ2EEApplicationWebModules() {
    }

    private void enableVirtualServerMonitoring() {
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            Container[] hostArray = engines[j].findChildren();
            for (int i = 0; i < hostArray.length; ++i) {
                VirtualServer vs = (VirtualServer)hostArray[i];
                this.enableVirtualServerMonitoring(vs);
            }
        }
    }

    private void enableVirtualServerMonitoring(VirtualServer vs) {
        ServerContext sc = this.getServerContext();
        MonitoringRegistry monitoringRegistry = (MonitoringRegistry)sc.getDefaultHabitat().getComponent(MonitoringRegistry.class);
        PWCVirtualServerStatsImpl vsStats = new PWCVirtualServerStatsImpl(vs);
        try {
            monitoringRegistry.registerPWCVirtualServerStats((PWCVirtualServerStats)vsStats, vs.getID(), null);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Unable to register PWCVirtualServerStats for " + vs.getID(), e);
        }
        PWCRequestStatsImpl pwcRequestStatsImpl = new PWCRequestStatsImpl(sc.getDefaultDomainName());
        vs.setPWCRequestStatsImpl(pwcRequestStatsImpl);
        try {
            monitoringRegistry.registerPWCRequestStats((PWCRequestStats)pwcRequestStatsImpl, vs.getID(), null);
        }
        catch (MonitoringRegistrationException mre) {
            String msg = _logger.getResourceBundle().getString("web.monitoringRegistrationError");
            msg = MessageFormat.format(msg, "PWCRequestStats");
            _logger.log(Level.WARNING, msg, mre);
        }
    }

    private void configureSSL(PECoyoteConnector connector, HttpListener httpListener) {
        String ciphers;
        Ssl sslConfig = httpListener.getSsl();
        if (sslConfig == null) {
            return;
        }
        if (Boolean.getBoolean(sslConfig.getClientAuthEnabled())) {
            connector.setClientAuth(true);
        }
        StringBuffer sslProtocolsBuf = new StringBuffer();
        boolean needComma = false;
        if (Boolean.getBoolean(sslConfig.getSsl2Enabled())) {
            sslProtocolsBuf.append("SSLv2");
            needComma = true;
        }
        if (Boolean.getBoolean(sslConfig.getSsl3Enabled())) {
            if (needComma) {
                sslProtocolsBuf.append(", ");
            } else {
                needComma = true;
            }
            sslProtocolsBuf.append("SSLv3");
        }
        if (Boolean.getBoolean(sslConfig.getTlsEnabled())) {
            if (needComma) {
                sslProtocolsBuf.append(", ");
            }
            sslProtocolsBuf.append("TLSv1");
        }
        if (Boolean.getBoolean(sslConfig.getSsl3Enabled()) || Boolean.getBoolean(sslConfig.getTlsEnabled())) {
            sslProtocolsBuf.append(", SSLv2Hello");
        }
        if (sslProtocolsBuf.length() == 0) {
            _logger.log(Level.WARNING, "pewebcontainer.all_ssl_protocols_disabled", httpListener.getId());
        } else {
            connector.setSslProtocols(sslProtocolsBuf.toString());
        }
        String certNickname = sslConfig.getCertNickname();
        if (certNickname != null && certNickname.length() > 0) {
            connector.setKeyAlias(sslConfig.getCertNickname());
        }
        if ((ciphers = sslConfig.getSsl3TlsCiphers()) != null) {
            String jsseCiphers = this.getJSSECiphers(ciphers);
            if (jsseCiphers == null) {
                _logger.log(Level.WARNING, "pewebcontainer.all_ciphers_disabled", httpListener.getId());
            } else {
                connector.setCiphers(jsseCiphers);
            }
        }
    }

    private void configureKeepAlive(PECoyoteConnector connector, KeepAlive keepAlive) {
        int timeoutInSeconds = 60;
        int maxConnections = 256;
        int threadCount = 1;
        if (keepAlive != null) {
            String msg;
            try {
                timeoutInSeconds = Integer.parseInt(keepAlive.getTimeoutInSeconds());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveTimeout");
                msg = MessageFormat.format(msg, keepAlive.getTimeoutInSeconds(), Integer.toString(timeoutInSeconds));
                _logger.log(Level.WARNING, msg, ex);
            }
            try {
                maxConnections = Integer.parseInt(keepAlive.getMaxConnections());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveMaxConnections");
                msg = MessageFormat.format(msg, keepAlive.getMaxConnections(), Integer.toString(maxConnections));
                _logger.log(Level.WARNING, msg, ex);
            }
            try {
                threadCount = Integer.parseInt(keepAlive.getThreadCount());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveThreadCount");
                msg = MessageFormat.format(msg, keepAlive.getThreadCount(), Integer.toString(threadCount));
                _logger.log(Level.WARNING, msg, ex);
            }
        }
        connector.setKeepAliveTimeoutInSeconds(timeoutInSeconds);
        connector.setMaxKeepAliveRequests(maxConnections);
        connector.setKeepAliveThreadCount(threadCount);
    }

    private void configureConnectionPool(PECoyoteConnector connector, ConnectionPool cp) {
        String msg;
        if (cp == null) {
            return;
        }
        try {
            int queueSizeInBytes = Integer.parseInt(cp.getQueueSizeInBytes());
            if (queueSizeInBytes <= -1) {
                _logger.log(Level.WARNING, "pewebcontainer.invalidQueueSizeInBytes", new Object[]{cp.getQueueSizeInBytes(), Integer.toString(connector.getQueueSizeInBytes())});
            } else {
                connector.setQueueSizeInBytes(queueSizeInBytes);
            }
        }
        catch (NumberFormatException ex) {
            msg = _rb.getString("pewebcontainer.invalidQueueSizeInBytes");
            msg = MessageFormat.format(msg, ConfigBeansUtilities.getDefaultQueueSizeInBytes(), Integer.toString(connector.getQueueSizeInBytes()));
            _logger.log(Level.WARNING, msg, ex);
        }
        try {
            int ssBackLog = Integer.parseInt(cp.getMaxPendingCount());
            if (ssBackLog <= 0) {
                _logger.log(Level.WARNING, "pewebcontainer.invalidMaxPendingCount", new Object[]{cp.getMaxPendingCount(), Integer.toString(connector.getSocketServerBacklog())});
            } else {
                connector.setSocketServerBacklog(ssBackLog);
            }
        }
        catch (NumberFormatException ex) {
            msg = _rb.getString("pewebcontainer.invalidMaxPendingCount");
            msg = MessageFormat.format(msg, cp.getMaxPendingCount(), Integer.toString(connector.getSocketServerBacklog()));
            _logger.log(Level.WARNING, msg, ex);
        }
        try {
            int bufferSize = Integer.parseInt(cp.getReceiveBufferSizeInBytes());
            if (bufferSize <= 0) {
                _logger.log(Level.WARNING, "pewebcontainer.invalidBufferSize", new Object[]{cp.getReceiveBufferSizeInBytes(), Integer.toString(connector.getBufferSize())});
            } else {
                connector.setBufferSize(bufferSize);
            }
        }
        catch (NumberFormatException ex) {
            msg = _rb.getString("pewebcontainer.invalidBufferSize");
            msg = MessageFormat.format(msg, cp.getReceiveBufferSizeInBytes(), Integer.toString(connector.getBufferSize()));
            _logger.log(Level.WARNING, msg, ex);
        }
        try {
            int maxHttpHeaderSize = Integer.parseInt(cp.getSendBufferSizeInBytes());
            if (maxHttpHeaderSize <= 0) {
                _logger.log(Level.WARNING, "pewebcontainer.invalidMaxHttpHeaderSize", new Object[]{cp.getSendBufferSizeInBytes(), Integer.toString(connector.getMaxHttpHeaderSize())});
            } else {
                connector.setMaxHttpHeaderSize(maxHttpHeaderSize);
            }
        }
        catch (NumberFormatException ex) {
            msg = _rb.getString("pewebcontainer.invalidMaxHttpHeaderSize");
            msg = MessageFormat.format(msg, cp.getSendBufferSizeInBytes(), Integer.toString(connector.getMaxHttpHeaderSize()));
            _logger.log(Level.WARNING, msg, ex);
        }
    }

    public void deleteHost(HttpService httpService) throws LifecycleException {
        int i;
        Engine[] engines = this._embedded.getEngines();
        Container[] virtualServers = engines[0].findChildren();
        block2: for (i = 0; i < virtualServers.length; ++i) {
            for (com.sun.enterprise.config.serverbeans.VirtualServer vse : httpService.getVirtualServer()) {
                if (!virtualServers[i].getName().equals(vse.getId())) continue;
                virtualServers[i] = null;
                continue block2;
            }
        }
        for (i = 0; i < virtualServers.length; ++i) {
            VirtualServer virtualServer = (VirtualServer)virtualServers[i];
            if (virtualServer == null) continue;
            if (virtualServer.getID().equals("__asadmin")) {
                throw new LifecycleException("Cannot delete admin virtual-server.");
            }
            Container[] webModules = virtualServer.findChildren();
            for (int j = 0; j < webModules.length; ++j) {
                this.unloadWebModule(webModules[j].getName(), webModules[j].getName(), virtualServer.getID(), null);
            }
            try {
                virtualServer.destroy();
                continue;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Error during destruction of virtual server " + virtualServer.getID(), e);
            }
        }
    }

    public void updateHost(com.sun.enterprise.config.serverbeans.VirtualServer vsBean, HttpService httpService, Server serverBean) throws LifecycleException {
        String newDefaultContextPath;
        PECoyoteConnector conn;
        int k;
        int i;
        Engine[] engines = this._embedded.getEngines();
        VirtualServer virtualServer = (VirtualServer)engines[0].findChild(vsBean.getId());
        String oldDefaultWebModule = virtualServer.getDefaultWebModuleID();
        virtualServer.setBean(vsBean);
        this._embedded.setLogFile(virtualServer, vsBean.getLogFile());
        virtualServer.configureVirtualServerState();
        virtualServer.clearAliases();
        virtualServer.configureAliases();
        String docroot = vsBean.getDocroot();
        if (docroot != null) {
            this.updateDocroot(docroot, virtualServer, vsBean);
        }
        int[] oldPorts = virtualServer.getPorts();
        List listeners = StringUtils.parseStringList((String)vsBean.getHttpListeners(), (String)",");
        if (listeners != null) {
            HttpListener[] httpListeners = new HttpListener[listeners.size()];
            for (i = 0; i < listeners.size(); ++i) {
                for (HttpListener httpListener : httpService.getHttpListener()) {
                    if (!httpListener.getId().equals(listeners.get(i))) continue;
                    httpListeners[i] = httpListener;
                }
            }
            this.configureHostPortNumbers(virtualServer, httpListeners);
        } else {
            virtualServer.setPorts(new int[0]);
        }
        int[] newPorts = virtualServer.getPorts();
        for (i = 0; i < oldPorts.length; ++i) {
            boolean found = false;
            for (int j = 0; j < newPorts.length; ++j) {
                if (oldPorts[i] != newPorts[j]) continue;
                found = true;
            }
            if (found) continue;
            Connector[] connectors = this._embedded.findConnectors();
            for (k = 0; k < connectors.length; ++k) {
                conn = (PECoyoteConnector)connectors[k];
                if (oldPorts[i] != conn.getPort()) continue;
                try {
                    conn.getMapperListener().unregisterHost(virtualServer.getJmxName());
                    continue;
                }
                catch (Exception e) {
                    throw new LifecycleException((Throwable)e);
                }
            }
        }
        for (i = 0; i < newPorts.length; ++i) {
            boolean found = false;
            for (int j = 0; j < oldPorts.length; ++j) {
                if (newPorts[i] != oldPorts[j]) continue;
                found = true;
            }
            if (found) continue;
            Connector[] connectors = this._embedded.findConnectors();
            for (k = 0; k < connectors.length; ++k) {
                conn = (PECoyoteConnector)connectors[k];
                if (newPorts[i] != conn.getPort()) continue;
                if (!conn.isAvailable()) {
                    conn.start();
                    this.enableHttpListenerMonitoring(virtualServer, conn.getPort(), conn.getName());
                }
                try {
                    conn.getMapperListener().registerHost(virtualServer.getJmxName());
                    continue;
                }
                catch (Exception e) {
                    throw new LifecycleException((Throwable)e);
                }
            }
        }
        if (oldDefaultWebModule != null) {
            this.updateDefaultWebModule(virtualServer, oldPorts, null);
        }
        if ((newDefaultContextPath = virtualServer.getDefaultContextPath(serverBean)) != null) {
            this.removeDummyModule(virtualServer);
            this.updateDefaultWebModule(virtualServer, virtualServer.getPorts(), newDefaultContextPath);
        } else {
            WebModuleConfig wmc = virtualServer.createSystemDefaultWebModuleIfNecessary();
            if (wmc != null) {
                this.loadStandaloneWebModule(virtualServer, wmc);
            }
        }
    }

    public void updateHostProperties(com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String name, String value, HttpService httpService, SecurityService securityService) {
        Engine[] engines = this._embedded.getEngines();
        VirtualServer vs = (VirtualServer)engines[0].findChild(vsBean.getId());
        vs.setBean(vsBean);
        if (name == null) {
            return;
        }
        if ("docroot".equals(name)) {
            this.updateDocroot(value, vs, vsBean);
        } else if (name.startsWith("alternatedocroot_")) {
            this.updateAlternateDocroot(vs, vsBean);
        } else if ("setCacheControl".equals(name)) {
            vs.configureCacheControl(value);
        } else if ("accesslog".equals(name)) {
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this._serverContext.getDefaultHabitat(), this.domain, this.globalAccessLoggingEnabled);
        } else if ("accessLogWriteInterval".equals(name)) {
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this._serverContext.getDefaultHabitat(), this.domain, this.globalAccessLoggingEnabled);
        } else if ("accessLogBufferSize".equals(name)) {
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this._serverContext.getDefaultHabitat(), this.domain, this.globalAccessLoggingEnabled);
        } else if ("allowRemoteHost".equals(name) || "denyRemoteHost".equals(name)) {
            vs.configureRemoteHostFilterValve(httpService.getHttpProtocol());
        } else if ("allowRemoteAddress".equals(name) || "denyRemoteAddress".equals(name)) {
            vs.configureRemoteAddressFilterValve();
        } else if ("sso-enabled".equals(name)) {
            vs.configureSSOValve(this.globalSSOEnabled, this.webFeatureFactory);
        } else if ("authRealm".equals(name)) {
            vs.configureAuthRealm(securityService);
        } else if (name.startsWith("send-error")) {
            vs.configureErrorPage();
        } else if (name.startsWith("redirect")) {
            vs.configureRedirect();
        } else if (name.startsWith("contextXmlDefault")) {
            vs.setDefaultContextXmlLocation(value);
        }
    }

    public void updateHttpService(HttpService httpService) throws LifecycleException {
        List httpListeners;
        List virtualServers;
        if (httpService == null) {
            return;
        }
        Property ssoEnabled = null;
        Property accessLoggingEnabled = null;
        Property accessLogWriteInterval = null;
        Property accessLogBufferSize = null;
        List props = httpService.getProperty();
        if (props != null) {
            for (Property prop : props) {
                if ("sso-enabled".equals(prop.getName())) {
                    ssoEnabled = prop;
                    this.globalSSOEnabled = ConfigBeansUtilities.toBoolean((String)prop.getValue());
                    continue;
                }
                if ("accessLoggingEnabled".equals(prop.getName())) {
                    accessLoggingEnabled = prop;
                    this.globalAccessLoggingEnabled = ConfigBeansUtilities.toBoolean((String)prop.getValue());
                    continue;
                }
                if ("accessLogWriteInterval".equals(prop.getName())) {
                    accessLogWriteInterval = prop;
                    this.globalAccessLogWriteInterval = prop.getValue();
                    continue;
                }
                if (!"accessLogBufferSize".equals(prop.getName())) continue;
                accessLogBufferSize = prop;
                this.globalAccessLogBufferSize = prop.getValue();
            }
        }
        if ((virtualServers = httpService.getVirtualServer()) != null && (ssoEnabled != null || accessLoggingEnabled != null || accessLogWriteInterval != null || accessLogBufferSize != null)) {
            for (com.sun.enterprise.config.serverbeans.VirtualServer virtualServer : virtualServers) {
                if (ssoEnabled != null) {
                    this.updateHostProperties(virtualServer, ssoEnabled.getName(), ssoEnabled.getValue(), httpService, null);
                }
                if (accessLoggingEnabled != null) {
                    this.updateHostProperties(virtualServer, accessLoggingEnabled.getName(), accessLoggingEnabled.getValue(), httpService, null);
                }
                if (accessLogWriteInterval != null) {
                    this.updateHostProperties(virtualServer, accessLogWriteInterval.getName(), accessLogWriteInterval.getValue(), httpService, null);
                }
                if (accessLogBufferSize == null) continue;
                this.updateHostProperties(virtualServer, accessLogBufferSize.getName(), accessLogBufferSize.getValue(), httpService, null);
            }
        }
        if ((httpListeners = httpService.getHttpListener()) != null) {
            for (HttpListener httpListener : httpListeners) {
                this.updateConnector(httpListener, httpService);
            }
        }
    }

    public void updateConnectorProperty(HttpListener httpListener, String propName, String propValue) throws LifecycleException {
        PECoyoteConnector connector = this.connectorMap.get(httpListener.getId());
        if (connector != null) {
            this.configureHttpListenerProperty(propName, propValue, connector);
        }
    }

    public void updateConnector(HttpListener httpListener, HttpService httpService) throws LifecycleException {
        if (httpListener.getDefaultVirtualServer().equals("__asadmin")) {
            return;
        }
        PECoyoteConnector connector = this.connectorMap.get(httpListener.getId());
        if (connector != null) {
            this._embedded.removeConnector(connector);
            this.connectorMap.remove(httpListener.getId());
        }
        if (!Boolean.getBoolean(httpListener.getEnabled())) {
            return;
        }
        connector = this.createConnector(httpListener, httpService);
        if (connector == null) {
            return;
        }
        String virtualServerName = httpListener.getDefaultVirtualServer();
        VirtualServer virtualServer = (VirtualServer)this._embedded.getEngines()[0].findChild(virtualServerName);
        boolean found = false;
        int[] ports = virtualServer.getPorts();
        for (int i = 0; i < ports.length; ++i) {
            if (ports[i] != connector.getPort()) continue;
            found = true;
            break;
        }
        if (!found) {
            int[] newPorts = new int[ports.length + 1];
            System.arraycopy(ports, 0, newPorts, 0, ports.length);
            newPorts[ports.length] = connector.getPort();
            virtualServer.setPorts(newPorts);
        }
        connector.start();
    }

    public void deleteConnector(HttpService httpService) throws LifecycleException {
        int i;
        Connector[] connectors = (Connector[])this._embedded.findConnectors().clone();
        block0: for (i = 0; i < connectors.length; ++i) {
            for (HttpListener httpListener : httpService.getHttpListener()) {
                if (((PECoyoteConnector)connectors[i]).getPort() != Integer.parseInt(httpListener.getPort())) continue;
                connectors[i] = null;
                continue block0;
            }
        }
        for (i = 0; i < connectors.length; ++i) {
            if (connectors[i] == null) continue;
            this._embedded.removeConnector((PECoyoteConnector)connectors[i]);
        }
    }

    public void updateAccessLog(HttpService httpService) {
        Container[] virtualServers = this._embedded.getEngines()[0].findChildren();
        for (int i = 0; i < virtualServers.length; ++i) {
            ((VirtualServer)virtualServers[i]).reconfigureAccessLog(httpService, (WebContainerFeatureFactory)this._serverContext.getDefaultHabitat().getComponent(WebContainerFeatureFactory.class));
        }
    }

    private void updateDocroot(String docroot, VirtualServer vs, com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        boolean isValid = this.validateDocroot(docroot, vsBean.getId(), vsBean.getDefaultWebModule());
        if (isValid) {
            vs.setAppBase(docroot);
            this.removeDummyModule(vs);
            WebModuleConfig wmInfo = vs.createSystemDefaultWebModuleIfNecessary();
            if (wmInfo != null) {
                this.loadStandaloneWebModule(vs, wmInfo);
            }
        }
    }

    private void updateAlternateDocroot(VirtualServer vs, com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        this.removeDummyModule(vs);
        WebModuleConfig wmInfo = vs.createSystemDefaultWebModuleIfNecessary();
        if (wmInfo != null) {
            this.loadStandaloneWebModule(vs, wmInfo);
        }
    }

    private void configureHttpProtocol(PECoyoteConnector connector, HttpProtocol httpProtocol) {
        if (httpProtocol == null) {
            return;
        }
    }

    private void configureFileCache(PECoyoteConnector connector, HttpFileCache httpFileCache) {
        if (httpFileCache == null) {
            return;
        }
        connector.setLargeFileCacheEnabled(ConfigBeansUtilities.toBoolean((String)httpFileCache.getFileCachingEnabled()));
        if (httpFileCache.getMaxAgeInSeconds() != null) {
            connector.setSecondsMaxAge(Integer.parseInt(httpFileCache.getMaxAgeInSeconds()));
        }
        if (httpFileCache.getMaxFilesCount() != null) {
            connector.setMaxCacheEntries(Integer.parseInt(httpFileCache.getMaxFilesCount()));
        }
        if (httpFileCache.getSmallFileSizeLimitInBytes() != null) {
            connector.setMinEntrySize(Integer.parseInt(httpFileCache.getSmallFileSizeLimitInBytes()));
        }
        if (httpFileCache.getMediumFileSizeLimitInBytes() != null) {
            connector.setMaxEntrySize(Integer.parseInt(httpFileCache.getMediumFileSizeLimitInBytes()));
        }
        if (httpFileCache.getMediumFileSpaceInBytes() != null) {
            connector.setMaxLargeCacheSize(Integer.parseInt(httpFileCache.getMediumFileSpaceInBytes()));
        }
        if (httpFileCache.getSmallFileSpaceInBytes() != null) {
            connector.setMaxSmallCacheSize(Integer.parseInt(httpFileCache.getSmallFileSpaceInBytes()));
        }
    }

    protected void configureRequestProcessing(HttpService httpService) {
        RequestProcessing rp = httpService.getRequestProcessing();
        Connector[] connectors = this._embedded.findConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            this.configureRequestProcessing(rp, (PECoyoteConnector)connectors[i]);
        }
    }

    protected void configureRequestProcessing(RequestProcessing rp, PECoyoteConnector connector) {
        if (rp == null) {
            return;
        }
        try {
            connector.setMaxProcessors(Integer.parseInt(rp.getThreadCount()));
            connector.setMinProcessors(Integer.parseInt(rp.getInitialThreadCount()));
            connector.setProcessorWorkerThreadsTimeout(Integer.parseInt(rp.getRequestTimeoutInSeconds()));
            connector.setProcessorWorkerThreadsIncrement(Integer.parseInt(rp.getThreadIncrement()));
            connector.setMaxHttpHeaderSize(Integer.parseInt(rp.getHeaderBufferLengthInBytes()));
        }
        catch (NumberFormatException ex) {
            _logger.log(Level.WARNING, " Invalid request-processing attribute", ex);
        }
    }

    private void setProxyHandler(PECoyoteConnector connector, String className) {
        Object handler = null;
        try {
            Class<?> handlerClass = Class.forName(className);
            handler = handlerClass.newInstance();
        }
        catch (Exception e) {
            String msg = _rb.getString("pewebcontainer.proxyHandlerClassLoadError");
            msg = MessageFormat.format(msg, className);
            _logger.log(Level.SEVERE, msg, e);
        }
        if (handler != null) {
            if (!(handler instanceof ProxyHandler)) {
                _logger.log(Level.SEVERE, "pewebcontainer.proxyHandlerClassInvalid", className);
            } else {
                connector.setProxyHandler(handler);
            }
        }
    }

    private void configureConnectorKeysAndCerts(PECoyoteConnector connector) {
        String prop = System.getProperty("javax.net.ssl.keyStore");
        if (prop != null) {
            connector.setKeystoreFile(prop);
            connector.setKeystoreType("JKS");
        }
        if ((prop = System.getProperty("javax.net.ssl.trustStore")) != null) {
            connector.setTruststore(prop);
            connector.setTruststoreType("JKS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureJKProperties(PECoyoteConnector connector) {
        File propertiesFile;
        String propertiesURL = System.getProperty("com.sun.enterprise.web.connector.enableJK.propertyFile");
        if (propertiesURL == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("com.sun.enterprise.web.connector.enableJK.propertyFile not defined");
            }
            return;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Loading glassfish-jk.properties from " + propertiesURL);
        }
        if (!(propertiesFile = new File(propertiesURL)).exists()) {
            String msg = _rb.getString("pewebcontainer.missingJKProperties");
            msg = MessageFormat.format(msg, propertiesURL);
            _logger.log(Level.WARNING, msg);
            return;
        }
        Properties properties = null;
        InputStream is = null;
        try {
            FileInputStream fis = new FileInputStream(propertiesFile);
            is = new BufferedInputStream(fis);
            properties = new Properties();
            properties.load(is);
        }
        catch (Exception ex) {
            String msg = _rb.getString("pewebcontainer.configureJK");
            msg = MessageFormat.format(msg, connector.getPort());
            _logger.log(Level.SEVERE, msg, ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = properties.getProperty(name);
            if (value == null) continue;
            IntrospectionUtils.setProperty(connector, name, value);
        }
    }
}

