/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.ProxyHandler;
import com.sun.appserv.server.util.ASClassLoaderUtil;
import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.PWCRequestStats;
import com.sun.enterprise.admin.monitor.stats.PWCVirtualServerStats;
import com.sun.enterprise.admin.monitor.stats.ServletStats;
import com.sun.enterprise.admin.monitor.stats.WebModuleStats;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.ConnectionPool;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpFileCache;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpProtocol;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.J2EeApplication;
import com.sun.enterprise.config.serverbeans.KeepAlive;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.RequestProcessing;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.runtime.web.ManagerProperties;
import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.deployment.runtime.web.StoreProperties;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.deployment.util.WebBundleVisitor;
import com.sun.enterprise.deployment.util.WebValidatorWithoutCL;
import com.sun.enterprise.security.CipherInfo;
import com.sun.enterprise.security.integration.RealmAdapterProxy;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.common.Result;
import com.sun.enterprise.v3.server.V3Environment;
import com.sun.enterprise.web.AdHocServletInfo;
import com.sun.enterprise.web.AdHocWebModule;
import com.sun.enterprise.web.DebugMonitor;
import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.HealthChecker;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.PEAccessLogValve;
import com.sun.enterprise.web.PEWebContainerFeatureFactoryImpl;
import com.sun.enterprise.web.ProxyHandlerImpl;
import com.sun.enterprise.web.SchemaUpdater;
import com.sun.enterprise.web.V3WebappLoader;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebConnector;
import com.sun.enterprise.web.WebContainerStartStopOperation;
import com.sun.enterprise.web.WebContainerTimer;
import com.sun.enterprise.web.WebDebugMonitor;
import com.sun.enterprise.web.WebDeployer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.connector.coyote.PECoyoteConnector;
import com.sun.enterprise.web.logger.IASLogger;
import com.sun.enterprise.web.monitor.impl.PwcServletStatsImpl;
import com.sun.enterprise.web.monitor.impl.PwcWebModuleStatsImpl;
import com.sun.enterprise.web.pluggable.WebContainerFeatureFactory;
import com.sun.enterprise.web.stats.PWCRequestStatsImpl;
import com.sun.enterprise.web.stats.PWCVirtualServerStatsImpl;
import com.sun.enterprise.web.stats.ServletStatsImpl;
import com.sun.enterprise.web.stats.WebModuleStatsImpl;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.spi.NamingManager;
import javax.servlet.jsp.JspFactory;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.startup.DigesterFactory;
import org.apache.catalina.startup.TldConfig;
import org.apache.catalina.util.ServerInfo;
import org.apache.coyote.tomcat5.CoyoteAdapter;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.Deployer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="com.sun.enterprise.web.WebContainer")
public class WebContainer
implements Container,
PostConstruct,
PreDestroy {
    @Inject
    Domain domain;
    @Inject
    ServerContext _serverContext;
    @Inject
    ComponentEnvManager componentEnvManager;
    @Inject(optional=true)
    Realm realm;
    HashMap<String, Integer> portMap = new HashMap();
    HashMap<Integer, Adapter> adapterMap = new HashMap();
    EmbeddedWebContainer _embedded;
    Engine engine;
    String instanceName;
    String defaultWebXml;
    private WebConnector jkConnector;
    private String _id = null;
    protected boolean globalAccessLoggingEnabled = true;
    protected String globalAccessLogBufferSize = null;
    protected String globalAccessLogWriteInterval = null;
    protected int defaultRedirectPort = -1;
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static final String DEFAULT_TRUSTSTORE_TYPE = "JKS";
    protected static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    public static final String DISPATCHER_MAX_DEPTH = "dispatcher-max-depth";
    static final int DEFAULT_REAP_INTERVAL = 60;
    public static final String JWS_APPCLIENT_EAR_NAME = "__JWSappclients";
    public static final String JWS_APPCLIENT_WAR_NAME = "sys";
    private static final String JWS_APPCLIENT_MODULE_NAME = "__JWSappclients:sys.war";
    private static final String DOC_BUILDER_FACTORY_PROPERTY = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String DOC_BUILDER_FACTORY_IMPL = "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl";
    protected V3Environment instance = null;
    private Server _serverBean = null;
    protected static final ResourceBundle _rb = _logger.getResourceBundle();
    protected static MonitoringLevel monitoringLevel;
    protected Level _logLevel = null;
    protected int _debug = 0;
    private String _modulesWorkRoot = null;
    private String modulesStubRoot = null;
    protected String _modulesRoot = null;
    private String _appsWorkRoot = null;
    private String appsStubRoot = null;
    private boolean _reloadingEnabled = false;
    private int _pollInterval = 2;
    protected boolean _started = false;
    protected boolean globalSSOEnabled = true;
    protected WebContainerFeatureFactory webFeatureFactory;
    private static final String DOL_DEPLOYMENT = "com.sun.enterprise.web.deployment.backend";
    protected static boolean useDOLforDeployment;
    private String instanceClassPath;
    boolean instanceEnableCookies = true;
    protected static WebContainer webContainer;
    private static boolean debugMonitoring;
    private static long debugMonitoringPeriodMS;
    private static WebContainerTimer _timer;
    protected boolean catalinaCachingAllowed = true;
    private HealthChecker _healthChecker = null;

    public void postConstruct() {
        WebContainer.setJspFactory();
        this.instance = (V3Environment)this._serverContext.getDefaultHabitat().getComponent(V3Environment.class);
        this._modulesWorkRoot = this.instance.getWebModuleCompileJspPath();
        this._appsWorkRoot = this.instance.getApplicationCompileJspPath();
        this._modulesRoot = this.instance.getApplicationRepositoryPath();
        this.instanceClassPath = this.getInstanceClassPath(this.instance);
        this.setTldScan();
        this.modulesStubRoot = this.instance.getModuleStubPath();
        this.appsStubRoot = this.instance.getApplicationStubPath();
        this.defaultWebXml = System.getProperty("AS_DEF_DOMAINS_PATH");
        if (this.defaultWebXml != null) {
            this.defaultWebXml = this.defaultWebXml + File.separator + "domain1" + File.separator + "config" + File.separator + "default-web.xml";
            _logger.info("Using default-web.xml " + this.defaultWebXml);
        }
        String root = System.getProperty("com.sun.aas.installRoot");
        File libRoot = new File(root, "lib");
        File schemas = new File(libRoot, "schemas");
        File dtds = new File(libRoot, "dtds");
        try {
            DigesterFactory.setSchemaResourcePrefix(schemas.toURL().toString());
            DigesterFactory.setDtdResourcePrefix(dtds.toURL().toString());
            ParserUtils.setSchemaResourcePrefix(schemas.toURL().toString());
            ParserUtils.setDtdResourcePrefix(dtds.toURL().toString());
        }
        catch (MalformedURLException e) {
            _logger.log(Level.SEVERE, "Exception setting the schemas/dtds location", e);
        }
        this.instanceName = this._serverContext.getInstanceName();
        LogService logService = null;
        Config cfg = (Config)this._serverContext.getDefaultHabitat().getComponent(Config.class);
        this.getDynamicReloadingSettings(cfg.getAdminService().getDasConfig());
        logService = cfg.getLogService();
        this.initLogLevel(logService);
        this.initMonitoringLevel(cfg.getMonitoringService());
        Property maxDepth = ConfigBeansUtilities.getPropertyByName((Object)cfg.getWebContainer(), (String)DISPATCHER_MAX_DEPTH);
        if (maxDepth != null && maxDepth.getValue() != null) {
            int depth = -1;
            try {
                depth = Integer.parseInt(maxDepth.getValue());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (depth > 0) {
                CoyoteRequest.setMaxDispatchDepth(depth);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Maximum depth for nested request dispatches set to " + maxDepth.getValue());
                }
            }
        }
        String logServiceFile = null;
        if (logService != null) {
            logServiceFile = logService.getFile();
        }
        this._embedded = new EmbeddedWebContainer(_logger, this._serverContext, this, logServiceFile);
        this._embedded.setUseNaming(false);
        if (this._debug > 1) {
            this._embedded.setDebug(this._debug);
        }
        this._embedded.setLogger(new IASLogger(_logger));
        this.engine = this._embedded.createEngine();
        this.engine.setParentClassLoader(EmbeddedWebContainer.class.getClassLoader());
        this._embedded.addEngine(this.engine);
        ((StandardEngine)this.engine).setDomain("com.sun.appserv");
        String serverInfo = System.getProperty("product.name");
        if (serverInfo != null) {
            ServerInfo.setServerInfo(serverInfo);
        } else {
            ServerInfo.setServerInfo(Version.getVersion());
            System.setProperty("product.name", Version.getVersion());
        }
        WebDebugMonitor debugMonitor = new WebDebugMonitor();
        HashMap monitorMap = debugMonitor.getDebugMonitoringDetails();
        debugMonitoring = (Boolean)monitorMap.get("debugMonitoring");
        debugMonitoringPeriodMS = (Long)monitorMap.get("debugMonitoringPeriodMS");
        if (debugMonitoring) {
            _timer.schedule((TimerTask)new DebugMonitor(this._embedded), 0L, debugMonitoringPeriodMS);
        }
        if (System.getProperty(DOC_BUILDER_FACTORY_PROPERTY) == null) {
            System.setProperty(DOC_BUILDER_FACTORY_PROPERTY, DOC_BUILDER_FACTORY_IMPL);
        }
        this.initInstanceSessionProperties();
        long btime = 0L;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("before schema check");
            btime = System.currentTimeMillis();
        }
        this.doSchemaCheck();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("after schema check time: " + (System.currentTimeMillis() - btime));
        }
        List configs = this.domain.getConfigs().getConfig();
        for (Config aConfig : configs) {
            HttpService httpService = aConfig.getHttpService();
            List httpListeners = httpService.getHttpListener();
            for (HttpListener httpListener : httpListeners) {
                if ("admin-listener".equals(httpListener.getId())) continue;
                this.createHttpListener(httpListener, httpService);
            }
            this.createJKConnector(httpService);
            this.setDefaultRedirectPort(this.defaultRedirectPort);
            List virtualServers = httpService.getVirtualServer();
            for (com.sun.enterprise.config.serverbeans.VirtualServer vs : virtualServers) {
                this.createVirtualServer(vs, httpService, aConfig.getSecurityService());
                _logger.info("Created virtual server " + vs.getId());
            }
        }
        this._started = true;
        try {
            this._embedded.start();
        }
        catch (LifecycleException le) {
            _logger.log(Level.SEVERE, "Unable to start web container", le);
            return;
        }
    }

    public void preDestroy() {
        try {
            this._embedded.stop();
        }
        catch (LifecycleException le) {
            _logger.log(Level.SEVERE, "Unable to stop web container", le);
            return;
        }
        _timer.cancel();
    }

    public String getName() {
        return "Web";
    }

    public Class<? extends Deployer> getDeployer() {
        return WebDeployer.class;
    }

    private void createHttpListener(HttpListener httpListener, HttpService httpService) {
        String address;
        if (!Boolean.getBoolean(httpListener.getEnabled())) {
            _logger.warning(httpListener.getId() + " HTTP listener is disabled " + Boolean.getBoolean(httpListener.getEnabled()));
        }
        int port = 8080;
        this.checkHostnameUniqueness(httpListener.getId(), httpService);
        try {
            port = Integer.parseInt(httpListener.getPort());
        }
        catch (NumberFormatException nfe) {
            String msg = _rb.getString("pewebcontainer.http_listener.invalid_port");
            msg = MessageFormat.format(msg, httpListener.getPort(), httpListener.getId());
            throw new IllegalArgumentException(msg);
        }
        boolean isSecure = Boolean.getBoolean(httpListener.getSecurityEnabled());
        if (isSecure && this.defaultRedirectPort == -1) {
            this.defaultRedirectPort = port;
        }
        if ("any".equals(address = httpListener.getAddress()) || "ANY".equals(address) || "INADDR_ANY".equals(address)) {
            address = null;
        }
        WebConnector connector = (WebConnector)this._embedded.createConnector(address, port, isSecure);
        _logger.info("Created HTTP listener " + httpListener.getId());
        connector.setName(httpListener.getId());
        this.configureConnector(connector, httpListener, isSecure, httpService);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "create.listenerport", new Object[]{port, connector});
        }
        this._embedded.addConnector(connector);
        this.portMap.put(httpListener.getId(), Integer.valueOf(httpListener.getPort()));
        CoyoteAdapter coyoteAdapter = new CoyoteAdapter(connector);
        this.adapterMap.put(Integer.valueOf(httpListener.getPort()), coyoteAdapter);
        if (this.defaultRedirectPort != -1) {
            connector.setRedirectPort(this.defaultRedirectPort);
        }
    }

    private void createJKConnector(HttpService httpService) {
        String portString = System.getProperty("com.sun.enterprise.web.connector.enableJK");
        if (portString == null) {
            return;
        }
        int port = 8009;
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException ex) {
            port = 8009;
        }
        this.jkConnector = (WebConnector)this._embedded.createConnector("0.0.0.0", port, "ajp");
        this.configureJKProperties(this.jkConnector);
        String defaultHost = "server";
        this.jkConnector.setDefaultHost(defaultHost);
        this.jkConnector.setDomain(this._serverContext.getDefaultDomainName());
        this.jkConnector.setLogger(_logger);
        this.jkConnector.setName("httpd-listener");
        this.configureHttpProtocol(this.jkConnector, httpService.getHttpProtocol());
        _logger.log(Level.INFO, "Apache mod_jk/jk2 attached to virtual-server " + defaultHost + " listening on port: " + portString);
        this._embedded.addConnector(this.jkConnector);
    }

    private void setDefaultRedirectPort(int defaultRedirectPort) {
        if (defaultRedirectPort != -1) {
            Connector[] connectors = this._embedded.getConnectors();
            for (int i = 0; i < connectors.length; ++i) {
                if (connectors[i].getRedirectPort() != -1) continue;
                connectors[i].setRedirectPort(defaultRedirectPort);
            }
        }
    }

    private void configureConnector(WebConnector connector, HttpListener httpListener, boolean isSecure, HttpService httpService) {
        String redirectPort;
        boolean blockingEnabled;
        this.configureConnectionPool(connector, httpService.getConnectionPool());
        connector.setDomain(this._serverContext.getDefaultDomainName());
        connector.setLogger(_logger);
        this.configureSSL(connector, httpListener);
        this.configureKeepAlive(connector, httpService.getKeepAlive());
        this.configureHttpProtocol(connector, httpService.getHttpProtocol());
        this.configureRequestProcessing(httpService.getRequestProcessing(), connector);
        this.configureFileCache(connector, httpService.getHttpFileCache());
        connector.setDefaultHost(httpListener.getDefaultVirtualServer());
        connector.setXpoweredBy(Boolean.getBoolean(httpListener.getXpoweredBy()));
        connector.setWebAppRootPath(this.getModulesRoot());
        String serverName = httpListener.getServerName();
        if (serverName != null && serverName.length() > 0) {
            if (serverName.startsWith("http://")) {
                serverName = serverName.substring("http://".length());
            } else if (serverName.startsWith("https://")) {
                serverName = serverName.substring("https://".length());
            }
            int index = serverName.indexOf(58);
            if (index != -1) {
                connector.setProxyName(serverName.substring(0, index).trim());
                String serverPort = serverName.substring(index + 1).trim();
                if (serverPort.length() > 0) {
                    try {
                        connector.setProxyPort(Integer.parseInt(serverPort));
                    }
                    catch (NumberFormatException nfe) {
                        _logger.log(Level.SEVERE, "pewebcontainer.invalid_proxy_port", new Object[]{serverPort, httpListener.getId()});
                    }
                }
            } else {
                connector.setProxyName(serverName);
            }
        }
        if (blockingEnabled = Boolean.valueOf(httpListener.getBlockingEnabled()).booleanValue()) {
            connector.setBlocking(blockingEnabled);
        }
        if ((redirectPort = httpListener.getRedirectPort()) != null && !redirectPort.equals("")) {
            try {
                connector.setRedirectPort(Integer.parseInt(redirectPort));
            }
            catch (NumberFormatException nfe) {
                _logger.log(Level.WARNING, "pewebcontainer.invalid_redirect_port", new Object[]{redirectPort, httpListener.getId(), Integer.toString(connector.getRedirectPort())});
            }
        } else {
            connector.setRedirectPort(-1);
        }
        String acceptorThreads = httpListener.getAcceptorThreads();
        if (acceptorThreads != null) {
            try {
                connector.setSelectorReadThreadsCount(Integer.parseInt(acceptorThreads));
            }
            catch (NumberFormatException nfe) {
                _logger.log(Level.WARNING, "pewebcontainer.invalid_acceptor_threads", new Object[]{acceptorThreads, httpListener.getId(), Integer.toString(connector.getMaxProcessors())});
            }
        }
        if (isSecure) {
            this.configureConnectorKeysAndCerts(connector);
        }
        this.configureHttpServiceProperties(httpService, connector);
        this.configureHttpListenerProperties(httpListener, connector);
    }

    public void configureHttpListenerProperties(HttpListener httpListener, WebConnector connector) {
        for (Property httpListenerProp : httpListener.getProperty()) {
            String propValue;
            String propName = httpListenerProp.getName();
            if (this.configureHttpListenerProperty(propName, propValue = httpListenerProp.getValue(), connector)) continue;
            _logger.log(Level.WARNING, "pewebcontainer.invalid_http_listener_property", propName);
        }
    }

    protected boolean configureHttpListenerProperty(String propName, String propValue, WebConnector connector) throws NumberFormatException {
        if ("bufferSize".equals(propName)) {
            connector.setBufferSize(Integer.parseInt(propValue));
            return true;
        }
        if ("recycle-objects".equals(propName)) {
            connector.setRecycleObjects(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("reader-threads".equals(propName)) {
            connector.setMaxReadWorkerThreads(Integer.parseInt(propValue));
            return true;
        }
        if ("acceptor-queue-length".equals(propName)) {
            connector.setMinAcceptQueueLength(Integer.parseInt(propValue));
            return true;
        }
        if ("reader-queue-length".equals(propName)) {
            connector.setMinReadQueueLength(Integer.parseInt(propValue));
            return true;
        }
        if ("use-nio-direct-bytebuffer".equals(propName)) {
            connector.setUseDirectByteBuffer(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("maxKeepAliveRequests".equals(propName)) {
            connector.setMaxKeepAliveRequests(Integer.parseInt(propValue));
            return true;
        }
        if ("reader-selectors".equals(propName)) {
            connector.setSelectorReadThreadsCount(Integer.parseInt(propValue));
            return true;
        }
        if ("authPassthroughEnabled".equals(propName)) {
            connector.setAuthPassthroughEnabled(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("maxPostSize".equals(propName)) {
            connector.setMaxPostSize(Integer.parseInt(propValue));
            return true;
        }
        if ("compression".equals(propName)) {
            connector.setProperty("compression", propValue);
            return true;
        }
        if ("compressableMimeType".equals(propName)) {
            connector.setProperty("compressableMimeType", propValue);
            return true;
        }
        if ("noCompressionUserAgents".equals(propName)) {
            connector.setProperty("noCompressionUserAgents", propValue);
            return true;
        }
        if ("compressionMinSize".equals(propName)) {
            connector.setProperty("compressionMinSize", propValue);
            return true;
        }
        if ("restrictedUserAgents".equals(propName)) {
            connector.setProperty("restrictedUserAgents", propValue);
            return true;
        }
        if ("blocking".equals(propName)) {
            connector.setBlocking(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("selectorThreadImpl".equals(propName)) {
            connector.setSelectorThreadImpl(propValue);
            return true;
        }
        if ("cometSupport".equals(propName)) {
            connector.setProperty(propName, ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("rcmSupport".equals(propName)) {
            connector.setProperty(propName, ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("connectionUploadTimeout".equals(propName)) {
            connector.setConnectionUploadTimeout(Integer.parseInt(propValue));
            return true;
        }
        if ("disableUploadTimeout".equals(propName)) {
            connector.setDisableUploadTimeout(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("proxiedProtocols".equals(propName)) {
            connector.setProperty(propName, propValue);
            return true;
        }
        if ("proxyHandler".equals(propName)) {
            this.setProxyHandler(connector, propValue);
            return true;
        }
        if ("uriEncoding".equals(propName)) {
            connector.setURIEncoding(propValue);
            return true;
        }
        if ("chunkingDisabled".equals(propName) || "chunking-disabled".equals(propName)) {
            connector.setChunkingDisabled(ConfigBeansUtilities.toBoolean((String)propValue));
            return true;
        }
        if ("crlFile".equals(propName)) {
            connector.setCrlFile(propValue);
            return true;
        }
        if ("trustAlgorithm".equals(propName)) {
            connector.setTrustAlgorithm(propValue);
            return true;
        }
        if ("trustMaxCertLength".equals(propName)) {
            connector.setTrustMaxCertLength(propValue);
            return true;
        }
        return false;
    }

    public void configureHttpServiceProperties(HttpService httpService, WebConnector connector) {
        List httpServiceProps = httpService.getProperty();
        connector.setProxyHandler(new ProxyHandlerImpl());
        if (httpServiceProps != null) {
            for (Property httpServiceProp : httpServiceProps) {
                String propValue;
                String propName = httpServiceProp.getName();
                if (this.configureHttpListenerProperty(propName, propValue = httpServiceProp.getValue(), connector)) continue;
                if ("connectionTimeout".equals(propName)) {
                    connector.setConnectionTimeout(Integer.parseInt(propValue));
                    continue;
                }
                if ("tcpNoDelay".equals(propName)) {
                    connector.setTcpNoDelay(ConfigBeansUtilities.toBoolean((String)propValue));
                    continue;
                }
                if ("traceEnabled".equals(propName)) {
                    connector.setAllowTrace(ConfigBeansUtilities.toBoolean((String)propValue));
                    continue;
                }
                if ("accessLoggingEnabled".equals(propName)) {
                    this.globalAccessLoggingEnabled = ConfigBeansUtilities.toBoolean((String)propValue);
                    continue;
                }
                if ("accessLogWriteInterval".equals(propName)) {
                    this.globalAccessLogWriteInterval = propValue;
                    continue;
                }
                if ("accessLogBufferSize".equals(propName)) {
                    this.globalAccessLogBufferSize = propValue;
                    continue;
                }
                if ("authPassthroughEnabled".equals(propName)) {
                    connector.setAuthPassthroughEnabled(ConfigBeansUtilities.toBoolean((String)propValue));
                    continue;
                }
                if ("ssl-session-timeout".equals(propName)) {
                    connector.setSSLSessionTimeout(propValue);
                    continue;
                }
                if ("ssl3-session-timeout".equals(propName)) {
                    connector.setSSL3SessionTimeout(propValue);
                    continue;
                }
                if ("ssl-cache-entries".equals(propName)) {
                    connector.setSSLSessionCacheSize(propValue);
                    continue;
                }
                if ("proxyHandler".equals(propName)) {
                    this.setProxyHandler(connector, propValue);
                    continue;
                }
                if ("sso-enabled".equals(propName)) {
                    this.globalSSOEnabled = ConfigBeansUtilities.toBoolean((String)propValue);
                    continue;
                }
                _logger.log(Level.WARNING, "pewebcontainer.invalid_http_service_property", httpServiceProp.getName());
            }
        }
    }

    private void checkHostnameUniqueness(String listenerId, HttpService httpService) {
        int j;
        ArrayList<com.sun.enterprise.config.serverbeans.VirtualServer> listenerVses = null;
        block0: for (com.sun.enterprise.config.serverbeans.VirtualServer vse : httpService.getVirtualServer()) {
            List vsListeners = StringUtils.parseStringList((String)vse.getHttpListeners(), (String)",");
            for (j = 0; vsListeners != null && j < vsListeners.size(); ++j) {
                if (!listenerId.equals((String)vsListeners.get(j))) continue;
                if (listenerVses == null) {
                    listenerVses = new ArrayList<com.sun.enterprise.config.serverbeans.VirtualServer>();
                }
                listenerVses.add(vse);
                continue block0;
            }
        }
        if (listenerVses == null) {
            return;
        }
        for (int i = 0; i < listenerVses.size(); ++i) {
            com.sun.enterprise.config.serverbeans.VirtualServer vs = (com.sun.enterprise.config.serverbeans.VirtualServer)listenerVses.get(i);
            List hosts = StringUtils.parseStringList((String)vs.getHosts(), (String)",");
            for (j = 0; hosts != null && j < hosts.size(); ++j) {
                String host = (String)hosts.get(j);
                for (int k = 0; k < listenerVses.size(); ++k) {
                    if (k <= i) continue;
                    com.sun.enterprise.config.serverbeans.VirtualServer otherVs = (com.sun.enterprise.config.serverbeans.VirtualServer)listenerVses.get(k);
                    List otherHosts = StringUtils.parseStringList((String)otherVs.getHosts(), (String)",");
                    for (int l = 0; otherHosts != null && l < otherHosts.size(); ++l) {
                        if (!host.equals((String)otherHosts.get(l))) continue;
                        _logger.log(Level.SEVERE, "pewebcontainer.duplicate_host_name", new Object[]{host, vs.getId(), otherVs.getId(), listenerId});
                    }
                }
            }
        }
    }

    private void createVirtualServer(com.sun.enterprise.config.serverbeans.VirtualServer vsBean, HttpService httpService, SecurityService securityService) {
        MimeMap mm = null;
        String vs_id = vsBean.getId();
        String docroot = ConfigBeansUtilities.getPropertyValueByName((Object)vsBean, (String)"docroot");
        this.validateDocroot(docroot, vs_id, vsBean.getDefaultWebModule());
        VirtualServer vs = this.createVS(vs_id, vsBean, docroot, vsBean.getLogFile(), mm, httpService.getHttpProtocol());
        Property cacheProp = ConfigBeansUtilities.getPropertyByName((Object)vsBean, (String)"setCacheControl");
        if (cacheProp != null) {
            vs.configureCacheControl(cacheProp.getValue());
        }
        List aliasNames = StringUtils.parseStringList((String)vsBean.getHosts(), (String)",");
        for (String alias : aliasNames) {
            if ("${com.sun.aas.hostName}".equals(alias)) {
                try {
                    alias = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    _logger.log(Level.SEVERE, "Unable to get local host name", e);
                }
            }
            vs.addAlias(alias);
        }
        PEAccessLogValve accessLogValve = vs.getAccessLogValve();
        boolean startAccessLog = accessLogValve.configure(vs_id, vsBean, httpService, this.domain, this._serverContext.getDefaultHabitat(), (WebContainerFeatureFactory)this._serverContext.getDefaultHabitat().getComponent(PEWebContainerFeatureFactoryImpl.class), this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval);
        if (startAccessLog && vs.isAccessLoggingEnabled(this.globalAccessLoggingEnabled)) {
            vs.addValve(accessLogValve);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Created virtual server " + vs_id);
        }
        this.configureHost(vs, httpService, securityService);
        this.engine.addChild(vs);
    }

    protected boolean validateDocroot(String docroot, String vs_id, String defaultWebModule) {
        if (docroot != null) {
            boolean isValid = new File(docroot).exists();
            if (!isValid && defaultWebModule == null) {
                String msg = _rb.getString("pewebcontainer.virtual_server.invalid_docroot");
                msg = MessageFormat.format(msg, vs_id, docroot);
                throw new IllegalArgumentException(msg);
            }
            if (!isValid) {
                _logger.log(Level.WARNING, "virtual-server " + vs_id + " has an invalid docroot: " + docroot);
            }
        } else if (defaultWebModule == null) {
            String msg = _rb.getString("pewebcontainer.virtual_server.missing_docroot");
            msg = MessageFormat.format(msg, vs_id);
            throw new IllegalArgumentException(msg);
        }
        return true;
    }

    protected void configureHost(VirtualServer vs, HttpService httpService, SecurityService securityService) {
        com.sun.enterprise.config.serverbeans.VirtualServer vsBean = vs.getBean();
        vs.configureAliases();
        List listeners = StringUtils.parseStringList((String)vsBean.getHttpListeners(), (String)",");
        if (listeners == null) {
            return;
        }
        HttpListener[] httpListeners = new HttpListener[listeners.size()];
        for (int i = 0; i < listeners.size(); ++i) {
            for (HttpListener httpListener : httpService.getHttpListener()) {
                if (!httpListener.getId().equals(listeners.get(i))) continue;
                httpListeners[i] = httpListener;
            }
        }
        this.configureHostPortNumbers(vs, httpListeners);
        vs.configureCatalinaProperties();
    }

    protected void configureHostPortNumbers(VirtualServer vs, HttpListener[] httpListeners) {
        boolean addJkListenerPort = this.jkConnector != null && !vs.getName().equalsIgnoreCase("__asadmin");
        ArrayList<Integer> portsList = new ArrayList<Integer>();
        for (int i = 0; i < httpListeners.length; ++i) {
            Integer port = this.portMap.get(httpListeners[i].getId());
            if (port == null) continue;
            portsList.add(port);
        }
        int numPorts = portsList.size();
        if (addJkListenerPort) {
            ++numPorts;
        }
        if (numPorts > 0) {
            int[] ports = new int[numPorts];
            int i = 0;
            for (i = 0; i < portsList.size(); ++i) {
                ports[i] = (Integer)portsList.get(i);
                _logger.info("Virtual Server " + vs.getID() + " set port " + ports[i]);
            }
            if (addJkListenerPort) {
                ports[i] = this.jkConnector.getPort();
                _logger.info("Virtual Server " + vs.getID() + " set jk port " + ports[i]);
            }
            vs.setPorts(ports);
        }
    }

    private void enableVirtualServerMonitoring() {
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            org.apache.catalina.Container[] hostArray = engines[j].findChildren();
            for (int i = 0; i < hostArray.length; ++i) {
                VirtualServer vs = (VirtualServer)hostArray[i];
                this.enableVirtualServerMonitoring(vs);
            }
        }
    }

    private void enableVirtualServerMonitoring(VirtualServer vs) {
        ServerContext sc = this.getServerContext();
        MonitoringRegistry monitoringRegistry = (MonitoringRegistry)sc.getDefaultHabitat().getComponent(MonitoringRegistry.class);
        PWCVirtualServerStatsImpl vsStats = new PWCVirtualServerStatsImpl(vs);
        try {
            monitoringRegistry.registerPWCVirtualServerStats((PWCVirtualServerStats)vsStats, vs.getID(), null);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Unable to register PWCVirtualServerStats for " + vs.getID(), e);
        }
        PWCRequestStatsImpl pwcRequestStatsImpl = new PWCRequestStatsImpl(sc.getDefaultDomainName());
        vs.setPWCRequestStatsImpl(pwcRequestStatsImpl);
        try {
            monitoringRegistry.registerPWCRequestStats((PWCRequestStats)pwcRequestStatsImpl, vs.getID(), null);
        }
        catch (MonitoringRegistrationException mre) {
            String msg = _logger.getResourceBundle().getString("web.monitoringRegistrationError");
            msg = MessageFormat.format(msg, "PWCRequestStats");
            _logger.log(Level.WARNING, msg, mre);
        }
    }

    private String getJSSECiphers(String ciphers) {
        String cipher = null;
        StringBuffer enabledCiphers = null;
        boolean first = true;
        int index = ciphers.indexOf(44);
        if (index != -1) {
            int fromIndex = 0;
            while (index != -1) {
                cipher = ciphers.substring(fromIndex, index).trim();
                if (cipher.length() > 0 && !cipher.startsWith("-")) {
                    String jsseCipher;
                    if (cipher.startsWith("+")) {
                        cipher = cipher.substring(1);
                    }
                    if ((jsseCipher = this.getJSSECipher(cipher)) == null) {
                        _logger.log(Level.WARNING, "pewebcontainer.unrecognized_cipher", cipher);
                    } else {
                        if (enabledCiphers == null) {
                            enabledCiphers = new StringBuffer();
                        }
                        if (!first) {
                            enabledCiphers.append(", ");
                        } else {
                            first = false;
                        }
                        enabledCiphers.append(jsseCipher);
                    }
                }
                fromIndex = index + 1;
                index = ciphers.indexOf(44, fromIndex);
            }
            cipher = ciphers.substring(fromIndex);
        } else {
            cipher = ciphers;
        }
        if (cipher != null && (cipher = cipher.trim()).length() > 0 && !cipher.startsWith("-")) {
            String jsseCipher;
            if (cipher.startsWith("+")) {
                cipher = cipher.substring(1);
            }
            if ((jsseCipher = this.getJSSECipher(cipher)) == null) {
                _logger.log(Level.WARNING, "pewebcontainer.unrecognized_cipher", cipher);
            } else {
                if (enabledCiphers == null) {
                    enabledCiphers = new StringBuffer();
                }
                if (!first) {
                    enabledCiphers.append(", ");
                } else {
                    first = false;
                }
                enabledCiphers.append(jsseCipher);
            }
        }
        return enabledCiphers == null ? null : enabledCiphers.toString();
    }

    private String getJSSECipher(String cipher) {
        String jsseCipher = null;
        CipherInfo ci = CipherInfo.getCipherInfo(cipher);
        if (ci != null) {
            jsseCipher = ci.getCipherName();
        }
        return jsseCipher;
    }

    private void configureSSL(PECoyoteConnector connector, HttpListener httpListener) {
        String ciphers;
        Ssl sslConfig = httpListener.getSsl();
        if (sslConfig == null) {
            return;
        }
        if (Boolean.getBoolean(sslConfig.getClientAuthEnabled())) {
            connector.setClientAuth(true);
        }
        StringBuffer sslProtocolsBuf = new StringBuffer();
        boolean needComma = false;
        if (Boolean.getBoolean(sslConfig.getSsl2Enabled())) {
            sslProtocolsBuf.append("SSLv2");
            needComma = true;
        }
        if (Boolean.getBoolean(sslConfig.getSsl3Enabled())) {
            if (needComma) {
                sslProtocolsBuf.append(", ");
            } else {
                needComma = true;
            }
            sslProtocolsBuf.append("SSLv3");
        }
        if (Boolean.getBoolean(sslConfig.getTlsEnabled())) {
            if (needComma) {
                sslProtocolsBuf.append(", ");
            }
            sslProtocolsBuf.append("TLSv1");
        }
        if (Boolean.getBoolean(sslConfig.getSsl3Enabled()) || Boolean.getBoolean(sslConfig.getTlsEnabled())) {
            sslProtocolsBuf.append(", SSLv2Hello");
        }
        if (sslProtocolsBuf.length() == 0) {
            _logger.log(Level.WARNING, "pewebcontainer.all_ssl_protocols_disabled", httpListener.getId());
        } else {
            connector.setSslProtocols(sslProtocolsBuf.toString());
        }
        String certNickname = sslConfig.getCertNickname();
        if (certNickname != null && certNickname.length() > 0) {
            connector.setKeyAlias(sslConfig.getCertNickname());
        }
        if ((ciphers = sslConfig.getSsl3TlsCiphers()) != null) {
            String jsseCiphers = this.getJSSECiphers(ciphers);
            if (jsseCiphers == null) {
                _logger.log(Level.WARNING, "pewebcontainer.all_ciphers_disabled", httpListener.getId());
            } else {
                connector.setCiphers(jsseCiphers);
            }
        }
    }

    private void configureKeepAlive(PECoyoteConnector connector, KeepAlive keepAlive) {
        int timeoutInSeconds = 60;
        int maxConnections = 256;
        int threadCount = 1;
        if (keepAlive != null) {
            String msg;
            try {
                timeoutInSeconds = Integer.parseInt(keepAlive.getTimeoutInSeconds());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveTimeout");
                msg = MessageFormat.format(msg, keepAlive.getTimeoutInSeconds(), Integer.toString(timeoutInSeconds));
                _logger.log(Level.WARNING, msg, ex);
            }
            try {
                maxConnections = Integer.parseInt(keepAlive.getMaxConnections());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveMaxConnections");
                msg = MessageFormat.format(msg, keepAlive.getMaxConnections(), Integer.toString(maxConnections));
                _logger.log(Level.WARNING, msg, ex);
            }
            try {
                threadCount = Integer.parseInt(keepAlive.getThreadCount());
            }
            catch (NumberFormatException ex) {
                msg = _rb.getString("pewebcontainer.invalidKeepAliveThreadCount");
                msg = MessageFormat.format(msg, keepAlive.getThreadCount(), Integer.toString(threadCount));
                _logger.log(Level.WARNING, msg, ex);
            }
        }
        connector.setKeepAliveTimeoutInSeconds(timeoutInSeconds);
        connector.setMaxKeepAliveRequests(maxConnections);
        connector.setKeepAliveThreadCount(threadCount);
    }

    private void configureConnectionPool(PECoyoteConnector connector, ConnectionPool cp) {
        String msg;
        if (cp == null) {
            return;
        }
        try {
            int queueSizeInBytes = Integer.parseInt(cp.getQueueSizeInBytes());
            if (queueSizeInBytes <= -1) {
                _logger.log(Level.WARNING, "pewebcontainer.invalidQueueSizeInBytes", new Object[]{cp.getQueueSizeInBytes(), Integer.toString(connector.getQueueSizeInBytes())});
            } else {
                connector.setQueueSizeInBytes(queueSizeInBytes);
            }
        }
        catch (NumberFormatException ex) {
            msg = _rb.getString("pewebcontainer.invalidQueueSizeInBytes");
            msg = MessageFormat.format(msg, ConfigBeansUtilities.getDefaultQueueSizeInBytes(), Integer.toString(connector.getQueueSizeInBytes()));
            _logger.log(Level.WARNING, msg, ex);
        }
        try {
            int ssBackLog = Integer.parseInt(cp.getMaxPendingCount());
            if (ssBackLog <= 0) {
                _logger.log(Level.WARNING, "pewebcontainer.invalidMaxPendingCount", new Object[]{cp.getMaxPendingCount(), Integer.toString(connector.getSocketServerBacklog())});
            } else {
                connector.setSocketServerBacklog(ssBackLog);
            }
        }
        catch (NumberFormatException ex) {
            msg = _rb.getString("pewebcontainer.invalidMaxPendingCount");
            msg = MessageFormat.format(msg, cp.getMaxPendingCount(), Integer.toString(connector.getSocketServerBacklog()));
            _logger.log(Level.WARNING, msg, ex);
        }
        try {
            int bufferSize = Integer.parseInt(cp.getReceiveBufferSizeInBytes());
            if (bufferSize <= 0) {
                _logger.log(Level.WARNING, "pewebcontainer.invalidBufferSize", new Object[]{cp.getReceiveBufferSizeInBytes(), Integer.toString(connector.getBufferSize())});
            } else {
                connector.setBufferSize(bufferSize);
            }
        }
        catch (NumberFormatException ex) {
            msg = _rb.getString("pewebcontainer.invalidBufferSize");
            msg = MessageFormat.format(msg, cp.getReceiveBufferSizeInBytes(), Integer.toString(connector.getBufferSize()));
            _logger.log(Level.WARNING, msg, ex);
        }
        try {
            int maxHttpHeaderSize = Integer.parseInt(cp.getSendBufferSizeInBytes());
            if (maxHttpHeaderSize <= 0) {
                _logger.log(Level.WARNING, "pewebcontainer.invalidMaxHttpHeaderSize", new Object[]{cp.getSendBufferSizeInBytes(), Integer.toString(connector.getMaxHttpHeaderSize())});
            } else {
                connector.setMaxHttpHeaderSize(maxHttpHeaderSize);
            }
        }
        catch (NumberFormatException ex) {
            msg = _rb.getString("pewebcontainer.invalidMaxHttpHeaderSize");
            msg = MessageFormat.format(msg, cp.getSendBufferSizeInBytes(), Integer.toString(connector.getMaxHttpHeaderSize()));
            _logger.log(Level.WARNING, msg, ex);
        }
    }

    private void configureHttpProtocol(PECoyoteConnector connector, HttpProtocol httpProtocol) {
        if (httpProtocol == null) {
            return;
        }
    }

    private void configureFileCache(PECoyoteConnector connector, HttpFileCache httpFileCache) {
        if (httpFileCache == null) {
            return;
        }
        connector.setLargeFileCacheEnabled(ConfigBeansUtilities.toBoolean((String)httpFileCache.getFileCachingEnabled()));
        if (httpFileCache.getMaxAgeInSeconds() != null) {
            connector.setSecondsMaxAge(Integer.parseInt(httpFileCache.getMaxAgeInSeconds()));
        }
        if (httpFileCache.getMaxFilesCount() != null) {
            connector.setMaxCacheEntries(Integer.parseInt(httpFileCache.getMaxFilesCount()));
        }
        if (httpFileCache.getSmallFileSizeLimitInBytes() != null) {
            connector.setMinEntrySize(Integer.parseInt(httpFileCache.getSmallFileSizeLimitInBytes()));
        }
        if (httpFileCache.getMediumFileSizeLimitInBytes() != null) {
            connector.setMaxEntrySize(Integer.parseInt(httpFileCache.getMediumFileSizeLimitInBytes()));
        }
        if (httpFileCache.getMediumFileSpaceInBytes() != null) {
            connector.setMaxLargeCacheSize(Integer.parseInt(httpFileCache.getMediumFileSpaceInBytes()));
        }
        if (httpFileCache.getSmallFileSpaceInBytes() != null) {
            connector.setMaxSmallCacheSize(Integer.parseInt(httpFileCache.getSmallFileSpaceInBytes()));
        }
    }

    protected void configureRequestProcessing(HttpService httpService) {
        RequestProcessing rp = httpService.getRequestProcessing();
        Connector[] connectors = this._embedded.findConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            this.configureRequestProcessing(rp, (PECoyoteConnector)connectors[i]);
        }
    }

    protected void configureRequestProcessing(RequestProcessing rp, PECoyoteConnector connector) {
        if (rp == null) {
            return;
        }
        try {
            connector.setMaxProcessors(Integer.parseInt(rp.getThreadCount()));
            connector.setMinProcessors(Integer.parseInt(rp.getInitialThreadCount()));
            connector.setProcessorWorkerThreadsTimeout(Integer.parseInt(rp.getRequestTimeoutInSeconds()));
            connector.setProcessorWorkerThreadsIncrement(Integer.parseInt(rp.getThreadIncrement()));
            connector.setMaxHttpHeaderSize(Integer.parseInt(rp.getHeaderBufferLengthInBytes()));
        }
        catch (NumberFormatException ex) {
            _logger.log(Level.WARNING, " Invalid request-processing attribute", ex);
        }
    }

    private void setProxyHandler(PECoyoteConnector connector, String className) {
        Object handler = null;
        try {
            Class<?> handlerClass = Class.forName(className);
            handler = handlerClass.newInstance();
        }
        catch (Exception e) {
            String msg = _rb.getString("pewebcontainer.proxyHandlerClassLoadError");
            msg = MessageFormat.format(msg, className);
            _logger.log(Level.SEVERE, msg, e);
        }
        if (handler != null) {
            if (!(handler instanceof ProxyHandler)) {
                _logger.log(Level.SEVERE, "pewebcontainer.proxyHandlerClassInvalid", className);
            } else {
                connector.setProxyHandler(handler);
            }
        }
    }

    private void configureConnectorKeysAndCerts(PECoyoteConnector connector) {
        String prop = System.getProperty("javax.net.ssl.keyStore");
        if (prop != null) {
            connector.setKeystoreFile(prop);
            connector.setKeystoreType("JKS");
        }
        if ((prop = System.getProperty("javax.net.ssl.trustStore")) != null) {
            connector.setTruststore(prop);
            connector.setTruststoreType("JKS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureJKProperties(PECoyoteConnector connector) {
        File propertiesFile;
        String propertiesURL = System.getProperty("com.sun.enterprise.web.connector.enableJK.propertyFile");
        if (propertiesURL == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("com.sun.enterprise.web.connector.enableJK.propertyFile not defined");
            }
            return;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Loading glassfish-jk.properties from " + propertiesURL);
        }
        if (!(propertiesFile = new File(propertiesURL)).exists()) {
            String msg = _rb.getString("pewebcontainer.missingJKProperties");
            msg = MessageFormat.format(msg, propertiesURL);
            _logger.log(Level.WARNING, msg);
            return;
        }
        Properties properties = null;
        InputStream is = null;
        try {
            FileInputStream fis = new FileInputStream(propertiesFile);
            is = new BufferedInputStream(fis);
            properties = new Properties();
            properties.load(is);
        }
        catch (Exception ex) {
            String msg = _rb.getString("pewebcontainer.configureJK");
            msg = MessageFormat.format(msg, connector.getPort());
            _logger.log(Level.SEVERE, msg, ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = properties.getProperty(name);
            if (value == null) continue;
            IntrospectionUtils.setProperty(connector, name, value);
        }
    }

    public String getID() {
        return this._id;
    }

    public HealthChecker getHealthChecker() {
        return this._healthChecker;
    }

    private void initHealthChecker() {
        WebContainerFeatureFactory webContainerFeatureFactory = (WebContainerFeatureFactory)this._serverContext.getDefaultHabitat().getComponent(WebContainerFeatureFactory.class);
        HealthChecker healthChecker = null;
        try {
            healthChecker = webContainerFeatureFactory.getHADBHealthChecker(this);
        }
        catch (NoClassDefFoundError ex) {
            _logger.log(Level.WARNING, "hadbhealthchecker.hadbClientJarsMissing");
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("WebContainer>>initHealthChecker - healthChecker = " + healthChecker);
        }
        if (healthChecker != null) {
            this._healthChecker = healthChecker;
            try {
                this._healthChecker.start();
            }
            catch (LifecycleException lifecycleException) {
                // empty catch block
            }
        }
    }

    private void stopHealthChecker() {
        if (this._healthChecker != null) {
            try {
                this._healthChecker.stop();
            }
            catch (LifecycleException lifecycleException) {
                // empty catch block
            }
            this._healthChecker = null;
        }
    }

    public VirtualServer createVS(String vsID, com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String docroot, String logFile, MimeMap mimeMap, HttpProtocol httpProtocol) {
        VirtualServer vs = (VirtualServer)this._embedded.createHost(vsID, vsBean, docroot, logFile, mimeMap);
        vs.configureRemoteAddressFilterValve();
        vs.configureRemoteHostFilterValve(httpProtocol);
        vs.configureSSOValve(this.globalSSOEnabled, (WebContainerFeatureFactory)this._serverContext.getDefaultHabitat().getComponent(WebContainerFeatureFactory.class));
        vs.configureRedirect();
        vs.configureErrorPage();
        return vs;
    }

    private void doSchemaCheck() {
        SchemaUpdater schemaUpdater;
        block5: {
            schemaUpdater = null;
            try {
                schemaUpdater = (SchemaUpdater)this._serverContext.getDefaultHabitat().getComponent(SchemaUpdater.class);
            }
            catch (NoClassDefFoundError ex) {
                if (!_logger.isLoggable(Level.FINE)) break block5;
                _logger.fine("HADB Warning - client jars missing - ok if not running with HADB");
            }
        }
        if (schemaUpdater != null) {
            try {
                schemaUpdater.doSchemaCheck();
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "schemaupdater.error", ex);
            }
        }
    }

    public void stop() throws LifecycleException {
        ArrayList shutdownCleanupCapablesList;
        WebContainerStartStopOperation startStopOperation;
        block3: {
            if (!this._started) {
                String msg = _rb.getString("webcontainer.notStarted");
                throw new LifecycleException(msg);
            }
            this.stopHealthChecker();
            startStopOperation = this.getWebContainerStartStopOperation();
            shutdownCleanupCapablesList = startStopOperation.doPreStop();
            this._started = false;
            try {
                this._embedded.stop();
            }
            catch (LifecycleException ex) {
                if (ex.getMessage().indexOf("has not been started") != -1) break block3;
                throw ex;
            }
        }
        startStopOperation.doPostStop(shutdownCleanupCapablesList);
    }

    public WebContainerStartStopOperation getWebContainerStartStopOperation() {
        WebContainerFeatureFactory webContainerFeatureFactory = (WebContainerFeatureFactory)this._serverContext.getDefaultHabitat().getComponent(WebContainerFeatureFactory.class);
        if (webContainerFeatureFactory == null) {
            return null;
        }
        WebContainerStartStopOperation startStopOperation = webContainerFeatureFactory.getWebContainerStartStopOperation();
        return startStopOperation;
    }

    protected void loadDefaultWebModules() {
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            org.apache.catalina.Container[] vsArray = engines[j].findChildren();
            for (int i = 0; i < vsArray.length; ++i) {
                if (!(vsArray[i] instanceof VirtualServer)) continue;
                VirtualServer vs = (VirtualServer)vsArray[i];
                String defaultPath = vs.getDefaultContextPath(this._serverBean);
                if (defaultPath != null) {
                    try {
                        this.updateDefaultWebModule(vs, vs.getPorts(), defaultPath);
                    }
                    catch (LifecycleException le) {
                        String msg = _rb.getString("webcontainer.defaultWebModuleError");
                        msg = MessageFormat.format(msg, defaultPath, vs.getName());
                        _logger.log(Level.SEVERE, msg, le);
                    }
                    continue;
                }
                WebModuleConfig wmInfo = vs.createSystemDefaultWebModuleIfNecessary();
                if (wmInfo == null) continue;
                this.loadStandaloneWebModule(vs, wmInfo);
            }
        }
    }

    protected void loadStandaloneWebModule(VirtualServer vs, WebModuleConfig wmInfo) {
        this.loadWebModule(vs, wmInfo, "null");
    }

    protected void loadAllJ2EEApplicationWebModules() {
        this.loadAllJ2EEApplicationWebModules(false);
    }

    private void loadAllJ2EEApplicationWebModules(boolean isStartUp) {
        Domain domain = (Domain)this._serverContext.getDefaultHabitat().getComponent(Domain.class);
        Applications appsBean = domain.getApplications();
        if (appsBean != null) {
            List modules = ConfigBeansUtilities.getModules(J2EeApplication.class, (Applications)appsBean);
            for (J2EeApplication module : modules) {
                if (!this.isReferenced(module.getName())) continue;
                this.loadJ2EEApplicationWebModules(module);
            }
        }
    }

    public void loadJ2EEApplicationWebModules(J2EeApplication j2eeAppBean) {
    }

    protected boolean isEnabled(String moduleName) {
        Domain domain = (Domain)this._serverContext.getDefaultHabitat().getComponent(Domain.class);
        return true;
    }

    public List<Result<WebModule>> loadWebModule(WebModuleConfig wmInfo, String j2eeApplication) {
        String vsIDs = wmInfo.getVirtualServers();
        List vsList = StringUtils.parseStringList((String)vsIDs, (String)" ,");
        boolean loadToAll = vsList == null || vsList.size() == 0;
        boolean loadAtLeastToOne = false;
        Engine[] engines = this._embedded.getEngines();
        ArrayList<Result<WebModule>> results = new ArrayList<Result<WebModule>>();
        for (int j = 0; j < engines.length; ++j) {
            org.apache.catalina.Container[] vsArray = engines[j].findChildren();
            for (int i = 0; i < vsArray.length; ++i) {
                VirtualServer vs;
                if (!(vsArray[i] instanceof VirtualServer) || (vs = (VirtualServer)vsArray[i]).getID().equals("__asadmin") && loadToAll || !loadToAll && !vsList.contains(vs.getID()) && !this.verifyAlias(vsList, vs)) continue;
                results.add(this.loadWebModule(vs, wmInfo, j2eeApplication));
                loadAtLeastToOne = true;
            }
        }
        if (!loadAtLeastToOne) {
            Object[] params = new Object[]{wmInfo.getName(), vsIDs};
            _logger.log(Level.SEVERE, "webcontainer.moduleNotLoadedToVS", params);
        }
        return results;
    }

    private boolean verifyAlias(List vsList, VirtualServer vs) {
        for (int i = 0; i < vs.getAliases().length; ++i) {
            if (!vsList.contains(vs.getAliases()[i])) continue;
            return true;
        }
        return false;
    }

    protected Result<WebModule> loadWebModule(VirtualServer vs, WebModuleConfig wmInfo, String j2eeApplication) {
        Result result;
        ClassLoader parentLoader;
        String wmName = wmInfo.getName();
        String wmContextPath = wmInfo.getContextPath();
        if (wmContextPath.equals("") && vs.getDefaultWebModuleID() != null) {
            _logger.log(Level.WARNING, "webcontainer.defaultWebModuleConflict", new Object[]{wmName, wmContextPath, vs.getID()});
            return null;
        }
        String displayContextPath = null;
        displayContextPath = wmContextPath.equals("") ? "/" : wmContextPath;
        HashMap adHocPaths = null;
        HashMap adHocSubtrees = null;
        WebModule ctx = (WebModule)vs.findChild(wmContextPath);
        if (ctx != null) {
            if (ctx instanceof AdHocWebModule) {
                if (ctx.hasAdHocPaths()) {
                    adHocPaths = ctx.getAdHocPaths();
                }
                if (ctx.hasAdHocSubtrees()) {
                    adHocSubtrees = ctx.getAdHocSubtrees();
                }
                vs.removeChild(ctx);
            } else if ("__default-web-module".equals(ctx.getModuleName())) {
                this.unloadWebModule(wmContextPath, ctx.getJ2EEApplication(), vs.getName(), null, true);
            } else {
                if (!ctx.getAvailable()) {
                    ctx.setAvailable(true);
                    return null;
                }
                Object[] params = new Object[]{vs.getID(), displayContextPath, wmName};
                _logger.log(Level.WARNING, "webcontainer.duplicateContextRoot", params);
                return null;
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            Object[] params = new Object[]{wmName, vs.getID(), displayContextPath};
            _logger.log(Level.FINEST, "webcontainer.loadModule", params);
        }
        String docBase = null;
        if (JWS_APPCLIENT_MODULE_NAME.equals(wmName)) {
            File installRootFile = new File(System.getProperty("com.sun.aas.installRoot"));
            String path = installRootFile.toURI().getPath();
            if (OS.isWindows()) {
                path = path.substring(1);
            }
            docBase = path;
        } else {
            docBase = wmInfo.getLocation();
        }
        WebBundleDescriptor wbd = wmInfo.getDescriptor();
        Throwable exception = null;
        String compEnvId = null;
        try {
            compEnvId = this.componentEnvManager.bindToComponentNamespace((JndiNameEnvironment)wbd);
        }
        catch (Exception ex) {
            exception = ex;
        }
        ctx = (WebModule)this._embedded.createContext(wmContextPath, docBase, vs.getDefaultContextXmlLocation(), vs.getDefaultWebXmlLocation(), useDOLforDeployment, wmInfo.getDescriptor(), compEnvId);
        ctx.setUseNaming(false);
        String engineName = vs.getParent().getName();
        String j2eeServer = this._serverContext.getInstanceName();
        String domain = this._serverContext.getDefaultDomainName();
        String server = domain + ":j2eeType=J2EEServer,name=" + j2eeServer;
        ctx.setDomain(domain);
        ctx.setJ2EEServer(j2eeServer);
        ctx.setJ2EEApplication(j2eeApplication);
        ctx.setEngineName(engineName);
        ctx.setServer(server);
        ctx.setCachingAllowed(false);
        ctx.setCacheControls(vs.getCacheControls());
        ctx.setBean(wmInfo.getBean());
        if (adHocPaths != null) {
            ctx.addAdHocPaths(adHocPaths);
        }
        if (adHocSubtrees != null) {
            ctx.addAdHocSubtrees(adHocSubtrees);
        }
        if (wmInfo.getDescriptor() != null) {
            ctx.setContextRoot(wmInfo.getDescriptor().getContextRoot());
        } else {
            _logger.log(Level.WARNING, "Unable to set context root", wmInfo);
        }
        String wmInfoWorkDir = wmInfo.getWorkDir();
        if (wmInfoWorkDir != null) {
            StringBuffer workDir = new StringBuffer(wmInfo.getWorkDir());
            if (wmName.equals("__default-web-module")) {
                workDir.append("-");
                workDir.append(FileUtils.makeFriendlyFilename((String)vs.getID()));
            }
            ctx.setWorkDir(workDir.toString());
        }
        if ((parentLoader = wmInfo.getParentLoader()) == null) {
            parentLoader = this._serverContext.getSharedClassLoader();
        }
        ctx.setParentClassLoader(parentLoader);
        try {
            if (wbd != null) {
                String altDDName = wbd.getModuleDescriptor().getAlternateDescriptor();
                if (altDDName != null) {
                    String appName = wmName.substring(0, wmName.indexOf(":"));
                    V3Environment env = (V3Environment)this._serverContext.getDefaultHabitat().getComponent(V3Environment.class);
                    String appLoc = env.getApplicationGeneratedXMLPath() + File.separator + appName;
                    if (!FileUtils.safeIsDirectory((String)appLoc)) {
                        appLoc = wmInfo.getLocation() + "/..";
                    }
                    altDDName = altDDName.startsWith("/") ? appLoc + altDDName.trim() : appLoc + "/" + altDDName.trim();
                    Object[] objs = new Object[]{altDDName, wmName};
                    _logger.log(Level.INFO, "webcontainer.altDDName", objs);
                    ctx.setAltDDName(altDDName);
                }
                if (wbd.hasWebServices()) {
                    ctx.setHasWebServices(true);
                    WebServicesDescriptor webService = wbd.getWebServices();
                    Vector<String> endpointList = new Vector<String>();
                    for (WebServiceEndpoint wse : webService.getEndpoints()) {
                        if (wbd.getContextRoot() != null) {
                            endpointList.add(wbd.getContextRoot() + "/" + wse.getEndpointAddressUri());
                            continue;
                        }
                        endpointList.add(wse.getEndpointAddressUri());
                    }
                    Object[] endpointAddresses = new String[endpointList.size()];
                    endpointList.copyInto(endpointAddresses);
                    ctx.setEndpointAddresses((String[])endpointAddresses);
                } else {
                    ctx.setHasWebServices(false);
                }
            }
            SunWebApp iasBean = null;
            if (wbd != null) {
                iasBean = wbd.getSunDescriptor();
            }
            ctx.setIasWebAppConfigBean(iasBean);
            ctx.setID(wmName);
            this.configureMiscSettings(ctx, iasBean, vs, displayContextPath);
            if ("__default-web-module".equals(ctx.getID())) {
                ctx.setAlternateDocBases(vs.getProperties());
            }
            Loader loader = this.configureLoader(ctx, iasBean, wmInfo);
            if (wbd != null && wbd.hasWebServices()) {
                wbd.addExtraAttribute("WEBLOADER", (Object)loader);
            }
            if (this._reloadingEnabled) {
                // empty if block
            }
            ctx.configureSessionSettings(wbd, wmInfo);
            ctx.setI18nInfo();
            if (wbd != null) {
                NamingManager namingMgr;
                boolean isSystem;
                String resourceType = wmInfo.getObjectType();
                boolean bl = isSystem = resourceType != null && resourceType.startsWith("system-");
                if ("null".equals(j2eeApplication)) {
                    if (this.realm != null && this.realm instanceof RealmAdapterProxy) {
                        ((RealmAdapterProxy)this.realm).initializeRealm((Object)wbd, isSystem, vs.getAuthRealmName());
                        ctx.setRealm(this.realm);
                    }
                } else if (this.realm != null && this.realm instanceof RealmAdapterProxy) {
                    ((RealmAdapterProxy)this.realm).initializeRealm((Object)wbd, isSystem, null);
                    ctx.setRealm(this.realm);
                }
                if (wbd.getApplication() != null && wbd.getApplication().isVirtual()) {
                    wbd.visit((WebBundleVisitor)new WebValidatorWithoutCL());
                }
                if ((namingMgr = (NamingManager)this._serverContext.getDefaultHabitat().getComponent(NamingManager.class)) != null) {
                    Method m = namingMgr.getClass().getMethod("bindObjects", Object.class);
                    m.invoke((Object)namingMgr, wbd);
                }
            }
            this.addMimeMappings(ctx, vs.getMimeMap());
        }
        catch (Throwable ex) {
            exception = ex;
        }
        if (wbd != null && wbd.getApplication() != null) {
            String moduleName = wbd.getApplication().isVirtual() ? wbd.getApplication().getRegistrationName() : wbd.getModuleDescriptor().getArchiveUri();
            ctx.setModuleName(moduleName);
        } else {
            ctx.setModuleName("__default-web-module");
        }
        try {
            vs.addChild(ctx);
        }
        catch (Throwable ex) {
            exception = ex;
        }
        if (exception != null) {
            ctx.setAvailable(false);
            String msg = _rb.getString("webcontainer.webModuleDisabled");
            msg = MessageFormat.format(msg, wmName);
            _logger.log(Level.SEVERE, msg, exception);
            result = new Result(exception);
        } else {
            result = new Result((Object)ctx);
        }
        this.enableWSMonitoring(wbd, j2eeServer);
        return result;
    }

    protected void updateDefaultWebModule(VirtualServer virtualServer, int[] ports, String defaultContextPath) throws LifecycleException {
        if (defaultContextPath != null && !defaultContextPath.startsWith("/")) {
            defaultContextPath = "/" + defaultContextPath;
        }
        Connector[] connectors = this._embedded.findConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            PECoyoteConnector conn = (PECoyoteConnector)connectors[i];
            int port = conn.getPort();
            for (int j = 0; j < ports.length; ++j) {
                if (port != ports[j]) continue;
                Mapper mapper = conn.getMapper();
                try {
                    mapper.setDefaultContextPath(virtualServer.getName(), defaultContextPath);
                    continue;
                }
                catch (Exception e) {
                    throw new LifecycleException((Throwable)e);
                }
            }
        }
    }

    public ServerContext getServerContext() {
        return this._serverContext;
    }

    String getAppsWorkRoot() {
        return this._appsWorkRoot;
    }

    String getModulesWorkRoot() {
        return this._modulesWorkRoot;
    }

    private Loader configureLoader(WebModule ctx, SunWebApp bean, WebModuleConfig wmInfo) {
        com.sun.enterprise.deployment.runtime.web.ClassLoader clBean = null;
        V3WebappLoader loader = new V3WebappLoader(wmInfo.getAppClassLoader());
        loader.setUseMyFaces(ctx.isUseMyFaces());
        if (bean != null) {
            clBean = bean.getClassLoader();
        }
        if (clBean != null) {
            this.configureLoaderAttributes(loader, clBean, ctx);
            this.configureLoaderProperties(loader, clBean);
        } else {
            loader.setDelegate(true);
        }
        String stubPath = wmInfo.getStubPath();
        if (stubPath != null) {
            loader.addRepository("file:" + stubPath + File.separator);
        }
        this.addLibs(loader, ctx);
        String packagesName = System.getProperty("com.sun.enterprise.overrideablejavaxpackages");
        if (packagesName != null) {
            List overridablePackages = StringUtils.parseStringList((String)packagesName, (String)" ,");
            for (int i = 0; i < overridablePackages.size(); ++i) {
                loader.addOverridablePackage((String)overridablePackages.get(i));
            }
        }
        ctx.setLoader(loader);
        return loader;
    }

    private void configureMiscSettings(WebModule ctx, SunWebApp bean, VirtualServer vs, String contextPath) {
        boolean allowLinking = vs.getAllowLinking();
        if (bean != null && bean.sizeWebProperty() > 0) {
            WebProperty[] props = bean.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
                }
                if (name.equalsIgnoreCase("singleThreadedServletPoolSize")) {
                    int poolSize = ctx.getSTMPoolSize();
                    try {
                        poolSize = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        Object[] params = new Object[]{value, contextPath, Integer.toString(poolSize)};
                        _logger.log(Level.WARNING, "webcontainer.invalidServletPoolSize", params);
                    }
                    if (poolSize <= 0) continue;
                    ctx.setSTMPoolSize(poolSize);
                    continue;
                }
                if (name.equalsIgnoreCase("tempdir")) {
                    ctx.setWorkDir(value);
                    continue;
                }
                if (name.equalsIgnoreCase("crossContextAllowed")) {
                    boolean crossContext = Boolean.parseBoolean(value);
                    ctx.setCrossContext(crossContext);
                    continue;
                }
                if (name.equalsIgnoreCase("allowLinking")) {
                    allowLinking = ConfigBeansUtilities.toBoolean((String)value);
                    continue;
                }
                if (name.equalsIgnoreCase("reuseSessionID")) {
                    boolean reuse = ConfigBeansUtilities.toBoolean((String)value);
                    ctx.setReuseSessionID(reuse);
                    if (!reuse) continue;
                    Object[] params = new Object[]{contextPath, vs.getID()};
                    _logger.log(Level.WARNING, "webcontainer.sessionIDsReused", params);
                    continue;
                }
                if (name.equalsIgnoreCase("useResponseCTForHeaders")) {
                    if (!value.equalsIgnoreCase("true")) continue;
                    ctx.setResponseCTForHeaders();
                    continue;
                }
                if (name.equalsIgnoreCase("encodeCookies")) {
                    boolean flag = ConfigBeansUtilities.toBoolean((String)value);
                    ctx.setEncodeCookies(flag);
                    continue;
                }
                if (name.equalsIgnoreCase("relativeRedirectAllowed")) {
                    boolean relativeRedirect = ConfigBeansUtilities.toBoolean((String)value);
                    ctx.setAllowRelativeRedirect(relativeRedirect);
                    continue;
                }
                if (name.equalsIgnoreCase("fileEncoding")) {
                    ctx.setFileEncoding(value);
                    continue;
                }
                if (name.equalsIgnoreCase("enableTldValidation") && ConfigBeansUtilities.toBoolean((String)value)) {
                    ctx.setTldValidation(true);
                    continue;
                }
                if (name.equalsIgnoreCase("enableTldNamespaceAware") && ConfigBeansUtilities.toBoolean((String)value)) {
                    ctx.setTldNamespaceAware(true);
                    continue;
                }
                if (name.equalsIgnoreCase("securePagesWithPragma")) {
                    boolean securePagesWithPragma = ConfigBeansUtilities.toBoolean((String)value);
                    ctx.setSecurePagesWithPragma(securePagesWithPragma);
                    continue;
                }
                if (name.equalsIgnoreCase("useMyFaces")) {
                    ctx.setUseMyFaces(ConfigBeansUtilities.toBoolean((String)value));
                    continue;
                }
                if (name.startsWith("alternatedocroot_")) {
                    ctx.parseAlternateDocBase(name, value);
                    continue;
                }
                Object[] params = new Object[]{name, value};
                _logger.log(Level.WARNING, "webcontainer.invalidProperty", params);
            }
        }
        ctx.setAllowLinking(allowLinking);
    }

    public String getApplicationId(WebModule wm) {
        return wm.getID();
    }

    public String getModulesRoot() {
        return this._modulesRoot;
    }

    private String getPersistenceFrequency(SessionManager smBean) {
        String persistenceFrequency = null;
        ManagerProperties mgrBean = smBean.getManagerProperties();
        if (mgrBean != null && mgrBean.sizeWebProperty() > 0) {
            WebProperty[] props = mgrBean.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
                }
                if (!name.equalsIgnoreCase("persistenceFrequency")) continue;
                persistenceFrequency = value;
                break;
            }
        }
        return persistenceFrequency;
    }

    private String getPersistenceScope(SessionManager smBean) {
        String persistenceScope = null;
        StoreProperties storeBean = smBean.getStoreProperties();
        if (storeBean != null && storeBean.sizeWebProperty() > 0) {
            WebProperty[] props = storeBean.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
                }
                if (!name.equalsIgnoreCase("persistenceScope")) continue;
                persistenceScope = value;
                break;
            }
        }
        return persistenceScope;
    }

    public void unloadWebModule(String contextRoot, String appName, String virtualServers, WebBundleDescriptor wbd) {
        this.unloadWebModule(contextRoot, appName, virtualServers, wbd, false);
    }

    public void unloadWebModule(String contextRoot, String appName, String virtualServers, WebBundleDescriptor wbd, boolean dummy) {
        this.disableWSMonitoring(wbd);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("WebContainer.unloadWebModule(): contextRoot: " + contextRoot + " appName:" + appName);
        }
        this.cleanSecurityContext(appName);
        if (!contextRoot.equals("") && !contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        } else if ("/".equals(contextRoot)) {
            contextRoot = "";
        }
        Engine[] engines = this._embedded.getEngines();
        List hostList = StringUtils.parseStringList((String)virtualServers, (String)" ,");
        boolean unloadToAll = hostList == null || hostList.size() == 0;
        boolean hasBeenUndeployed = false;
        org.apache.catalina.Container[] hostArray = null;
        VirtualServer host = null;
        WebModule context = null;
        for (int j = 0; j < engines.length; ++j) {
            hostArray = engines[j].findChildren();
            for (int i = 0; i < hostArray.length; ++i) {
                WebModuleConfig wmInfo;
                host = (VirtualServer)hostArray[i];
                if (unloadToAll && host.getName().equalsIgnoreCase("__asadmin") || !unloadToAll && !hostList.contains(host.getName()) && !this.verifyAlias(hostList, host) || (context = (WebModule)host.findChild(contextRoot)) == null) continue;
                host.removeChild(context);
                try {
                    context.destroy();
                }
                catch (Exception ex) {
                    _logger.log(Level.WARNING, "[WebContainer] Context " + contextRoot + " threw exception in destroy()", ex);
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "[WebContainer] Context " + contextRoot + " undeployed from " + host);
                }
                hasBeenUndeployed = true;
                host.fireContainerEvent("remove", context);
                if (context.hasAdHocPaths() || context.hasAdHocSubtrees()) {
                    WebModule wm = this.createAdHocWebModule(host, contextRoot, context.getJ2EEApplication());
                    wm.addAdHocPaths(context.getAdHocPaths());
                    wm.addAdHocSubtrees(context.getAdHocSubtrees());
                }
                if (dummy || (wmInfo = host.createSystemDefaultWebModuleIfNecessary()) == null) continue;
                this.loadStandaloneWebModule(host, wmInfo);
            }
        }
        if (!hasBeenUndeployed) {
            _logger.log(Level.SEVERE, "[WebContainer] Undeployment failed for context " + contextRoot);
        }
    }

    public void enableWebModule(WebModuleConfig wmInfo, String j2eeApplication) {
        String vsIDs = wmInfo.getVirtualServers();
        List vsList = StringUtils.parseStringList((String)vsIDs, (String)" ,");
        boolean enabledToAll = vsList == null || vsList.size() == 0;
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            org.apache.catalina.Container[] vsArray = engines[j].findChildren();
            for (int i = 0; i < vsArray.length; ++i) {
                VirtualServer vs;
                if (!(vsArray[i] instanceof VirtualServer) || (vs = (VirtualServer)vsArray[i]).getID().equals("__asadmin") && enabledToAll || !enabledToAll && !vsList.contains(vs.getID()) && !this.verifyAlias(vsList, vs)) continue;
                this.loadWebModule(vs, wmInfo, j2eeApplication);
            }
        }
    }

    public void disableWebModule(String contextRoot, String appName, String virtualServers) {
        if (!contextRoot.equals("") && !contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        Engine[] engines = this._embedded.getEngines();
        List hostList = StringUtils.parseStringList((String)virtualServers, (String)" ,");
        boolean disableToAll = hostList == null || hostList.size() == 0;
        boolean hasBeenDisabled = false;
        org.apache.catalina.Container[] hostArray = null;
        VirtualServer host = null;
        Context context = null;
        for (int j = 0; j < engines.length; ++j) {
            hostArray = engines[j].findChildren();
            for (int i = 0; i < hostArray.length; ++i) {
                host = (VirtualServer)hostArray[i];
                if (disableToAll && host.getName().equalsIgnoreCase("__asadmin") || !disableToAll && !hostList.contains(host.getName()) && !this.verifyAlias(hostList, host) || (context = (Context)host.findChild(contextRoot)) == null) continue;
                context.setAvailable(false);
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "[WebContainer] Context " + contextRoot + " disabled from " + host);
                }
                hasBeenDisabled = true;
            }
        }
        if (!hasBeenDisabled) {
            _logger.log(Level.WARNING, "[WebContainer] moduleDisabled fail for context " + contextRoot);
        }
    }

    private void getDynamicReloadingSettings(DasConfig appsBean) {
        if (appsBean != null) {
            this._reloadingEnabled = Boolean.parseBoolean(appsBean.getDynamicReloadEnabled());
            String seconds = appsBean.getDynamicReloadPollIntervalInSeconds();
            if (seconds != null) {
                try {
                    this._pollInterval = Integer.parseInt(seconds);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private void setLogLevel(Level level) {
        this._logLevel = level;
        _logger.setLevel(this._logLevel);
        this._debug = level.equals(Level.FINE) ? 1 : (level.equals(Level.FINER) ? 2 : (level.equals(Level.FINEST) ? 5 : 0));
    }

    private void initLogLevel(LogService logserviceBean) {
        Level level = Level.SEVERE;
        this.setLogLevel(level);
        if (logserviceBean != null) {
            try {
                level = Level.parse(logserviceBean.getModuleLogLevels().getRoot());
                this.setLogLevel(level);
            }
            catch (NullPointerException e) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        try {
            Config config = (Config)this._serverContext.getDefaultHabitat().getComponent(Config.class);
            level = Level.parse(config.getMonitoringService().getModuleMonitoringLevels().getWebContainer());
            this.setLogLevel(level);
        }
        catch (NullPointerException e) {
            if (this._debug > 0) {
                _logger.finest("Defaulting <web-container> log-level");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this._debug > 0) {
            _logger.fine("Web container log level: " + this._logLevel);
        }
    }

    private void initMonitoringLevel(MonitoringService monitoringBean) {
        ModuleMonitoringLevels levels;
        monitoringLevel = MonitoringLevel.OFF;
        if (monitoringBean != null && (levels = monitoringBean.getModuleMonitoringLevels()) != null) {
            monitoringLevel = MonitoringLevel.instance((String)levels.getWebContainer());
        }
    }

    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    private void cleanSecurityContext(String appName) {
    }

    private void addMimeMappings(StandardContext ctx, MimeMap mimeMap) {
        if (mimeMap == null) {
            return;
        }
        Iterator itr = mimeMap.getExtensions();
        while (itr.hasNext()) {
            String extension = (String)itr.next();
            if (ctx.findMimeMapping(extension) != null) continue;
            ctx.addMimeMapping(extension, mimeMap.getType(extension));
        }
    }

    private void enableAllWSEndpoints() {
        List j2eeAppBeans = ConfigBeansUtilities.getModules(J2EeApplication.class, (Applications)this.domain.getApplications());
        for (J2EeApplication appBean : j2eeAppBeans) {
            if (!this.isReferenced(appBean.getName())) continue;
            this.enableWSMonitoring(appBean.getName());
        }
    }

    private boolean disableWSMonitoring(WebBundleDescriptor wbd) {
        boolean result = true;
        return true;
    }

    private boolean enableWSMonitoring(String id) {
        boolean result = true;
        return true;
    }

    void enableWSMonitoring(WebBundleDescriptor wbd, String serverName) {
    }

    void enableMonitoring(WebModule ctx, String vsId) {
    }

    protected void disableMonitoring(WebModule ctx, String vsId) {
    }

    private void setTldScan() {
        HashSet<String> tldJars = null;
        HashSet tldListeners = null;
        String prop = System.getProperty("com.sun.enterprise.taglibs");
        if (prop != null && prop.trim().length() > 0) {
            tldJars = new HashSet<String>(StringUtils.parseStringList((String)prop, (String)","));
        }
        if ((prop = System.getProperty("com.sun.enterprise.taglisteners")) != null && prop.trim().length() > 0) {
            tldListeners = new HashSet(StringUtils.parseStringList((String)prop, (String)","));
        }
        if (tldListeners != null && tldListeners.size() > 0) {
            TldConfig.setScanParentTldListener(true);
        }
        TldConfig.setTldListeners(tldListeners);
        TldLocationsCache.setTldJars(tldJars);
    }

    private boolean isReferenced(String appName) {
        Servers servers = this.domain.getServers();
        for (Server server : servers.getServer()) {
            if (!server.getName().equals(this._serverContext.getInstanceName())) continue;
            for (ApplicationRef ref : server.getApplicationRef()) {
                if (!ref.getRef().equals(appName)) continue;
                return true;
            }
        }
        return false;
    }

    private void registerServletStats(String j2eeApplication, String j2eeServer, String webModuleName, String vsId, String contextRoot, String servletName, MonitoringLevelListener listener) {
        PwcServletStatsImpl pwcServletStats = new PwcServletStatsImpl(this._serverContext.getDefaultDomainName(), vsId, contextRoot, servletName, j2eeApplication, j2eeServer);
        ServletStatsImpl servletStats = new ServletStatsImpl(pwcServletStats);
        MonitoringRegistry monitoringRegistry = (MonitoringRegistry)this._serverContext.getDefaultHabitat().getComponent(MonitoringRegistry.class);
        String app = "null".equalsIgnoreCase(j2eeApplication) ? null : j2eeApplication;
        try {
            monitoringRegistry.registerServletStats((ServletStats)servletStats, app, webModuleName, contextRoot, vsId, servletName, listener);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Exception during registration of servletstats", e);
        }
    }

    private void unregisterServletStats(String j2eeApplication, String webModuleName, String contextRoot, String vsId, String servletName) {
        MonitoringRegistry monitoringRegistry = (MonitoringRegistry)this._serverContext.getDefaultHabitat().getComponent(MonitoringRegistry.class);
        try {
            monitoringRegistry.unregisterServletStats(j2eeApplication, webModuleName, contextRoot, vsId, servletName);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Exception during unregistration of servletstats", e);
        }
    }

    private WebModuleStats registerWebModuleStats(String j2eeApplication, String j2eeServer, String vsId, WebModule ctx, MonitoringLevelListener listener) {
        WebContainerFeatureFactory webFeatureFac = (WebContainerFeatureFactory)this._serverContext.getDefaultHabitat().getComponent(WebContainerFeatureFactory.class);
        WebModuleStatsImpl webStats = (WebModuleStatsImpl)this.webFeatureFactory.getWebModuleStats();
        PwcWebModuleStatsImpl pwcWebStats = new PwcWebModuleStatsImpl(ctx.getObjectName(), ctx.getEncodedPath(), this._serverContext.getDefaultDomainName(), vsId, j2eeApplication, j2eeServer);
        webStats.setPwcWebModuleStats(pwcWebStats);
        webStats.setSessionManager(ctx.getManager());
        MonitoringRegistry monitoringRegistry = (MonitoringRegistry)this._serverContext.getDefaultHabitat().getComponent(MonitoringRegistry.class);
        String app = "null".equalsIgnoreCase(j2eeApplication) ? null : j2eeApplication;
        try {
            monitoringRegistry.registerWebModuleStats((WebModuleStats)webStats, app, ctx.getModuleName(), ctx.getEncodedPath(), vsId, listener);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Fail to register WebModuleStats for " + ctx.getModuleName() + " deployed on " + vsId, e);
        }
        return webStats;
    }

    private void unregisterWebModuleStats(String j2eeApplication, String webModuleName, String contextRoot, String vsId) {
        MonitoringRegistry monitoringRegistry = (MonitoringRegistry)this._serverContext.getDefaultHabitat().getComponent(MonitoringRegistry.class);
        try {
            monitoringRegistry.unregisterWebModuleStats(j2eeApplication, webModuleName, contextRoot, vsId);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Fail to unregister WebModuleStats for " + webModuleName + " deployed on " + vsId, e);
        }
    }

    public static WebContainer getInstance() {
        return webContainer;
    }

    public Engine[] getEngines() {
        return this._embedded.getEngines();
    }

    public void registerAdHocPath(String path, String ctxtRoot, String appName, AdHocServletInfo servletInfo) {
        this.registerAdHocPathAndSubtree(path, null, ctxtRoot, appName, servletInfo);
    }

    public void registerAdHocPathAndSubtree(String path, String subtree, String ctxtRoot, String appName, AdHocServletInfo servletInfo) {
        WebModule wm = null;
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            org.apache.catalina.Container[] vsList = engines[j].findChildren();
            for (int i = 0; i < vsList.length; ++i) {
                VirtualServer vs = (VirtualServer)vsList[i];
                if (vs.getName().equalsIgnoreCase("__asadmin")) continue;
                wm = (WebModule)vs.findChild(ctxtRoot);
                if (wm == null) {
                    wm = this.createAdHocWebModule(vs, ctxtRoot, appName);
                }
                wm.addAdHocPathAndSubtree(path, subtree, servletInfo);
            }
        }
    }

    public void unregisterAdHocPath(String path, String ctxtRoot) {
        this.unregisterAdHocPathAndSubtree(path, null, ctxtRoot);
    }

    public void unregisterAdHocPathAndSubtree(String path, String subtree, String ctxtRoot) {
        WebModule wm = null;
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            org.apache.catalina.Container[] vsList = engines[j].findChildren();
            for (int i = 0; i < vsList.length; ++i) {
                VirtualServer vs = (VirtualServer)vsList[i];
                if (vs.getName().equalsIgnoreCase("__asadmin") || (wm = (WebModule)vs.findChild(ctxtRoot)) == null) continue;
                wm.removeAdHocPath(path);
                wm.removeAdHocSubtree(subtree);
                if (!(wm instanceof AdHocWebModule) || wm.hasAdHocPaths() || wm.hasAdHocSubtrees()) continue;
                vs.removeChild(wm);
                try {
                    wm.destroy();
                    continue;
                }
                catch (Exception ex) {
                    _logger.log(Level.WARNING, "[WebContainer] Context " + wm.getPath() + " threw exception in destroy()", ex);
                }
            }
        }
    }

    private WebModule createAdHocWebModule(VirtualServer vs, String ctxtRoot, String appName) {
        AdHocWebModule wm = new AdHocWebModule(this);
        wm.setParentClassLoader(Thread.currentThread().getContextClassLoader());
        wm.setContextRoot(ctxtRoot);
        wm.setJ2EEApplication(appName);
        wm.setName(ctxtRoot);
        wm.setDocBase(vs.getAppBase());
        wm.setEngineName(vs.getParent().getName());
        String domain = this._serverContext.getDefaultDomainName();
        wm.setDomain(domain);
        String j2eeServer = this._serverContext.getInstanceName();
        wm.setJ2EEServer(j2eeServer);
        String server = domain + ":j2eeType=J2EEServer,name=" + j2eeServer;
        wm.setServer(server);
        wm.setCrossContext(true);
        vs.addChild(wm);
        return wm;
    }

    private void addLibs(Loader loader, WebModule ctx) {
        String list = ASClassLoaderUtil.getLibrariesForModule(this._serverContext.getDefaultHabitat(), WebModule.class, ctx.getID());
        if (list == null) {
            return;
        }
        String[] libs = list.split(",");
        if (libs == null) {
            return;
        }
        File libDir = new File(this.instance.getLibPath());
        String libDirPath = libDir.getAbsolutePath();
        String appLibsPrefix = libDirPath + File.separator + "applibs" + File.separator;
        for (int i = 0; i < libs.length; ++i) {
            try {
                URL url = new URL(libs[i]);
                loader.addRepository(libs[i]);
                continue;
            }
            catch (MalformedURLException e) {
                File file = new File(libs[i]);
                if (file.isAbsolute()) {
                    loader.addRepository("file:" + file.getAbsolutePath());
                    continue;
                }
                loader.addRepository("file:" + appLibsPrefix + libs[i]);
            }
        }
    }

    private void configureLoaderAttributes(Loader loader, com.sun.enterprise.deployment.runtime.web.ClassLoader clBean, WebModule ctx) {
        String[] pathElements;
        String value = clBean.getAttributeValue("Delegate");
        boolean delegate = ConfigBeansUtilities.toBoolean((String)value);
        loader.setDelegate(delegate);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("WebModule[" + ctx.getPath() + "]: Setting delegate to " + delegate);
        }
        if ((value = clBean.getAttributeValue("ExtraClassPath")) != null && (pathElements = value.split(";|((?<!\\\\):)")) != null) {
            for (String path : pathElements) {
                path = path.replace("\\:", ":");
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("WebModule[" + ctx.getPath() + "]: Adding " + path + " to the classpath");
                }
                try {
                    URL url = new URL(path);
                    loader.addRepository(path);
                }
                catch (MalformedURLException mue1) {
                    File file = new File(path);
                    if (!file.isAbsolute()) {
                        file = new File(ctx.getDocBase(), path);
                    }
                    try {
                        URL url = file.toURI().toURL();
                        loader.addRepository(url.toString());
                    }
                    catch (MalformedURLException mue2) {
                        String msg = _rb.getString("webcontainer.classpathError");
                        Object[] params = new Object[]{path};
                        msg = MessageFormat.format(msg, params);
                        _logger.log(Level.SEVERE, msg, mue2);
                    }
                }
            }
        }
        if ((value = clBean.getAttributeValue("DynamicReloadInterval")) != null) {
            _logger.log(Level.WARNING, "webcontainer.dynamicReloadInterval");
        }
    }

    private void configureLoaderProperties(Loader loader, com.sun.enterprise.deployment.runtime.web.ClassLoader clBean) {
        String name = null;
        String value = null;
        WebProperty[] props = clBean.getWebProperty();
        if (props == null || props.length == 0) {
            return;
        }
        for (int i = 0; i < props.length; ++i) {
            name = props[i].getAttributeValue("name");
            value = props[i].getAttributeValue("value");
            if (name == null || value == null) {
                throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
            }
            if (name.equalsIgnoreCase("ignoreHiddenJarFiles")) {
                loader.setIgnoreHiddenJarFiles(ConfigBeansUtilities.toBoolean((String)value));
                continue;
            }
            Object[] params = new Object[]{name, value};
            _logger.log(Level.WARNING, "webcontainer.invalidProperty", params);
        }
    }

    private String getInstanceClassPath(V3Environment instanceEnv) {
        if (instanceEnv == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        File libDir = new File(instanceEnv.getLibPath());
        String libDirPath = libDir.getAbsolutePath();
        sb.append(libDirPath + File.separator + "classes");
        sb.append(File.pathSeparator);
        String[] files = libDir.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".jar") && !files[i].endsWith(".zip")) continue;
                sb.append(libDirPath + File.separator + files[i]);
                sb.append(File.pathSeparator);
            }
        }
        return sb.toString();
    }

    String getInstanceClassPath() {
        return this.instanceClassPath;
    }

    void removeDummyModule(VirtualServer vs) {
        WebModule ctx = (WebModule)vs.findChild("");
        if (ctx != null && "__default-web-module".equals(ctx.getModuleName())) {
            this.unloadWebModule("", ctx.getJ2EEApplication(), vs.getName(), null, true);
        }
    }

    private void initInstanceSessionProperties() {
    }

    private static synchronized void setJspFactory() {
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory((JspFactory)new JspFactoryImpl());
        }
    }

    static {
        useDOLforDeployment = true;
        if (System.getProperty(DOL_DEPLOYMENT) != null) {
            useDOLforDeployment = Boolean.valueOf(System.getProperty(DOL_DEPLOYMENT));
        }
        debugMonitoring = false;
        debugMonitoringPeriodMS = 30000L;
        _timer = new WebContainerTimer();
    }
}

