/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.BytecodePreprocessor;
import com.sun.appserv.server.util.ASClassLoaderUtil;
import com.sun.appserv.web.cache.CacheManager;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.deployment.util.WebBundleVisitor;
import com.sun.enterprise.deployment.util.WebValidatorWithCL;
import com.sun.enterprise.loader.InstrumentableClassLoader;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.web.CacheModule;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.jsp.ResourceInjectorImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Wrapper;
import org.apache.catalina.loader.WebappClassLoader;
import org.glassfish.api.web.TldProvider;

final class WebModuleListener
implements LifecycleListener {
    private static Logger _logger;
    private static boolean _debugLog;
    private static final String JSF_HABITAT_ATTRIBUTE = "com.sun.appserv.jsf.habitat";
    private String instanceClassPath;
    private WebBundleDescriptor wbd;
    private String explodedLocation;
    private ServerContext serverContext;

    public WebModuleListener(ServerContext serverContext, String instanceClassPath, String explodedLocation, WebBundleDescriptor wbd) {
        this.serverContext = serverContext;
        this.instanceClassPath = instanceClassPath;
        this.wbd = wbd;
        this.explodedLocation = explodedLocation;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        WebModule webModule;
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
            _debugLog = _logger.isLoggable(Level.FINE);
        }
        try {
            webModule = (WebModule)event.getLifecycle();
        }
        catch (ClassCastException e) {
            _logger.log(Level.WARNING, "webmodule.listener.classcastException", event.getLifecycle());
            return;
        }
        if (event.getType().equals("start")) {
            if (this.wbd != null && this.wbd.getApplication() != null && this.wbd.getApplication().isVirtual()) {
                this.wbd.setClassLoader(webModule.getLoader().getClassLoader());
                this.wbd.visit((WebBundleVisitor)new WebValidatorWithCL());
            }
            this.configureDefaultServlet(webModule);
            this.configureJspParameters(webModule);
            this.startCacheManager(webModule);
        } else if (event.getType().equals("stop")) {
            this.stopCacheManager(webModule);
        }
    }

    private void configureJspParameters(WebModule webModule) {
        Collection tldProviders = this.serverContext.getDefaultHabitat().getAllByContract(TldProvider.class);
        ArrayList<URL> tldURLs = new ArrayList<URL>();
        for (TldProvider tldProvider : tldProviders) {
            URL[] urls = tldProvider.getTldURLs();
            if (urls == null || urls.length <= 0) continue;
            for (URL url : urls) {
                tldURLs.add(url);
            }
        }
        webModule.getServletContext().setAttribute("com.sun.appserv.tld.urls", tldURLs);
        webModule.getServletContext().setAttribute(JSF_HABITAT_ATTRIBUTE, (Object)this.serverContext.getDefaultHabitat());
        SunWebApp bean = webModule.getIasWebAppConfigBean();
        String name = webModule.findServletMapping("*.jsp");
        Wrapper wrapper = (Wrapper)webModule.findChild(name);
        if (wrapper == null) {
            return;
        }
        String servletClass = wrapper.getServletClass();
        if (servletClass != null && servletClass.equals("org.apache.jasper.servlet.JspServlet")) {
            if (webModule.getTldValidation()) {
                wrapper.addInitParameter("enableTldValidation", "true");
            }
            if (bean != null && bean.getJspConfig() != null) {
                WebProperty[] props = bean.getJspConfig().getWebProperty();
                for (int i = 0; i < props.length; ++i) {
                    String pname = props[i].getAttributeValue("name");
                    String pvalue = props[i].getAttributeValue("value");
                    if (_debugLog) {
                        _logger.fine("jsp-config property for [" + webModule.getID() + "] is [" + pname + "] = [" + pvalue + "]");
                    }
                    wrapper.addInitParameter(pname, pvalue);
                }
            }
            wrapper.addInitParameter("logVerbosityLevel", this.getJasperLogLevel());
            wrapper.addInitParameter("com.sun.appserv.jsp.resource.injector", ResourceInjectorImpl.class.getName());
            String sysClassPath = ASClassLoaderUtil.getWebModuleClassPath(this.serverContext.getDefaultHabitat(), webModule.getID());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(" sysClasspath for " + webModule.getID() + " is \n" + sysClassPath + "\n");
            }
            if (this.instanceClassPath != null && this.instanceClassPath.length() > 0) {
                sysClassPath = sysClassPath + this.instanceClassPath;
            }
            wrapper.addInitParameter("com.sun.appserv.jsp.classpath", sysClassPath);
        }
    }

    private String getJasperLogLevel() {
        Level level = _logger.getLevel();
        if (level == null) {
            return "warning";
        }
        if (level.equals(Level.WARNING)) {
            return "warning";
        }
        if (level.equals(Level.FINE)) {
            return "information";
        }
        if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            return "debug";
        }
        return "warning";
    }

    private void startCacheManager(WebModule webModule) {
        SunWebApp bean = webModule.getIasWebAppConfigBean();
        if (bean != null) {
            CacheManager cm = null;
            try {
                cm = CacheModule.configureResponseCache(webModule, bean);
            }
            catch (Exception ee) {
                _logger.log(Level.WARNING, "webmodule.listener.cachemgrException", ee);
            }
            if (cm != null) {
                try {
                    cm.start();
                    if (_debugLog) {
                        _logger.fine("Cache Manager started");
                    }
                    ServletContext ctxt = webModule.getServletContext();
                    ctxt.setAttribute("com.sun.appserv.web.CacheManager", (Object)cm);
                }
                catch (LifecycleException ee) {
                    _logger.log(Level.WARNING, ee.getMessage(), ee.getThrowable());
                }
            }
        }
    }

    private void stopCacheManager(WebModule webModule) {
        ServletContext ctxt = webModule.getServletContext();
        CacheManager cm = (CacheManager)ctxt.getAttribute("com.sun.appserv.web.CacheManager");
        if (cm != null) {
            try {
                cm.stop();
                if (_debugLog) {
                    _logger.fine("Cache Manager stopped");
                }
                ctxt.removeAttribute("com.sun.appserv.web.CacheManager");
            }
            catch (LifecycleException ee) {
                _logger.log(Level.WARNING, ee.getMessage(), ee.getThrowable());
            }
        }
    }

    private void configureDefaultServlet(WebModule webModule) {
        Wrapper wrapper = (Wrapper)webModule.findChild("default");
        if (wrapper == null) {
            return;
        }
        String servletClass = wrapper.getServletClass();
        if (servletClass == null || !servletClass.equals(Globals.DEFAULT_SERVLET_CLASS_NAME)) {
            return;
        }
        String fileEncoding = webModule.getFileEncoding();
        if (fileEncoding != null) {
            wrapper.addInitParameter("fileEncoding", fileEncoding);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InstrumentableWebappClassLoader
    extends ClassLoader
    implements InstrumentableClassLoader {
        private final WebappClassLoader webappClassLoader;

        public InstrumentableWebappClassLoader(WebappClassLoader webappClassLoader) {
            super(webappClassLoader.getParent());
            this.webappClassLoader = webappClassLoader;
        }

        public ClassLoader copy() {
            _logger.entering("WebModuleListener$InstrumentableWebappClassLoader", "copy");
            return new URLClassLoader(this.webappClassLoader.getURLs(), this.getParent());
        }

        public void addTransformer(final ClassFileTransformer transformer) {
            this.webappClassLoader.addByteCodePreprocessor(new BytecodePreprocessor(){

                public boolean initialize(Hashtable parameters) {
                    return true;
                }

                public byte[] preprocess(String resourceName, byte[] classBytes) {
                    try {
                        String classname = resourceName.substring(0, resourceName.length() - 6);
                        byte[] newBytes = transformer.transform((ClassLoader)InstrumentableWebappClassLoader.this.webappClassLoader, classname, null, null, classBytes);
                        return newBytes == null ? classBytes : newBytes;
                    }
                    catch (IllegalClassFormatException e) {
                        _logger.logp(Level.WARNING, "WebModuleListener$InstrumentableClassLoader$BytecodePreprocessor", "preprocess", e.getMessage());
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.webappClassLoader.loadClass(name);
        }

        @Override
        public URL getResource(String name) {
            return this.webappClassLoader.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.webappClassLoader.getResources(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return this.webappClassLoader.getResourceAsStream(name);
        }

        @Override
        public synchronized void setDefaultAssertionStatus(boolean enabled) {
            this.webappClassLoader.setDefaultAssertionStatus(enabled);
        }

        @Override
        public synchronized void setPackageAssertionStatus(String packageName, boolean enabled) {
            this.webappClassLoader.setPackageAssertionStatus(packageName, enabled);
        }

        @Override
        public synchronized void setClassAssertionStatus(String className, boolean enabled) {
            this.webappClassLoader.setClassAssertionStatus(className, enabled);
        }

        @Override
        public synchronized void clearAssertionStatus() {
            this.webappClassLoader.clearAssertionStatus();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("InstrumentableWebappClassLoader\r\n");
            sb.append(" Parent -> ");
            sb.append(this.webappClassLoader);
            return sb.toString();
        }
    }
}

