/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import com.sun.org.apache.commons.modeler.ManagedBean;
import com.sun.org.apache.commons.modeler.Registry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.TreeMap;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.naming.directory.DirContext;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Auditor;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.AlternateDocBase;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardContextValve;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.FilterMaps;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.MessageDestination;
import org.apache.catalina.deploy.MessageDestinationRef;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.deploy.ResourceParams;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.deploy.ServletMap;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.TldConfig;
import org.apache.catalina.util.CharsetMapper;
import org.apache.catalina.util.ExtensionValidator;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.URLEncoder;
import org.apache.naming.ContextBindings;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.WARDirContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardContext
extends ContainerBase
implements Context,
Serializable {
    private static transient Log log = LogFactory.getLog(StandardContext.class);
    private static final ClassLoader standardContextClassLoader = StandardContext.class.getClassLoader();
    private String altDDName = null;
    private String hostName;
    private String[] applicationListeners = new String[0];
    private transient Object[] applicationEventListenersObjects = new Object[0];
    private transient Object[] applicationLifecycleListenersObjects = new Object[0];
    private ApplicationParameter[] applicationParameters = new ApplicationParameter[0];
    private boolean available = false;
    private NotificationBroadcasterSupport broadcaster = null;
    private transient CharsetMapper charsetMapper = null;
    private String charsetMapperClass = "org.apache.catalina.util.CharsetMapper";
    private String configFile = null;
    private boolean configured = false;
    private SecurityConstraint[] constraints = new SecurityConstraint[0];
    protected transient ApplicationContext context = null;
    private String compilerClasspath = null;
    private boolean cookies = true;
    private boolean crossContext = false;
    private boolean delegate = false;
    private String displayName = null;
    private String defaultWebXml;
    private boolean distributable = false;
    private String docBase = null;
    private HashMap exceptionPages = new HashMap();
    private HashMap filterConfigs = new HashMap();
    private HashMap filterDefs = new HashMap();
    private FilterMap[] filterMaps = new FilterMap[0];
    private static final String info = "org.apache.catalina.core.StandardContext/1.0";
    private String[] instanceListeners = new String[0];
    private LoginConfig loginConfig = null;
    private transient Mapper mapper = new Mapper();
    private transient NamingContextListener namingContextListener = null;
    private NamingResources namingResources = new NamingResources();
    private HashMap messageDestinations = new HashMap();
    private HashMap<String, String> mimeMappings = new HashMap();
    private HashMap parameters = new HashMap();
    private boolean paused = false;
    private String publicId = null;
    private boolean reloadable = false;
    private boolean unpackWAR = true;
    private boolean override = false;
    private boolean privileged = false;
    private boolean replaceWelcomeFiles = false;
    private boolean securePagesWithPragma = true;
    private HashMap roleMappings = new HashMap();
    private String[] securityRoles = new String[0];
    private HashMap servletMappings = new HashMap();
    private int sessionTimeout = 30;
    private boolean sessionTimeoutOveridden = false;
    private long sequenceNumber = 0L;
    private HashMap statusPages = new HashMap();
    private boolean swallowOutput = false;
    private HashMap taglibs = new HashMap();
    private String[] welcomeFiles = new String[0];
    private String[] wrapperLifecycles = new String[0];
    private String[] wrapperListeners = new String[0];
    private String workDir = null;
    private String wrapperClassName = StandardWrapper.class.getName();
    private Class wrapperClass = null;
    private boolean useNaming = true;
    private boolean filesystemBased = false;
    private String namingContextName = null;
    private int managerChecksFrequency = 6;
    private int count = 0;
    private boolean cachingAllowed = true;
    protected boolean caseSensitive = true;
    protected boolean allowLinking = false;
    protected int cacheMaxSize = 10240;
    protected int cacheTTL = 5000;
    private boolean lazy = true;
    private transient DirContext webappResources = null;
    private long startupTime;
    private long startTimeMillis;
    private long tldScanTime;
    protected boolean caseSensitiveMapping = true;
    private boolean reuseSessionID = false;
    private boolean allowRelativeRedirect = false;
    private String engineName = null;
    private String j2EEApplication = "null";
    private String j2EEServer = "none";
    private transient Auditor[] auditors = null;
    private static int instanceIDCounter = 1;
    private boolean webXmlValidation = false;
    private boolean webXmlNamespaceAware = false;
    private boolean tldValidation = false;
    private boolean tldNamespaceAware = false;
    protected boolean isJsfApplication = false;
    private boolean saveConfig = true;
    protected static final URLEncoder urlEncoder = new URLEncoder();
    private boolean isReload = false;
    private ArrayList<AlternateDocBase> alternateDocBases = null;
    private boolean useMyFaces;
    private String encodedPath = null;
    private String server = null;
    private String[] javaVMs = null;

    public StandardContext() {
        this.pipeline.setBasic(new StandardContextValve());
        this.namingResources.setContainer(this);
        this.broadcaster = new NotificationBroadcasterSupport();
    }

    public void restrictedSetPipeline(Pipeline pl) {
        pl.setBasic(new StandardContextValve());
        this.pipeline = pl;
    }

    @Override
    public String getEncodedPath() {
        return this.encodedPath;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.encodedPath = urlEncoder.encode(name);
    }

    public boolean isSaveConfig() {
        return this.saveConfig;
    }

    public void setSaveConfig(boolean saveConfig) {
        this.saveConfig = saveConfig;
    }

    public boolean isCachingAllowed() {
        return this.cachingAllowed;
    }

    public void setCachingAllowed(boolean cachingAllowed) {
        this.cachingAllowed = cachingAllowed;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitiveMapping(boolean caseSensitiveMap) {
        this.caseSensitiveMapping = caseSensitiveMap;
    }

    public boolean isCaseSensitiveMapping() {
        return this.caseSensitiveMapping;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public boolean isAllowLinking() {
        return this.allowLinking;
    }

    public void setCacheTTL(int cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public int getCacheTTL() {
        return this.cacheTTL;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        boolean oldDelegate = this.delegate;
        this.delegate = delegate;
        this.support.firePropertyChange("delegate", (Object)oldDelegate, (Object)this.delegate);
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean useNaming) {
        this.useNaming = useNaming;
    }

    public boolean isFilesystemBased() {
        return this.filesystemBased;
    }

    @Override
    public Object[] getApplicationEventListeners() {
        return this.applicationEventListenersObjects;
    }

    @Override
    public void setApplicationEventListeners(Object[] listeners) {
        this.applicationEventListenersObjects = listeners;
    }

    @Override
    public Object[] getApplicationLifecycleListeners() {
        return this.applicationLifecycleListenersObjects;
    }

    @Override
    public void setApplicationLifecycleListeners(Object[] listeners) {
        this.applicationLifecycleListenersObjects = listeners;
    }

    @Override
    public boolean getAvailable() {
        return this.available;
    }

    @Override
    public void setAvailable(boolean available) {
        boolean oldAvailable = this.available;
        this.available = available;
        this.support.firePropertyChange("available", (Object)oldAvailable, (Object)this.available);
    }

    @Override
    public CharsetMapper getCharsetMapper() {
        if (this.charsetMapper == null) {
            try {
                Class<?> clazz = Class.forName(this.charsetMapperClass);
                this.charsetMapper = (CharsetMapper)clazz.newInstance();
            }
            catch (Throwable t) {
                this.charsetMapper = new CharsetMapper();
            }
        }
        return this.charsetMapper;
    }

    @Override
    public void setCharsetMapper(CharsetMapper mapper) {
        CharsetMapper oldCharsetMapper = this.charsetMapper;
        this.charsetMapper = mapper;
        if (mapper != null) {
            this.charsetMapperClass = mapper.getClass().getName();
        }
        this.support.firePropertyChange("charsetMapper", oldCharsetMapper, this.charsetMapper);
    }

    @Override
    public String getConfigFile() {
        return this.configFile;
    }

    @Override
    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    @Override
    public boolean getConfigured() {
        return this.configured;
    }

    @Override
    public void setConfigured(boolean configured) {
        boolean oldConfigured = this.configured;
        this.configured = configured;
        this.support.firePropertyChange("configured", (Object)oldConfigured, (Object)this.configured);
    }

    @Override
    public boolean getCookies() {
        return this.cookies;
    }

    @Override
    public void setCookies(boolean cookies) {
        boolean oldCookies = this.cookies;
        this.cookies = cookies;
        this.support.firePropertyChange("cookies", (Object)oldCookies, (Object)this.cookies);
    }

    @Override
    public boolean getCrossContext() {
        return this.crossContext;
    }

    @Override
    public void setCrossContext(boolean crossContext) {
        boolean oldCrossContext = this.crossContext;
        this.crossContext = crossContext;
        this.support.firePropertyChange("crossContext", (Object)oldCrossContext, (Object)this.crossContext);
    }

    public String getDefaultWebXml() {
        return this.defaultWebXml;
    }

    public void setDefaultWebXml(String defaultWebXml) {
        this.defaultWebXml = defaultWebXml;
    }

    public long getStartupTime() {
        return this.startupTime;
    }

    public void setStartupTime(long startupTime) {
        this.startupTime = startupTime;
    }

    public long getTldScanTime() {
        return this.tldScanTime;
    }

    public void setTldScanTime(long tldScanTime) {
        this.tldScanTime = tldScanTime;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getAltDDName() {
        return this.altDDName;
    }

    @Override
    public void setAltDDName(String altDDName) {
        this.altDDName = altDDName;
        if (this.context != null) {
            this.context.setAttribute("org.apache.catalina.deploy.alt_dd", altDDName);
            this.context.setAttributeReadOnly("org.apache.catalina.deploy.alt_dd");
        }
    }

    public String getCompilerClasspath() {
        return this.compilerClasspath;
    }

    public void setCompilerClasspath(String compilerClasspath) {
        this.compilerClasspath = compilerClasspath;
    }

    @Override
    public void setDisplayName(String displayName) {
        String oldDisplayName = this.displayName;
        this.displayName = displayName;
        this.support.firePropertyChange("displayName", oldDisplayName, this.displayName);
    }

    @Override
    public boolean getDistributable() {
        return this.distributable;
    }

    @Override
    public void setDistributable(boolean distributable) {
        boolean oldDistributable = this.distributable;
        this.distributable = distributable;
        this.support.firePropertyChange("distributable", (Object)oldDistributable, (Object)this.distributable);
        if (this.getManager() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Propagating distributable=" + distributable + " to manager"));
            }
            this.getManager().setDistributable(distributable);
        }
    }

    @Override
    public String getDocBase() {
        return this.docBase;
    }

    @Override
    public void setDocBase(String docBase) {
        this.docBase = docBase;
    }

    public void addAlternateDocBase(String urlPattern, String docBase) {
        if (urlPattern == null || docBase == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.alternateDocBase.missingPathOrUrlPattern"));
        }
        AlternateDocBase alternateDocBase = new AlternateDocBase();
        alternateDocBase.setUrlPattern(urlPattern);
        alternateDocBase.setDocBase(docBase);
        alternateDocBase.setBasePath(this.getBasePath(docBase));
        if (this.alternateDocBases == null) {
            this.alternateDocBases = new ArrayList();
        }
        this.alternateDocBases.add(alternateDocBase);
    }

    public ArrayList<AlternateDocBase> getAlternateDocBases() {
        return this.alternateDocBases;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public int getManagerChecksFrequency() {
        return this.managerChecksFrequency;
    }

    public void setManagerChecksFrequency(int managerChecksFrequency) {
        if (managerChecksFrequency <= 0) {
            return;
        }
        int oldManagerChecksFrequency = this.managerChecksFrequency;
        this.managerChecksFrequency = managerChecksFrequency;
        this.support.firePropertyChange("managerChecksFrequency", (Object)oldManagerChecksFrequency, (Object)this.managerChecksFrequency);
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getEngineName() {
        if (this.engineName != null) {
            return this.engineName;
        }
        return this.domain;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public String getJ2EEApplication() {
        return this.j2EEApplication;
    }

    public void setJ2EEApplication(String j2EEApplication) {
        this.j2EEApplication = j2EEApplication;
    }

    public String getJ2EEServer() {
        return this.j2EEServer;
    }

    public void setJ2EEServer(String j2EEServer) {
        this.j2EEServer = j2EEServer;
    }

    @Override
    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    @Override
    public void setLoginConfig(LoginConfig config) {
        String errorPage;
        if (config == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.loginConfig.required"));
        }
        String loginPage = config.getLoginPage();
        if (loginPage != null && !loginPage.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("standardContext.loginConfig.loginWarning", loginPage));
                }
                config.setLoginPage("/" + loginPage);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.loginConfig.loginPage", loginPage));
            }
        }
        if ((errorPage = config.getErrorPage()) != null && !errorPage.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("standardContext.loginConfig.errorWarning", errorPage));
                }
                config.setErrorPage("/" + errorPage);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.loginConfig.errorPage", errorPage));
            }
        }
        LoginConfig oldLoginConfig = this.loginConfig;
        this.loginConfig = config;
        this.support.firePropertyChange("loginConfig", oldLoginConfig, this.loginConfig);
    }

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    @Override
    public NamingResources getNamingResources() {
        return this.namingResources;
    }

    @Override
    public void setNamingResources(NamingResources namingResources) {
        NamingResources oldNamingResources = this.namingResources;
        this.namingResources = namingResources;
        this.support.firePropertyChange("namingResources", oldNamingResources, this.namingResources);
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    @Override
    public void setPath(String path) {
        this.setName(RequestUtil.URLDecode(path, "UTF-8"));
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public void setPublicId(String publicId) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Setting deployment descriptor public ID to '" + publicId + "'"));
        }
        String oldPublicId = this.publicId;
        this.publicId = publicId;
        this.support.firePropertyChange("publicId", oldPublicId, publicId);
    }

    @Override
    public boolean getReloadable() {
        return this.reloadable;
    }

    @Override
    public boolean getOverride() {
        return this.override;
    }

    @Override
    public boolean getPrivileged() {
        return this.privileged;
    }

    @Override
    public void setPrivileged(boolean privileged) {
        boolean oldPrivileged = this.privileged;
        this.privileged = privileged;
        this.support.firePropertyChange("privileged", (Object)oldPrivileged, (Object)this.privileged);
    }

    @Override
    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", (Object)oldReloadable, (Object)this.reloadable);
    }

    @Override
    public void setOverride(boolean override) {
        boolean oldOverride = this.override;
        this.override = override;
        this.support.firePropertyChange("override", (Object)oldOverride, (Object)this.override);
    }

    @Override
    public boolean isJsfApplication() {
        return this.isJsfApplication;
    }

    @Override
    public boolean hasAdHocPaths() {
        return false;
    }

    @Override
    public String getAdHocServletName(String path) {
        return null;
    }

    public boolean isReplaceWelcomeFiles() {
        return this.replaceWelcomeFiles;
    }

    public void setReplaceWelcomeFiles(boolean replaceWelcomeFiles) {
        boolean oldReplaceWelcomeFiles = this.replaceWelcomeFiles;
        this.replaceWelcomeFiles = replaceWelcomeFiles;
        this.support.firePropertyChange("replaceWelcomeFiles", (Object)oldReplaceWelcomeFiles, (Object)this.replaceWelcomeFiles);
    }

    @Override
    public boolean isSecurePagesWithPragma() {
        return this.securePagesWithPragma;
    }

    @Override
    public void setSecurePagesWithPragma(boolean securePagesWithPragma) {
        boolean oldSecurePagesWithPragma = this.securePagesWithPragma;
        this.securePagesWithPragma = securePagesWithPragma;
        this.support.firePropertyChange("securePagesWithPragma", (Object)oldSecurePagesWithPragma, (Object)this.securePagesWithPragma);
    }

    public void setUseMyFaces(boolean useMyFaces) {
        this.useMyFaces = useMyFaces;
    }

    public boolean isUseMyFaces() {
        return this.useMyFaces;
    }

    @Override
    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new ApplicationContext(this.getBasePath(this.getDocBase()), this.getAlternateDocBases(), this);
            if (this.altDDName != null && this.context.getAttribute("org.apache.catalina.deploy.alt_dd") == null) {
                this.context.setAttribute("org.apache.catalina.deploy.alt_dd", this.altDDName);
                this.context.setAttributeReadOnly("org.apache.catalina.deploy.alt_dd");
            }
        }
        return this.context.getFacade();
    }

    @Override
    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public boolean isSessionTimeoutOveridden() {
        return this.sessionTimeoutOveridden;
    }

    @Override
    public void setSessionTimeout(int timeout) {
        int oldSessionTimeout = this.sessionTimeout;
        this.sessionTimeout = timeout == 0 ? -1 : timeout;
        this.support.firePropertyChange("sessionTimeout", (Object)oldSessionTimeout, (Object)this.sessionTimeout);
        this.sessionTimeoutOveridden = true;
    }

    public boolean getSwallowOutput() {
        return this.swallowOutput;
    }

    public void setSwallowOutput(boolean swallowOutput) {
        boolean oldSwallowOutput = this.swallowOutput;
        this.swallowOutput = swallowOutput;
        this.support.firePropertyChange("swallowOutput", (Object)oldSwallowOutput, (Object)this.swallowOutput);
    }

    public boolean getUnpackWAR() {
        return this.unpackWAR;
    }

    public void setUnpackWAR(boolean unpackWAR) {
        this.unpackWAR = unpackWAR;
    }

    @Override
    public String getWrapperClass() {
        return this.wrapperClassName;
    }

    @Override
    public void setWrapperClass(String wrapperClassName) {
        this.wrapperClassName = wrapperClassName;
        try {
            this.wrapperClass = Class.forName(wrapperClassName);
            if (!StandardWrapper.class.isAssignableFrom(this.wrapperClass)) {
                throw new IllegalArgumentException(sm.getString("standardContext.invalidWrapperClass", wrapperClassName));
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException(cnfe);
        }
    }

    @Override
    public synchronized void setResources(DirContext resources) {
        if (this.started) {
            throw new IllegalStateException(sm.getString("standardContext.resources.started"));
        }
        DirContext oldResources = this.webappResources;
        if (oldResources == resources) {
            return;
        }
        if (resources instanceof BaseDirContext) {
            ((BaseDirContext)resources).setCached(this.isCachingAllowed());
            ((BaseDirContext)resources).setCacheTTL(this.getCacheTTL());
            ((BaseDirContext)resources).setCacheMaxSize(this.getCacheMaxSize());
        }
        if (resources instanceof FileDirContext) {
            this.filesystemBased = true;
            ((FileDirContext)resources).setCaseSensitive(this.isCaseSensitive());
            ((FileDirContext)resources).setAllowLinking(this.isAllowLinking());
        }
        this.webappResources = resources;
        this.resources = null;
        this.support.firePropertyChange("resources", oldResources, this.webappResources);
    }

    private synchronized void setAlternateResources(AlternateDocBase alternateDocBase, DirContext resources) {
        if (this.started) {
            throw new IllegalStateException(sm.getString("standardContext.resources.started"));
        }
        DirContext oldResources = alternateDocBase.getWebappResources();
        if (oldResources == resources) {
            return;
        }
        if (resources instanceof BaseDirContext) {
            ((BaseDirContext)resources).setCached(this.isCachingAllowed());
            ((BaseDirContext)resources).setCacheTTL(this.getCacheTTL());
            ((BaseDirContext)resources).setCacheMaxSize(this.getCacheMaxSize());
        }
        if (resources instanceof FileDirContext) {
            this.filesystemBased = true;
            ((FileDirContext)resources).setCaseSensitive(this.isCaseSensitive());
            ((FileDirContext)resources).setAllowLinking(this.isAllowLinking());
        }
        alternateDocBase.setWebappResources(resources);
        alternateDocBase.setResources(null);
    }

    @Override
    public boolean getReuseSessionID() {
        return this.reuseSessionID;
    }

    @Override
    public void setReuseSessionID(boolean reuse) {
        this.reuseSessionID = reuse;
    }

    @Override
    public boolean getAllowRelativeRedirect() {
        return this.allowRelativeRedirect;
    }

    @Override
    public void setAllowRelativeRedirect(boolean allowRelativeURLs) {
        this.allowRelativeRedirect = allowRelativeURLs;
    }

    @Override
    public Auditor[] getAuditors() {
        return this.auditors;
    }

    @Override
    public void setAuditors(Auditor[] auditor) {
        this.auditors = auditor;
    }

    public void setReload(boolean isReload) {
        this.isReload = isReload;
    }

    public boolean isReload() {
        return this.isReload;
    }

    public String getCharsetMapperClass() {
        return this.charsetMapperClass;
    }

    public void setCharsetMapperClass(String mapper) {
        String oldCharsetMapperClass = this.charsetMapperClass;
        this.charsetMapperClass = mapper;
        this.support.firePropertyChange("charsetMapperClass", oldCharsetMapperClass, this.charsetMapperClass);
    }

    public String getWorkPath() {
        File workDir = new File(this.getWorkDir());
        if (!workDir.isAbsolute()) {
            File catalinaHome = this.engineBase();
            String catalinaHomePath = null;
            try {
                catalinaHomePath = catalinaHome.getCanonicalPath();
                workDir = new File(catalinaHomePath, this.getWorkDir());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return workDir.getAbsolutePath();
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
        if (this.started) {
            this.postWorkDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplicationListener(String listener) {
        String[] stringArray = this.applicationListeners;
        synchronized (this.applicationListeners) {
            String[] results = new String[this.applicationListeners.length + 1];
            if ("com.sun.faces.config.ConfigureListener".equals(listener)) {
                for (int i = 0; i < this.applicationListeners.length; ++i) {
                    if (listener.equals(this.applicationListeners[i])) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    results[i + 1] = this.applicationListeners[i];
                }
                results[0] = listener;
            } else {
                for (int i = 0; i < this.applicationListeners.length; ++i) {
                    if (listener.equals(this.applicationListeners[i])) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    results[i] = this.applicationListeners[i];
                }
                results[this.applicationListeners.length] = listener;
            }
            this.applicationListeners = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("addApplicationListener", listener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplicationParameter(ApplicationParameter parameter) {
        ApplicationParameter[] applicationParameterArray = this.applicationParameters;
        synchronized (this.applicationParameters) {
            String newName = parameter.getName();
            for (int i = 0; i < this.applicationParameters.length; ++i) {
                if (!newName.equals(this.applicationParameters[i].getName()) || this.applicationParameters[i].getOverride()) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            ApplicationParameter[] results = new ApplicationParameter[this.applicationParameters.length + 1];
            System.arraycopy(this.applicationParameters, 0, results, 0, this.applicationParameters.length);
            results[this.applicationParameters.length] = parameter;
            this.applicationParameters = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("addApplicationParameter", parameter);
            }
            return;
        }
    }

    @Override
    public void addChild(Container child) {
        String jspFile;
        Wrapper oldJspServlet = null;
        if (!(child instanceof Wrapper)) {
            throw new IllegalArgumentException(sm.getString("standardContext.notWrapper"));
        }
        Wrapper wrapper = (Wrapper)child;
        boolean isJspServlet = "jsp".equals(child.getName());
        if (isJspServlet && (oldJspServlet = (Wrapper)this.findChild("jsp")) != null) {
            this.removeChild(oldJspServlet);
        }
        if ((jspFile = wrapper.getJspFile()) != null && !jspFile.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("standardContext.wrapper.warning", jspFile));
                }
                wrapper.setJspFile("/" + jspFile);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.wrapper.error", jspFile));
            }
        }
        super.addChild(child);
        if (this.getAvailable() && wrapper instanceof StandardWrapper) {
            ((StandardWrapper)wrapper).registerJMX(this);
        }
        if (isJspServlet && oldJspServlet != null) {
            String[] jspMappings = oldJspServlet.findMappings();
            for (int i = 0; jspMappings != null && i < jspMappings.length; ++i) {
                this.addServletMapping(jspMappings[i], child.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConstraint(SecurityConstraint constraint) {
        SecurityCollection[] collections = constraint.findCollections();
        for (int i = 0; i < collections.length; ++i) {
            String[] patterns = collections[i].findPatterns();
            for (int j = 0; j < patterns.length; ++j) {
                patterns[j] = this.adjustURLPattern(patterns[j]);
                if (this.validateURLPattern(patterns[j])) continue;
                throw new IllegalArgumentException(sm.getString("standardContext.securityConstraint.pattern", patterns[j]));
            }
        }
        SecurityConstraint[] securityConstraintArray = this.constraints;
        synchronized (this.constraints) {
            SecurityConstraint[] results = new SecurityConstraint[this.constraints.length + 1];
            for (int i = 0; i < this.constraints.length; ++i) {
                results[i] = this.constraints[i];
            }
            results[this.constraints.length] = constraint;
            this.constraints = results;
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void addEjb(ContextEjb ejb) {
        this.namingResources.addEjb(ejb);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addEjb", ejb.getName());
        }
    }

    @Override
    public void addEnvironment(ContextEnvironment environment) {
        ContextEnvironment env = this.findEnvironment(environment.getName());
        if (env != null && !env.getOverride()) {
            return;
        }
        this.namingResources.addEnvironment(environment);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addEnvironment", environment.getName());
        }
    }

    public void addResourceParams(ResourceParams resourceParameters) {
        this.namingResources.addResourceParams(resourceParameters);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addResourceParams", resourceParameters.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addErrorPage(ErrorPage errorPage) {
        String exceptionType;
        if (errorPage == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.errorPage.required"));
        }
        String location = errorPage.getLocation();
        if (location != null && !location.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("standardContext.errorPage.warning", location));
                }
                errorPage.setLocation("/" + location);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.errorPage.error", location));
            }
        }
        if ((exceptionType = errorPage.getExceptionType()) != null) {
            HashMap hashMap = this.exceptionPages;
            synchronized (hashMap) {
                this.exceptionPages.put(exceptionType, errorPage);
            }
        }
        HashMap hashMap = this.statusPages;
        synchronized (hashMap) {
            int errorCode = errorPage.getErrorCode();
            if (errorCode >= 400 && errorCode < 600) {
                this.statusPages.put(errorCode, errorPage);
            } else {
                log.error((Object)sm.getString("standardContext.invalidErrorPageCode", errorCode));
            }
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addErrorPage", errorPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFilterDef(FilterDef filterDef) {
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            this.filterDefs.put(filterDef.getFilterName(), filterDef);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addFilterDef", filterDef);
        }
    }

    public void addFilterMaps(FilterMaps filterMaps) {
        FilterMap fmap;
        int i;
        int dispatcherMapping = filterMaps.getDispatcherMapping();
        String filterName = filterMaps.getFilterName();
        String[] servletNames = filterMaps.getServletNames();
        String[] urlPatterns = filterMaps.getURLPatterns();
        for (i = 0; i < servletNames.length; ++i) {
            fmap = new FilterMap();
            fmap.setFilterName(filterName);
            fmap.setServletName(servletNames[i]);
            fmap.setDispatcherMapping(dispatcherMapping);
            this.addFilterMap(fmap);
        }
        for (i = 0; i < urlPatterns.length; ++i) {
            fmap = new FilterMap();
            fmap.setFilterName(filterName);
            fmap.setURLPattern(urlPatterns[i]);
            fmap.setDispatcherMapping(dispatcherMapping);
            this.addFilterMap(fmap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFilterMap(FilterMap filterMap) {
        String filterName = filterMap.getFilterName();
        String servletName = filterMap.getServletName();
        String urlPattern = filterMap.getURLPattern();
        if (this.findFilterDef(filterName) == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.name", filterName));
        }
        if (servletName == null && urlPattern == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.either"));
        }
        if (servletName != null && urlPattern != null) {
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.either"));
        }
        if (urlPattern != null && !this.validateURLPattern(urlPattern)) {
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.pattern", urlPattern));
        }
        FilterMap[] filterMapArray = this.filterMaps;
        synchronized (this.filterMaps) {
            FilterMap[] results = new FilterMap[this.filterMaps.length + 1];
            System.arraycopy(this.filterMaps, 0, results, 0, this.filterMaps.length);
            results[this.filterMaps.length] = filterMap;
            this.filterMaps = results;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("addFilterMap", filterMap);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInstanceListener(String listener) {
        String[] stringArray = this.instanceListeners;
        synchronized (this.instanceListeners) {
            String[] results = new String[this.instanceListeners.length + 1];
            for (int i = 0; i < this.instanceListeners.length; ++i) {
                results[i] = this.instanceListeners[i];
            }
            results[this.instanceListeners.length] = listener;
            this.instanceListeners = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("addInstanceListener", listener);
            }
            return;
        }
    }

    @Override
    public void addJspMapping(String pattern) {
        String servletName = this.findServletMapping("*.jsp");
        if (servletName == null) {
            servletName = "jsp";
        }
        if (this.findChild(servletName) != null) {
            this.addServletMapping(pattern, servletName, true);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Skipping " + pattern + " , no servlet " + servletName));
        }
    }

    @Override
    public void addLocaleEncodingMappingParameter(String locale, String encoding) {
        this.getCharsetMapper().addCharsetMappingFromDeploymentDescriptor(locale, encoding);
    }

    @Override
    public void addLocalEjb(ContextLocalEjb ejb) {
        this.namingResources.addLocalEjb(ejb);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addLocalEjb", ejb.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageDestination(MessageDestination md) {
        HashMap hashMap = this.messageDestinations;
        synchronized (hashMap) {
            this.messageDestinations.put(md.getName(), md);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addMessageDestination", md.getName());
        }
    }

    public void addMessageDestinationRef(MessageDestinationRef mdr) {
        this.namingResources.addMessageDestinationRef(mdr);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addMessageDestinationRef", mdr.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMimeMapping(String extension, String mimeType) {
        HashMap<String, String> hashMap = this.mimeMappings;
        synchronized (hashMap) {
            this.mimeMappings.put(extension, mimeType);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addMimeMapping", extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addParameter(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.required"));
        }
        if (this.parameters.get(name) != null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.duplicate", name));
        }
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.put(name, value);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addParameter", name);
        }
    }

    @Override
    public void addResource(ContextResource resource) {
        this.namingResources.addResource(resource);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addResource", resource.getName());
        }
    }

    @Override
    public void addResourceEnvRef(String name, String type) {
        this.namingResources.addResourceEnvRef(name, type);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addResourceEnvRef", name);
        }
    }

    @Override
    public void addResourceLink(ContextResourceLink resourceLink) {
        this.namingResources.addResourceLink(resourceLink);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addResourceLink", resourceLink.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRoleMapping(String role, String link) {
        HashMap hashMap = this.roleMappings;
        synchronized (hashMap) {
            this.roleMappings.put(role, link);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addRoleMapping", role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSecurityRole(String role) {
        String[] stringArray = this.securityRoles;
        synchronized (this.securityRoles) {
            String[] results = new String[this.securityRoles.length + 1];
            for (int i = 0; i < this.securityRoles.length; ++i) {
                results[i] = this.securityRoles[i];
            }
            results[this.securityRoles.length] = role;
            this.securityRoles = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("addSecurityRole", role);
            }
            return;
        }
    }

    public void addServletMapping(ServletMap servletMap) {
        String[] patterns = servletMap.getUrlPatterns();
        String name = servletMap.getServletName();
        for (int i = 0; i < patterns.length; ++i) {
            this.addServletMapping(patterns[i], name, false);
        }
    }

    @Override
    public void addServletMapping(String pattern, String name) {
        this.addServletMapping(pattern, name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServletMapping(String pattern, String name, boolean jspWildCard) {
        if (this.findChild(name) == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.servletMap.name", name));
        }
        if (!this.validateURLPattern(pattern = this.adjustURLPattern(RequestUtil.URLDecode(pattern)))) {
            throw new IllegalArgumentException(sm.getString("standardContext.servletMap.pattern", pattern));
        }
        HashMap hashMap = this.servletMappings;
        synchronized (hashMap) {
            String name2 = (String)this.servletMappings.get(pattern);
            if (name2 != null) {
                Wrapper wrapper = (Wrapper)this.findChild(name2);
                wrapper.removeMapping(pattern);
                this.mapper.removeWrapper(pattern);
            }
            this.servletMappings.put(pattern, name);
        }
        Wrapper wrapper = (Wrapper)this.findChild(name);
        wrapper.addMapping(pattern);
        this.mapper.addWrapper(pattern, (Object)wrapper, jspWildCard);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addServletMapping", pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaglib(String uri, String location) {
        HashMap hashMap = this.taglibs;
        synchronized (hashMap) {
            this.taglibs.put(uri, location);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addTaglib", uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWelcomeFile(String name) {
        String[] stringArray = this.welcomeFiles;
        synchronized (this.welcomeFiles) {
            if (this.replaceWelcomeFiles) {
                this.welcomeFiles = new String[0];
                this.setReplaceWelcomeFiles(false);
            }
            String[] results = new String[this.welcomeFiles.length + 1];
            for (int i = 0; i < this.welcomeFiles.length; ++i) {
                results[i] = this.welcomeFiles[i];
            }
            results[this.welcomeFiles.length] = name;
            this.welcomeFiles = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.postWelcomeFiles();
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("addWelcomeFile", name);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWrapperLifecycle(String listener) {
        String[] stringArray = this.wrapperLifecycles;
        synchronized (this.wrapperLifecycles) {
            String[] results = new String[this.wrapperLifecycles.length + 1];
            for (int i = 0; i < this.wrapperLifecycles.length; ++i) {
                results[i] = this.wrapperLifecycles[i];
            }
            results[this.wrapperLifecycles.length] = listener;
            this.wrapperLifecycles = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("addWrapperLifecycle", listener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWrapperListener(String listener) {
        String[] stringArray = this.wrapperListeners;
        synchronized (this.wrapperListeners) {
            String[] results = new String[this.wrapperListeners.length + 1];
            for (int i = 0; i < this.wrapperListeners.length; ++i) {
                results[i] = this.wrapperListeners[i];
            }
            results[this.wrapperListeners.length] = listener;
            this.wrapperListeners = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("addWrapperListener", listener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Wrapper createWrapper() {
        Wrapper wrapper = null;
        if (this.wrapperClass != null) {
            try {
                wrapper = (Wrapper)this.wrapperClass.newInstance();
            }
            catch (Throwable t) {
                log.error((Object)sm.getString("standardContext.createWrapperInstance", this.wrapperClassName), t);
                return null;
            }
        } else {
            wrapper = new StandardWrapper();
        }
        String[] stringArray = this.instanceListeners;
        synchronized (this.instanceListeners) {
            Object listener;
            Class<?> clazz;
            int i;
            for (i = 0; i < this.instanceListeners.length; ++i) {
                try {
                    clazz = Class.forName(this.instanceListeners[i]);
                    listener = (InstanceListener)clazz.newInstance();
                    wrapper.addInstanceListener((InstanceListener)listener);
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)sm.getString("standardContext.instanceListener", this.instanceListeners[i]), t);
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return null;
                }
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            stringArray = this.wrapperLifecycles;
            synchronized (this.wrapperLifecycles) {
                for (i = 0; i < this.wrapperLifecycles.length; ++i) {
                    try {
                        clazz = Class.forName(this.wrapperLifecycles[i]);
                        listener = (LifecycleListener)clazz.newInstance();
                        if (!(wrapper instanceof Lifecycle)) continue;
                        ((Lifecycle)wrapper).addLifecycleListener((LifecycleListener)listener);
                        continue;
                    }
                    catch (Throwable t) {
                        log.error((Object)sm.getString("standardContext.lifecycleListener", this.wrapperLifecycles[i]), t);
                        // ** MonitorExit[var2_3] (shouldn't be in output)
                        return null;
                    }
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                stringArray = this.wrapperListeners;
                synchronized (this.wrapperListeners) {
                    for (i = 0; i < this.wrapperListeners.length; ++i) {
                        try {
                            clazz = Class.forName(this.wrapperListeners[i]);
                            listener = (ContainerListener)clazz.newInstance();
                            wrapper.addContainerListener((ContainerListener)listener);
                            continue;
                        }
                        catch (Throwable t) {
                            log.error((Object)sm.getString("standardContext.containerListener", this.wrapperListeners[i]), t);
                            // ** MonitorExit[var2_3] (shouldn't be in output)
                            return null;
                        }
                    }
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return wrapper;
                }
            }
        }
    }

    @Override
    public String[] findApplicationListeners() {
        return this.applicationListeners;
    }

    @Override
    public ApplicationParameter[] findApplicationParameters() {
        return this.applicationParameters;
    }

    @Override
    public SecurityConstraint[] findConstraints() {
        return this.constraints;
    }

    @Override
    public ContextEjb findEjb(String name) {
        return this.namingResources.findEjb(name);
    }

    @Override
    public ContextEjb[] findEjbs() {
        return this.namingResources.findEjbs();
    }

    @Override
    public ContextEnvironment findEnvironment(String name) {
        return this.namingResources.findEnvironment(name);
    }

    @Override
    public ContextEnvironment[] findEnvironments() {
        return this.namingResources.findEnvironments();
    }

    @Override
    public ErrorPage findErrorPage(int errorCode) {
        if (errorCode >= 400 && errorCode < 600) {
            return (ErrorPage)this.statusPages.get(errorCode);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ErrorPage findErrorPage(String exceptionType) {
        HashMap hashMap = this.exceptionPages;
        synchronized (hashMap) {
            return (ErrorPage)this.exceptionPages.get(exceptionType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ErrorPage[] findErrorPages() {
        HashMap hashMap = this.exceptionPages;
        synchronized (hashMap) {
            HashMap hashMap2 = this.statusPages;
            synchronized (hashMap2) {
                int i;
                ErrorPage[] results1 = new ErrorPage[this.exceptionPages.size()];
                results1 = this.exceptionPages.values().toArray(results1);
                ErrorPage[] results2 = new ErrorPage[this.statusPages.size()];
                results2 = this.statusPages.values().toArray(results2);
                ErrorPage[] results = new ErrorPage[results1.length + results2.length];
                for (i = 0; i < results1.length; ++i) {
                    results[i] = results1[i];
                }
                for (i = results1.length; i < results.length; ++i) {
                    results[i] = results2[i - results1.length];
                }
                return results;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterDef findFilterDef(String filterName) {
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            return (FilterDef)this.filterDefs.get(filterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterDef[] findFilterDefs() {
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            FilterDef[] results = new FilterDef[this.filterDefs.size()];
            return this.filterDefs.values().toArray(results);
        }
    }

    @Override
    public FilterMap[] findFilterMaps() {
        return this.filterMaps;
    }

    @Override
    public String[] findInstanceListeners() {
        return this.instanceListeners;
    }

    @Override
    public ContextLocalEjb findLocalEjb(String name) {
        return this.namingResources.findLocalEjb(name);
    }

    @Override
    public ContextLocalEjb[] findLocalEjbs() {
        return this.namingResources.findLocalEjbs();
    }

    public Context findMappingObject() {
        return (Context)this.getMappingObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestination findMessageDestination(String name) {
        HashMap hashMap = this.messageDestinations;
        synchronized (hashMap) {
            return (MessageDestination)this.messageDestinations.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestination[] findMessageDestinations() {
        HashMap hashMap = this.messageDestinations;
        synchronized (hashMap) {
            MessageDestination[] results = new MessageDestination[this.messageDestinations.size()];
            return this.messageDestinations.values().toArray(results);
        }
    }

    public MessageDestinationRef findMessageDestinationRef(String name) {
        return this.namingResources.findMessageDestinationRef(name);
    }

    public MessageDestinationRef[] findMessageDestinationRefs() {
        return this.namingResources.findMessageDestinationRefs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findMimeMapping(String extension) {
        String mimeType = this.mimeMappings.get(extension);
        if (mimeType == null) {
            HashMap<String, String> hashMap = this.mimeMappings;
            synchronized (hashMap) {
                for (String ext : this.mimeMappings.keySet()) {
                    if (!ext.equalsIgnoreCase(extension)) continue;
                    mimeType = this.mimeMappings.get(ext);
                    this.mimeMappings.put(extension, mimeType);
                    break;
                }
            }
        }
        return mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findMimeMappings() {
        HashMap<String, String> hashMap = this.mimeMappings;
        synchronized (hashMap) {
            String[] results = new String[this.mimeMappings.size()];
            return this.mimeMappings.keySet().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findParameter(String name) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            return (String)this.parameters.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findParameters() {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            String[] results = new String[this.parameters.size()];
            return this.parameters.keySet().toArray(results);
        }
    }

    @Override
    public ContextResource findResource(String name) {
        return this.namingResources.findResource(name);
    }

    @Override
    public String findResourceEnvRef(String name) {
        return this.namingResources.findResourceEnvRef(name);
    }

    @Override
    public String[] findResourceEnvRefs() {
        return this.namingResources.findResourceEnvRefs();
    }

    @Override
    public ContextResourceLink findResourceLink(String name) {
        return this.namingResources.findResourceLink(name);
    }

    @Override
    public ContextResourceLink[] findResourceLinks() {
        return this.namingResources.findResourceLinks();
    }

    @Override
    public ContextResource[] findResources() {
        return this.namingResources.findResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findRoleMapping(String role) {
        String realRole = null;
        HashMap hashMap = this.roleMappings;
        synchronized (hashMap) {
            realRole = (String)this.roleMappings.get(role);
        }
        if (realRole != null) {
            return realRole;
        }
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean findSecurityRole(String role) {
        String[] stringArray = this.securityRoles;
        synchronized (this.securityRoles) {
            for (int i = 0; i < this.securityRoles.length; ++i) {
                if (!role.equals(this.securityRoles[i])) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    @Override
    public String[] findSecurityRoles() {
        return this.securityRoles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findServletMapping(String pattern) {
        HashMap hashMap = this.servletMappings;
        synchronized (hashMap) {
            return (String)this.servletMappings.get(pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findServletMappings() {
        HashMap hashMap = this.servletMappings;
        synchronized (hashMap) {
            String[] results = new String[this.servletMappings.size()];
            return this.servletMappings.keySet().toArray(results);
        }
    }

    @Override
    public String findStatusPage(int status) {
        return (String)this.statusPages.get(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] findStatusPages() {
        HashMap hashMap = this.statusPages;
        synchronized (hashMap) {
            int[] results = new int[this.statusPages.size()];
            Iterator elements = this.statusPages.keySet().iterator();
            int i = 0;
            while (elements.hasNext()) {
                results[i++] = (Integer)elements.next();
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findTaglib(String uri) {
        HashMap hashMap = this.taglibs;
        synchronized (hashMap) {
            return (String)this.taglibs.get(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findTaglibs() {
        HashMap hashMap = this.taglibs;
        synchronized (hashMap) {
            String[] results = new String[this.taglibs.size()];
            return this.taglibs.keySet().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean findWelcomeFile(String name) {
        String[] stringArray = this.welcomeFiles;
        synchronized (this.welcomeFiles) {
            for (int i = 0; i < this.welcomeFiles.length; ++i) {
                if (!name.equals(this.welcomeFiles[i])) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    @Override
    public String[] findWelcomeFiles() {
        return this.welcomeFiles;
    }

    @Override
    public String[] findWrapperLifecycles() {
        return this.wrapperLifecycles;
    }

    @Override
    public String[] findWrapperListeners() {
        return this.wrapperListeners;
    }

    @Override
    public synchronized void reload() {
        if (!this.started) {
            throw new IllegalStateException(sm.getString("containerBase.notStarted", this.logName()));
        }
        log.info((Object)sm.getString("standardContext.reloadingStarted"));
        this.setPaused(true);
        try {
            this.stop();
        }
        catch (LifecycleException e) {
            log.error((Object)sm.getString("standardContext.stoppingContext", this), (Throwable)e);
        }
        try {
            this.start();
        }
        catch (LifecycleException e) {
            log.error((Object)sm.getString("standardContext.startingContext", this), (Throwable)e);
        }
        this.setPaused(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationListener(String listener) {
        String[] stringArray = this.applicationListeners;
        synchronized (this.applicationListeners) {
            int n = -1;
            for (int i = 0; i < this.applicationListeners.length; ++i) {
                if (!this.applicationListeners[i].equals(listener)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.applicationListeners.length - 1];
            for (int i = 0; i < this.applicationListeners.length; ++i) {
                if (i == n) continue;
                results[j++] = this.applicationListeners[i];
            }
            this.applicationListeners = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("removeApplicationListener", listener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationParameter(String name) {
        ApplicationParameter[] applicationParameterArray = this.applicationParameters;
        synchronized (this.applicationParameters) {
            int n = -1;
            for (int i = 0; i < this.applicationParameters.length; ++i) {
                if (!name.equals(this.applicationParameters[i].getName())) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            ApplicationParameter[] results = new ApplicationParameter[this.applicationParameters.length - 1];
            for (int i = 0; i < this.applicationParameters.length; ++i) {
                if (i == n) continue;
                results[j++] = this.applicationParameters[i];
            }
            this.applicationParameters = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("removeApplicationParameter", name);
            }
            return;
        }
    }

    @Override
    public void removeChild(Container child) {
        if (!(child instanceof Wrapper)) {
            throw new IllegalArgumentException(sm.getString("standardContext.notWrapper"));
        }
        super.removeChild(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConstraint(SecurityConstraint constraint) {
        SecurityConstraint[] securityConstraintArray = this.constraints;
        synchronized (this.constraints) {
            int n = -1;
            for (int i = 0; i < this.constraints.length; ++i) {
                if (!this.constraints[i].equals(constraint)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            SecurityConstraint[] results = new SecurityConstraint[this.constraints.length - 1];
            for (int i = 0; i < this.constraints.length; ++i) {
                if (i == n) continue;
                results[j++] = this.constraints[i];
            }
            this.constraints = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("removeConstraint", constraint);
            }
            return;
        }
    }

    @Override
    public void removeEjb(String name) {
        this.namingResources.removeEjb(name);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeEjb", name);
        }
    }

    @Override
    public void removeEnvironment(String name) {
        if (this.namingResources == null) {
            return;
        }
        ContextEnvironment env = this.namingResources.findEnvironment(name);
        if (env == null) {
            throw new IllegalArgumentException("Invalid environment name '" + name + "'");
        }
        this.namingResources.removeEnvironment(name);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeEnvironment", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeErrorPage(ErrorPage errorPage) {
        String exceptionType = errorPage.getExceptionType();
        if (exceptionType != null) {
            HashMap hashMap = this.exceptionPages;
            synchronized (hashMap) {
                this.exceptionPages.remove(exceptionType);
            }
        }
        HashMap hashMap = this.statusPages;
        synchronized (hashMap) {
            this.statusPages.remove(errorPage.getErrorCode());
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeErrorPage", errorPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFilterDef(FilterDef filterDef) {
        HashMap hashMap = this.filterDefs;
        synchronized (hashMap) {
            this.filterDefs.remove(filterDef.getFilterName());
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeFilterDef", filterDef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFilterMap(FilterMap filterMap) {
        FilterMap[] filterMapArray = this.filterMaps;
        synchronized (this.filterMaps) {
            int n = -1;
            for (int i = 0; i < this.filterMaps.length; ++i) {
                if (this.filterMaps[i] != filterMap) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            FilterMap[] results = new FilterMap[this.filterMaps.length - 1];
            System.arraycopy(this.filterMaps, 0, results, 0, n);
            System.arraycopy(this.filterMaps, n + 1, results, n, this.filterMaps.length - 1 - n);
            this.filterMaps = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("removeFilterMap", filterMap);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInstanceListener(String listener) {
        String[] stringArray = this.instanceListeners;
        synchronized (this.instanceListeners) {
            int n = -1;
            for (int i = 0; i < this.instanceListeners.length; ++i) {
                if (!this.instanceListeners[i].equals(listener)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.instanceListeners.length - 1];
            for (int i = 0; i < this.instanceListeners.length; ++i) {
                if (i == n) continue;
                results[j++] = this.instanceListeners[i];
            }
            this.instanceListeners = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("removeInstanceListener", listener);
            }
            return;
        }
    }

    @Override
    public void removeLocalEjb(String name) {
        this.namingResources.removeLocalEjb(name);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeLocalEjb", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageDestination(String name) {
        HashMap hashMap = this.messageDestinations;
        synchronized (hashMap) {
            this.messageDestinations.remove(name);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeMessageDestination", name);
        }
    }

    public void removeMessageDestinationRef(String name) {
        this.namingResources.removeMessageDestinationRef(name);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeMessageDestinationRef", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMimeMapping(String extension) {
        HashMap<String, String> hashMap = this.mimeMappings;
        synchronized (hashMap) {
            this.mimeMappings.remove(extension);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeMimeMapping", extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeParameter(String name) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.remove(name);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeParameter", name);
        }
    }

    @Override
    public void removeResource(String name) {
        name = URLDecoder.decode(name);
        if (this.namingResources == null) {
            return;
        }
        ContextResource resource = this.namingResources.findResource(name);
        if (resource == null) {
            throw new IllegalArgumentException("Invalid resource name '" + name + "'");
        }
        this.namingResources.removeResource(name);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeResource", name);
        }
    }

    @Override
    public void removeResourceEnvRef(String name) {
        this.namingResources.removeResourceEnvRef(name);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeResourceEnvRef", name);
        }
    }

    @Override
    public void removeResourceLink(String name) {
        name = URLDecoder.decode(name);
        if (this.namingResources == null) {
            return;
        }
        ContextResourceLink resource = this.namingResources.findResourceLink(name);
        if (resource == null) {
            throw new IllegalArgumentException("Invalid resource name '" + name + "'");
        }
        this.namingResources.removeResourceLink(name);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeResourceLink", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRoleMapping(String role) {
        HashMap hashMap = this.roleMappings;
        synchronized (hashMap) {
            this.roleMappings.remove(role);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeRoleMapping", role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSecurityRole(String role) {
        String[] stringArray = this.securityRoles;
        synchronized (this.securityRoles) {
            int n = -1;
            for (int i = 0; i < this.securityRoles.length; ++i) {
                if (!role.equals(this.securityRoles[i])) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.securityRoles.length - 1];
            for (int i = 0; i < this.securityRoles.length; ++i) {
                if (i == n) continue;
                results[j++] = this.securityRoles[i];
            }
            this.securityRoles = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("removeSecurityRole", role);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServletMapping(String pattern) {
        String name = null;
        HashMap hashMap = this.servletMappings;
        synchronized (hashMap) {
            name = (String)this.servletMappings.remove(pattern);
        }
        Wrapper wrapper = (Wrapper)this.findChild(name);
        if (wrapper != null) {
            wrapper.removeMapping(pattern);
        }
        this.mapper.removeWrapper(pattern);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeServletMapping", pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTaglib(String uri) {
        HashMap hashMap = this.taglibs;
        synchronized (hashMap) {
            this.taglibs.remove(uri);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeTaglib", uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWelcomeFile(String name) {
        String[] stringArray = this.welcomeFiles;
        synchronized (this.welcomeFiles) {
            int n = -1;
            for (int i = 0; i < this.welcomeFiles.length; ++i) {
                if (!this.welcomeFiles[i].equals(name)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.welcomeFiles.length - 1];
            for (int i = 0; i < this.welcomeFiles.length; ++i) {
                if (i == n) continue;
                results[j++] = this.welcomeFiles[i];
            }
            this.welcomeFiles = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.postWelcomeFiles();
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("removeWelcomeFile", name);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWrapperLifecycle(String listener) {
        String[] stringArray = this.wrapperLifecycles;
        synchronized (this.wrapperLifecycles) {
            int n = -1;
            for (int i = 0; i < this.wrapperLifecycles.length; ++i) {
                if (!this.wrapperLifecycles[i].equals(listener)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.wrapperLifecycles.length - 1];
            for (int i = 0; i < this.wrapperLifecycles.length; ++i) {
                if (i == n) continue;
                results[j++] = this.wrapperLifecycles[i];
            }
            this.wrapperLifecycles = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("removeWrapperLifecycle", listener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWrapperListener(String listener) {
        String[] stringArray = this.wrapperListeners;
        synchronized (this.wrapperListeners) {
            int n = -1;
            for (int i = 0; i < this.wrapperListeners.length; ++i) {
                if (!this.wrapperListeners[i].equals(listener)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.wrapperListeners.length - 1];
            for (int i = 0; i < this.wrapperListeners.length; ++i) {
                if (i == n) continue;
                results[j++] = this.wrapperListeners[i];
            }
            this.wrapperListeners = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("removeWrapperListener", listener);
            }
            return;
        }
    }

    public long getProcessingTimeMillis() {
        long result = 0L;
        Container[] children = this.findChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                result += ((StandardWrapper)children[i]).getProcessingTimeMillis();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterStart() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting filters");
        }
        boolean ok = true;
        HashMap hashMap = this.filterConfigs;
        synchronized (hashMap) {
            this.filterConfigs.clear();
            for (String name : this.filterDefs.keySet()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Starting filter '" + name + "'"));
                }
                ApplicationFilterConfig filterConfig = null;
                try {
                    filterConfig = new ApplicationFilterConfig(this, (FilterDef)this.filterDefs.get(name));
                    this.filterConfigs.put(name, filterConfig);
                }
                catch (Throwable t) {
                    this.getServletContext().log(sm.getString("standardContext.filterStart", name), t);
                    ok = false;
                }
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterStop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping filters");
        }
        HashMap hashMap = this.filterConfigs;
        synchronized (hashMap) {
            for (String name : this.filterConfigs.keySet()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Stopping filter '" + name + "'"));
                }
                ApplicationFilterConfig filterConfig = (ApplicationFilterConfig)this.filterConfigs.get(name);
                filterConfig.release();
            }
            this.filterConfigs.clear();
        }
        return true;
    }

    public FilterConfig findFilterConfig(String name) {
        return (FilterConfig)this.filterConfigs.get(name);
    }

    public boolean listenerStart() {
        Object[] instances;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuring application event listeners");
        }
        ClassLoader loader = this.getLoader().getClassLoader();
        String[] listeners = this.findApplicationListeners();
        Object[] results = new Object[listeners.length];
        boolean ok = true;
        for (int i = 0; i < results.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Configuring event listener class '" + listeners[i] + "'"));
            }
            try {
                Class<?> clazz = loader.loadClass(listeners[i]);
                results[i] = clazz.newInstance();
                this.fireContainerEvent("afterListenerInstantiated", results[i]);
                continue;
            }
            catch (Throwable t) {
                this.getServletContext().log(sm.getString("standardContext.applicationListener", listeners[i]), t);
                ok = false;
            }
        }
        if (!ok) {
            log.error((Object)sm.getString("standardContext.applicationSkipped"));
            return false;
        }
        ArrayList<Object> eventListeners = new ArrayList<Object>();
        ArrayList<Object> lifecycleListeners = new ArrayList<Object>();
        for (int i = 0; i < results.length; ++i) {
            if (results[i] instanceof ServletContextAttributeListener || results[i] instanceof ServletRequestAttributeListener || results[i] instanceof ServletRequestListener || results[i] instanceof HttpSessionAttributeListener) {
                eventListeners.add(results[i]);
            }
            if (!(results[i] instanceof ServletContextListener) && !(results[i] instanceof HttpSessionListener)) continue;
            lifecycleListeners.add(results[i]);
        }
        this.setApplicationEventListeners(eventListeners.toArray());
        this.setApplicationLifecycleListeners(lifecycleListeners.toArray());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sending application start events");
        }
        if ((instances = this.getApplicationLifecycleListeners()) == null) {
            return ok;
        }
        ServletContextEvent event = new ServletContextEvent(this.getServletContext());
        for (int i = 0; i < instances.length; ++i) {
            if (instances[i] == null || !(instances[i] instanceof ServletContextListener)) continue;
            ServletContextListener listener = (ServletContextListener)instances[i];
            try {
                this.fireContainerEvent("beforeContextInitialized", listener);
                listener.contextInitialized(event);
                this.fireContainerEvent("afterContextInitialized", listener);
                continue;
            }
            catch (Throwable t) {
                this.fireContainerEvent("afterContextInitialized", listener);
                this.getServletContext().log(sm.getString("standardContext.listenerStart", instances[i].getClass().getName()), t);
                ok = false;
            }
        }
        return ok;
    }

    public boolean listenerStop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sending application stop events");
        }
        boolean ok = true;
        Object[] listeners = this.getApplicationLifecycleListeners();
        if (listeners == null) {
            return ok;
        }
        ServletContextEvent event = new ServletContextEvent(this.getServletContext());
        for (int i = 0; i < listeners.length; ++i) {
            int j = listeners.length - 1 - i;
            if (listeners[j] == null || !(listeners[j] instanceof ServletContextListener)) continue;
            ServletContextListener listener = (ServletContextListener)listeners[j];
            try {
                this.fireContainerEvent("beforeContextDestroyed", listener);
                listener.contextDestroyed(event);
                this.fireContainerEvent("afterContextDestroyed", listener);
                continue;
            }
            catch (Throwable t) {
                this.fireContainerEvent("afterContextDestroyed", listener);
                this.getServletContext().log(sm.getString("standardContext.listenerStop", listeners[j].getClass().getName()), t);
                ok = false;
            }
        }
        this.setApplicationEventListeners(null);
        this.setApplicationLifecycleListeners(null);
        return ok;
    }

    public boolean resourcesStart() {
        boolean ok = true;
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.getParent() != null) {
            env.put("host", this.getParent().getName());
        }
        env.put("context", this.getName());
        try {
            ProxyDirContext proxyDirContext = new ProxyDirContext(env, this.webappResources);
            if (this.webappResources instanceof BaseDirContext) {
                ((BaseDirContext)this.webappResources).setDocBase(this.getBasePath(this.getDocBase()));
                ((BaseDirContext)this.webappResources).allocate();
            }
            if (this.isCachingAllowed()) {
                ObjectName resourcesName = new ObjectName(this.getDomain() + ":type=Cache,host=" + this.getHostname() + ",path=" + ("".equals(this.encodedPath) ? "/" : this.encodedPath));
                Registry.getRegistry(null, null).registerComponent((Object)proxyDirContext.getCache(), resourcesName, null);
            }
            this.resources = proxyDirContext;
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.error((Object)sm.getString("standardContext.resourcesStart", this.getName()), t);
            } else {
                log.error((Object)sm.getString("standardContext.resourcesStart", this.getName()));
                log.error((Object)t.getMessage());
            }
            ok = false;
        }
        return ok;
    }

    public boolean alternateResourcesStart() {
        boolean ok = true;
        if (this.alternateDocBases == null || this.alternateDocBases.size() == 0) {
            return ok;
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.getParent() != null) {
            env.put("host", this.getParent().getName());
        }
        env.put("context", this.getName());
        for (int i = 0; i < this.alternateDocBases.size(); ++i) {
            AlternateDocBase alternateDocBase = this.alternateDocBases.get(i);
            String basePath = alternateDocBase.getBasePath();
            DirContext alternateWebappResources = alternateDocBase.getWebappResources();
            try {
                ProxyDirContext proxyDirContext = new ProxyDirContext(env, alternateWebappResources);
                if (alternateWebappResources instanceof BaseDirContext) {
                    ((BaseDirContext)alternateWebappResources).setDocBase(basePath);
                    ((BaseDirContext)alternateWebappResources).allocate();
                }
                alternateDocBase.setResources(proxyDirContext);
                continue;
            }
            catch (Throwable t) {
                if (log.isDebugEnabled()) {
                    log.error((Object)sm.getString("standardContext.resourcesStart", this.getName()), t);
                } else {
                    log.error((Object)sm.getString("standardContext.resourcesStart", this.getName()));
                    log.error((Object)t.getMessage());
                }
                ok = false;
            }
        }
        return ok;
    }

    public boolean resourcesStop() {
        boolean ok = true;
        try {
            if (this.resources != null) {
                if (this.resources instanceof Lifecycle) {
                    ((Lifecycle)this.resources).stop();
                }
                if (this.webappResources instanceof BaseDirContext) {
                    ((BaseDirContext)this.webappResources).release();
                }
                if (this.isCachingAllowed()) {
                    ObjectName resourcesName = new ObjectName(this.getDomain() + ":type=Cache,host=" + this.getHostname() + ",path=" + ("".equals(this.getPath()) ? "/" : this.getPath()));
                    Registry.getRegistry(null, null).unregisterComponent(resourcesName);
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("standardContext.resourcesStop"), t);
            ok = false;
        }
        this.resources = null;
        return ok;
    }

    public boolean alternateResourcesStop() {
        boolean ok = true;
        if (this.alternateDocBases == null || this.alternateDocBases.size() == 0) {
            return ok;
        }
        for (int i = 0; i < this.alternateDocBases.size(); ++i) {
            DirContext alternateWebappResources;
            AlternateDocBase alternateDocBase = this.alternateDocBases.get(i);
            ProxyDirContext alternateResources = alternateDocBase.getResources();
            if (alternateResources instanceof Lifecycle) {
                try {
                    ((Lifecycle)alternateResources).stop();
                }
                catch (Throwable t) {
                    log.error((Object)sm.getString("standardContext.resourcesStop"), t);
                    ok = false;
                }
            }
            if (!((alternateWebappResources = alternateDocBase.getWebappResources()) instanceof BaseDirContext)) continue;
            try {
                ((BaseDirContext)alternateWebappResources).release();
                continue;
            }
            catch (Throwable t) {
                log.error((Object)sm.getString("standardContext.resourcesStop"), t);
                ok = false;
            }
        }
        this.alternateDocBases = null;
        return ok;
    }

    public void loadOnStartup(Container[] children) throws LifecycleException {
        TreeMap<Integer, ArrayList<Wrapper>> map = new TreeMap<Integer, ArrayList<Wrapper>>();
        for (int i = 0; i < children.length; ++i) {
            Integer key;
            ArrayList<Wrapper> list;
            Wrapper wrapper = (Wrapper)children[i];
            int loadOnStartup = wrapper.getLoadOnStartup();
            if (loadOnStartup < 0) continue;
            if (loadOnStartup == 0) {
                loadOnStartup = Integer.MAX_VALUE;
            }
            if ((list = (ArrayList<Wrapper>)map.get(key = Integer.valueOf(loadOnStartup))) == null) {
                list = new ArrayList<Wrapper>();
                map.put(key, list);
            }
            list.add(wrapper);
        }
        for (Integer key : map.keySet()) {
            ArrayList list = (ArrayList)map.get(key);
            for (Wrapper wrapper : list) {
                try {
                    wrapper.load();
                }
                catch (ServletException e) {
                    this.getServletContext().log(sm.getString("standardWrapper.loadException", this.getName()), StandardWrapper.getRootCause(e));
                    throw new LifecycleException(StandardWrapper.getRootCause(e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() throws LifecycleException {
        ClassLoader oldCCL;
        boolean ok;
        long startupTimeStart;
        block81: {
            String useNamingProperty;
            block80: {
                Container host;
                if (this.started) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)sm.getString("containerBase.alreadyStarted", this.logName()));
                    }
                    return;
                }
                startupTimeStart = System.currentTimeMillis();
                if (!this.initialized) {
                    try {
                        this.init();
                    }
                    catch (Exception ex) {
                        throw new LifecycleException("Error initializaing ", (Throwable)ex);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Starting " + ("".equals(this.getName()) ? "ROOT" : this.getName())));
                }
                this.preRegisterJMX();
                if (this.oname != null && Registry.getRegistry().getMBeanServer().isRegistered(this.oname)) {
                    Registry.getRegistry(null, null).unregisterComponent(this.oname);
                }
                this.lifecycle.fireLifecycleEvent("before_start", null);
                this.setAvailable(false);
                this.setConfigured(false);
                ok = true;
                File configBase = this.getConfigBase();
                if (configBase != null && this.saveConfig) {
                    if (this.getConfigFile() == null) {
                        File file = new File(configBase, this.getDefaultConfigFile());
                        this.setConfigFile(file.getPath());
                        try {
                            File appBaseFile = new File(this.getAppBase());
                            if (!appBaseFile.isAbsolute()) {
                                appBaseFile = new File(this.engineBase(), this.getAppBase());
                            }
                            String appBase = appBaseFile.getCanonicalPath();
                            String basePath = new File(this.getBasePath(this.getDocBase())).getCanonicalPath();
                            if (!basePath.startsWith(appBase)) {
                                Server server = ServerFactory.getServer();
                                ((StandardServer)server).storeContext(this);
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)"Error storing config file", (Throwable)e);
                        }
                    } else {
                        try {
                            File file;
                            String canConfigFile = new File(this.getConfigFile()).getCanonicalPath();
                            if (!canConfigFile.startsWith(configBase.getCanonicalPath()) && this.copy(new File(canConfigFile), file = new File(configBase, this.getDefaultConfigFile()))) {
                                this.setConfigFile(file.getPath());
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)"Error setting config file", (Throwable)e);
                        }
                    }
                }
                if (!this.getOverride() && (host = this.getParent()) instanceof StandardHost) {
                    ((StandardHost)host).installDefaultContext(this);
                    Container engine = host.getParent();
                    if (engine instanceof StandardEngine) {
                        ((StandardEngine)engine).installDefaultContext(this);
                    }
                }
                if (this.webappResources == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Configuring default Resources");
                    }
                    try {
                        if (this.docBase != null && this.docBase.endsWith(".war") && !new File(this.docBase).isDirectory()) {
                            this.setResources((DirContext)((Object)new WARDirContext()));
                        } else {
                            this.setResources((DirContext)new FileDirContext());
                        }
                    }
                    catch (IllegalArgumentException e) {
                        log.error((Object)sm.getString("standardContext.resourcesInit"), (Throwable)e);
                        ok = false;
                    }
                }
                if (ok && !this.resourcesStart()) {
                    ok = false;
                }
                if (this.alternateDocBases != null && this.alternateDocBases.size() > 0) {
                    for (int i = 0; i < this.alternateDocBases.size(); ++i) {
                        AlternateDocBase alternateDocBase = this.alternateDocBases.get(i);
                        String docBase = alternateDocBase.getDocBase();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Configuring alternate resources");
                        }
                        try {
                            if (docBase != null && docBase.endsWith(".war")) {
                                this.setAlternateResources(alternateDocBase, (DirContext)((Object)new WARDirContext()));
                                continue;
                            }
                            this.setAlternateResources(alternateDocBase, (DirContext)new FileDirContext());
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            log.error((Object)sm.getString("standardContext.resourcesInit"), (Throwable)e);
                            ok = false;
                        }
                    }
                    if (ok && !this.alternateResourcesStart()) {
                        ok = false;
                    }
                }
                if (this.realm == null) {
                    ObjectName realmName = null;
                    try {
                        realmName = new ObjectName(this.getEngineName() + ":type=Realm,host=" + this.getHostname() + ",path=" + this.getPath());
                        if (this.mserver.isRegistered(realmName)) {
                            this.mserver.invoke(realmName, "init", new Object[0], new String[0]);
                        }
                    }
                    catch (Throwable t) {
                        if (!log.isDebugEnabled()) break block80;
                        log.debug((Object)("No realm for this host " + realmName));
                    }
                }
            }
            if (this.getLoader() == null) {
                this.createLoader();
            }
            this.getCharsetMapper();
            this.postWorkDirectory();
            boolean dependencyCheck = true;
            try {
                dependencyCheck = ExtensionValidator.validateApplication(this.getResources(), this);
            }
            catch (IOException ioe) {
                log.error((Object)sm.getString("standardContext.dependencyCheck", this), (Throwable)ioe);
                dependencyCheck = false;
            }
            if (!dependencyCheck) {
                ok = false;
            }
            if ((useNamingProperty = System.getProperty("catalina.useNaming")) != null && useNamingProperty.equals("false")) {
                this.useNaming = false;
            }
            if (ok && this.isUseNaming() && this.namingContextListener == null) {
                this.namingContextListener = new NamingContextListener();
                this.namingContextListener.setDebug(this.getDebug());
                this.namingContextListener.setName(this.getNamingContextName());
                this.addLifecycleListener(this.namingContextListener);
            }
            oldCCL = null;
            if (log.isTraceEnabled()) {
                log.trace((Object)"Processing standard container startup");
            }
            boolean mainOk = false;
            try {
                if (!ok) break block81;
                this.started = true;
                if (this.loader != null && this.loader instanceof Lifecycle) {
                    ((Lifecycle)this.loader).start();
                }
                if (this.logger != null && this.logger instanceof Lifecycle) {
                    ((Lifecycle)this.logger).start();
                }
                oldCCL = this.bindThread();
                if (this.cluster != null && this.cluster instanceof Lifecycle) {
                    ((Lifecycle)this.cluster).start();
                }
                if (this.realm != null && this.realm instanceof Lifecycle) {
                    ((Lifecycle)this.realm).start();
                }
                if (this.resources != null && this.resources instanceof Lifecycle) {
                    ((Lifecycle)this.resources).start();
                }
                Container[] children = this.findChildren();
                for (int i = 0; i < children.length; ++i) {
                    if (!(children[i] instanceof Lifecycle)) continue;
                    ((Lifecycle)children[i]).start();
                }
                if (this.pipeline instanceof Lifecycle) {
                    ((Lifecycle)this.pipeline).start();
                }
                this.lifecycle.fireLifecycleEvent("start", null);
                if (!TldConfig.getScanParentTldListener()) {
                    this.isJsfApplication = this.isJsfServletDefined();
                }
                TldConfig tldConfig = new TldConfig();
                tldConfig.setContext(this);
                tldConfig.setTldValidation(this.tldValidation);
                tldConfig.setTldNamespaceAware(this.tldNamespaceAware);
                if (!this.tldValidation) {
                    tldConfig.setTldValidation(((StandardHost)this.getParent()).getXmlValidation());
                }
                try {
                    tldConfig.execute();
                }
                catch (Exception ex) {
                    log.error((Object)sm.getString("standardContext.tldConfig"), (Throwable)ex);
                }
                if (this.manager != null && this.manager instanceof Lifecycle) {
                    ((Lifecycle)this.getManager()).start();
                }
                super.threadStart();
                mainOk = true;
            }
            finally {
                this.unbindThread(oldCCL);
                if (!mainOk) {
                    this.registerJMX();
                }
            }
        }
        if (!this.getConfigured()) {
            ok = false;
        }
        if (ok) {
            this.getServletContext().setAttribute("org.apache.catalina.resources", (Object)this.getResources());
            this.context.setAttributeReadOnly("org.apache.catalina.resources");
            this.getServletContext().setAttribute("org.apache.catalina.alternateResources", this.getAlternateDocBases());
            this.context.setAttributeReadOnly("org.apache.catalina.alternateResources");
        }
        this.mapper.setContext(this.getPath(), this.welcomeFiles, (javax.naming.Context)this.resources);
        oldCCL = this.bindThread();
        try {
            if (ok) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Posting standard context attributes");
                }
                this.postWelcomeFiles();
            }
            if (ok) {
                this.lifecycle.fireLifecycleEvent("after_start", null);
            }
            if (ok && !this.listenerStart()) {
                ok = false;
            }
            if (ok && !this.filterStart()) {
                ok = false;
            }
            if (ok) {
                this.loadOnStartup(this.findChildren());
            }
        }
        finally {
            this.unbindThread(oldCCL);
        }
        if (ok) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Starting completed");
            }
            this.setAvailable(true);
        } else {
            log.error((Object)sm.getString("standardContext.startFailed", this.getName()));
            try {
                this.stop();
            }
            catch (Throwable t) {
                log.error((Object)sm.getString("standardContext.startCleanup"), t);
            }
            this.setAvailable(false);
        }
        this.registerJMX();
        this.startTimeMillis = System.currentTimeMillis();
        this.startupTime = this.startTimeMillis - startupTimeStart;
        if (ok && this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.running", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        if (this.getLoader() instanceof WebappLoader) {
            ((WebappLoader)this.getLoader()).closeJARs(true);
        }
        if (!ok && this.started) {
            this.stop();
        }
    }

    public void createLoader() {
        ClassLoader parent = null;
        if (this.getPrivileged()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Configuring privileged default Loader");
            }
            parent = this.getClass().getClassLoader();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Configuring non-privileged default Loader");
            }
            parent = this.getParentClassLoader();
        }
        WebappLoader webappLoader = new WebappLoader(parent);
        webappLoader.setDelegate(this.getDelegate());
        webappLoader.setUseMyFaces(this.useMyFaces);
        this.setLoader(webappLoader);
    }

    private void cacheContext() {
        try {
            File workDir = new File(this.getWorkPath());
            File ctxSer = new File(workDir, "_tomcat_context.ser");
            FileOutputStream fos = new FileOutputStream(ctxSer);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this);
            oos.close();
            fos.close();
        }
        catch (Throwable t) {
            log.info((Object)"Error saving context.ser ", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() throws LifecycleException {
        if (!this.started) {
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("containerBase.notStarted", this.logName()));
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.stopping", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        this.setAvailable(false);
        ClassLoader oldCCL = this.bindThread();
        try {
            this.filterStop();
            super.threadStop();
            if (this.manager != null && this.manager instanceof Lifecycle) {
                ((Lifecycle)this.manager).stop();
            }
            this.setCharsetMapper(null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Processing standard container shutdown");
            }
            this.lifecycle.fireLifecycleEvent("stop", null);
            this.started = false;
            if (this.pipeline instanceof Lifecycle) {
                ((Lifecycle)this.pipeline).stop();
            }
            Container[] children = this.findChildren();
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] instanceof Lifecycle)) continue;
                ((Lifecycle)children[i]).stop();
            }
            if (this.context != null) {
                this.context.clearAttributes();
            }
            this.listenerStop();
            this.resourcesStop();
            this.alternateResourcesStop();
            if (this.realm != null && this.realm instanceof Lifecycle) {
                ((Lifecycle)this.realm).stop();
            }
            if (this.cluster != null && this.cluster instanceof Lifecycle) {
                ((Lifecycle)this.cluster).stop();
            }
            if (this.logger != null && this.logger instanceof Lifecycle) {
                ((Lifecycle)this.logger).stop();
            }
        }
        finally {
            this.unbindThread(oldCCL);
            if (this.loader != null && this.loader instanceof Lifecycle) {
                ((Lifecycle)this.loader).stop();
            }
        }
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.stopped", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        this.context = null;
        try {
            this.resetContext();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("standardContext.reset", this), (Throwable)ex);
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping complete");
        }
    }

    @Override
    public void destroy() throws Exception {
        if (this.oname != null) {
            Notification notification = new Notification("j2ee.object.deleted", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        super.destroy();
        if (this.getManager() instanceof ManagerBase) {
            ((ManagerBase)this.getManager()).release();
        }
        this.instanceListeners = new String[0];
    }

    private void resetContext() throws Exception, MBeanRegistrationException {
        this.children = new HashMap();
        this.startupTime = 0L;
        this.startTimeMillis = 0L;
        this.tldScanTime = 0L;
        this.distributable = false;
        this.applicationListeners = new String[0];
        this.applicationEventListenersObjects = new Object[0];
        this.applicationLifecycleListenersObjects = new Object[0];
        if (log.isDebugEnabled()) {
            log.debug((Object)("resetContext " + this.oname + " " + this.mserver));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardContext[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backgroundProcess() {
        if (!this.started) {
            return;
        }
        this.count = (this.count + 1) % this.managerChecksFrequency;
        if (this.getManager() != null && this.count == 0) {
            if (this.getManager() instanceof StandardManager) {
                ((StandardManager)this.getManager()).processExpires();
            } else if (this.getManager() instanceof PersistentManagerBase) {
                PersistentManagerBase pManager = (PersistentManagerBase)this.getManager();
                pManager.backgroundProcess();
            }
        }
        if (this.isReload() && this.getLoader() != null) {
            if (this.reloadable && this.getLoader().modified()) {
                try {
                    Thread.currentThread().setContextClassLoader(standardContextClassLoader);
                    this.reload();
                }
                finally {
                    if (this.getLoader() != null) {
                        Thread.currentThread().setContextClassLoader(this.getLoader().getClassLoader());
                    }
                }
            }
            if (this.getLoader() instanceof WebappLoader) {
                ((WebappLoader)this.getLoader()).closeJARs(false);
            }
        }
    }

    private boolean isJsfServletDefined() {
        Container[] wrappers = this.findChildren();
        for (int i = 0; i < wrappers.length; ++i) {
            String servletName = ((Wrapper)wrappers[i]).getServletClass();
            if (servletName == null || !servletName.equals("javax.faces.webapp.FacesServlet")) continue;
            return true;
        }
        return false;
    }

    protected String adjustURLPattern(String urlPattern) {
        if (urlPattern == null) {
            return urlPattern;
        }
        if (urlPattern.startsWith("/") || urlPattern.startsWith("*.")) {
            return urlPattern;
        }
        if (!this.isServlet22()) {
            return urlPattern;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("standardContext.urlPattern.patternWarning", urlPattern));
        }
        return "/" + urlPattern;
    }

    protected boolean isServlet22() {
        if (this.publicId == null) {
            return false;
        }
        return this.publicId.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN");
    }

    protected File engineBase() {
        String base = System.getProperty("catalina.base");
        if (base == null) {
            StandardEngine eng = (StandardEngine)this.getParent().getParent();
            base = eng.getBaseDir();
        }
        return new File(base);
    }

    private ClassLoader bindThread() {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getLoader().getClassLoader());
        if (this.isUseNaming()) {
            try {
                ContextBindings.bindThread(this, this);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return oldContextClassLoader;
    }

    private void unbindThread(ClassLoader oldContextClassLoader) {
        Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        if (this.isUseNaming()) {
            ContextBindings.unbindThread(this, this);
        }
    }

    private String getBasePath(String docBase) {
        Container container;
        String basePath = null;
        for (container = this; container != null && !(container instanceof Host); container = container.getParent()) {
        }
        File file = new File(docBase);
        if (!file.isAbsolute()) {
            if (container == null) {
                basePath = new File(this.engineBase(), docBase).getPath();
            } else {
                String appBase = ((Host)container).getAppBase();
                file = new File(appBase);
                if (!file.isAbsolute()) {
                    file = new File(this.engineBase(), appBase);
                }
                basePath = new File(file, docBase).getPath();
            }
        } else {
            basePath = file.getPath();
        }
        return basePath;
    }

    private String getAppBase() {
        Container container;
        String appBase = null;
        for (container = this; container != null && !(container instanceof Host); container = container.getParent()) {
        }
        if (container != null) {
            appBase = ((Host)container).getAppBase();
        }
        return appBase;
    }

    private File getConfigBase() {
        File configBase = new File(System.getProperty("catalina.base"), "conf");
        if (!configBase.exists()) {
            return null;
        }
        StandardContext host = null;
        Container engine = null;
        for (Container container = this; container != null; container = container.getParent()) {
            if (container instanceof Host) {
                host = container;
            }
            if (!(container instanceof Engine)) continue;
            engine = container;
        }
        if (engine != null) {
            configBase = new File(configBase, engine.getName());
        }
        if (host != null) {
            configBase = new File(configBase, host.getName());
        }
        configBase.mkdirs();
        return configBase;
    }

    protected String getDefaultConfigFile() {
        String basename = null;
        String path = this.getPath();
        basename = path.equals("") ? "ROOT" : path.substring(1).replace('/', '_');
        return basename + ".xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copy(File src, File dest) {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            int len;
            is = new FileInputStream(src);
            os = new FileOutputStream(dest);
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) >= 0) {
                os.write(buf, 0, len);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception e) {}
        }
        return true;
    }

    public String getNamingContextName() {
        if (this.namingContextName == null) {
            Container parent = this.getParent();
            if (parent == null) {
                this.namingContextName = this.getName();
            } else {
                Stack<String> stk = new Stack<String>();
                StringBuffer buff = new StringBuffer();
                while (parent != null) {
                    stk.push(parent.getName());
                    parent = parent.getParent();
                }
                while (!stk.empty()) {
                    buff.append("/" + stk.pop());
                }
                buff.append(this.getName());
                this.namingContextName = buff.toString();
            }
            this.namingContextName = this.namingContextName + instanceIDCounter++;
        }
        return this.namingContextName;
    }

    public boolean getPaused() {
        return this.paused;
    }

    private void postResources() {
        this.getServletContext().setAttribute("org.apache.catalina.resources", (Object)this.getResources());
        this.context.setAttributeReadOnly("org.apache.catalina.resources");
    }

    private void postWelcomeFiles() {
        this.getServletContext().setAttribute("org.apache.catalina.WELCOME_FILES", (Object)this.welcomeFiles);
        this.context.setAttributeReadOnly("org.apache.catalina.WELCOME_FILES");
    }

    public String getHostname() {
        Container parentHost = this.getParent();
        if (parentHost != null) {
            this.hostName = parentHost.getName();
        }
        if (this.hostName == null || this.hostName.length() < 1) {
            this.hostName = "_";
        }
        return this.hostName;
    }

    private void postWorkDirectory() {
        File dir;
        String workDir = this.getWorkDir();
        if (workDir == null) {
            String temp;
            String hostName = null;
            String engineName = null;
            String hostWorkDir = null;
            Container parentHost = this.getParent();
            if (parentHost != null) {
                Container parentEngine;
                hostName = parentHost.getName();
                if (parentHost instanceof StandardHost) {
                    hostWorkDir = ((StandardHost)parentHost).getWorkDir();
                }
                if ((parentEngine = parentHost.getParent()) != null) {
                    engineName = parentEngine.getName();
                }
            }
            if (hostName == null || hostName.length() < 1) {
                hostName = "_";
            }
            if (engineName == null || engineName.length() < 1) {
                engineName = "_";
            }
            if ((temp = this.getPath()).startsWith("/")) {
                temp = temp.substring(1);
            }
            temp = temp.replace('/', '_');
            if ((temp = temp.replace('\\', '_')).length() < 1) {
                temp = "_";
            }
            workDir = hostWorkDir != null ? hostWorkDir + File.separator + temp : "work" + File.separator + engineName + File.separator + hostName + File.separator + temp;
            this.setWorkDir(workDir);
        }
        if (!(dir = new File(workDir)).isAbsolute()) {
            File catalinaHome = this.engineBase();
            String catalinaHomePath = null;
            try {
                catalinaHomePath = catalinaHome.getCanonicalPath();
                dir = new File(catalinaHomePath, workDir);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        dir.mkdirs();
        this.getServletContext().setAttribute("javax.servlet.context.tempdir", (Object)dir);
        this.context.setAttributeReadOnly("javax.servlet.context.tempdir");
    }

    private void setPaused(boolean paused) {
        this.paused = paused;
    }

    private boolean validateURLPattern(String urlPattern) {
        if (urlPattern == null) {
            return false;
        }
        if (urlPattern.indexOf(10) >= 0 || urlPattern.indexOf(13) >= 0) {
            log.warn((Object)sm.getString("standardContext.crlfinurl", urlPattern));
        }
        if (urlPattern.startsWith("*.")) {
            return urlPattern.indexOf(47) < 0;
        }
        return urlPattern.startsWith("/") && urlPattern.indexOf("*.") < 0;
    }

    public String[] getEnvironments() {
        ContextEnvironment[] envs = this.getNamingResources().findEnvironments();
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < envs.length; ++i) {
            try {
                ObjectName oname = MBeanUtils.createObjectName(this.getEngineName(), envs[i]);
                results.add(oname.toString());
                continue;
            }
            catch (MalformedObjectNameException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for environment " + envs[i]);
                iae.initCause(e);
                throw iae;
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getResourceNames() {
        ContextResource[] resources = this.getNamingResources().findResources();
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < resources.length; ++i) {
            try {
                ObjectName oname = MBeanUtils.createObjectName(this.getEngineName(), resources[i]);
                results.add(oname.toString());
                continue;
            }
            catch (MalformedObjectNameException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for resource " + resources[i]);
                iae.initCause(e);
                throw iae;
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getResourceLinks() {
        ContextResourceLink[] links = this.getNamingResources().findResourceLinks();
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < links.length; ++i) {
            try {
                ObjectName oname = MBeanUtils.createObjectName(this.getEngineName(), links[i]);
                results.add(oname.toString());
                continue;
            }
            catch (MalformedObjectNameException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for resource " + links[i]);
                iae.initCause(e);
                throw iae;
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String addEnvironment(String envName, String type) throws MalformedObjectNameException {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return null;
        }
        ContextEnvironment env = nresources.findEnvironment(envName);
        if (env != null) {
            throw new IllegalArgumentException("Invalid environment name - already exists '" + envName + "'");
        }
        env = new ContextEnvironment();
        env.setName(envName);
        env.setType(type);
        nresources.addEnvironment(env);
        ManagedBean managed = Registry.getRegistry(null, null).findManagedBean("ContextEnvironment");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), env);
        return oname.toString();
    }

    public String addResource(String resourceName, String type) throws MalformedObjectNameException {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return null;
        }
        ContextResource resource = nresources.findResource(resourceName);
        if (resource != null) {
            throw new IllegalArgumentException("Invalid resource name - already exists'" + resourceName + "'");
        }
        resource = new ContextResource();
        resource.setName(resourceName);
        resource.setType(type);
        nresources.addResource(resource);
        ManagedBean managed = Registry.getRegistry(null, null).findManagedBean("ContextResource");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), resource);
        return oname.toString();
    }

    public String addResourceLink(String resourceLinkName, String global, String name, String type) throws MalformedObjectNameException {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return null;
        }
        ContextResourceLink resourceLink = nresources.findResourceLink(resourceLinkName);
        if (resourceLink != null) {
            throw new IllegalArgumentException("Invalid resource link name - already exists'" + resourceLinkName + "'");
        }
        resourceLink = new ContextResourceLink();
        resourceLink.setGlobal(global);
        resourceLink.setName(resourceLinkName);
        resourceLink.setType(type);
        nresources.addResourceLink(resourceLink);
        ManagedBean managed = Registry.getRegistry(null, null).findManagedBean("ContextResourceLink");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), resourceLink);
        return oname.toString();
    }

    public String getDeploymentDescriptor() {
        InputStream stream = null;
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null) {
            stream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
        }
        if (stream == null) {
            return "";
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        StringBuffer sb = new StringBuffer();
        String strRead = "";
        try {
            while (strRead != null) {
                sb.append(strRead);
                strRead = br.readLine();
            }
        }
        catch (IOException e) {
            return "";
        }
        return sb.toString();
    }

    public String[] getServlets() {
        String[] result = null;
        Container[] children = this.findChildren();
        if (children != null) {
            result = new String[children.length];
            for (int i = 0; i < children.length; ++i) {
                result[i] = ((StandardWrapper)children[i]).getObjectName();
            }
        }
        return result;
    }

    @Override
    public ObjectName createObjectName(String hostDomain, ObjectName parentName) throws MalformedObjectNameException {
        StandardHost hst = (StandardHost)this.getParent();
        String hostName = this.getParent().getName();
        String name = "//" + (hostName == null ? "DEFAULT" : hostName) + ("".equals(this.encodedPath) ? "/" : this.encodedPath);
        String suffix = ",J2EEApplication=" + this.getJ2EEApplication() + ",J2EEServer=" + this.getJ2EEServer();
        String onameStr = "j2eeType=WebModule,name=" + name + suffix;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering " + onameStr + " for " + this.oname));
        }
        if (this.getDomain() == null) {
            this.domain = hst.getDomain();
        }
        ObjectName oname = new ObjectName(this.getDomain() + ":" + onameStr);
        return oname;
    }

    private void preRegisterJMX() {
        try {
            StandardHost host = (StandardHost)this.getParent();
            if (this.oname == null || this.oname.getKeyProperty("j2eeType") == null) {
                this.controller = this.oname = this.createObjectName(host.getDomain(), host.getJmxName());
            }
        }
        catch (Exception ex) {
            log.info((Object)("Error registering ctx with jmx " + this + " " + this.oname + " " + ex.toString()), (Throwable)ex);
        }
    }

    private void registerJMX() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking for " + this.oname));
            }
            if (!Registry.getRegistry(null, null).getMBeanServer().isRegistered(this.oname)) {
                this.controller = this.oname;
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
                if (this.getObjectName() != null) {
                    Notification notification = new Notification("j2ee.object.created", this.getObjectName(), this.sequenceNumber++);
                    this.broadcaster.sendNotification(notification);
                }
            }
            Container[] children = this.findChildren();
            for (int i = 0; children != null && i < children.length; ++i) {
                ((StandardWrapper)children[i]).registerJMX(this);
            }
        }
        catch (Exception ex) {
            log.info((Object)("Error registering wrapper with jmx " + this + " " + this.oname + " " + ex.toString()), (Throwable)ex);
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (this.oname != null) {
            return name;
        }
        ObjectName result = super.preRegister(server, name);
        return name;
    }

    @Override
    public void preDeregister() throws Exception {
        if (this.started) {
            try {
                this.stop();
            }
            catch (Exception ex) {
                log.error((Object)sm.getString("standardContext.stoppingContext", this), (Throwable)ex);
            }
        }
    }

    @Override
    public void init() throws Exception {
        if (this.getParent() == null) {
            ObjectName parentName = this.getParentName();
            if (!this.mserver.isRegistered(parentName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No host, creating one " + parentName));
                }
                StandardHost host = new StandardHost();
                host.setName(this.hostName);
                Registry.getRegistry(null, null).registerComponent((Object)host, parentName, null);
                this.mserver.invoke(parentName, "init", new Object[0], new String[0]);
            }
            ContextConfig config = new ContextConfig();
            this.addLifecycleListener(config);
            if (log.isDebugEnabled()) {
                log.debug((Object)("AddChild " + parentName + " " + this));
            }
            try {
                this.mserver.invoke(parentName, "addChild", new Object[]{this}, new String[]{"org.apache.catalina.Container"});
            }
            catch (Exception e) {
                this.destroy();
                throw e;
            }
        }
        if (this.initialized) {
            return;
        }
        super.init();
        this.lifecycle.fireLifecycleEvent("init", null);
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.starting", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
    }

    @Override
    public ObjectName getParentName() throws MalformedObjectNameException {
        String path = this.oname.getKeyProperty("name");
        if (path == null) {
            log.error((Object)sm.getString("standardContext.missingNameAttributeInName", this.getName()));
            return null;
        }
        if (!path.startsWith("//")) {
            log.error((Object)sm.getString("standardContext.malformedName", this.getName()));
        }
        path = path.substring(2);
        int delim = path.indexOf("/");
        this.hostName = "localhost";
        if (delim > 0) {
            this.hostName = path.substring(0, delim);
            if ((path = path.substring(delim)).equals("/")) {
                this.setName("");
            } else {
                this.setName(path);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting path " + path));
            }
            this.setName(path);
        }
        String parentDomain = this.getEngineName();
        if (parentDomain == null) {
            parentDomain = this.domain;
        }
        ObjectName parentName = new ObjectName(parentDomain + ":" + "type=Host,host=" + this.hostName);
        return parentName;
    }

    public void create() throws Exception {
        this.init();
    }

    public DirContext getStaticResources() {
        return this.getResources();
    }

    public DirContext findStaticResources() {
        return this.getResources();
    }

    public String[] getWelcomeFiles() {
        return this.findWelcomeFiles();
    }

    public boolean isStateManageable() {
        return true;
    }

    @Override
    public void setXmlValidation(boolean webXmlValidation) {
        this.webXmlValidation = webXmlValidation;
    }

    @Override
    public boolean getXmlValidation() {
        return this.webXmlValidation;
    }

    @Override
    public boolean getXmlNamespaceAware() {
        return this.webXmlNamespaceAware;
    }

    @Override
    public void setXmlNamespaceAware(boolean webXmlNamespaceAware) {
        this.webXmlNamespaceAware = webXmlNamespaceAware;
    }

    @Override
    public void setTldValidation(boolean tldValidation) {
        this.tldValidation = tldValidation;
    }

    @Override
    public boolean getTldValidation() {
        return this.tldValidation;
    }

    @Override
    public boolean getTldNamespaceAware() {
        return this.tldNamespaceAware;
    }

    @Override
    public void setTldNamespaceAware(boolean tldNamespaceAware) {
        this.tldNamespaceAware = tldNamespaceAware;
    }

    public void startRecursive() throws LifecycleException {
        this.start();
    }

    public int getState() {
        if (this.started) {
            return 1;
        }
        if (this.initialized) {
            return 0;
        }
        if (!this.available) {
            return 4;
        }
        return 3;
    }

    public String getServer() {
        return this.server;
    }

    public String setServer(String server) {
        this.server = server;
        return this.server;
    }

    public String[] getJavaVMs() {
        return this.javaVMs;
    }

    public String[] setJavaVMs(String[] javaVMs) {
        this.javaVMs = javaVMs;
        return javaVMs;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public boolean isEventProvider() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    static {
        urlEncoder.addSafeCharacter('~');
        urlEncoder.addSafeCharacter('-');
        urlEncoder.addSafeCharacter('_');
        urlEncoder.addSafeCharacter('.');
        urlEncoder.addSafeCharacter('*');
        urlEncoder.addSafeCharacter('/');
    }
}

