/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.util.Enumeration;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.startup.UserDatabase;
import org.apache.catalina.util.StringManager;

public final class UserConfig
implements LifecycleListener {
    private String configClass = "org.apache.catalina.startup.ContextConfig";
    private String contextClass = "org.apache.catalina.core.StandardContext";
    private int debug = 999;
    private String directoryName = "public_html";
    private String homeBase = null;
    private Host host = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    private String userClass = "org.apache.catalina.startup.PasswdUserDatabase";

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        this.configClass = configClass;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        this.contextClass = contextClass;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public String getHomeBase() {
        return this.homeBase;
    }

    public void setHomeBase(String homeBase) {
        this.homeBase = homeBase;
    }

    public String getUserClass() {
        return this.userClass;
    }

    public void setUserClass(String userClass) {
        this.userClass = userClass;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.host = (Host)event.getLifecycle();
        }
        catch (ClassCastException e) {
            this.log(sm.getString("hostConfig.cce", event.getLifecycle()), e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    private void deploy() {
        if (this.debug >= 1) {
            this.log(sm.getString("userConfig.deploying"));
        }
        UserDatabase database = null;
        try {
            Class<?> clazz = Class.forName(this.userClass);
            database = (UserDatabase)clazz.newInstance();
            database.setUserConfig(this);
        }
        catch (Exception e) {
            this.log(sm.getString("userConfig.database"), e);
            return;
        }
        Enumeration users = database.getUsers();
        while (users.hasMoreElements()) {
            String user = (String)users.nextElement();
            String home = database.getHome(user);
            this.deploy(user, home);
        }
    }

    private void deploy(String user, String home) {
        String contextPath = "/~" + user;
        if (this.host.findChild(contextPath) != null) {
            return;
        }
        File app = new File(home, this.directoryName);
        if (!app.exists() || !app.isDirectory()) {
            return;
        }
        this.log(sm.getString("userConfig.deploy", user));
        try {
            Class<?> clazz = Class.forName(this.contextClass);
            Context context = (Context)clazz.newInstance();
            context.setPath(contextPath);
            context.setDocBase(app.toString());
            if (context instanceof Lifecycle) {
                clazz = Class.forName(this.configClass);
                LifecycleListener listener = (LifecycleListener)clazz.newInstance();
                ((Lifecycle)context).addLifecycleListener(listener);
            }
            this.host.addChild(context);
        }
        catch (Exception e) {
            this.log(sm.getString("userConfig.error", user), e);
        }
    }

    private void log(String message) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
        }
        if (logger != null) {
            logger.log("UserConfig[" + this.host.getName() + "]: " + message);
        } else {
            System.out.println("UserConfig[" + this.host.getName() + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
        }
        if (logger != null) {
            logger.log("UserConfig[" + this.host.getName() + "] " + message, throwable);
        } else {
            System.out.println("UserConfig[" + this.host.getName() + "]: " + message);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    private void start() {
        if (this.debug > 0) {
            this.log(sm.getString("userConfig.start"));
        }
        this.deploy();
    }

    private void stop() {
        if (this.debug > 0) {
            this.log(sm.getString("userConfig.stop"));
        }
    }
}

