/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.BitSet;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.C2BConverter;

public final class UEncoder {
    private static Log log = LogFactory.getLog(UEncoder.class);
    private BitSet safeChars = null;
    private C2BConverter c2b = null;
    private ByteChunk bb = null;
    private String encoding = "UTF8";
    private static final int debug = 0;

    public UEncoder() {
        this.initSafeChars();
    }

    public void setEncoding(String s) {
        this.encoding = s;
    }

    public void addSafeCharacter(char c) {
        this.safeChars.set(c);
    }

    public void urlEncode(Writer buf, String s) throws IOException {
        if (this.c2b == null) {
            this.bb = new ByteChunk(16);
            this.c2b = C2BConverter.getInstance(this.bb, this.encoding);
        }
        for (int i = 0; i < s.length(); ++i) {
            char d;
            char c = s.charAt(i);
            if (this.safeChars.get(c)) {
                buf.write(c);
                continue;
            }
            this.c2b.convert(c);
            if (c >= '\ud800' && c <= '\udbff' && i + 1 < s.length() && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                this.c2b.convert(d);
                ++i;
            }
            this.urlEncode(buf, this.bb.getBuffer(), this.bb.getOffset(), this.bb.getLength());
            this.bb.recycle();
        }
    }

    public void urlEncode(Writer buf, byte[] bytes, int off, int len) throws IOException {
        for (int j = off; j < len; ++j) {
            buf.write(37);
            char ch = Character.forDigit(bytes[j] >> 4 & 0xF, 16);
            buf.write(ch);
            ch = Character.forDigit(bytes[j] & 0xF, 16);
            buf.write(ch);
        }
    }

    public String encodeURL(String uri) {
        String outUri = null;
        try {
            CharArrayWriter out = new CharArrayWriter();
            this.urlEncode(out, uri);
            outUri = out.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outUri;
    }

    private void init() {
    }

    private void initSafeChars() {
        int i;
        this.safeChars = new BitSet(128);
        for (i = 97; i <= 122; ++i) {
            this.safeChars.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            this.safeChars.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            this.safeChars.set(i);
        }
        this.safeChars.set(36);
        this.safeChars.set(45);
        this.safeChars.set(95);
        this.safeChars.set(46);
        this.safeChars.set(33);
        this.safeChars.set(42);
        this.safeChars.set(39);
        this.safeChars.set(40);
        this.safeChars.set(41);
        this.safeChars.set(44);
    }

    private static void log(String s) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Encoder: " + s));
        }
    }
}

