/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.jruby.RubyObjectPool;
import com.sun.grizzly.jruby.RubyRuntimeAsyncFilter;
import com.sun.grizzly.standalone.DynamicContentAdapter;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.InternalOutputBuffer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyIO;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RailsAdapter
extends DynamicContentAdapter
implements Adapter {
    private static final int RAILS_TOKEN = 17;
    private RubyObjectPool pool = null;
    private RubyRuntimeAsyncFilter asyncFilter;

    public RailsAdapter(RubyObjectPool pool) {
        super(pool.getRailsRoot() + "/public");
        this.pool = pool;
    }

    public RailsAdapter(RubyObjectPool pool, RubyRuntimeAsyncFilter asyncFilter) {
        this(pool);
        this.asyncFilter = asyncFilter;
    }

    protected int getTokenID() {
        return 17;
    }

    protected void serviceDynamicContent(Request req, Response res) throws IOException {
        Ruby runtime = null;
        DynamicContentAdapter.RequestTupple rt = (DynamicContentAdapter.RequestTupple)req.getNote(17);
        if (rt == null) {
            rt = new DynamicContentAdapter.RequestTupple((DynamicContentAdapter)this);
        }
        rt.req = req;
        try {
            runtime = this.pool.borrowRuntime();
            if (runtime == null) {
                throw new IllegalStateException();
            }
            req.doRead(rt.readChunk);
            ((InternalOutputBuffer)res.getOutputBuffer()).commit();
            res.setCommitted(true);
            IRubyObject reqObj = JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)req);
            IRubyObject loggerObj = JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)SelectorThread.logger());
            OutputStream os = ((InternalOutputBuffer)res.getOutputBuffer()).getOutputStream();
            RubyIO iObj = new RubyIO(runtime, (InputStream)rt.inputStream);
            RubyIO oObj = new RubyIO(runtime, os);
            runtime.defineReadonlyVariable("$req", reqObj);
            runtime.defineReadonlyVariable("$stdin", (IRubyObject)iObj);
            runtime.defineReadonlyVariable("$stdout", (IRubyObject)oObj);
            runtime.defineReadonlyVariable("$logger", loggerObj);
            if (this.contextRoot != null && !this.contextRoot.equals("/")) {
                runtime.defineReadonlyVariable("$root", JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)this.contextRoot));
            }
            JavaEmbedUtils.newRuntimeAdapter().eval(runtime, this.getDispatcherString());
        }
        catch (RaiseException e) {
            RubyException exception = e.getException();
            System.err.println(e.getMessage());
            exception.printBacktrace(System.err);
            throw e;
        }
        finally {
            rt.recycle();
            req.setNote(17, (Object)rt);
            if (runtime != null) {
                this.pool.returnRuntime(runtime);
            }
        }
    }

    private String getDispatcherString() {
        StringBuffer completeText = new StringBuffer();
        try {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/dispatch.rb");
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String str = br.readLine();
            while (str != null) {
                completeText.append(str + "\n");
                str = br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return completeText.toString();
    }
}

