/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby;

import com.sun.grizzly.http.SelectorThread;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.jruby.Ruby;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.load.LoadService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyObjectPool {
    private static long DEFAULT_TIMEOUT = 1000L;
    private String jrubyLib = null;
    private int numberOfRuntime = 5;
    private BlockingQueue<Ruby> queue = new LinkedBlockingQueue<Ruby>();
    private String railsRoot = null;
    private boolean asyncEnabled = false;

    public Ruby borrowRuntime() {
        if (!this.isAsyncEnabled()) {
            try {
                return this.queue.poll(DEFAULT_TIMEOUT, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return (Ruby)this.queue.poll();
    }

    public void returnRuntime(Ruby runtime) {
        this.queue.offer(runtime);
    }

    public void setJrubyLib(String jrubyLib) {
        this.jrubyLib = jrubyLib;
    }

    public void setNumberOfRuntime(int numberOfRuntime) {
        this.numberOfRuntime = numberOfRuntime;
    }

    public void setRailsRoot(String railsRoot) {
        this.railsRoot = railsRoot;
    }

    public void start() {
        try {
            if (this.jrubyLib == null || this.railsRoot == null) {
                throw new IllegalStateException("jrubyLib or railsRoot can not be null.");
            }
            int pnum = Runtime.getRuntime().availableProcessors();
            ExecutorService exec = Executors.newFixedThreadPool(pnum + 1);
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.numberOfRuntime; ++i) {
                exec.execute(new Runnable(){

                    public void run() {
                        long startTime = System.currentTimeMillis();
                        Ruby runtime = RubyObjectPool.this.initializeRubyRuntime();
                        RubyObjectPool.this.loadRubyLibraries(runtime);
                        SelectorThread.logger().log(Level.INFO, "Rails instance instantiation took : " + (System.currentTimeMillis() - startTime) + "ms");
                        RubyObjectPool.this.queue.offer(runtime);
                    }
                });
            }
            exec.shutdown();
            exec.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void stop() {
        for (Ruby ruby : this.queue) {
            ruby.tearDown();
        }
        this.queue.clear();
    }

    protected Ruby initializeRubyRuntime() {
        ArrayList<String> libs = new ArrayList<String>();
        libs.add("META-INF/jruby.home/lib/ruby/site_ruby/1.8");
        return JavaEmbedUtils.initialize(libs);
    }

    protected void loadRubyLibraries(Ruby runtime) {
        LoadService loadService = runtime.getLoadService();
        loadService.require(this.railsRoot + "/config/environment.rb");
    }

    public String getJrubyLib() {
        return this.jrubyLib;
    }

    public int getNumberOfRuntime() {
        return this.numberOfRuntime;
    }

    public String getRailsRoot() {
        return this.railsRoot;
    }

    protected BlockingQueue<Ruby> getRubyRuntimeQueue() {
        return this.queue;
    }

    public boolean isAsyncEnabled() {
        return this.asyncEnabled;
    }

    public void setAsyncEnabled(boolean asyncEnabled) {
        this.asyncEnabled = asyncEnabled;
    }
}

