/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby;

import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.http.AsyncExecutor;
import com.sun.grizzly.http.AsyncFilter;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyRuntimeAsyncFilter
implements AsyncFilter {
    private BlockingQueue<?> rubyRuntimeQueue;
    private LinkedBlockingQueue<AsyncProcessorTask> parkedRequest = new LinkedBlockingQueue();

    public boolean doFilter(AsyncExecutor asyncExecutor) {
        AsyncProcessorTask apt = (AsyncProcessorTask)asyncExecutor.getAsyncTask();
        if (this.rubyRuntimeQueue.size() == 0) {
            this.parkedRequest.offer(apt);
            return false;
        }
        try {
            apt.getProcessorTask().invokeAdapter();
        }
        catch (IllegalStateException ex) {
            this.parkedRequest.offer(apt);
            return false;
        }
        apt.setStage(2);
        return true;
    }

    protected void setRubyRuntimeQueue(BlockingQueue<?> rubyRuntimeQueue) {
        this.rubyRuntimeQueue = rubyRuntimeQueue;
    }

    protected void unpark() {
        AsyncProcessorTask apt = this.parkedRequest.poll();
        if (apt == null) {
            return;
        }
        apt.setStage(4);
        try {
            apt.doTask();
        }
        catch (IllegalStateException e) {
            this.parkedRequest.offer(apt);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

