/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.async;

import com.sun.grizzly.Controller;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.async.AsyncQueue;
import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.async.AsyncQueueReader;
import com.sun.grizzly.async.AsyncReadCallbackHandler;
import com.sun.grizzly.async.AsyncReadCondition;
import com.sun.grizzly.async.AsyncReadQueueRecord;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public class TCPAsyncQueueReader
implements AsyncQueueReader {
    private SelectorHandler selectorHandler;
    private AsyncQueue<SelectableChannel, AsyncReadQueueRecord> readQueue;
    private ConcurrentLinkedQueue<AsyncReadQueueRecord> recordQueue;

    public TCPAsyncQueueReader(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
        this.readQueue = new AsyncQueue();
        this.recordQueue = new ConcurrentLinkedQueue();
    }

    public void read(SelectionKey key, ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler) throws IOException {
        this.read(key, buffer, callbackHandler, null);
    }

    public void read(SelectionKey key, ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition) throws IOException {
        this.read(key, buffer, callbackHandler, condition, null);
    }

    public void read(SelectionKey key, ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition, AsyncQueueDataProcessor readPostProcessor) throws IOException {
        if (key == null) {
            throw new IOException("SelectionKey is null! Probably key was cancelled or connection was closed?");
        }
        SocketChannel channel = (SocketChannel)key.channel();
        AsyncQueue.AsyncQueueEntry channelEntry = this.readQueue.obtainAsyncQueueEntry(channel);
        ConcurrentLinkedQueue<AsyncReadQueueRecord> queue = channelEntry.queue;
        AtomicReference currentElement = channelEntry.currentElement;
        ReentrantLock lock = channelEntry.queuedActionLock;
        try {
            block21: {
                try {
                    AsyncReadQueueRecord record = null;
                    int directReadLength = 0;
                    if (currentElement.get() == null && lock.tryLock()) {
                        record = this.obtainRecord();
                        if (currentElement.compareAndSet(null, record)) {
                            directReadLength = this.doRead(channel, buffer, readPostProcessor);
                        } else {
                            lock.unlock();
                        }
                    }
                    if (buffer.hasRemaining() && (directReadLength == 0 || condition == null || !condition.checkAsyncReadCompleted(key, channel.socket().getRemoteSocketAddress(), buffer))) {
                        if (record == null) {
                            record = this.obtainRecord();
                        }
                        record.set(buffer, callbackHandler, condition, readPostProcessor);
                        boolean isRegisterForReading = false;
                        if (currentElement.get() != record) {
                            queue.offer(record);
                            if (!lock.isLocked()) {
                                isRegisterForReading = true;
                            }
                        } else {
                            isRegisterForReading = true;
                            lock.unlock();
                        }
                        if (isRegisterForReading) {
                            this.registerForReading(key);
                        }
                        break block21;
                    }
                    if (callbackHandler != null) {
                        callbackHandler.onReadCompleted(key, channel.socket().getRemoteSocketAddress(), buffer);
                    }
                    if (lock.isHeldByCurrentThread()) {
                        AsyncReadQueueRecord nextRecord = (AsyncReadQueueRecord)queue.poll();
                        if (nextRecord != null) {
                            currentElement.set(nextRecord);
                            lock.unlock();
                            this.registerForReading(key);
                        } else {
                            currentElement.set(null);
                            lock.unlock();
                            if (queue.peek() != null) {
                                this.registerForReading(key);
                            }
                        }
                    }
                    if (record == null) break block21;
                    this.recordQueue.offer(record);
                }
                catch (IOException e) {
                    this.onClose(channel);
                    throw e;
                }
            }
            Object var15_16 = null;
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
            throw throwable;
        }
    }

    public boolean isAsyncQueueReaderEnabledFor(SelectionKey key) {
        AsyncQueue.AsyncQueueEntry channelEntry = this.readQueue.getAsyncQueueEntry(key.channel());
        return channelEntry != null && (channelEntry.currentElement != null || channelEntry.queue != null && !channelEntry.queue.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onRead(SelectionKey key) throws IOException {
        SocketChannel channel = (SocketChannel)key.channel();
        AsyncQueue.AsyncQueueEntry channelEntry = this.readQueue.obtainAsyncQueueEntry(channel);
        ConcurrentLinkedQueue<AsyncReadQueueRecord> queue = channelEntry.queue;
        AtomicReference currentElement = channelEntry.currentElement;
        ReentrantLock lock = channelEntry.queuedActionLock;
        if (currentElement.get() == null) {
            AsyncReadQueueRecord nextRecord = (AsyncReadQueueRecord)queue.peek();
            if (nextRecord == null || !lock.tryLock()) return;
            if (currentElement.compareAndSet(null, nextRecord)) {
                queue.remove();
            }
        } else if (!lock.tryLock()) {
            return;
        }
        try {
            while (currentElement.get() != null) {
                AsyncReadQueueRecord queueRecord = (AsyncReadQueueRecord)currentElement.get();
                ByteBuffer byteBuffer = queueRecord.byteBuffer;
                AsyncQueueDataProcessor readPostProcessor = queueRecord.readPostProcessor;
                try {
                    this.doRead(channel, byteBuffer, readPostProcessor);
                }
                catch (IOException e) {
                    if (queueRecord.callbackHandler != null) {
                        queueRecord.callbackHandler.onIOException(e, key, byteBuffer, queue);
                    } else {
                        Controller.logger().log(Level.SEVERE, "Exception occured when executing asynchronous queue reading", e);
                    }
                    this.onClose(channel);
                }
                AsyncReadCondition condition = queueRecord.condition;
                if (!byteBuffer.hasRemaining() || condition != null && condition.checkAsyncReadCompleted(key, channel.socket().getRemoteSocketAddress(), byteBuffer)) {
                    if (queueRecord.callbackHandler != null) {
                        queueRecord.callbackHandler.onReadCompleted(key, channel.socket().getRemoteSocketAddress(), byteBuffer);
                    }
                    currentElement.set(queue.poll());
                    this.recordQueue.offer(queueRecord);
                    if (currentElement.get() != null) continue;
                    lock.unlock();
                    AsyncReadQueueRecord nextRecord = queue.peek();
                    if (nextRecord == null || !lock.tryLock()) break;
                    if (!currentElement.compareAndSet(null, nextRecord)) continue;
                    queue.remove();
                    continue;
                }
                lock.unlock();
                this.registerForReading(key);
                break;
            }
            Object var13_13 = null;
            if (!lock.isHeldByCurrentThread()) return;
            channelEntry.queuedActionLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (!lock.isHeldByCurrentThread()) throw throwable;
            channelEntry.queuedActionLock.unlock();
            throw throwable;
        }
    }

    public void onClose(SelectableChannel channel) {
        this.readQueue.removeEntry(channel);
    }

    public void close() {
        this.readQueue.clear();
    }

    private int doRead(SocketChannel channel, ByteBuffer byteBuffer, AsyncQueueDataProcessor readPostProcessor) throws IOException {
        if (readPostProcessor != null) {
            ByteBuffer inputByteBuffer = null;
            int oldPosition = byteBuffer.position();
            do {
                int readBytes;
                if ((readBytes = this.doRead(channel, inputByteBuffer = readPostProcessor.getInternalByteBuffer())) > 0) {
                    readPostProcessor.process(byteBuffer);
                    continue;
                }
                if (readBytes != -1) continue;
                if (byteBuffer.position() != oldPosition) break;
                return -1;
            } while (byteBuffer.hasRemaining() && !inputByteBuffer.hasRemaining());
            return byteBuffer.position() - oldPosition;
        }
        return this.doRead(channel, byteBuffer);
    }

    private int doRead(ReadableByteChannel channel, ByteBuffer byteBuffer) throws IOException {
        int readBytes = 0;
        int lastReadBytes = 0;
        do {
            if ((lastReadBytes = channel.read(byteBuffer)) > 0) {
                readBytes += lastReadBytes;
                continue;
            }
            if (lastReadBytes != -1 || readBytes != 0) continue;
            readBytes = -1;
        } while (lastReadBytes > 0 && byteBuffer.hasRemaining());
        return readBytes;
    }

    private void registerForReading(SelectionKey key) {
        this.selectorHandler.register(key, 1);
    }

    private AsyncReadQueueRecord obtainRecord() {
        AsyncReadQueueRecord record = this.recordQueue.poll();
        if (record == null) {
            record = new AsyncReadQueueRecord();
        }
        return record;
    }
}

