/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.MaskingClassLoader;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.RepositoryChangeListener;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.common_impl.DirectoryBasedRepository;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Main
extends com.sun.enterprise.module.bootstrap.Main {
    static final Logger logger = Logger.getAnonymousLogger();

    public static void main(String[] args) {
        new Main().run(args);
    }

    protected void setParentClassLoader(ModulesRegistry mr) throws BootException {
        Repository lib;
        Module parentModule;
        ClassLoader cl = this.getClass().getClassLoader();
        mr.setParentClassLoader(cl);
        Module shared = mr.makeModuleFor("org.glassfish.external:glassfish-jaxb", null);
        if (shared != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (URI location : shared.getModuleDefinition().getLocations()) {
                try {
                    urls.add(location.toURL());
                }
                catch (MalformedURLException e) {
                    throw new BootException("Cannot set up masking class loader", e);
                }
            }
            cl = new MaskingClassLoader(cl, urls.toArray(new URL[urls.size()]), "javax.xml.bind.", "javax.xml.ws.", "com.sun.xml.");
            mr.setParentClassLoader(cl);
        }
        if ((parentModule = mr.makeModuleFor("javax.javaee:javaee", null)) != null) {
            cl = parentModule.getClassLoader();
        }
        if ((lib = mr.getRepository("lib")) != null) {
            cl = this.setupSharedCL(cl, lib);
        }
        mr.setParentClassLoader(cl);
    }

    protected void createRepository(File root, File bootstrapJar, Manifest mf, ModulesRegistry mr) throws BootException {
        super.createRepository(root, bootstrapJar, mf, mr);
        Repository repo = mr.getRepository("shared");
        File repoLocation = new File(repo.getLocation());
        for (File file : repoLocation.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            try {
                DirectoryBasedRepository newRepo = new DirectoryBasedRepository(file.getName(), file);
                newRepo.initialize();
                mr.addRepository(newRepo);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Cannot initialize repository at " + file.getAbsolutePath(), e);
            }
        }
    }

    private ClassLoader setupSharedCL(ClassLoader parent, Repository sharedRepo) {
        List<URI> uris = sharedRepo.getJarLocations();
        URL[] urls = new URL[uris.size()];
        int i = 0;
        for (URI uri : uris) {
            try {
                urls[i++] = uri.toURL();
            }
            catch (MalformedURLException e) {
                logger.warning("Error while adding library to shared classpath " + e.getMessage());
            }
        }
        return new ExtensibleClassLoader(urls, parent, sharedRepo);
    }

    private class ExtensibleClassLoader
    extends URLClassLoader
    implements RepositoryChangeListener {
        public ExtensibleClassLoader(URL[] urls, ClassLoader parent, Repository repo) {
            super(urls, parent);
            repo.addListener(this);
        }

        public void jarAdded(URI uri) {
            try {
                super.addURL(uri.toURL());
                logger.info("Added " + uri + " to shared classpath, no need to restart appserver");
            }
            catch (MalformedURLException e) {
                logger.log(Level.SEVERE, "Cannot add new added library to shared classpath", e);
            }
        }

        public void jarRemoved(URI uri) {
        }

        public void moduleAdded(ModuleDefinition moduleDefinition) {
        }

        public void moduleRemoved(ModuleDefinition moduleDefinition) {
        }
    }
}

