/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.launcher.util;

import java.io.File;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.UnknownHostException;

public class GFLauncherUtils {
    private GFLauncherUtils() {
    }

    public static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean safeExists(File f) {
        return f != null && f.exists();
    }

    public static boolean safeIsDirectory(File f) {
        return f != null && f.isDirectory();
    }

    public static File absolutize(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getCanonicalFile();
        }
        catch (Exception e) {
            return f.getAbsoluteFile();
        }
    }

    public static File getInstallDir() {
        String resourceName = GFLauncherUtils.class.getName().replace(".", "/") + ".class";
        URL resource = GFLauncherUtils.class.getClassLoader().getResource(resourceName);
        if (resource == null) {
            return null;
        }
        if (!resource.getProtocol().equals("jar")) {
            return null;
        }
        try {
            JarURLConnection c = (JarURLConnection)resource.openConnection();
            URL jarFile = c.getJarFileURL();
            File f = new File(jarFile.toURI());
            f = f.getParentFile();
            if (f == null) {
                return null;
            }
            f = f.getParentFile();
            return GFLauncherUtils.absolutize(f);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isWindows() {
        String osname = System.getProperty("os.name");
        if (osname == null || osname.length() <= 0) {
            return false;
        }
        return (osname = osname.toLowerCase()).indexOf("windows") >= 0;
    }

    public static String getCanonicalHostName() throws UnknownHostException {
        String hostname = null;
        String defaultHostname = InetAddress.getLocalHost().getHostName();
        hostname = InetAddress.getLocalHost().getCanonicalHostName();
        if (hostname.equals(InetAddress.getLocalHost().getHostAddress()) || !hostname.startsWith(defaultHostname)) {
            hostname = defaultHostname;
        }
        return hostname;
    }

    public static String replace(String s, String token, String replace) {
        if (s == null || s.length() <= 0 || token == null || token.length() <= 0) {
            return s;
        }
        int index = s.indexOf(token);
        if (index < 0) {
            return s;
        }
        int tokenLength = token.length();
        String ret = s.substring(0, index);
        ret = ret + replace;
        ret = ret + s.substring(index + tokenLength);
        return ret;
    }

    public static boolean isRelativePath(String path) {
        if (!GFLauncherUtils.ok(path)) {
            return false;
        }
        if (path.startsWith(".")) {
            return true;
        }
        if (path.indexOf("/.") >= 0) {
            return true;
        }
        return path.indexOf("\\.") >= 0;
    }
}

