/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.launcher.util;

import com.sun.enterprise.glassfish.bootstrap.launcher.util.AttributeManager;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class MiniXmlParser {
    private XMLStreamReader parser;
    private String serverName;
    private String configRef;
    private AttributeManager javaConfigAttributeManager;
    private List<String> jvmOptions = new ArrayList<String>();

    public static void main(String[] args) {
        try {
            File dxml = new File("C:/glassfish/domains/domain1/config/domain.xml");
            MiniXmlParser parser = new MiniXmlParser(dxml, "server");
            parser.read();
        }
        catch (Exception e) {
            System.out.println("EXCEPTION: " + e);
        }
    }

    MiniXmlParser(File domainXml, String serverName) {
        this.serverName = serverName;
        try {
            FileInputStream stream = new FileInputStream(domainXml);
            XMLInputFactory xif = XMLInputFactory.newInstance();
            this.parser = xif.createXMLStreamReader(domainXml.toURI().toString(), stream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void read() {
        try {
            this.getConfigRefName();
            this.getConfig();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void getConfigRefName() throws XMLStreamException {
        AttributeManager mgr;
        String thisName;
        if (this.configRef != null) {
            return;
        }
        this.skipRoot("domain");
        this.skipTo("servers");
        do {
            this.skipNonStartElements();
            if (this.parser.getLocalName().equals("server")) continue;
            throw new XMLStreamException("no server found");
        } while (!this.serverName.equals(thisName = (mgr = this.parseAttributes()).getValue("name")));
        this.configRef = mgr.getValue("config-ref");
    }

    private void getConfig() throws XMLStreamException {
        AttributeManager mgr;
        String thisName;
        this.skipTo("configs");
        do {
            this.skipTo("config");
        } while (!this.configRef.equals(thisName = (mgr = this.parseAttributes()).getValue("name")));
        this.getJavaConfig();
    }

    private void getJavaConfig() throws XMLStreamException {
        this.skipTo("java-config");
        this.javaConfigAttributeManager = this.parseAttributes();
        this.getJvmOptions();
    }

    private void getJvmOptions() throws XMLStreamException {
        while (this.skipToButNotPast("jvm-options", "java-config")) {
            this.jvmOptions.add(this.parser.getElementText());
        }
        for (String s : this.jvmOptions) {
            System.out.println("JVM OPTION: " + s);
        }
    }

    private void skipNonStartElements() throws XMLStreamException {
        int event;
        while ((event = this.parser.next()) != 1) {
        }
    }

    private void skipRoot(String name) throws XMLStreamException {
        int event;
        while ((event = this.parser.next()) != 1) {
        }
        if (!name.equals(this.parser.getLocalName())) {
            throw new XMLStreamException("Unknown Domain XML Layout");
        }
    }

    private void skipTo(String name) throws XMLStreamException {
        while (true) {
            this.skipNonStartElements();
            String localName = this.parser.getLocalName();
            if (name.equals(localName)) {
                return;
            }
            this.skipTree(localName);
        }
    }

    private boolean skipToButNotPast(String startName, String endName) throws XMLStreamException {
        int event;
        do {
            if ((event = this.parser.next()) != 1 || !this.parser.getLocalName().equals(startName)) continue;
            return true;
        } while (event != 2 || !this.parser.getLocalName().equals(endName));
        return false;
    }

    private void skipTree(String name) throws XMLStreamException {
        int event;
        while ((event = this.parser.next()) != 2 || !name.equals(this.parser.getLocalName())) {
        }
    }

    private void dump() throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        sb.append("\ngetName(): ").append(this.parser.getName());
        sb.append("\ngetLocalName(): ").append(this.parser.getLocalName());
        sb.append("\ngetNamespaceURI(): ").append(this.parser.getNamespaceURI());
        try {
            sb.append("\ngetText(): ").append(this.parser.getText());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            sb.append("\ngetElementText(): ").append(this.parser.getElementText());
        }
        catch (Exception e) {
            // empty catch block
        }
        sb.append("\ngetEventType(): ").append(this.parser.getEventType());
        sb.append("\ngetLocation(): ").append(this.parser.getLocation());
        try {
            sb.append("\ngetAttributeCount(): ").append(this.parser.getAttributeCount());
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println(sb.toString());
    }

    private AttributeManager parseAttributes() {
        AttributeManager mgr = new AttributeManager();
        int num = this.parser.getAttributeCount();
        for (int i = 0; i < num; ++i) {
            mgr.add(this.parser.getAttributeName(i).getLocalPart(), this.parser.getAttributeValue(i));
        }
        return mgr;
    }
}

