/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.mbean;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.AnyPropertyConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.PropertyConfig;
import com.sun.appserv.management.config.RefConfigReferent;
import com.sun.appserv.management.config.SystemPropertiesAccess;
import com.sun.appserv.management.config.SystemPropertyConfig;
import com.sun.appserv.management.helper.RefHelper;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.glassfish.admin.amx.mbean.AMXImplBase;
import org.glassfish.admin.amx.mbean.Delegate;
import org.glassfish.admin.amx.mbean.MBeanInfoCache;
import org.glassfish.admin.amx.util.Issues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMXConfigImplBase
extends AMXImplBase
implements AMXConfig {
    private final Class<?> mSupplementaryInterface;
    private static final String CREATE = "create";
    private static final String CREATE_PREFIX = "create";
    private static final String REMOVE_PREFIX = "remove";
    private static final String CONFIG_SUFFIX = "Config";
    private static final String FACTORY_SUFFIX = "Factory";
    private static final Class[] STRING_SIG = new Class[]{String.class};
    private static final Set<String> CR_PREFIXES = GSetUtil.newUnmodifiableStringSet((String[])new String[]{"create", "remove"});

    public AMXConfigImplBase(String j2eeType, String fullType, ObjectName parentObjectName, Class<? extends AMX> theInterface, Class<?> supplementaryInterface, Delegate delegate) {
        super(j2eeType, fullType, parentObjectName, theInterface, delegate);
        this.mSupplementaryInterface = supplementaryInterface;
    }

    @Override
    protected MBeanInfo modifyMBeanInfo(MBeanInfo defaultInfo) {
        MBeanInfo info = super.modifyMBeanInfo(defaultInfo);
        if (this.mSupplementaryInterface != null) {
            MBeanInfo supplementaryInfo = MBeanInfoCache.getOtherMBeanInfo(this.mSupplementaryInterface);
            info = JMXUtil.mergeMBeanInfos((MBeanInfo)defaultInfo, (MBeanInfo)supplementaryInfo);
        }
        return info;
    }

    protected boolean supportsProperties() {
        return PropertiesAccess.class.isAssignableFrom(this.getInterface());
    }

    protected boolean supportsSystemProperties() {
        return SystemPropertiesAccess.class.isAssignableFrom(this.getInterface());
    }

    @Override
    protected final Set<String> getSuperfluousMethods() {
        Method[] methods;
        Set<String> items = super.getSuperfluousMethods();
        for (Method m : methods = this.getClass().getMethods()) {
            String name = m.getName();
            if (!this.isConfigFactoryGetter(name) && !this.isRemoveConfig(name) && !this.isCreateConfig(name) || m.getParameterTypes().length > 1) continue;
            items.add(name);
        }
        return items;
    }

    private static void validatePropertyName(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            throw new IllegalArgumentException("Illegal property name: " + StringUtil.quote((Object)propertyName));
        }
    }

    protected final <T extends AnyPropertyConfig> Map<String, String> asNameValuePairs(Map<String, T> items) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String name : items.keySet()) {
            AnyPropertyConfig any = (AnyPropertyConfig)items.get(name);
            String value = any.getValue();
            result.put(name, value);
        }
        return result;
    }

    protected final <T extends AnyPropertyConfig> AnyPropertyConfig getAnyPropertyConfig(Map<String, T> props, String propertyName) {
        return (AnyPropertyConfig)props.get(propertyName);
    }

    protected final <T extends AnyPropertyConfig> String getPropertyValue(Map<String, T> props, String propertyName) {
        AnyPropertyConfig prop = (AnyPropertyConfig)props.get(propertyName);
        return prop == null ? null : prop.getValue();
    }

    private void validateNameValue(String propertyName, String propertyValue) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        if (propertyValue == null) {
            throw new IllegalArgumentException("null");
        }
    }

    protected Map<String, PropertyConfig> getPropertyConfigMap() {
        return this.getSelf(PropertiesAccess.class).getPropertyConfigMap();
    }

    public Map<String, String> getProperties() {
        return this.asNameValuePairs(this.getPropertyConfigMap());
    }

    public String[] getPropertyNames() {
        return GSetUtil.toStringArray(this.getPropertyConfigMap().keySet());
    }

    public String getPropertyValue(String propertyName) {
        return this.getPropertyValue(this.getPropertyConfigMap(), propertyName);
    }

    public final void setPropertyValue(String propertyName, String propertyValue) {
        this.validateNameValue(propertyName, propertyValue);
        PropertyConfig prop = this.getPropertyConfigMap().get(propertyName);
        if (prop != null) {
            prop.setValue(propertyValue);
        } else {
            this.createProperty(propertyName, propertyValue);
        }
    }

    public final boolean existsProperty(String propertyName) {
        return this.getPropertyConfigMap().keySet().contains(propertyName);
    }

    public final void removeProperty(String propertyName) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        throw new UnsupportedOperationException("Can't (yet) remove properties");
    }

    public final void createProperty(String propertyName, String propertyValue) {
        this.validateNameValue(propertyName, propertyValue);
        throw new UnsupportedOperationException("Can't (yet) create new properties");
    }

    @Override
    public final String getGroup() {
        return "configuration";
    }

    protected Map<String, SystemPropertyConfig> getSystemPropertyConfigMap() {
        return this.getSelf(SystemPropertiesAccess.class).getSystemPropertyConfigMap();
    }

    public Map<String, String> getSystemProperties() {
        return this.asNameValuePairs(this.getSystemPropertyConfigMap());
    }

    public String[] getSystemPropertyNames() {
        return GSetUtil.toStringArray(this.getSystemPropertyConfigMap().keySet());
    }

    public String getSystemPropertyValue(String propertyName) {
        return this.getPropertyValue(this.getSystemPropertyConfigMap(), propertyName);
    }

    public final void setSystemPropertyValue(String propertyName, String propertyValue) {
        this.validateNameValue(propertyName, propertyValue);
        SystemPropertyConfig prop = this.getSystemPropertyConfigMap().get(propertyName);
        if (prop != null) {
            prop.setValue(propertyValue);
        } else {
            this.createSystemProperty(propertyName, propertyValue);
        }
    }

    public final boolean existsSystemProperty(String propertyName) {
        return this.getSystemPropertyConfigMap().keySet().contains(propertyName);
    }

    public final void removeSystemProperty(String propertyName) {
        AMXConfigImplBase.validatePropertyName(propertyName);
        throw new UnsupportedOperationException("Can't (yet) remove system properties");
    }

    public final void createSystemProperty(String propertyName, String propertyValue) {
        this.validateNameValue(propertyName, propertyValue);
        throw new UnsupportedOperationException("Can't (yet) create new system properties");
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] superInfos = super.getNotificationInfo();
        String description = "";
        String[] notifTypes = new String[]{"jmx.attribute.change"};
        MBeanNotificationInfo attributeChange = new MBeanNotificationInfo(notifTypes, AttributeChangeNotification.class.getName(), "");
        MBeanNotificationInfo[] selfInfos = new MBeanNotificationInfo[]{attributeChange};
        MBeanNotificationInfo[] allInfos = JMXUtil.mergeMBeanNotificationInfos((MBeanNotificationInfo[])superInfos, (MBeanNotificationInfo[])selfInfos);
        return allInfos;
    }

    private String getSimpleInterfaceName(AMX amx) {
        String fullInterfaceName = Util.getExtra((AMX)amx).getInterfaceName();
        String interfaceName = ClassUtil.stripPackageName((String)fullInterfaceName);
        return interfaceName;
    }

    protected void preRemove(ObjectName objectName) {
        AMXConfig amxConfig = this.getProxy(objectName, AMXConfig.class);
        if (amxConfig instanceof RefConfigReferent) {
            this.debug("*** Removing all references to ", objectName);
            Set failures = RefHelper.removeAllRefsTo((RefConfigReferent)((RefConfigReferent)amxConfig), (boolean)true);
            if (failures.size() != 0) {
                this.debug((Object)("FAILURE removing references to " + objectName + ": " + CollectionUtil.toString((Collection)Util.toObjectNames((Set)failures))));
            }
        } else {
            this.debug("*** not a RefConfigReferent: ", objectName);
        }
    }

    protected ObjectName preRemove(Map<String, ObjectName> items, String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        ObjectName objectName = items.get(name);
        if (objectName == null) {
            throw new IllegalArgumentException("Item not found: " + name);
        }
        this.preRemove(objectName);
        return objectName;
    }

    public final void removeConfig(String j2eeType, String name) {
        Issues.getAMXIssues().notDone("AMXConfigImplBase(): support for removing config");
        throw new RuntimeException("support for removing config not implemented");
    }

    protected void removeRefConfig(String j2eeType, String name) {
        this.removeConfig(j2eeType, name);
    }

    private boolean isRemoveConfig(String operationName) {
        return operationName.startsWith(REMOVE_PREFIX) && operationName.endsWith(CONFIG_SUFFIX);
    }

    private boolean isRemoveConfig(String operationName, Object[] args, String[] types) {
        boolean isRemove;
        int numArgs = args == null ? 0 : args.length;
        boolean bl = isRemove = numArgs <= 1 && this.isRemoveConfig(operationName);
        if (isRemove && numArgs == 1) {
            isRemove = types[0].equals(String.class.getName());
        }
        return isRemove;
    }

    private boolean isCreateConfig(String operationName) {
        return operationName.startsWith("create") && operationName.endsWith(CONFIG_SUFFIX);
    }

    private boolean isConfigFactoryGetter(String operationName, Object[] args, String[] types) {
        int numArgs = args == null ? 0 : args.length;
        return numArgs == 0 && this.isConfigFactoryGetter(operationName);
    }

    private boolean isConfigFactoryGetter(String operationName) {
        return operationName.startsWith("get") && operationName.endsWith(FACTORY_SUFFIX) && !operationName.equals("getProxyFactory");
    }

    protected String operationNameToSimpleClassname(String operationName) {
        return StringUtil.findAndStripPrefix(CR_PREFIXES, (String)operationName);
    }

    @Override
    protected String operationNameToJ2EEType(String operationName) {
        String j2eeType = null;
        j2eeType = this.isRemoveConfig(operationName) || this.isCreateConfig(operationName) ? "X-" + this.operationNameToSimpleClassname(operationName) : super.operationNameToJ2EEType(operationName);
        return j2eeType;
    }

    protected void removeConfig(String operationName) {
        String j2eeType = this.operationNameToJ2EEType(operationName);
        ObjectName objectName = this.getContainerSupport().getContaineeObjectName(j2eeType);
        if (objectName == null) {
            throw new RuntimeException(new InstanceNotFoundException(j2eeType));
        }
        this.preRemove(objectName);
        String simpleInterfaceName = operationName.substring(REMOVE_PREFIX.length(), operationName.length());
        throw new RuntimeException("removeConfig() not supported");
    }

    protected void removeConfig(String operationName, Object[] args, String[] types) throws InvocationTargetException {
        String name = (String)args[0];
        String simpleInterfaceName = operationName.substring(REMOVE_PREFIX.length(), operationName.length());
        Set containees = this.getFactoryContainer().getContaineeSet();
        ObjectName objectName = null;
        for (AMX containee : containees) {
            if (!containee.getName().equals(name)) continue;
            this.debug((Object)("removeConfig: found name match: " + Util.getObjectName((AMX)containee)));
            if (this.getSimpleInterfaceName(containee).equals(simpleInterfaceName)) {
                objectName = Util.getObjectName((AMX)containee);
                break;
            }
            this.debug(this.getSimpleInterfaceName(containee), " != ", simpleInterfaceName);
        }
        if (objectName == null) {
            throw new IllegalArgumentException("Not found: " + name);
        }
        AMX amx = this.getProxy(objectName, AMX.class);
        this.removeConfig(amx.getJ2EEType(), amx.getName());
    }

    protected String getFactoryPackage() {
        return this.getClass().getPackage().getName();
    }

    @Override
    protected Object invokeManually(String operationName, Object[] args, String[] types) throws MBeanException, ReflectionException, NoSuchMethodException, AttributeNotFoundException {
        int numArgs = args == null ? 0 : args.length;
        Object result = null;
        this.debugMethod(operationName, args);
        result = super.invokeManually(operationName, args, types);
        return result;
    }

    public String getConfigName() {
        return this.getKeyProperty("X-ConfigConfig");
    }

    public void sendConfigCreatedNotification(ObjectName configObjectName) {
        this.sendNotification("com.sun.appserv.management.config.ConfigCreated", "com.sun.appserv.management.config.ConfigRemoved", "ConfigObjectName", configObjectName);
    }

    public void sendConfigRemovedNotification(ObjectName configObjectName) {
        this.sendNotification("com.sun.appserv.management.config.ConfigRemoved", "com.sun.appserv.management.config.ConfigRemoved", "ConfigObjectName", configObjectName);
    }

    public String getDefaultValue(String name) {
        try {
            return this.getDelegate().getDefaultValue(name);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

